/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SessionParameterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/session_parameter#id SessionParameter#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of session parameter. Valid values are those in [session parameters](https://docs.snowflake.com/en/sql-reference/parameters.html#session-parameters).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/session_parameter#key SessionParameter#key}
    */
    readonly key: string;
    /**
    * If true, the session parameter will be set on the account level.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/session_parameter#on_account SessionParameter#on_account}
    */
    readonly onAccount?: boolean | cdktf.IResolvable;
    /**
    * The user to set the session parameter for. Required if on_account is false
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/session_parameter#user SessionParameter#user}
    */
    readonly user?: string;
    /**
    * Value of session parameter, as a string. Constraints are the same as those for the parameters in Snowflake documentation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/session_parameter#value SessionParameter#value}
    */
    readonly value: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/session_parameter snowflake_session_parameter}
*/
export declare class SessionParameter extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_session_parameter";
    /**
    * Generates CDKTF code for importing a SessionParameter resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SessionParameter to import
    * @param importFromId The id of the existing SessionParameter that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/session_parameter#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SessionParameter to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/session_parameter snowflake_session_parameter} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SessionParameterConfig
    */
    constructor(scope: Construct, id: string, config: SessionParameterConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _onAccount?;
    get onAccount(): boolean | cdktf.IResolvable;
    set onAccount(value: boolean | cdktf.IResolvable);
    resetOnAccount(): void;
    get onAccountInput(): boolean | cdktf.IResolvable | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
