/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StreamOnExternalTableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the stream.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/stream_on_external_table#comment StreamOnExternalTable#comment}
    */
    readonly comment?: string;
    /**
    * Retains the access permissions from the original stream when a stream is recreated using the OR REPLACE clause. That is sometimes used when the provider detects changes for fields that can not be changed by ALTER. This value will not have any effect when creating a new stream.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/stream_on_external_table#copy_grants StreamOnExternalTable#copy_grants}
    */
    readonly copyGrants?: boolean | cdktf.IResolvable;
    /**
    * The database in which to create the stream. Due to technical limitations (read more [here](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/docs/technical-documentation/identifiers_rework_design_decisions.md#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `(`, `)`, `"`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/stream_on_external_table#database StreamOnExternalTable#database}
    */
    readonly database: string;
    /**
    * Specifies an identifier for the external table the stream will monitor. Due to technical limitations (read more [here](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/docs/technical-documentation/identifiers_rework_design_decisions.md#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `(`, `)`, `"`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/stream_on_external_table#external_table StreamOnExternalTable#external_table}
    */
    readonly externalTable: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/stream_on_external_table#id StreamOnExternalTable#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies whether this is an insert-only stream. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/stream_on_external_table#insert_only StreamOnExternalTable#insert_only}
    */
    readonly insertOnly?: string;
    /**
    * Specifies the identifier for the stream; must be unique for the database and schema in which the stream is created. Due to technical limitations (read more [here](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/docs/technical-documentation/identifiers_rework_design_decisions.md#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `(`, `)`, `"`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/stream_on_external_table#name StreamOnExternalTable#name}
    */
    readonly name: string;
    /**
    * The schema in which to create the stream. Due to technical limitations (read more [here](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/docs/technical-documentation/identifiers_rework_design_decisions.md#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `(`, `)`, `"`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/stream_on_external_table#schema StreamOnExternalTable#schema}
    */
    readonly schema: string;
    /**
    * at block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/stream_on_external_table#at StreamOnExternalTable#at}
    */
    readonly at?: StreamOnExternalTableAt;
    /**
    * before block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/stream_on_external_table#before StreamOnExternalTable#before}
    */
    readonly before?: StreamOnExternalTableBefore;
}
export interface StreamOnExternalTableDescribeOutput {
}
export declare function streamOnExternalTableDescribeOutputToTerraform(struct?: StreamOnExternalTableDescribeOutput): any;
export declare function streamOnExternalTableDescribeOutputToHclTerraform(struct?: StreamOnExternalTableDescribeOutput): any;
export declare class StreamOnExternalTableDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StreamOnExternalTableDescribeOutput | undefined;
    set internalValue(value: StreamOnExternalTableDescribeOutput | undefined);
    get baseTables(): string[];
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get invalidReason(): string;
    get mode(): string;
    get name(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get schemaName(): string;
    get sourceType(): string;
    get stale(): cdktf.IResolvable;
    get staleAfter(): string;
    get tableName(): string;
    get type(): string;
}
export declare class StreamOnExternalTableDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StreamOnExternalTableDescribeOutputOutputReference;
}
export interface StreamOnExternalTableShowOutput {
}
export declare function streamOnExternalTableShowOutputToTerraform(struct?: StreamOnExternalTableShowOutput): any;
export declare function streamOnExternalTableShowOutputToHclTerraform(struct?: StreamOnExternalTableShowOutput): any;
export declare class StreamOnExternalTableShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StreamOnExternalTableShowOutput | undefined;
    set internalValue(value: StreamOnExternalTableShowOutput | undefined);
    get baseTables(): string[];
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get invalidReason(): string;
    get mode(): string;
    get name(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get schemaName(): string;
    get sourceType(): string;
    get stale(): cdktf.IResolvable;
    get staleAfter(): string;
    get tableName(): string;
    get type(): string;
}
export declare class StreamOnExternalTableShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StreamOnExternalTableShowOutputOutputReference;
}
export interface StreamOnExternalTableAt {
    /**
    * Specifies the difference in seconds from the current time to use for Time Travel, in the form -N where N can be an integer or arithmetic expression (e.g. -120 is 120 seconds, -30*60 is 1800 seconds or 30 minutes).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/stream_on_external_table#offset StreamOnExternalTable#offset}
    */
    readonly offset?: string;
    /**
    * Specifies the query ID of a statement to use as the reference point for Time Travel. This parameter supports any statement of one of the following types: DML (e.g. INSERT, UPDATE, DELETE), TCL (BEGIN, COMMIT transaction), SELECT.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/stream_on_external_table#statement StreamOnExternalTable#statement}
    */
    readonly statement?: string;
    /**
    * Specifies the identifier (i.e. name) for an existing stream on the queried table or view. The current offset in the stream is used as the AT point in time for returning change data for the source object.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/stream_on_external_table#stream StreamOnExternalTable#stream}
    */
    readonly stream?: string;
    /**
    * Specifies an exact date and time to use for Time Travel. The value must be explicitly cast to a TIMESTAMP, TIMESTAMP_LTZ, TIMESTAMP_NTZ, or TIMESTAMP_TZ data type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/stream_on_external_table#timestamp StreamOnExternalTable#timestamp}
    */
    readonly timestamp?: string;
}
export declare function streamOnExternalTableAtToTerraform(struct?: StreamOnExternalTableAtOutputReference | StreamOnExternalTableAt): any;
export declare function streamOnExternalTableAtToHclTerraform(struct?: StreamOnExternalTableAtOutputReference | StreamOnExternalTableAt): any;
export declare class StreamOnExternalTableAtOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StreamOnExternalTableAt | undefined;
    set internalValue(value: StreamOnExternalTableAt | undefined);
    private _offset?;
    get offset(): string;
    set offset(value: string);
    resetOffset(): void;
    get offsetInput(): string | undefined;
    private _statement?;
    get statement(): string;
    set statement(value: string);
    resetStatement(): void;
    get statementInput(): string | undefined;
    private _stream?;
    get stream(): string;
    set stream(value: string);
    resetStream(): void;
    get streamInput(): string | undefined;
    private _timestamp?;
    get timestamp(): string;
    set timestamp(value: string);
    resetTimestamp(): void;
    get timestampInput(): string | undefined;
}
export interface StreamOnExternalTableBefore {
    /**
    * Specifies the difference in seconds from the current time to use for Time Travel, in the form -N where N can be an integer or arithmetic expression (e.g. -120 is 120 seconds, -30*60 is 1800 seconds or 30 minutes).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/stream_on_external_table#offset StreamOnExternalTable#offset}
    */
    readonly offset?: string;
    /**
    * Specifies the query ID of a statement to use as the reference point for Time Travel. This parameter supports any statement of one of the following types: DML (e.g. INSERT, UPDATE, DELETE), TCL (BEGIN, COMMIT transaction), SELECT.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/stream_on_external_table#statement StreamOnExternalTable#statement}
    */
    readonly statement?: string;
    /**
    * Specifies the identifier (i.e. name) for an existing stream on the queried table or view. The current offset in the stream is used as the AT point in time for returning change data for the source object.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/stream_on_external_table#stream StreamOnExternalTable#stream}
    */
    readonly stream?: string;
    /**
    * Specifies an exact date and time to use for Time Travel. The value must be explicitly cast to a TIMESTAMP, TIMESTAMP_LTZ, TIMESTAMP_NTZ, or TIMESTAMP_TZ data type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/stream_on_external_table#timestamp StreamOnExternalTable#timestamp}
    */
    readonly timestamp?: string;
}
export declare function streamOnExternalTableBeforeToTerraform(struct?: StreamOnExternalTableBeforeOutputReference | StreamOnExternalTableBefore): any;
export declare function streamOnExternalTableBeforeToHclTerraform(struct?: StreamOnExternalTableBeforeOutputReference | StreamOnExternalTableBefore): any;
export declare class StreamOnExternalTableBeforeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StreamOnExternalTableBefore | undefined;
    set internalValue(value: StreamOnExternalTableBefore | undefined);
    private _offset?;
    get offset(): string;
    set offset(value: string);
    resetOffset(): void;
    get offsetInput(): string | undefined;
    private _statement?;
    get statement(): string;
    set statement(value: string);
    resetStatement(): void;
    get statementInput(): string | undefined;
    private _stream?;
    get stream(): string;
    set stream(value: string);
    resetStream(): void;
    get streamInput(): string | undefined;
    private _timestamp?;
    get timestamp(): string;
    set timestamp(value: string);
    resetTimestamp(): void;
    get timestampInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/stream_on_external_table snowflake_stream_on_external_table}
*/
export declare class StreamOnExternalTable extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_stream_on_external_table";
    /**
    * Generates CDKTF code for importing a StreamOnExternalTable resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StreamOnExternalTable to import
    * @param importFromId The id of the existing StreamOnExternalTable that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/stream_on_external_table#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StreamOnExternalTable to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/stream_on_external_table snowflake_stream_on_external_table} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StreamOnExternalTableConfig
    */
    constructor(scope: Construct, id: string, config: StreamOnExternalTableConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _copyGrants?;
    get copyGrants(): boolean | cdktf.IResolvable;
    set copyGrants(value: boolean | cdktf.IResolvable);
    resetCopyGrants(): void;
    get copyGrantsInput(): boolean | cdktf.IResolvable | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _describeOutput;
    get describeOutput(): StreamOnExternalTableDescribeOutputList;
    private _externalTable?;
    get externalTable(): string;
    set externalTable(value: string);
    get externalTableInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _insertOnly?;
    get insertOnly(): string;
    set insertOnly(value: string);
    resetInsertOnly(): void;
    get insertOnlyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _showOutput;
    get showOutput(): StreamOnExternalTableShowOutputList;
    get stale(): cdktf.IResolvable;
    get streamType(): string;
    private _at;
    get at(): StreamOnExternalTableAtOutputReference;
    putAt(value: StreamOnExternalTableAt): void;
    resetAt(): void;
    get atInput(): StreamOnExternalTableAt | undefined;
    private _before;
    get before(): StreamOnExternalTableBeforeOutputReference;
    putBefore(value: StreamOnExternalTableBefore): void;
    resetBefore(): void;
    get beforeInput(): StreamOnExternalTableBefore | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
