/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TagAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/tag_association#id TagAssociation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the object identifier for the tag association.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/tag_association#object_name TagAssociation#object_name}
    */
    readonly objectName?: string;
    /**
    * Specifies the type of object to add a tag. Allowed object types: [ACCOUNT APPLICATION APPLICATION PACKAGE DATABASE FAILOVER GROUP INTEGRATION NETWORK POLICY REPLICATION GROUP ROLE SHARE USER WAREHOUSE DATABASE ROLE SCHEMA ALERT SNOWFLAKE.CORE.BUDGET SNOWFLAKE.ML.CLASSIFICATION EXTERNAL FUNCTION EXTERNAL TABLE FUNCTION GIT REPOSITORY ICEBERG TABLE MATERIALIZED VIEW PIPE MASKING POLICY PASSWORD POLICY ROW ACCESS POLICY SESSION POLICY PRIVACY POLICY PROCEDURE STAGE STREAM TABLE TASK VIEW COLUMN EVENT TABLE].
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/tag_association#object_type TagAssociation#object_type}
    */
    readonly objectType: string;
    /**
    * If true, skips validation of the tag association.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/tag_association#skip_validation TagAssociation#skip_validation}
    */
    readonly skipValidation?: boolean | cdktf.IResolvable;
    /**
    * Specifies the identifier for the tag. Note: format must follow: "databaseName"."schemaName"."tagName" or "databaseName.schemaName.tagName" or "databaseName|schemaName.tagName" (snowflake_tag.tag.id)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/tag_association#tag_id TagAssociation#tag_id}
    */
    readonly tagId: string;
    /**
    * Specifies the value of the tag, (e.g. 'finance' or 'engineering')
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/tag_association#tag_value TagAssociation#tag_value}
    */
    readonly tagValue: string;
    /**
    * object_identifier block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/tag_association#object_identifier TagAssociation#object_identifier}
    */
    readonly objectIdentifier: TagAssociationObjectIdentifier[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/tag_association#timeouts TagAssociation#timeouts}
    */
    readonly timeouts?: TagAssociationTimeouts;
}
export interface TagAssociationObjectIdentifier {
    /**
    * Name of the database that the object was created in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/tag_association#database TagAssociation#database}
    */
    readonly database?: string;
    /**
    * Name of the object to associate the tag with.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/tag_association#name TagAssociation#name}
    */
    readonly name: string;
    /**
    * Name of the schema that the object was created in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/tag_association#schema TagAssociation#schema}
    */
    readonly schema?: string;
}
export declare function tagAssociationObjectIdentifierToTerraform(struct?: TagAssociationObjectIdentifier | cdktf.IResolvable): any;
export declare function tagAssociationObjectIdentifierToHclTerraform(struct?: TagAssociationObjectIdentifier | cdktf.IResolvable): any;
export declare class TagAssociationObjectIdentifierOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TagAssociationObjectIdentifier | cdktf.IResolvable | undefined;
    set internalValue(value: TagAssociationObjectIdentifier | cdktf.IResolvable | undefined);
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
}
export declare class TagAssociationObjectIdentifierList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: TagAssociationObjectIdentifier[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TagAssociationObjectIdentifierOutputReference;
}
export interface TagAssociationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/tag_association#create TagAssociation#create}
    */
    readonly create?: string;
}
export declare function tagAssociationTimeoutsToTerraform(struct?: TagAssociationTimeouts | cdktf.IResolvable): any;
export declare function tagAssociationTimeoutsToHclTerraform(struct?: TagAssociationTimeouts | cdktf.IResolvable): any;
export declare class TagAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): TagAssociationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: TagAssociationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/tag_association snowflake_tag_association}
*/
export declare class TagAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_tag_association";
    /**
    * Generates CDKTF code for importing a TagAssociation resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the TagAssociation to import
    * @param importFromId The id of the existing TagAssociation that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/tag_association#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the TagAssociation to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/tag_association snowflake_tag_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TagAssociationConfig
    */
    constructor(scope: Construct, id: string, config: TagAssociationConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _objectName?;
    get objectName(): string;
    set objectName(value: string);
    resetObjectName(): void;
    get objectNameInput(): string | undefined;
    private _objectType?;
    get objectType(): string;
    set objectType(value: string);
    get objectTypeInput(): string | undefined;
    private _skipValidation?;
    get skipValidation(): boolean | cdktf.IResolvable;
    set skipValidation(value: boolean | cdktf.IResolvable);
    resetSkipValidation(): void;
    get skipValidationInput(): boolean | cdktf.IResolvable | undefined;
    private _tagId?;
    get tagId(): string;
    set tagId(value: string);
    get tagIdInput(): string | undefined;
    private _tagValue?;
    get tagValue(): string;
    set tagValue(value: string);
    get tagValueInput(): string | undefined;
    private _objectIdentifier;
    get objectIdentifier(): TagAssociationObjectIdentifierList;
    putObjectIdentifier(value: TagAssociationObjectIdentifier[] | cdktf.IResolvable): void;
    get objectIdentifierInput(): cdktf.IResolvable | TagAssociationObjectIdentifier[] | undefined;
    private _timeouts;
    get timeouts(): TagAssociationTimeoutsOutputReference;
    putTimeouts(value: TagAssociationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | TagAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
