/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the action that Snowflake performs for in-progress queries if connectivity is lost due to abrupt termination of a session (e.g. network outage, browser termination, service interruption). For more information, check [ABORT_DETACHED_QUERY docs](https://docs.snowflake.com/en/sql-reference/parameters#abort-detached-query).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#abort_detached_query User#abort_detached_query}
    */
    readonly abortDetachedQuery?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether autocommit is enabled for the session. Autocommit determines whether a DML statement, when executed without an active transaction, is automatically committed after the statement successfully completes. For more information, see [Transactions](https://docs.snowflake.com/en/sql-reference/transactions). For more information, check [AUTOCOMMIT docs](https://docs.snowflake.com/en/sql-reference/parameters#autocommit).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#autocommit User#autocommit}
    */
    readonly autocommit?: boolean | cdktf.IResolvable;
    /**
    * The format of VARCHAR values passed as input to VARCHAR-to-BINARY conversion functions. For more information, see [Binary input and output](https://docs.snowflake.com/en/sql-reference/binary-input-output). For more information, check [BINARY_INPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#binary-input-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#binary_input_format User#binary_input_format}
    */
    readonly binaryInputFormat?: string;
    /**
    * The format for VARCHAR values returned as output by BINARY-to-VARCHAR conversion functions. For more information, see [Binary input and output](https://docs.snowflake.com/en/sql-reference/binary-input-output). For more information, check [BINARY_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#binary-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#binary_output_format User#binary_output_format}
    */
    readonly binaryOutputFormat?: string;
    /**
    * Parameter that specifies the maximum amount of memory the JDBC driver or ODBC driver should use for the result set from queries (in MB). For more information, check [CLIENT_MEMORY_LIMIT docs](https://docs.snowflake.com/en/sql-reference/parameters#client-memory-limit).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#client_memory_limit User#client_memory_limit}
    */
    readonly clientMemoryLimit?: number;
    /**
    * For specific ODBC functions and JDBC methods, this parameter can change the default search scope from all databases/schemas to the current database/schema. The narrower search typically returns fewer rows and executes more quickly. For more information, check [CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX docs](https://docs.snowflake.com/en/sql-reference/parameters#client-metadata-request-use-connection-ctx).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#client_metadata_request_use_connection_ctx User#client_metadata_request_use_connection_ctx}
    */
    readonly clientMetadataRequestUseConnectionCtx?: boolean | cdktf.IResolvable;
    /**
    * Parameter that specifies the number of threads used by the client to pre-fetch large result sets. The driver will attempt to honor the parameter value, but defines the minimum and maximum values (depending on your system’s resources) to improve performance. For more information, check [CLIENT_PREFETCH_THREADS docs](https://docs.snowflake.com/en/sql-reference/parameters#client-prefetch-threads).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#client_prefetch_threads User#client_prefetch_threads}
    */
    readonly clientPrefetchThreads?: number;
    /**
    * Parameter that specifies the maximum size of each set (or chunk) of query results to download (in MB). The JDBC driver downloads query results in chunks. For more information, check [CLIENT_RESULT_CHUNK_SIZE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-result-chunk-size).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#client_result_chunk_size User#client_result_chunk_size}
    */
    readonly clientResultChunkSize?: number;
    /**
    * Parameter that indicates whether to match column name case-insensitively in ResultSet.get* methods in JDBC. For more information, check [CLIENT_RESULT_COLUMN_CASE_INSENSITIVE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-result-column-case-insensitive).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#client_result_column_case_insensitive User#client_result_column_case_insensitive}
    */
    readonly clientResultColumnCaseInsensitive?: boolean | cdktf.IResolvable;
    /**
    * Parameter that indicates whether to force a user to log in again after a period of inactivity in the session. For more information, check [CLIENT_SESSION_KEEP_ALIVE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-session-keep-alive).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#client_session_keep_alive User#client_session_keep_alive}
    */
    readonly clientSessionKeepAlive?: boolean | cdktf.IResolvable;
    /**
    * Number of seconds in-between client attempts to update the token for the session. For more information, check [CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY docs](https://docs.snowflake.com/en/sql-reference/parameters#client-session-keep-alive-heartbeat-frequency).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#client_session_keep_alive_heartbeat_frequency User#client_session_keep_alive_heartbeat_frequency}
    */
    readonly clientSessionKeepAliveHeartbeatFrequency?: number;
    /**
    * Specifies the [TIMESTAMP_* variation](https://docs.snowflake.com/en/sql-reference/data-types-datetime.html#label-datatypes-timestamp-variations) to use when binding timestamp variables for JDBC or ODBC applications that use the bind API to load data. For more information, check [CLIENT_TIMESTAMP_TYPE_MAPPING docs](https://docs.snowflake.com/en/sql-reference/parameters#client-timestamp-type-mapping).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#client_timestamp_type_mapping User#client_timestamp_type_mapping}
    */
    readonly clientTimestampTypeMapping?: string;
    /**
    * Specifies a comment for the user.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#comment User#comment}
    */
    readonly comment?: string;
    /**
    * Specifies the input format for the DATE data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [DATE_INPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#date-input-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#date_input_format User#date_input_format}
    */
    readonly dateInputFormat?: string;
    /**
    * Specifies the display format for the DATE data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [DATE_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#date-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#date_output_format User#date_output_format}
    */
    readonly dateOutputFormat?: string;
    /**
    * Specifies the number of days after which the user status is set to `Expired` and the user is no longer allowed to log in. This is useful for defining temporary users (i.e. users who should only have access to Snowflake for a limited time period). In general, you should not set this property for [account administrators](https://docs.snowflake.com/en/user-guide/security-access-control-considerations.html#label-accountadmin-users) (i.e. users with the `ACCOUNTADMIN` role) because Snowflake locks them out when they become `Expired`. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#days_to_expiry User#days_to_expiry}
    */
    readonly daysToExpiry?: number;
    /**
    * Specifies the namespace (database only or database and schema) that is active by default for the user’s session upon login. Note that the CREATE USER operation does not verify that the namespace exists.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#default_namespace User#default_namespace}
    */
    readonly defaultNamespace?: string;
    /**
    * Specifies the role that is active by default for the user’s session upon login. Note that specifying a default role for a user does **not** grant the role to the user. The role must be granted explicitly to the user using the [GRANT ROLE](https://docs.snowflake.com/en/sql-reference/sql/grant-role) command. In addition, the CREATE USER operation does not verify that the role exists.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#default_role User#default_role}
    */
    readonly defaultRole?: string;
    /**
    * Specifies the secondary roles that are active for the user’s session upon login. Valid values are (case-insensitive): `DEFAULT` | `NONE` | `ALL`. More information can be found in [doc](https://docs.snowflake.com/en/sql-reference/sql/create-user#optional-object-properties-objectproperties).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#default_secondary_roles_option User#default_secondary_roles_option}
    */
    readonly defaultSecondaryRolesOption?: string;
    /**
    * Specifies the virtual warehouse that is active by default for the user’s session upon login. Note that the CREATE USER operation does not verify that the warehouse exists.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#default_warehouse User#default_warehouse}
    */
    readonly defaultWarehouse?: string;
    /**
    * Allows enabling or disabling [multi-factor authentication](https://docs.snowflake.com/en/user-guide/security-mfa). Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#disable_mfa User#disable_mfa}
    */
    readonly disableMfa?: string;
    /**
    * Specifies whether the user is disabled, which prevents logging in and aborts all the currently-running queries for the user. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#disabled User#disabled}
    */
    readonly disabled?: string;
    /**
    * Name displayed for the user in the Snowflake web interface.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#display_name User#display_name}
    */
    readonly displayName?: string;
    /**
    * Email address for the user.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#email User#email}
    */
    readonly email?: string;
    /**
    * Specifies whether to set the schema for unloaded Parquet files based on the logical column data types (i.e. the types in the unload SQL query or source table) or on the unloaded column values (i.e. the smallest data types and precision that support the values in the output columns of the unload SQL statement or source table). For more information, check [ENABLE_UNLOAD_PHYSICAL_TYPE_OPTIMIZATION docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-unload-physical-type-optimization).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#enable_unload_physical_type_optimization User#enable_unload_physical_type_optimization}
    */
    readonly enableUnloadPhysicalTypeOptimization?: boolean | cdktf.IResolvable;
    /**
    * Controls whether query text is redacted if a SQL query fails due to a syntax or parsing error. If `FALSE`, the content of a failed query is redacted in the views, pages, and functions that provide a query history. Only users with a role that is granted or inherits the AUDIT privilege can set the ENABLE_UNREDACTED_QUERY_SYNTAX_ERROR parameter. When using the ALTER USER command to set the parameter to `TRUE` for a particular user, modify the user that you want to see the query text, not the user who executed the query (if those are different users). For more information, check [ENABLE_UNREDACTED_QUERY_SYNTAX_ERROR docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-unredacted-query-syntax-error).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#enable_unredacted_query_syntax_error User#enable_unredacted_query_syntax_error}
    */
    readonly enableUnredactedQuerySyntaxError?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether to return an error when the [MERGE](https://docs.snowflake.com/en/sql-reference/sql/merge) command is used to update or delete a target row that joins multiple source rows and the system cannot determine the action to perform on the target row. For more information, check [ERROR_ON_NONDETERMINISTIC_MERGE docs](https://docs.snowflake.com/en/sql-reference/parameters#error-on-nondeterministic-merge).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#error_on_nondeterministic_merge User#error_on_nondeterministic_merge}
    */
    readonly errorOnNondeterministicMerge?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether to return an error when the [UPDATE](https://docs.snowflake.com/en/sql-reference/sql/update) command is used to update a target row that joins multiple source rows and the system cannot determine the action to perform on the target row. For more information, check [ERROR_ON_NONDETERMINISTIC_UPDATE docs](https://docs.snowflake.com/en/sql-reference/parameters#error-on-nondeterministic-update).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#error_on_nondeterministic_update User#error_on_nondeterministic_update}
    */
    readonly errorOnNondeterministicUpdate?: boolean | cdktf.IResolvable;
    /**
    * First name of the user.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#first_name User#first_name}
    */
    readonly firstName?: string;
    /**
    * Display format for [GEOGRAPHY values](https://docs.snowflake.com/en/sql-reference/data-types-geospatial.html#label-data-types-geography). For more information, check [GEOGRAPHY_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#geography-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#geography_output_format User#geography_output_format}
    */
    readonly geographyOutputFormat?: string;
    /**
    * Display format for [GEOMETRY values](https://docs.snowflake.com/en/sql-reference/data-types-geospatial.html#label-data-types-geometry). For more information, check [GEOMETRY_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#geometry-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#geometry_output_format User#geometry_output_format}
    */
    readonly geometryOutputFormat?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#id User#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies how JDBC processes columns that have a scale of zero (0). For more information, check [JDBC_TREAT_DECIMAL_AS_INT docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-treat-decimal-as-int).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#jdbc_treat_decimal_as_int User#jdbc_treat_decimal_as_int}
    */
    readonly jdbcTreatDecimalAsInt?: boolean | cdktf.IResolvable;
    /**
    * Specifies how JDBC processes TIMESTAMP_NTZ values. For more information, check [JDBC_TREAT_TIMESTAMP_NTZ_AS_UTC docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-treat-timestamp-ntz-as-utc).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#jdbc_treat_timestamp_ntz_as_utc User#jdbc_treat_timestamp_ntz_as_utc}
    */
    readonly jdbcTreatTimestampNtzAsUtc?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether the JDBC Driver uses the time zone of the JVM or the time zone of the session (specified by the [TIMEZONE](https://docs.snowflake.com/en/sql-reference/parameters#label-timezone) parameter) for the getDate(), getTime(), and getTimestamp() methods of the ResultSet class. For more information, check [JDBC_USE_SESSION_TIMEZONE docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-use-session-timezone).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#jdbc_use_session_timezone User#jdbc_use_session_timezone}
    */
    readonly jdbcUseSessionTimezone?: boolean | cdktf.IResolvable;
    /**
    * Specifies the number of blank spaces to indent each new element in JSON output in the session. Also specifies whether to insert newline characters after each element. For more information, check [JSON_INDENT docs](https://docs.snowflake.com/en/sql-reference/parameters#json-indent).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#json_indent User#json_indent}
    */
    readonly jsonIndent?: number;
    /**
    * Last name of the user.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#last_name User#last_name}
    */
    readonly lastName?: string;
    /**
    * Number of seconds to wait while trying to lock a resource, before timing out and aborting the statement. For more information, check [LOCK_TIMEOUT docs](https://docs.snowflake.com/en/sql-reference/parameters#lock-timeout).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#lock_timeout User#lock_timeout}
    */
    readonly lockTimeout?: number;
    /**
    * Specifies the severity level of messages that should be ingested and made available in the active event table. Messages at the specified level (and at more severe levels) are ingested. For more information about log levels, see [Setting log level](https://docs.snowflake.com/en/developer-guide/logging-tracing/logging-log-level). For more information, check [LOG_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#log-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#log_level User#log_level}
    */
    readonly logLevel?: string;
    /**
    * The name users use to log in. If not supplied, snowflake will use name instead. Login names are always case-insensitive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#login_name User#login_name}
    */
    readonly loginName?: string;
    /**
    * Middle name of the user.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#middle_name User#middle_name}
    */
    readonly middleName?: string;
    /**
    * Specifies the number of minutes to temporarily bypass MFA for the user. This property can be used to allow a MFA-enrolled user to temporarily bypass MFA during login in the event that their MFA device is not available. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#mins_to_bypass_mfa User#mins_to_bypass_mfa}
    */
    readonly minsToBypassMfa?: number;
    /**
    * Specifies the number of minutes until the temporary lock on the user login is cleared. To protect against unauthorized user login, Snowflake places a temporary lock on a user after five consecutive unsuccessful login attempts. When creating a user, this property can be set to prevent them from logging in until the specified amount of time passes. To remove a lock immediately for a user, specify a value of 0 for this parameter. **Note** because this value changes continuously after setting it, the provider is currently NOT handling the external changes to it. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#mins_to_unlock User#mins_to_unlock}
    */
    readonly minsToUnlock?: number;
    /**
    * Number of statements to execute when using the multi-statement capability. For more information, check [MULTI_STATEMENT_COUNT docs](https://docs.snowflake.com/en/sql-reference/parameters#multi-statement-count).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#multi_statement_count User#multi_statement_count}
    */
    readonly multiStatementCount?: number;
    /**
    * Specifies whether the user is forced to change their password on next login (including their first/initial login) into the system. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#must_change_password User#must_change_password}
    */
    readonly mustChangePassword?: string;
    /**
    * Name of the user. Note that if you do not supply login_name this will be used as login_name. Check the [docs](https://docs.snowflake.net/manuals/sql-reference/sql/create-user.html#required-parameters). Due to technical limitations (read more [here](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/docs/technical-documentation/identifiers_rework_design_decisions.md#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `(`, `)`, `"`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#name User#name}
    */
    readonly name: string;
    /**
    * Specifies the network policy to enforce for your account. Network policies enable restricting access to your account based on users’ IP address. For more details, see [Controlling network traffic with network policies](https://docs.snowflake.com/en/user-guide/network-policies). Any existing network policy (created using [CREATE NETWORK POLICY](https://docs.snowflake.com/en/sql-reference/sql/create-network-policy)). For more information, check [NETWORK_POLICY docs](https://docs.snowflake.com/en/sql-reference/parameters#network-policy).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#network_policy User#network_policy}
    */
    readonly networkPolicy?: string;
    /**
    * Specifies whether the ORDER or NOORDER property is set by default when you create a new sequence or add a new table column. The ORDER and NOORDER properties determine whether or not the values are generated for the sequence or auto-incremented column in [increasing or decreasing order](https://docs.snowflake.com/en/user-guide/querying-sequences.html#label-querying-sequences-increasing-values). For more information, check [NOORDER_SEQUENCE_AS_DEFAULT docs](https://docs.snowflake.com/en/sql-reference/parameters#noorder-sequence-as-default).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#noorder_sequence_as_default User#noorder_sequence_as_default}
    */
    readonly noorderSequenceAsDefault?: boolean | cdktf.IResolvable;
    /**
    * Specifies how ODBC processes columns that have a scale of zero (0). For more information, check [ODBC_TREAT_DECIMAL_AS_INT docs](https://docs.snowflake.com/en/sql-reference/parameters#odbc-treat-decimal-as-int).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#odbc_treat_decimal_as_int User#odbc_treat_decimal_as_int}
    */
    readonly odbcTreatDecimalAsInt?: boolean | cdktf.IResolvable;
    /**
    * Password for the user. **WARNING:** this will put the password in the terraform state file. Use carefully.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#password User#password}
    */
    readonly password?: string;
    /**
    * Specifies whether to prevent data unload operations to internal (Snowflake) stages using [COPY INTO <location>](https://docs.snowflake.com/en/sql-reference/sql/copy-into-location) statements. For more information, check [PREVENT_UNLOAD_TO_INTERNAL_STAGES docs](https://docs.snowflake.com/en/sql-reference/parameters#prevent-unload-to-internal-stages).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#prevent_unload_to_internal_stages User#prevent_unload_to_internal_stages}
    */
    readonly preventUnloadToInternalStages?: boolean | cdktf.IResolvable;
    /**
    * Optional string that can be used to tag queries and other SQL statements executed within a session. The tags are displayed in the output of the [QUERY_HISTORY, QUERY_HISTORY_BY_*](https://docs.snowflake.com/en/sql-reference/functions/query_history) functions. For more information, check [QUERY_TAG docs](https://docs.snowflake.com/en/sql-reference/parameters#query-tag).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#query_tag User#query_tag}
    */
    readonly queryTag?: string;
    /**
    * Specifies whether letters in double-quoted object identifiers are stored and resolved as uppercase letters. By default, Snowflake preserves the case of alphabetic characters when storing and resolving double-quoted identifiers (see [Identifier resolution](https://docs.snowflake.com/en/sql-reference/identifiers-syntax.html#label-identifier-casing)). You can use this parameter in situations in which [third-party applications always use double quotes around identifiers](https://docs.snowflake.com/en/sql-reference/identifiers-syntax.html#label-identifier-casing-parameter). For more information, check [QUOTED_IDENTIFIERS_IGNORE_CASE docs](https://docs.snowflake.com/en/sql-reference/parameters#quoted-identifiers-ignore-case).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#quoted_identifiers_ignore_case User#quoted_identifiers_ignore_case}
    */
    readonly quotedIdentifiersIgnoreCase?: boolean | cdktf.IResolvable;
    /**
    * Specifies the maximum number of rows returned in a result set. A value of 0 specifies no maximum. For more information, check [ROWS_PER_RESULTSET docs](https://docs.snowflake.com/en/sql-reference/parameters#rows-per-resultset).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#rows_per_resultset User#rows_per_resultset}
    */
    readonly rowsPerResultset?: number;
    /**
    * Specifies the user’s RSA public key; used for key-pair authentication. Must be on 1 line without header and trailer.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#rsa_public_key User#rsa_public_key}
    */
    readonly rsaPublicKey?: string;
    /**
    * Specifies the user’s second RSA public key; used to rotate the public and private keys for key-pair authentication based on an expiration schedule set by your organization. Must be on 1 line without header and trailer.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#rsa_public_key_2 User#rsa_public_key_2}
    */
    readonly rsaPublicKey2?: string;
    /**
    * Specifies the DNS name of an Amazon S3 interface endpoint. Requests sent to the internal stage of an account via [AWS PrivateLink for Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/privatelink-interface-endpoints.html) use this endpoint to connect. For more information, see [Accessing Internal stages with dedicated interface endpoints](https://docs.snowflake.com/en/user-guide/private-internal-stages-aws.html#label-aws-privatelink-internal-stage-network-isolation). For more information, check [S3_STAGE_VPCE_DNS_NAME docs](https://docs.snowflake.com/en/sql-reference/parameters#s3-stage-vpce-dns-name).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#s3_stage_vpce_dns_name User#s3_stage_vpce_dns_name}
    */
    readonly s3StageVpceDnsName?: string;
    /**
    * Specifies the path to search to resolve unqualified object names in queries. For more information, see [Name resolution in queries](https://docs.snowflake.com/en/sql-reference/name-resolution.html#label-object-name-resolution-search-path). Comma-separated list of identifiers. An identifier can be a fully or partially qualified schema name. For more information, check [SEARCH_PATH docs](https://docs.snowflake.com/en/sql-reference/parameters#search-path).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#search_path User#search_path}
    */
    readonly searchPath?: string;
    /**
    * Specifies the name of a consumer account to simulate for testing/validating shared data, particularly shared secure views. When this parameter is set in a session, shared views return rows as if executed in the specified consumer account rather than the provider account. For more information, see [Introduction to Secure Data Sharing](https://docs.snowflake.com/en/user-guide/data-sharing-intro) and [Working with shares](https://docs.snowflake.com/en/user-guide/data-sharing-provider). For more information, check [SIMULATED_DATA_SHARING_CONSUMER docs](https://docs.snowflake.com/en/sql-reference/parameters#simulated-data-sharing-consumer).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#simulated_data_sharing_consumer User#simulated_data_sharing_consumer}
    */
    readonly simulatedDataSharingConsumer?: string;
    /**
    * Amount of time, in seconds, a SQL statement (query, DDL, DML, etc.) remains queued for a warehouse before it is canceled by the system. This parameter can be used in conjunction with the [MAX_CONCURRENCY_LEVEL](https://docs.snowflake.com/en/sql-reference/parameters#label-max-concurrency-level) parameter to ensure a warehouse is never backlogged. For more information, check [STATEMENT_QUEUED_TIMEOUT_IN_SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#statement-queued-timeout-in-seconds).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#statement_queued_timeout_in_seconds User#statement_queued_timeout_in_seconds}
    */
    readonly statementQueuedTimeoutInSeconds?: number;
    /**
    * Amount of time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system. For more information, check [STATEMENT_TIMEOUT_IN_SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#statement-timeout-in-seconds).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#statement_timeout_in_seconds User#statement_timeout_in_seconds}
    */
    readonly statementTimeoutInSeconds?: number;
    /**
    * This parameter specifies whether JSON output in a session is compatible with the general standard (as described by [http://json.org](http://json.org)). By design, Snowflake allows JSON input that contains non-standard values; however, these non-standard values might result in Snowflake outputting JSON that is incompatible with other platforms and languages. This parameter, when enabled, ensures that Snowflake outputs valid/compatible JSON. For more information, check [STRICT_JSON_OUTPUT docs](https://docs.snowflake.com/en/sql-reference/parameters#strict-json-output).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#strict_json_output User#strict_json_output}
    */
    readonly strictJsonOutput?: boolean | cdktf.IResolvable;
    /**
    * Specifies the input format for the TIME data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). Any valid, supported time format or AUTO (AUTO specifies that Snowflake attempts to automatically detect the format of times stored in the system during the session). For more information, check [TIME_INPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#time-input-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#time_input_format User#time_input_format}
    */
    readonly timeInputFormat?: string;
    /**
    * Specifies the display format for the TIME data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIME_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#time-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#time_output_format User#time_output_format}
    */
    readonly timeOutputFormat?: string;
    /**
    * Specifies whether the [DATEADD](https://docs.snowflake.com/en/sql-reference/functions/dateadd) function (and its aliases) always consider a day to be exactly 24 hours for expressions that span multiple days. For more information, check [TIMESTAMP_DAY_IS_ALWAYS_24H docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-day-is-always-24h).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#timestamp_day_is_always_24h User#timestamp_day_is_always_24h}
    */
    readonly timestampDayIsAlways24H?: boolean | cdktf.IResolvable;
    /**
    * Specifies the input format for the TIMESTAMP data type alias. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). Any valid, supported timestamp format or AUTO (AUTO specifies that Snowflake attempts to automatically detect the format of timestamps stored in the system during the session). For more information, check [TIMESTAMP_INPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-input-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#timestamp_input_format User#timestamp_input_format}
    */
    readonly timestampInputFormat?: string;
    /**
    * Specifies the display format for the TIMESTAMP_LTZ data type. If no format is specified, defaults to [TIMESTAMP_OUTPUT_FORMAT](https://docs.snowflake.com/en/sql-reference/parameters#label-timestamp-output-format). For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP_LTZ_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-ltz-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#timestamp_ltz_output_format User#timestamp_ltz_output_format}
    */
    readonly timestampLtzOutputFormat?: string;
    /**
    * Specifies the display format for the TIMESTAMP_NTZ data type. For more information, check [TIMESTAMP_NTZ_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-ntz-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#timestamp_ntz_output_format User#timestamp_ntz_output_format}
    */
    readonly timestampNtzOutputFormat?: string;
    /**
    * Specifies the display format for the TIMESTAMP data type alias. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#timestamp_output_format User#timestamp_output_format}
    */
    readonly timestampOutputFormat?: string;
    /**
    * Specifies the TIMESTAMP_* variation that the TIMESTAMP data type alias maps to. For more information, check [TIMESTAMP_TYPE_MAPPING docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-type-mapping).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#timestamp_type_mapping User#timestamp_type_mapping}
    */
    readonly timestampTypeMapping?: string;
    /**
    * Specifies the display format for the TIMESTAMP_TZ data type. If no format is specified, defaults to [TIMESTAMP_OUTPUT_FORMAT](https://docs.snowflake.com/en/sql-reference/parameters#label-timestamp-output-format). For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP_TZ_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-tz-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#timestamp_tz_output_format User#timestamp_tz_output_format}
    */
    readonly timestampTzOutputFormat?: string;
    /**
    * Specifies the time zone for the session. You can specify a [time zone name](https://data.iana.org/time-zones/tzdb-2021a/zone1970.tab) or a [link name](https://data.iana.org/time-zones/tzdb-2021a/backward) from release 2021a of the [IANA Time Zone Database](https://www.iana.org/time-zones) (e.g. America/Los_Angeles, Europe/London, UTC, Etc/GMT, etc.). For more information, check [TIMEZONE docs](https://docs.snowflake.com/en/sql-reference/parameters#timezone).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#timezone User#timezone}
    */
    readonly timezone?: string;
    /**
    * Controls how trace events are ingested into the event table. For more information about trace levels, see [Setting trace level](https://docs.snowflake.com/en/developer-guide/logging-tracing/tracing-trace-level). For more information, check [TRACE_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#trace-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#trace_level User#trace_level}
    */
    readonly traceLevel?: string;
    /**
    * Specifies the action to perform when a statement issued within a non-autocommit transaction returns with an error. For more information, check [TRANSACTION_ABORT_ON_ERROR docs](https://docs.snowflake.com/en/sql-reference/parameters#transaction-abort-on-error).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#transaction_abort_on_error User#transaction_abort_on_error}
    */
    readonly transactionAbortOnError?: boolean | cdktf.IResolvable;
    /**
    * Specifies the isolation level for transactions in the user session. For more information, check [TRANSACTION_DEFAULT_ISOLATION_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#transaction-default-isolation-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#transaction_default_isolation_level User#transaction_default_isolation_level}
    */
    readonly transactionDefaultIsolationLevel?: string;
    /**
    * Specifies the “century start” year for 2-digit years (i.e. the earliest year such dates can represent). This parameter prevents ambiguous dates when importing or converting data with the `YY` date format component (i.e. years represented as 2 digits). For more information, check [TWO_DIGIT_CENTURY_START docs](https://docs.snowflake.com/en/sql-reference/parameters#two-digit-century-start).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#two_digit_century_start User#two_digit_century_start}
    */
    readonly twoDigitCenturyStart?: number;
    /**
    * Determines if an unsupported (i.e. non-default) value specified for a constraint property returns an error. For more information, check [UNSUPPORTED_DDL_ACTION docs](https://docs.snowflake.com/en/sql-reference/parameters#unsupported-ddl-action).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#unsupported_ddl_action User#unsupported_ddl_action}
    */
    readonly unsupportedDdlAction?: string;
    /**
    * Specifies whether to reuse persisted query results, if available, when a matching query is submitted. For more information, check [USE_CACHED_RESULT docs](https://docs.snowflake.com/en/sql-reference/parameters#use-cached-result).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#use_cached_result User#use_cached_result}
    */
    readonly useCachedResult?: boolean | cdktf.IResolvable;
    /**
    * Specifies how the weeks in a given year are computed. `0`: The semantics used are equivalent to the ISO semantics, in which a week belongs to a given year if at least 4 days of that week are in that year. `1`: January 1 is included in the first week of the year and December 31 is included in the last week of the year. For more information, check [WEEK_OF_YEAR_POLICY docs](https://docs.snowflake.com/en/sql-reference/parameters#week-of-year-policy).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#week_of_year_policy User#week_of_year_policy}
    */
    readonly weekOfYearPolicy?: number;
    /**
    * Specifies the first day of the week (used by week-related date functions). `0`: Legacy Snowflake behavior is used (i.e. ISO-like semantics). `1` (Monday) to `7` (Sunday): All the week-related functions use weeks that start on the specified day of the week. For more information, check [WEEK_START docs](https://docs.snowflake.com/en/sql-reference/parameters#week-start).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#week_start User#week_start}
    */
    readonly weekStart?: number;
}
export interface UserParametersAbortDetachedQuery {
}
export declare function userParametersAbortDetachedQueryToTerraform(struct?: UserParametersAbortDetachedQuery): any;
export declare function userParametersAbortDetachedQueryToHclTerraform(struct?: UserParametersAbortDetachedQuery): any;
export declare class UserParametersAbortDetachedQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersAbortDetachedQuery | undefined;
    set internalValue(value: UserParametersAbortDetachedQuery | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersAbortDetachedQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersAbortDetachedQueryOutputReference;
}
export interface UserParametersAutocommit {
}
export declare function userParametersAutocommitToTerraform(struct?: UserParametersAutocommit): any;
export declare function userParametersAutocommitToHclTerraform(struct?: UserParametersAutocommit): any;
export declare class UserParametersAutocommitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersAutocommit | undefined;
    set internalValue(value: UserParametersAutocommit | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersAutocommitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersAutocommitOutputReference;
}
export interface UserParametersBinaryInputFormat {
}
export declare function userParametersBinaryInputFormatToTerraform(struct?: UserParametersBinaryInputFormat): any;
export declare function userParametersBinaryInputFormatToHclTerraform(struct?: UserParametersBinaryInputFormat): any;
export declare class UserParametersBinaryInputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersBinaryInputFormat | undefined;
    set internalValue(value: UserParametersBinaryInputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersBinaryInputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersBinaryInputFormatOutputReference;
}
export interface UserParametersBinaryOutputFormat {
}
export declare function userParametersBinaryOutputFormatToTerraform(struct?: UserParametersBinaryOutputFormat): any;
export declare function userParametersBinaryOutputFormatToHclTerraform(struct?: UserParametersBinaryOutputFormat): any;
export declare class UserParametersBinaryOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersBinaryOutputFormat | undefined;
    set internalValue(value: UserParametersBinaryOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersBinaryOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersBinaryOutputFormatOutputReference;
}
export interface UserParametersClientMemoryLimit {
}
export declare function userParametersClientMemoryLimitToTerraform(struct?: UserParametersClientMemoryLimit): any;
export declare function userParametersClientMemoryLimitToHclTerraform(struct?: UserParametersClientMemoryLimit): any;
export declare class UserParametersClientMemoryLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersClientMemoryLimit | undefined;
    set internalValue(value: UserParametersClientMemoryLimit | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersClientMemoryLimitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersClientMemoryLimitOutputReference;
}
export interface UserParametersClientMetadataRequestUseConnectionCtx {
}
export declare function userParametersClientMetadataRequestUseConnectionCtxToTerraform(struct?: UserParametersClientMetadataRequestUseConnectionCtx): any;
export declare function userParametersClientMetadataRequestUseConnectionCtxToHclTerraform(struct?: UserParametersClientMetadataRequestUseConnectionCtx): any;
export declare class UserParametersClientMetadataRequestUseConnectionCtxOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersClientMetadataRequestUseConnectionCtx | undefined;
    set internalValue(value: UserParametersClientMetadataRequestUseConnectionCtx | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersClientMetadataRequestUseConnectionCtxList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersClientMetadataRequestUseConnectionCtxOutputReference;
}
export interface UserParametersClientPrefetchThreads {
}
export declare function userParametersClientPrefetchThreadsToTerraform(struct?: UserParametersClientPrefetchThreads): any;
export declare function userParametersClientPrefetchThreadsToHclTerraform(struct?: UserParametersClientPrefetchThreads): any;
export declare class UserParametersClientPrefetchThreadsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersClientPrefetchThreads | undefined;
    set internalValue(value: UserParametersClientPrefetchThreads | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersClientPrefetchThreadsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersClientPrefetchThreadsOutputReference;
}
export interface UserParametersClientResultChunkSize {
}
export declare function userParametersClientResultChunkSizeToTerraform(struct?: UserParametersClientResultChunkSize): any;
export declare function userParametersClientResultChunkSizeToHclTerraform(struct?: UserParametersClientResultChunkSize): any;
export declare class UserParametersClientResultChunkSizeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersClientResultChunkSize | undefined;
    set internalValue(value: UserParametersClientResultChunkSize | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersClientResultChunkSizeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersClientResultChunkSizeOutputReference;
}
export interface UserParametersClientResultColumnCaseInsensitive {
}
export declare function userParametersClientResultColumnCaseInsensitiveToTerraform(struct?: UserParametersClientResultColumnCaseInsensitive): any;
export declare function userParametersClientResultColumnCaseInsensitiveToHclTerraform(struct?: UserParametersClientResultColumnCaseInsensitive): any;
export declare class UserParametersClientResultColumnCaseInsensitiveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersClientResultColumnCaseInsensitive | undefined;
    set internalValue(value: UserParametersClientResultColumnCaseInsensitive | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersClientResultColumnCaseInsensitiveList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersClientResultColumnCaseInsensitiveOutputReference;
}
export interface UserParametersClientSessionKeepAlive {
}
export declare function userParametersClientSessionKeepAliveToTerraform(struct?: UserParametersClientSessionKeepAlive): any;
export declare function userParametersClientSessionKeepAliveToHclTerraform(struct?: UserParametersClientSessionKeepAlive): any;
export declare class UserParametersClientSessionKeepAliveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersClientSessionKeepAlive | undefined;
    set internalValue(value: UserParametersClientSessionKeepAlive | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersClientSessionKeepAliveList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersClientSessionKeepAliveOutputReference;
}
export interface UserParametersClientSessionKeepAliveHeartbeatFrequency {
}
export declare function userParametersClientSessionKeepAliveHeartbeatFrequencyToTerraform(struct?: UserParametersClientSessionKeepAliveHeartbeatFrequency): any;
export declare function userParametersClientSessionKeepAliveHeartbeatFrequencyToHclTerraform(struct?: UserParametersClientSessionKeepAliveHeartbeatFrequency): any;
export declare class UserParametersClientSessionKeepAliveHeartbeatFrequencyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersClientSessionKeepAliveHeartbeatFrequency | undefined;
    set internalValue(value: UserParametersClientSessionKeepAliveHeartbeatFrequency | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersClientSessionKeepAliveHeartbeatFrequencyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersClientSessionKeepAliveHeartbeatFrequencyOutputReference;
}
export interface UserParametersClientTimestampTypeMapping {
}
export declare function userParametersClientTimestampTypeMappingToTerraform(struct?: UserParametersClientTimestampTypeMapping): any;
export declare function userParametersClientTimestampTypeMappingToHclTerraform(struct?: UserParametersClientTimestampTypeMapping): any;
export declare class UserParametersClientTimestampTypeMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersClientTimestampTypeMapping | undefined;
    set internalValue(value: UserParametersClientTimestampTypeMapping | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersClientTimestampTypeMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersClientTimestampTypeMappingOutputReference;
}
export interface UserParametersDateInputFormat {
}
export declare function userParametersDateInputFormatToTerraform(struct?: UserParametersDateInputFormat): any;
export declare function userParametersDateInputFormatToHclTerraform(struct?: UserParametersDateInputFormat): any;
export declare class UserParametersDateInputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersDateInputFormat | undefined;
    set internalValue(value: UserParametersDateInputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersDateInputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersDateInputFormatOutputReference;
}
export interface UserParametersDateOutputFormat {
}
export declare function userParametersDateOutputFormatToTerraform(struct?: UserParametersDateOutputFormat): any;
export declare function userParametersDateOutputFormatToHclTerraform(struct?: UserParametersDateOutputFormat): any;
export declare class UserParametersDateOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersDateOutputFormat | undefined;
    set internalValue(value: UserParametersDateOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersDateOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersDateOutputFormatOutputReference;
}
export interface UserParametersEnableUnloadPhysicalTypeOptimization {
}
export declare function userParametersEnableUnloadPhysicalTypeOptimizationToTerraform(struct?: UserParametersEnableUnloadPhysicalTypeOptimization): any;
export declare function userParametersEnableUnloadPhysicalTypeOptimizationToHclTerraform(struct?: UserParametersEnableUnloadPhysicalTypeOptimization): any;
export declare class UserParametersEnableUnloadPhysicalTypeOptimizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersEnableUnloadPhysicalTypeOptimization | undefined;
    set internalValue(value: UserParametersEnableUnloadPhysicalTypeOptimization | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersEnableUnloadPhysicalTypeOptimizationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersEnableUnloadPhysicalTypeOptimizationOutputReference;
}
export interface UserParametersEnableUnredactedQuerySyntaxError {
}
export declare function userParametersEnableUnredactedQuerySyntaxErrorToTerraform(struct?: UserParametersEnableUnredactedQuerySyntaxError): any;
export declare function userParametersEnableUnredactedQuerySyntaxErrorToHclTerraform(struct?: UserParametersEnableUnredactedQuerySyntaxError): any;
export declare class UserParametersEnableUnredactedQuerySyntaxErrorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersEnableUnredactedQuerySyntaxError | undefined;
    set internalValue(value: UserParametersEnableUnredactedQuerySyntaxError | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersEnableUnredactedQuerySyntaxErrorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersEnableUnredactedQuerySyntaxErrorOutputReference;
}
export interface UserParametersErrorOnNondeterministicMerge {
}
export declare function userParametersErrorOnNondeterministicMergeToTerraform(struct?: UserParametersErrorOnNondeterministicMerge): any;
export declare function userParametersErrorOnNondeterministicMergeToHclTerraform(struct?: UserParametersErrorOnNondeterministicMerge): any;
export declare class UserParametersErrorOnNondeterministicMergeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersErrorOnNondeterministicMerge | undefined;
    set internalValue(value: UserParametersErrorOnNondeterministicMerge | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersErrorOnNondeterministicMergeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersErrorOnNondeterministicMergeOutputReference;
}
export interface UserParametersErrorOnNondeterministicUpdate {
}
export declare function userParametersErrorOnNondeterministicUpdateToTerraform(struct?: UserParametersErrorOnNondeterministicUpdate): any;
export declare function userParametersErrorOnNondeterministicUpdateToHclTerraform(struct?: UserParametersErrorOnNondeterministicUpdate): any;
export declare class UserParametersErrorOnNondeterministicUpdateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersErrorOnNondeterministicUpdate | undefined;
    set internalValue(value: UserParametersErrorOnNondeterministicUpdate | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersErrorOnNondeterministicUpdateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersErrorOnNondeterministicUpdateOutputReference;
}
export interface UserParametersGeographyOutputFormat {
}
export declare function userParametersGeographyOutputFormatToTerraform(struct?: UserParametersGeographyOutputFormat): any;
export declare function userParametersGeographyOutputFormatToHclTerraform(struct?: UserParametersGeographyOutputFormat): any;
export declare class UserParametersGeographyOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersGeographyOutputFormat | undefined;
    set internalValue(value: UserParametersGeographyOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersGeographyOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersGeographyOutputFormatOutputReference;
}
export interface UserParametersGeometryOutputFormat {
}
export declare function userParametersGeometryOutputFormatToTerraform(struct?: UserParametersGeometryOutputFormat): any;
export declare function userParametersGeometryOutputFormatToHclTerraform(struct?: UserParametersGeometryOutputFormat): any;
export declare class UserParametersGeometryOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersGeometryOutputFormat | undefined;
    set internalValue(value: UserParametersGeometryOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersGeometryOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersGeometryOutputFormatOutputReference;
}
export interface UserParametersJdbcTreatDecimalAsInt {
}
export declare function userParametersJdbcTreatDecimalAsIntToTerraform(struct?: UserParametersJdbcTreatDecimalAsInt): any;
export declare function userParametersJdbcTreatDecimalAsIntToHclTerraform(struct?: UserParametersJdbcTreatDecimalAsInt): any;
export declare class UserParametersJdbcTreatDecimalAsIntOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersJdbcTreatDecimalAsInt | undefined;
    set internalValue(value: UserParametersJdbcTreatDecimalAsInt | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersJdbcTreatDecimalAsIntList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersJdbcTreatDecimalAsIntOutputReference;
}
export interface UserParametersJdbcTreatTimestampNtzAsUtc {
}
export declare function userParametersJdbcTreatTimestampNtzAsUtcToTerraform(struct?: UserParametersJdbcTreatTimestampNtzAsUtc): any;
export declare function userParametersJdbcTreatTimestampNtzAsUtcToHclTerraform(struct?: UserParametersJdbcTreatTimestampNtzAsUtc): any;
export declare class UserParametersJdbcTreatTimestampNtzAsUtcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersJdbcTreatTimestampNtzAsUtc | undefined;
    set internalValue(value: UserParametersJdbcTreatTimestampNtzAsUtc | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersJdbcTreatTimestampNtzAsUtcList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersJdbcTreatTimestampNtzAsUtcOutputReference;
}
export interface UserParametersJdbcUseSessionTimezone {
}
export declare function userParametersJdbcUseSessionTimezoneToTerraform(struct?: UserParametersJdbcUseSessionTimezone): any;
export declare function userParametersJdbcUseSessionTimezoneToHclTerraform(struct?: UserParametersJdbcUseSessionTimezone): any;
export declare class UserParametersJdbcUseSessionTimezoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersJdbcUseSessionTimezone | undefined;
    set internalValue(value: UserParametersJdbcUseSessionTimezone | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersJdbcUseSessionTimezoneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersJdbcUseSessionTimezoneOutputReference;
}
export interface UserParametersJsonIndent {
}
export declare function userParametersJsonIndentToTerraform(struct?: UserParametersJsonIndent): any;
export declare function userParametersJsonIndentToHclTerraform(struct?: UserParametersJsonIndent): any;
export declare class UserParametersJsonIndentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersJsonIndent | undefined;
    set internalValue(value: UserParametersJsonIndent | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersJsonIndentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersJsonIndentOutputReference;
}
export interface UserParametersLockTimeout {
}
export declare function userParametersLockTimeoutToTerraform(struct?: UserParametersLockTimeout): any;
export declare function userParametersLockTimeoutToHclTerraform(struct?: UserParametersLockTimeout): any;
export declare class UserParametersLockTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersLockTimeout | undefined;
    set internalValue(value: UserParametersLockTimeout | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersLockTimeoutList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersLockTimeoutOutputReference;
}
export interface UserParametersLogLevel {
}
export declare function userParametersLogLevelToTerraform(struct?: UserParametersLogLevel): any;
export declare function userParametersLogLevelToHclTerraform(struct?: UserParametersLogLevel): any;
export declare class UserParametersLogLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersLogLevel | undefined;
    set internalValue(value: UserParametersLogLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersLogLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersLogLevelOutputReference;
}
export interface UserParametersMultiStatementCount {
}
export declare function userParametersMultiStatementCountToTerraform(struct?: UserParametersMultiStatementCount): any;
export declare function userParametersMultiStatementCountToHclTerraform(struct?: UserParametersMultiStatementCount): any;
export declare class UserParametersMultiStatementCountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersMultiStatementCount | undefined;
    set internalValue(value: UserParametersMultiStatementCount | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersMultiStatementCountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersMultiStatementCountOutputReference;
}
export interface UserParametersNetworkPolicy {
}
export declare function userParametersNetworkPolicyToTerraform(struct?: UserParametersNetworkPolicy): any;
export declare function userParametersNetworkPolicyToHclTerraform(struct?: UserParametersNetworkPolicy): any;
export declare class UserParametersNetworkPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersNetworkPolicy | undefined;
    set internalValue(value: UserParametersNetworkPolicy | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersNetworkPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersNetworkPolicyOutputReference;
}
export interface UserParametersNoorderSequenceAsDefault {
}
export declare function userParametersNoorderSequenceAsDefaultToTerraform(struct?: UserParametersNoorderSequenceAsDefault): any;
export declare function userParametersNoorderSequenceAsDefaultToHclTerraform(struct?: UserParametersNoorderSequenceAsDefault): any;
export declare class UserParametersNoorderSequenceAsDefaultOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersNoorderSequenceAsDefault | undefined;
    set internalValue(value: UserParametersNoorderSequenceAsDefault | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersNoorderSequenceAsDefaultList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersNoorderSequenceAsDefaultOutputReference;
}
export interface UserParametersOdbcTreatDecimalAsInt {
}
export declare function userParametersOdbcTreatDecimalAsIntToTerraform(struct?: UserParametersOdbcTreatDecimalAsInt): any;
export declare function userParametersOdbcTreatDecimalAsIntToHclTerraform(struct?: UserParametersOdbcTreatDecimalAsInt): any;
export declare class UserParametersOdbcTreatDecimalAsIntOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersOdbcTreatDecimalAsInt | undefined;
    set internalValue(value: UserParametersOdbcTreatDecimalAsInt | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersOdbcTreatDecimalAsIntList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersOdbcTreatDecimalAsIntOutputReference;
}
export interface UserParametersPreventUnloadToInternalStages {
}
export declare function userParametersPreventUnloadToInternalStagesToTerraform(struct?: UserParametersPreventUnloadToInternalStages): any;
export declare function userParametersPreventUnloadToInternalStagesToHclTerraform(struct?: UserParametersPreventUnloadToInternalStages): any;
export declare class UserParametersPreventUnloadToInternalStagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersPreventUnloadToInternalStages | undefined;
    set internalValue(value: UserParametersPreventUnloadToInternalStages | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersPreventUnloadToInternalStagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersPreventUnloadToInternalStagesOutputReference;
}
export interface UserParametersQueryTag {
}
export declare function userParametersQueryTagToTerraform(struct?: UserParametersQueryTag): any;
export declare function userParametersQueryTagToHclTerraform(struct?: UserParametersQueryTag): any;
export declare class UserParametersQueryTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersQueryTag | undefined;
    set internalValue(value: UserParametersQueryTag | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersQueryTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersQueryTagOutputReference;
}
export interface UserParametersQuotedIdentifiersIgnoreCase {
}
export declare function userParametersQuotedIdentifiersIgnoreCaseToTerraform(struct?: UserParametersQuotedIdentifiersIgnoreCase): any;
export declare function userParametersQuotedIdentifiersIgnoreCaseToHclTerraform(struct?: UserParametersQuotedIdentifiersIgnoreCase): any;
export declare class UserParametersQuotedIdentifiersIgnoreCaseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersQuotedIdentifiersIgnoreCase | undefined;
    set internalValue(value: UserParametersQuotedIdentifiersIgnoreCase | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersQuotedIdentifiersIgnoreCaseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersQuotedIdentifiersIgnoreCaseOutputReference;
}
export interface UserParametersRowsPerResultset {
}
export declare function userParametersRowsPerResultsetToTerraform(struct?: UserParametersRowsPerResultset): any;
export declare function userParametersRowsPerResultsetToHclTerraform(struct?: UserParametersRowsPerResultset): any;
export declare class UserParametersRowsPerResultsetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersRowsPerResultset | undefined;
    set internalValue(value: UserParametersRowsPerResultset | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersRowsPerResultsetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersRowsPerResultsetOutputReference;
}
export interface UserParametersS3StageVpceDnsName {
}
export declare function userParametersS3StageVpceDnsNameToTerraform(struct?: UserParametersS3StageVpceDnsName): any;
export declare function userParametersS3StageVpceDnsNameToHclTerraform(struct?: UserParametersS3StageVpceDnsName): any;
export declare class UserParametersS3StageVpceDnsNameOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersS3StageVpceDnsName | undefined;
    set internalValue(value: UserParametersS3StageVpceDnsName | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersS3StageVpceDnsNameList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersS3StageVpceDnsNameOutputReference;
}
export interface UserParametersSearchPath {
}
export declare function userParametersSearchPathToTerraform(struct?: UserParametersSearchPath): any;
export declare function userParametersSearchPathToHclTerraform(struct?: UserParametersSearchPath): any;
export declare class UserParametersSearchPathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersSearchPath | undefined;
    set internalValue(value: UserParametersSearchPath | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersSearchPathList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersSearchPathOutputReference;
}
export interface UserParametersSimulatedDataSharingConsumer {
}
export declare function userParametersSimulatedDataSharingConsumerToTerraform(struct?: UserParametersSimulatedDataSharingConsumer): any;
export declare function userParametersSimulatedDataSharingConsumerToHclTerraform(struct?: UserParametersSimulatedDataSharingConsumer): any;
export declare class UserParametersSimulatedDataSharingConsumerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersSimulatedDataSharingConsumer | undefined;
    set internalValue(value: UserParametersSimulatedDataSharingConsumer | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersSimulatedDataSharingConsumerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersSimulatedDataSharingConsumerOutputReference;
}
export interface UserParametersStatementQueuedTimeoutInSeconds {
}
export declare function userParametersStatementQueuedTimeoutInSecondsToTerraform(struct?: UserParametersStatementQueuedTimeoutInSeconds): any;
export declare function userParametersStatementQueuedTimeoutInSecondsToHclTerraform(struct?: UserParametersStatementQueuedTimeoutInSeconds): any;
export declare class UserParametersStatementQueuedTimeoutInSecondsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersStatementQueuedTimeoutInSeconds | undefined;
    set internalValue(value: UserParametersStatementQueuedTimeoutInSeconds | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersStatementQueuedTimeoutInSecondsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersStatementQueuedTimeoutInSecondsOutputReference;
}
export interface UserParametersStatementTimeoutInSeconds {
}
export declare function userParametersStatementTimeoutInSecondsToTerraform(struct?: UserParametersStatementTimeoutInSeconds): any;
export declare function userParametersStatementTimeoutInSecondsToHclTerraform(struct?: UserParametersStatementTimeoutInSeconds): any;
export declare class UserParametersStatementTimeoutInSecondsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersStatementTimeoutInSeconds | undefined;
    set internalValue(value: UserParametersStatementTimeoutInSeconds | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersStatementTimeoutInSecondsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersStatementTimeoutInSecondsOutputReference;
}
export interface UserParametersStrictJsonOutput {
}
export declare function userParametersStrictJsonOutputToTerraform(struct?: UserParametersStrictJsonOutput): any;
export declare function userParametersStrictJsonOutputToHclTerraform(struct?: UserParametersStrictJsonOutput): any;
export declare class UserParametersStrictJsonOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersStrictJsonOutput | undefined;
    set internalValue(value: UserParametersStrictJsonOutput | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersStrictJsonOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersStrictJsonOutputOutputReference;
}
export interface UserParametersTimeInputFormat {
}
export declare function userParametersTimeInputFormatToTerraform(struct?: UserParametersTimeInputFormat): any;
export declare function userParametersTimeInputFormatToHclTerraform(struct?: UserParametersTimeInputFormat): any;
export declare class UserParametersTimeInputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersTimeInputFormat | undefined;
    set internalValue(value: UserParametersTimeInputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersTimeInputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersTimeInputFormatOutputReference;
}
export interface UserParametersTimeOutputFormat {
}
export declare function userParametersTimeOutputFormatToTerraform(struct?: UserParametersTimeOutputFormat): any;
export declare function userParametersTimeOutputFormatToHclTerraform(struct?: UserParametersTimeOutputFormat): any;
export declare class UserParametersTimeOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersTimeOutputFormat | undefined;
    set internalValue(value: UserParametersTimeOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersTimeOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersTimeOutputFormatOutputReference;
}
export interface UserParametersTimestampDayIsAlways24H {
}
export declare function userParametersTimestampDayIsAlways24HToTerraform(struct?: UserParametersTimestampDayIsAlways24H): any;
export declare function userParametersTimestampDayIsAlways24HToHclTerraform(struct?: UserParametersTimestampDayIsAlways24H): any;
export declare class UserParametersTimestampDayIsAlways24HOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersTimestampDayIsAlways24H | undefined;
    set internalValue(value: UserParametersTimestampDayIsAlways24H | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersTimestampDayIsAlways24HList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersTimestampDayIsAlways24HOutputReference;
}
export interface UserParametersTimestampInputFormat {
}
export declare function userParametersTimestampInputFormatToTerraform(struct?: UserParametersTimestampInputFormat): any;
export declare function userParametersTimestampInputFormatToHclTerraform(struct?: UserParametersTimestampInputFormat): any;
export declare class UserParametersTimestampInputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersTimestampInputFormat | undefined;
    set internalValue(value: UserParametersTimestampInputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersTimestampInputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersTimestampInputFormatOutputReference;
}
export interface UserParametersTimestampLtzOutputFormat {
}
export declare function userParametersTimestampLtzOutputFormatToTerraform(struct?: UserParametersTimestampLtzOutputFormat): any;
export declare function userParametersTimestampLtzOutputFormatToHclTerraform(struct?: UserParametersTimestampLtzOutputFormat): any;
export declare class UserParametersTimestampLtzOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersTimestampLtzOutputFormat | undefined;
    set internalValue(value: UserParametersTimestampLtzOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersTimestampLtzOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersTimestampLtzOutputFormatOutputReference;
}
export interface UserParametersTimestampNtzOutputFormat {
}
export declare function userParametersTimestampNtzOutputFormatToTerraform(struct?: UserParametersTimestampNtzOutputFormat): any;
export declare function userParametersTimestampNtzOutputFormatToHclTerraform(struct?: UserParametersTimestampNtzOutputFormat): any;
export declare class UserParametersTimestampNtzOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersTimestampNtzOutputFormat | undefined;
    set internalValue(value: UserParametersTimestampNtzOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersTimestampNtzOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersTimestampNtzOutputFormatOutputReference;
}
export interface UserParametersTimestampOutputFormat {
}
export declare function userParametersTimestampOutputFormatToTerraform(struct?: UserParametersTimestampOutputFormat): any;
export declare function userParametersTimestampOutputFormatToHclTerraform(struct?: UserParametersTimestampOutputFormat): any;
export declare class UserParametersTimestampOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersTimestampOutputFormat | undefined;
    set internalValue(value: UserParametersTimestampOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersTimestampOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersTimestampOutputFormatOutputReference;
}
export interface UserParametersTimestampTypeMapping {
}
export declare function userParametersTimestampTypeMappingToTerraform(struct?: UserParametersTimestampTypeMapping): any;
export declare function userParametersTimestampTypeMappingToHclTerraform(struct?: UserParametersTimestampTypeMapping): any;
export declare class UserParametersTimestampTypeMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersTimestampTypeMapping | undefined;
    set internalValue(value: UserParametersTimestampTypeMapping | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersTimestampTypeMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersTimestampTypeMappingOutputReference;
}
export interface UserParametersTimestampTzOutputFormat {
}
export declare function userParametersTimestampTzOutputFormatToTerraform(struct?: UserParametersTimestampTzOutputFormat): any;
export declare function userParametersTimestampTzOutputFormatToHclTerraform(struct?: UserParametersTimestampTzOutputFormat): any;
export declare class UserParametersTimestampTzOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersTimestampTzOutputFormat | undefined;
    set internalValue(value: UserParametersTimestampTzOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersTimestampTzOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersTimestampTzOutputFormatOutputReference;
}
export interface UserParametersTimezone {
}
export declare function userParametersTimezoneToTerraform(struct?: UserParametersTimezone): any;
export declare function userParametersTimezoneToHclTerraform(struct?: UserParametersTimezone): any;
export declare class UserParametersTimezoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersTimezone | undefined;
    set internalValue(value: UserParametersTimezone | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersTimezoneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersTimezoneOutputReference;
}
export interface UserParametersTraceLevel {
}
export declare function userParametersTraceLevelToTerraform(struct?: UserParametersTraceLevel): any;
export declare function userParametersTraceLevelToHclTerraform(struct?: UserParametersTraceLevel): any;
export declare class UserParametersTraceLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersTraceLevel | undefined;
    set internalValue(value: UserParametersTraceLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersTraceLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersTraceLevelOutputReference;
}
export interface UserParametersTransactionAbortOnError {
}
export declare function userParametersTransactionAbortOnErrorToTerraform(struct?: UserParametersTransactionAbortOnError): any;
export declare function userParametersTransactionAbortOnErrorToHclTerraform(struct?: UserParametersTransactionAbortOnError): any;
export declare class UserParametersTransactionAbortOnErrorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersTransactionAbortOnError | undefined;
    set internalValue(value: UserParametersTransactionAbortOnError | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersTransactionAbortOnErrorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersTransactionAbortOnErrorOutputReference;
}
export interface UserParametersTransactionDefaultIsolationLevel {
}
export declare function userParametersTransactionDefaultIsolationLevelToTerraform(struct?: UserParametersTransactionDefaultIsolationLevel): any;
export declare function userParametersTransactionDefaultIsolationLevelToHclTerraform(struct?: UserParametersTransactionDefaultIsolationLevel): any;
export declare class UserParametersTransactionDefaultIsolationLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersTransactionDefaultIsolationLevel | undefined;
    set internalValue(value: UserParametersTransactionDefaultIsolationLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersTransactionDefaultIsolationLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersTransactionDefaultIsolationLevelOutputReference;
}
export interface UserParametersTwoDigitCenturyStart {
}
export declare function userParametersTwoDigitCenturyStartToTerraform(struct?: UserParametersTwoDigitCenturyStart): any;
export declare function userParametersTwoDigitCenturyStartToHclTerraform(struct?: UserParametersTwoDigitCenturyStart): any;
export declare class UserParametersTwoDigitCenturyStartOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersTwoDigitCenturyStart | undefined;
    set internalValue(value: UserParametersTwoDigitCenturyStart | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersTwoDigitCenturyStartList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersTwoDigitCenturyStartOutputReference;
}
export interface UserParametersUnsupportedDdlAction {
}
export declare function userParametersUnsupportedDdlActionToTerraform(struct?: UserParametersUnsupportedDdlAction): any;
export declare function userParametersUnsupportedDdlActionToHclTerraform(struct?: UserParametersUnsupportedDdlAction): any;
export declare class UserParametersUnsupportedDdlActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersUnsupportedDdlAction | undefined;
    set internalValue(value: UserParametersUnsupportedDdlAction | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersUnsupportedDdlActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersUnsupportedDdlActionOutputReference;
}
export interface UserParametersUseCachedResult {
}
export declare function userParametersUseCachedResultToTerraform(struct?: UserParametersUseCachedResult): any;
export declare function userParametersUseCachedResultToHclTerraform(struct?: UserParametersUseCachedResult): any;
export declare class UserParametersUseCachedResultOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersUseCachedResult | undefined;
    set internalValue(value: UserParametersUseCachedResult | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersUseCachedResultList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersUseCachedResultOutputReference;
}
export interface UserParametersWeekOfYearPolicy {
}
export declare function userParametersWeekOfYearPolicyToTerraform(struct?: UserParametersWeekOfYearPolicy): any;
export declare function userParametersWeekOfYearPolicyToHclTerraform(struct?: UserParametersWeekOfYearPolicy): any;
export declare class UserParametersWeekOfYearPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersWeekOfYearPolicy | undefined;
    set internalValue(value: UserParametersWeekOfYearPolicy | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersWeekOfYearPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersWeekOfYearPolicyOutputReference;
}
export interface UserParametersWeekStart {
}
export declare function userParametersWeekStartToTerraform(struct?: UserParametersWeekStart): any;
export declare function userParametersWeekStartToHclTerraform(struct?: UserParametersWeekStart): any;
export declare class UserParametersWeekStartOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParametersWeekStart | undefined;
    set internalValue(value: UserParametersWeekStart | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class UserParametersWeekStartList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersWeekStartOutputReference;
}
export interface UserParameters {
}
export declare function userParametersToTerraform(struct?: UserParameters): any;
export declare function userParametersToHclTerraform(struct?: UserParameters): any;
export declare class UserParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserParameters | undefined;
    set internalValue(value: UserParameters | undefined);
    private _abortDetachedQuery;
    get abortDetachedQuery(): UserParametersAbortDetachedQueryList;
    private _autocommit;
    get autocommit(): UserParametersAutocommitList;
    private _binaryInputFormat;
    get binaryInputFormat(): UserParametersBinaryInputFormatList;
    private _binaryOutputFormat;
    get binaryOutputFormat(): UserParametersBinaryOutputFormatList;
    private _clientMemoryLimit;
    get clientMemoryLimit(): UserParametersClientMemoryLimitList;
    private _clientMetadataRequestUseConnectionCtx;
    get clientMetadataRequestUseConnectionCtx(): UserParametersClientMetadataRequestUseConnectionCtxList;
    private _clientPrefetchThreads;
    get clientPrefetchThreads(): UserParametersClientPrefetchThreadsList;
    private _clientResultChunkSize;
    get clientResultChunkSize(): UserParametersClientResultChunkSizeList;
    private _clientResultColumnCaseInsensitive;
    get clientResultColumnCaseInsensitive(): UserParametersClientResultColumnCaseInsensitiveList;
    private _clientSessionKeepAlive;
    get clientSessionKeepAlive(): UserParametersClientSessionKeepAliveList;
    private _clientSessionKeepAliveHeartbeatFrequency;
    get clientSessionKeepAliveHeartbeatFrequency(): UserParametersClientSessionKeepAliveHeartbeatFrequencyList;
    private _clientTimestampTypeMapping;
    get clientTimestampTypeMapping(): UserParametersClientTimestampTypeMappingList;
    private _dateInputFormat;
    get dateInputFormat(): UserParametersDateInputFormatList;
    private _dateOutputFormat;
    get dateOutputFormat(): UserParametersDateOutputFormatList;
    private _enableUnloadPhysicalTypeOptimization;
    get enableUnloadPhysicalTypeOptimization(): UserParametersEnableUnloadPhysicalTypeOptimizationList;
    private _enableUnredactedQuerySyntaxError;
    get enableUnredactedQuerySyntaxError(): UserParametersEnableUnredactedQuerySyntaxErrorList;
    private _errorOnNondeterministicMerge;
    get errorOnNondeterministicMerge(): UserParametersErrorOnNondeterministicMergeList;
    private _errorOnNondeterministicUpdate;
    get errorOnNondeterministicUpdate(): UserParametersErrorOnNondeterministicUpdateList;
    private _geographyOutputFormat;
    get geographyOutputFormat(): UserParametersGeographyOutputFormatList;
    private _geometryOutputFormat;
    get geometryOutputFormat(): UserParametersGeometryOutputFormatList;
    private _jdbcTreatDecimalAsInt;
    get jdbcTreatDecimalAsInt(): UserParametersJdbcTreatDecimalAsIntList;
    private _jdbcTreatTimestampNtzAsUtc;
    get jdbcTreatTimestampNtzAsUtc(): UserParametersJdbcTreatTimestampNtzAsUtcList;
    private _jdbcUseSessionTimezone;
    get jdbcUseSessionTimezone(): UserParametersJdbcUseSessionTimezoneList;
    private _jsonIndent;
    get jsonIndent(): UserParametersJsonIndentList;
    private _lockTimeout;
    get lockTimeout(): UserParametersLockTimeoutList;
    private _logLevel;
    get logLevel(): UserParametersLogLevelList;
    private _multiStatementCount;
    get multiStatementCount(): UserParametersMultiStatementCountList;
    private _networkPolicy;
    get networkPolicy(): UserParametersNetworkPolicyList;
    private _noorderSequenceAsDefault;
    get noorderSequenceAsDefault(): UserParametersNoorderSequenceAsDefaultList;
    private _odbcTreatDecimalAsInt;
    get odbcTreatDecimalAsInt(): UserParametersOdbcTreatDecimalAsIntList;
    private _preventUnloadToInternalStages;
    get preventUnloadToInternalStages(): UserParametersPreventUnloadToInternalStagesList;
    private _queryTag;
    get queryTag(): UserParametersQueryTagList;
    private _quotedIdentifiersIgnoreCase;
    get quotedIdentifiersIgnoreCase(): UserParametersQuotedIdentifiersIgnoreCaseList;
    private _rowsPerResultset;
    get rowsPerResultset(): UserParametersRowsPerResultsetList;
    private _s3StageVpceDnsName;
    get s3StageVpceDnsName(): UserParametersS3StageVpceDnsNameList;
    private _searchPath;
    get searchPath(): UserParametersSearchPathList;
    private _simulatedDataSharingConsumer;
    get simulatedDataSharingConsumer(): UserParametersSimulatedDataSharingConsumerList;
    private _statementQueuedTimeoutInSeconds;
    get statementQueuedTimeoutInSeconds(): UserParametersStatementQueuedTimeoutInSecondsList;
    private _statementTimeoutInSeconds;
    get statementTimeoutInSeconds(): UserParametersStatementTimeoutInSecondsList;
    private _strictJsonOutput;
    get strictJsonOutput(): UserParametersStrictJsonOutputList;
    private _timeInputFormat;
    get timeInputFormat(): UserParametersTimeInputFormatList;
    private _timeOutputFormat;
    get timeOutputFormat(): UserParametersTimeOutputFormatList;
    private _timestampDayIsAlways24H;
    get timestampDayIsAlways24H(): UserParametersTimestampDayIsAlways24HList;
    private _timestampInputFormat;
    get timestampInputFormat(): UserParametersTimestampInputFormatList;
    private _timestampLtzOutputFormat;
    get timestampLtzOutputFormat(): UserParametersTimestampLtzOutputFormatList;
    private _timestampNtzOutputFormat;
    get timestampNtzOutputFormat(): UserParametersTimestampNtzOutputFormatList;
    private _timestampOutputFormat;
    get timestampOutputFormat(): UserParametersTimestampOutputFormatList;
    private _timestampTypeMapping;
    get timestampTypeMapping(): UserParametersTimestampTypeMappingList;
    private _timestampTzOutputFormat;
    get timestampTzOutputFormat(): UserParametersTimestampTzOutputFormatList;
    private _timezone;
    get timezone(): UserParametersTimezoneList;
    private _traceLevel;
    get traceLevel(): UserParametersTraceLevelList;
    private _transactionAbortOnError;
    get transactionAbortOnError(): UserParametersTransactionAbortOnErrorList;
    private _transactionDefaultIsolationLevel;
    get transactionDefaultIsolationLevel(): UserParametersTransactionDefaultIsolationLevelList;
    private _twoDigitCenturyStart;
    get twoDigitCenturyStart(): UserParametersTwoDigitCenturyStartList;
    private _unsupportedDdlAction;
    get unsupportedDdlAction(): UserParametersUnsupportedDdlActionList;
    private _useCachedResult;
    get useCachedResult(): UserParametersUseCachedResultList;
    private _weekOfYearPolicy;
    get weekOfYearPolicy(): UserParametersWeekOfYearPolicyList;
    private _weekStart;
    get weekStart(): UserParametersWeekStartList;
}
export declare class UserParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserParametersOutputReference;
}
export interface UserShowOutput {
}
export declare function userShowOutputToTerraform(struct?: UserShowOutput): any;
export declare function userShowOutputToHclTerraform(struct?: UserShowOutput): any;
export declare class UserShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserShowOutput | undefined;
    set internalValue(value: UserShowOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get daysToExpiry(): string;
    get defaultNamespace(): string;
    get defaultRole(): string;
    get defaultSecondaryRoles(): string;
    get defaultWarehouse(): string;
    get disabled(): cdktf.IResolvable;
    get displayName(): string;
    get email(): string;
    get expiresAtTime(): string;
    get extAuthnDuo(): cdktf.IResolvable;
    get extAuthnUid(): string;
    get firstName(): string;
    get hasMfa(): cdktf.IResolvable;
    get hasPassword(): cdktf.IResolvable;
    get hasRsaPublicKey(): cdktf.IResolvable;
    get lastName(): string;
    get lastSuccessLogin(): string;
    get lockedUntilTime(): string;
    get loginName(): string;
    get minsToBypassMfa(): string;
    get minsToUnlock(): string;
    get mustChangePassword(): cdktf.IResolvable;
    get name(): string;
    get owner(): string;
    get snowflakeLock(): cdktf.IResolvable;
    get type(): string;
}
export declare class UserShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserShowOutputOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user snowflake_user}
*/
export declare class User extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_user";
    /**
    * Generates CDKTF code for importing a User resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the User to import
    * @param importFromId The id of the existing User that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the User to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/user snowflake_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserConfig
    */
    constructor(scope: Construct, id: string, config: UserConfig);
    private _abortDetachedQuery?;
    get abortDetachedQuery(): boolean | cdktf.IResolvable;
    set abortDetachedQuery(value: boolean | cdktf.IResolvable);
    resetAbortDetachedQuery(): void;
    get abortDetachedQueryInput(): boolean | cdktf.IResolvable | undefined;
    private _autocommit?;
    get autocommit(): boolean | cdktf.IResolvable;
    set autocommit(value: boolean | cdktf.IResolvable);
    resetAutocommit(): void;
    get autocommitInput(): boolean | cdktf.IResolvable | undefined;
    private _binaryInputFormat?;
    get binaryInputFormat(): string;
    set binaryInputFormat(value: string);
    resetBinaryInputFormat(): void;
    get binaryInputFormatInput(): string | undefined;
    private _binaryOutputFormat?;
    get binaryOutputFormat(): string;
    set binaryOutputFormat(value: string);
    resetBinaryOutputFormat(): void;
    get binaryOutputFormatInput(): string | undefined;
    private _clientMemoryLimit?;
    get clientMemoryLimit(): number;
    set clientMemoryLimit(value: number);
    resetClientMemoryLimit(): void;
    get clientMemoryLimitInput(): number | undefined;
    private _clientMetadataRequestUseConnectionCtx?;
    get clientMetadataRequestUseConnectionCtx(): boolean | cdktf.IResolvable;
    set clientMetadataRequestUseConnectionCtx(value: boolean | cdktf.IResolvable);
    resetClientMetadataRequestUseConnectionCtx(): void;
    get clientMetadataRequestUseConnectionCtxInput(): boolean | cdktf.IResolvable | undefined;
    private _clientPrefetchThreads?;
    get clientPrefetchThreads(): number;
    set clientPrefetchThreads(value: number);
    resetClientPrefetchThreads(): void;
    get clientPrefetchThreadsInput(): number | undefined;
    private _clientResultChunkSize?;
    get clientResultChunkSize(): number;
    set clientResultChunkSize(value: number);
    resetClientResultChunkSize(): void;
    get clientResultChunkSizeInput(): number | undefined;
    private _clientResultColumnCaseInsensitive?;
    get clientResultColumnCaseInsensitive(): boolean | cdktf.IResolvable;
    set clientResultColumnCaseInsensitive(value: boolean | cdktf.IResolvable);
    resetClientResultColumnCaseInsensitive(): void;
    get clientResultColumnCaseInsensitiveInput(): boolean | cdktf.IResolvable | undefined;
    private _clientSessionKeepAlive?;
    get clientSessionKeepAlive(): boolean | cdktf.IResolvable;
    set clientSessionKeepAlive(value: boolean | cdktf.IResolvable);
    resetClientSessionKeepAlive(): void;
    get clientSessionKeepAliveInput(): boolean | cdktf.IResolvable | undefined;
    private _clientSessionKeepAliveHeartbeatFrequency?;
    get clientSessionKeepAliveHeartbeatFrequency(): number;
    set clientSessionKeepAliveHeartbeatFrequency(value: number);
    resetClientSessionKeepAliveHeartbeatFrequency(): void;
    get clientSessionKeepAliveHeartbeatFrequencyInput(): number | undefined;
    private _clientTimestampTypeMapping?;
    get clientTimestampTypeMapping(): string;
    set clientTimestampTypeMapping(value: string);
    resetClientTimestampTypeMapping(): void;
    get clientTimestampTypeMappingInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _dateInputFormat?;
    get dateInputFormat(): string;
    set dateInputFormat(value: string);
    resetDateInputFormat(): void;
    get dateInputFormatInput(): string | undefined;
    private _dateOutputFormat?;
    get dateOutputFormat(): string;
    set dateOutputFormat(value: string);
    resetDateOutputFormat(): void;
    get dateOutputFormatInput(): string | undefined;
    private _daysToExpiry?;
    get daysToExpiry(): number;
    set daysToExpiry(value: number);
    resetDaysToExpiry(): void;
    get daysToExpiryInput(): number | undefined;
    private _defaultNamespace?;
    get defaultNamespace(): string;
    set defaultNamespace(value: string);
    resetDefaultNamespace(): void;
    get defaultNamespaceInput(): string | undefined;
    private _defaultRole?;
    get defaultRole(): string;
    set defaultRole(value: string);
    resetDefaultRole(): void;
    get defaultRoleInput(): string | undefined;
    private _defaultSecondaryRolesOption?;
    get defaultSecondaryRolesOption(): string;
    set defaultSecondaryRolesOption(value: string);
    resetDefaultSecondaryRolesOption(): void;
    get defaultSecondaryRolesOptionInput(): string | undefined;
    private _defaultWarehouse?;
    get defaultWarehouse(): string;
    set defaultWarehouse(value: string);
    resetDefaultWarehouse(): void;
    get defaultWarehouseInput(): string | undefined;
    private _disableMfa?;
    get disableMfa(): string;
    set disableMfa(value: string);
    resetDisableMfa(): void;
    get disableMfaInput(): string | undefined;
    private _disabled?;
    get disabled(): string;
    set disabled(value: string);
    resetDisabled(): void;
    get disabledInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    private _enableUnloadPhysicalTypeOptimization?;
    get enableUnloadPhysicalTypeOptimization(): boolean | cdktf.IResolvable;
    set enableUnloadPhysicalTypeOptimization(value: boolean | cdktf.IResolvable);
    resetEnableUnloadPhysicalTypeOptimization(): void;
    get enableUnloadPhysicalTypeOptimizationInput(): boolean | cdktf.IResolvable | undefined;
    private _enableUnredactedQuerySyntaxError?;
    get enableUnredactedQuerySyntaxError(): boolean | cdktf.IResolvable;
    set enableUnredactedQuerySyntaxError(value: boolean | cdktf.IResolvable);
    resetEnableUnredactedQuerySyntaxError(): void;
    get enableUnredactedQuerySyntaxErrorInput(): boolean | cdktf.IResolvable | undefined;
    private _errorOnNondeterministicMerge?;
    get errorOnNondeterministicMerge(): boolean | cdktf.IResolvable;
    set errorOnNondeterministicMerge(value: boolean | cdktf.IResolvable);
    resetErrorOnNondeterministicMerge(): void;
    get errorOnNondeterministicMergeInput(): boolean | cdktf.IResolvable | undefined;
    private _errorOnNondeterministicUpdate?;
    get errorOnNondeterministicUpdate(): boolean | cdktf.IResolvable;
    set errorOnNondeterministicUpdate(value: boolean | cdktf.IResolvable);
    resetErrorOnNondeterministicUpdate(): void;
    get errorOnNondeterministicUpdateInput(): boolean | cdktf.IResolvable | undefined;
    private _firstName?;
    get firstName(): string;
    set firstName(value: string);
    resetFirstName(): void;
    get firstNameInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _geographyOutputFormat?;
    get geographyOutputFormat(): string;
    set geographyOutputFormat(value: string);
    resetGeographyOutputFormat(): void;
    get geographyOutputFormatInput(): string | undefined;
    private _geometryOutputFormat?;
    get geometryOutputFormat(): string;
    set geometryOutputFormat(value: string);
    resetGeometryOutputFormat(): void;
    get geometryOutputFormatInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _jdbcTreatDecimalAsInt?;
    get jdbcTreatDecimalAsInt(): boolean | cdktf.IResolvable;
    set jdbcTreatDecimalAsInt(value: boolean | cdktf.IResolvable);
    resetJdbcTreatDecimalAsInt(): void;
    get jdbcTreatDecimalAsIntInput(): boolean | cdktf.IResolvable | undefined;
    private _jdbcTreatTimestampNtzAsUtc?;
    get jdbcTreatTimestampNtzAsUtc(): boolean | cdktf.IResolvable;
    set jdbcTreatTimestampNtzAsUtc(value: boolean | cdktf.IResolvable);
    resetJdbcTreatTimestampNtzAsUtc(): void;
    get jdbcTreatTimestampNtzAsUtcInput(): boolean | cdktf.IResolvable | undefined;
    private _jdbcUseSessionTimezone?;
    get jdbcUseSessionTimezone(): boolean | cdktf.IResolvable;
    set jdbcUseSessionTimezone(value: boolean | cdktf.IResolvable);
    resetJdbcUseSessionTimezone(): void;
    get jdbcUseSessionTimezoneInput(): boolean | cdktf.IResolvable | undefined;
    private _jsonIndent?;
    get jsonIndent(): number;
    set jsonIndent(value: number);
    resetJsonIndent(): void;
    get jsonIndentInput(): number | undefined;
    private _lastName?;
    get lastName(): string;
    set lastName(value: string);
    resetLastName(): void;
    get lastNameInput(): string | undefined;
    private _lockTimeout?;
    get lockTimeout(): number;
    set lockTimeout(value: number);
    resetLockTimeout(): void;
    get lockTimeoutInput(): number | undefined;
    private _logLevel?;
    get logLevel(): string;
    set logLevel(value: string);
    resetLogLevel(): void;
    get logLevelInput(): string | undefined;
    private _loginName?;
    get loginName(): string;
    set loginName(value: string);
    resetLoginName(): void;
    get loginNameInput(): string | undefined;
    private _middleName?;
    get middleName(): string;
    set middleName(value: string);
    resetMiddleName(): void;
    get middleNameInput(): string | undefined;
    private _minsToBypassMfa?;
    get minsToBypassMfa(): number;
    set minsToBypassMfa(value: number);
    resetMinsToBypassMfa(): void;
    get minsToBypassMfaInput(): number | undefined;
    private _minsToUnlock?;
    get minsToUnlock(): number;
    set minsToUnlock(value: number);
    resetMinsToUnlock(): void;
    get minsToUnlockInput(): number | undefined;
    private _multiStatementCount?;
    get multiStatementCount(): number;
    set multiStatementCount(value: number);
    resetMultiStatementCount(): void;
    get multiStatementCountInput(): number | undefined;
    private _mustChangePassword?;
    get mustChangePassword(): string;
    set mustChangePassword(value: string);
    resetMustChangePassword(): void;
    get mustChangePasswordInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkPolicy?;
    get networkPolicy(): string;
    set networkPolicy(value: string);
    resetNetworkPolicy(): void;
    get networkPolicyInput(): string | undefined;
    private _noorderSequenceAsDefault?;
    get noorderSequenceAsDefault(): boolean | cdktf.IResolvable;
    set noorderSequenceAsDefault(value: boolean | cdktf.IResolvable);
    resetNoorderSequenceAsDefault(): void;
    get noorderSequenceAsDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _odbcTreatDecimalAsInt?;
    get odbcTreatDecimalAsInt(): boolean | cdktf.IResolvable;
    set odbcTreatDecimalAsInt(value: boolean | cdktf.IResolvable);
    resetOdbcTreatDecimalAsInt(): void;
    get odbcTreatDecimalAsIntInput(): boolean | cdktf.IResolvable | undefined;
    private _parameters;
    get parameters(): UserParametersList;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _preventUnloadToInternalStages?;
    get preventUnloadToInternalStages(): boolean | cdktf.IResolvable;
    set preventUnloadToInternalStages(value: boolean | cdktf.IResolvable);
    resetPreventUnloadToInternalStages(): void;
    get preventUnloadToInternalStagesInput(): boolean | cdktf.IResolvable | undefined;
    private _queryTag?;
    get queryTag(): string;
    set queryTag(value: string);
    resetQueryTag(): void;
    get queryTagInput(): string | undefined;
    private _quotedIdentifiersIgnoreCase?;
    get quotedIdentifiersIgnoreCase(): boolean | cdktf.IResolvable;
    set quotedIdentifiersIgnoreCase(value: boolean | cdktf.IResolvable);
    resetQuotedIdentifiersIgnoreCase(): void;
    get quotedIdentifiersIgnoreCaseInput(): boolean | cdktf.IResolvable | undefined;
    private _rowsPerResultset?;
    get rowsPerResultset(): number;
    set rowsPerResultset(value: number);
    resetRowsPerResultset(): void;
    get rowsPerResultsetInput(): number | undefined;
    private _rsaPublicKey?;
    get rsaPublicKey(): string;
    set rsaPublicKey(value: string);
    resetRsaPublicKey(): void;
    get rsaPublicKeyInput(): string | undefined;
    private _rsaPublicKey2?;
    get rsaPublicKey2(): string;
    set rsaPublicKey2(value: string);
    resetRsaPublicKey2(): void;
    get rsaPublicKey2Input(): string | undefined;
    private _s3StageVpceDnsName?;
    get s3StageVpceDnsName(): string;
    set s3StageVpceDnsName(value: string);
    resetS3StageVpceDnsName(): void;
    get s3StageVpceDnsNameInput(): string | undefined;
    private _searchPath?;
    get searchPath(): string;
    set searchPath(value: string);
    resetSearchPath(): void;
    get searchPathInput(): string | undefined;
    private _showOutput;
    get showOutput(): UserShowOutputList;
    private _simulatedDataSharingConsumer?;
    get simulatedDataSharingConsumer(): string;
    set simulatedDataSharingConsumer(value: string);
    resetSimulatedDataSharingConsumer(): void;
    get simulatedDataSharingConsumerInput(): string | undefined;
    private _statementQueuedTimeoutInSeconds?;
    get statementQueuedTimeoutInSeconds(): number;
    set statementQueuedTimeoutInSeconds(value: number);
    resetStatementQueuedTimeoutInSeconds(): void;
    get statementQueuedTimeoutInSecondsInput(): number | undefined;
    private _statementTimeoutInSeconds?;
    get statementTimeoutInSeconds(): number;
    set statementTimeoutInSeconds(value: number);
    resetStatementTimeoutInSeconds(): void;
    get statementTimeoutInSecondsInput(): number | undefined;
    private _strictJsonOutput?;
    get strictJsonOutput(): boolean | cdktf.IResolvable;
    set strictJsonOutput(value: boolean | cdktf.IResolvable);
    resetStrictJsonOutput(): void;
    get strictJsonOutputInput(): boolean | cdktf.IResolvable | undefined;
    private _timeInputFormat?;
    get timeInputFormat(): string;
    set timeInputFormat(value: string);
    resetTimeInputFormat(): void;
    get timeInputFormatInput(): string | undefined;
    private _timeOutputFormat?;
    get timeOutputFormat(): string;
    set timeOutputFormat(value: string);
    resetTimeOutputFormat(): void;
    get timeOutputFormatInput(): string | undefined;
    private _timestampDayIsAlways24H?;
    get timestampDayIsAlways24H(): boolean | cdktf.IResolvable;
    set timestampDayIsAlways24H(value: boolean | cdktf.IResolvable);
    resetTimestampDayIsAlways24H(): void;
    get timestampDayIsAlways24HInput(): boolean | cdktf.IResolvable | undefined;
    private _timestampInputFormat?;
    get timestampInputFormat(): string;
    set timestampInputFormat(value: string);
    resetTimestampInputFormat(): void;
    get timestampInputFormatInput(): string | undefined;
    private _timestampLtzOutputFormat?;
    get timestampLtzOutputFormat(): string;
    set timestampLtzOutputFormat(value: string);
    resetTimestampLtzOutputFormat(): void;
    get timestampLtzOutputFormatInput(): string | undefined;
    private _timestampNtzOutputFormat?;
    get timestampNtzOutputFormat(): string;
    set timestampNtzOutputFormat(value: string);
    resetTimestampNtzOutputFormat(): void;
    get timestampNtzOutputFormatInput(): string | undefined;
    private _timestampOutputFormat?;
    get timestampOutputFormat(): string;
    set timestampOutputFormat(value: string);
    resetTimestampOutputFormat(): void;
    get timestampOutputFormatInput(): string | undefined;
    private _timestampTypeMapping?;
    get timestampTypeMapping(): string;
    set timestampTypeMapping(value: string);
    resetTimestampTypeMapping(): void;
    get timestampTypeMappingInput(): string | undefined;
    private _timestampTzOutputFormat?;
    get timestampTzOutputFormat(): string;
    set timestampTzOutputFormat(value: string);
    resetTimestampTzOutputFormat(): void;
    get timestampTzOutputFormatInput(): string | undefined;
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    resetTimezone(): void;
    get timezoneInput(): string | undefined;
    private _traceLevel?;
    get traceLevel(): string;
    set traceLevel(value: string);
    resetTraceLevel(): void;
    get traceLevelInput(): string | undefined;
    private _transactionAbortOnError?;
    get transactionAbortOnError(): boolean | cdktf.IResolvable;
    set transactionAbortOnError(value: boolean | cdktf.IResolvable);
    resetTransactionAbortOnError(): void;
    get transactionAbortOnErrorInput(): boolean | cdktf.IResolvable | undefined;
    private _transactionDefaultIsolationLevel?;
    get transactionDefaultIsolationLevel(): string;
    set transactionDefaultIsolationLevel(value: string);
    resetTransactionDefaultIsolationLevel(): void;
    get transactionDefaultIsolationLevelInput(): string | undefined;
    private _twoDigitCenturyStart?;
    get twoDigitCenturyStart(): number;
    set twoDigitCenturyStart(value: number);
    resetTwoDigitCenturyStart(): void;
    get twoDigitCenturyStartInput(): number | undefined;
    private _unsupportedDdlAction?;
    get unsupportedDdlAction(): string;
    set unsupportedDdlAction(value: string);
    resetUnsupportedDdlAction(): void;
    get unsupportedDdlActionInput(): string | undefined;
    private _useCachedResult?;
    get useCachedResult(): boolean | cdktf.IResolvable;
    set useCachedResult(value: boolean | cdktf.IResolvable);
    resetUseCachedResult(): void;
    get useCachedResultInput(): boolean | cdktf.IResolvable | undefined;
    get userType(): string;
    private _weekOfYearPolicy?;
    get weekOfYearPolicy(): number;
    set weekOfYearPolicy(value: number);
    resetWeekOfYearPolicy(): void;
    get weekOfYearPolicyInput(): number | undefined;
    private _weekStart?;
    get weekStart(): number;
    set weekStart(value: number);
    resetWeekStart(): void;
    get weekStartInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
