/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ViewConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies to enable or disable change tracking on the table. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#change_tracking View#change_tracking}
    */
    readonly changeTracking?: string;
    /**
    * Specifies a comment for the view.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#comment View#comment}
    */
    readonly comment?: string;
    /**
    * Retains the access permissions from the original view when a new view is created using the OR REPLACE clause.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#copy_grants View#copy_grants}
    */
    readonly copyGrants?: boolean | cdktf.IResolvable;
    /**
    * The database in which to create the view. Due to technical limitations (read more [here](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/docs/technical-documentation/identifiers_rework_design_decisions.md#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `(`, `)`, `"`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#database View#database}
    */
    readonly database: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#id View#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies that the view can refer to itself using recursive syntax without necessarily using a CTE (common table expression). Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#is_recursive View#is_recursive}
    */
    readonly isRecursive?: string;
    /**
    * Specifies that the view is secure. By design, the Snowflake's `SHOW VIEWS` command does not provide information about secure views (consult [view usage notes](https://docs.snowflake.com/en/sql-reference/sql/create-view#usage-notes)) which is essential to manage/import view with Terraform. Use the role owning the view while managing secure views. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#is_secure View#is_secure}
    */
    readonly isSecure?: string;
    /**
    * Specifies that the view persists only for the duration of the session that you created it in. A temporary view and all its contents are dropped at the end of the session. In context of this provider, it means that it's dropped after a Terraform operation. This results in a permanent plan with object creation. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#is_temporary View#is_temporary}
    */
    readonly isTemporary?: string;
    /**
    * Specifies the identifier for the view; must be unique for the schema in which the view is created. Due to technical limitations (read more [here](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/docs/technical-documentation/identifiers_rework_design_decisions.md#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `(`, `)`, `"`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#name View#name}
    */
    readonly name: string;
    /**
    * The schema in which to create the view. Due to technical limitations (read more [here](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/docs/technical-documentation/identifiers_rework_design_decisions.md#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `(`, `)`, `"`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#schema View#schema}
    */
    readonly schema: string;
    /**
    * Specifies the query used to create the view.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#statement View#statement}
    */
    readonly statement: string;
    /**
    * aggregation_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#aggregation_policy View#aggregation_policy}
    */
    readonly aggregationPolicy?: ViewAggregationPolicy;
    /**
    * column block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#column View#column}
    */
    readonly column?: ViewColumn[] | cdktf.IResolvable;
    /**
    * data_metric_function block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#data_metric_function View#data_metric_function}
    */
    readonly dataMetricFunction?: ViewDataMetricFunction[] | cdktf.IResolvable;
    /**
    * data_metric_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#data_metric_schedule View#data_metric_schedule}
    */
    readonly dataMetricSchedule?: ViewDataMetricSchedule;
    /**
    * row_access_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#row_access_policy View#row_access_policy}
    */
    readonly rowAccessPolicy?: ViewRowAccessPolicy;
}
export interface ViewDescribeOutput {
}
export declare function viewDescribeOutputToTerraform(struct?: ViewDescribeOutput): any;
export declare function viewDescribeOutputToHclTerraform(struct?: ViewDescribeOutput): any;
export declare class ViewDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ViewDescribeOutput | undefined;
    set internalValue(value: ViewDescribeOutput | undefined);
    get check(): string;
    get comment(): string;
    get default(): string;
    get expression(): string;
    get isNullable(): cdktf.IResolvable;
    get isPrimary(): cdktf.IResolvable;
    get isUnique(): cdktf.IResolvable;
    get kind(): string;
    get name(): string;
    get policyName(): string;
    get privacyDomain(): string;
    get type(): string;
}
export declare class ViewDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ViewDescribeOutputOutputReference;
}
export interface ViewShowOutput {
}
export declare function viewShowOutputToTerraform(struct?: ViewShowOutput): any;
export declare function viewShowOutputToHclTerraform(struct?: ViewShowOutput): any;
export declare class ViewShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ViewShowOutput | undefined;
    set internalValue(value: ViewShowOutput | undefined);
    get changeTracking(): string;
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get isMaterialized(): cdktf.IResolvable;
    get isSecure(): cdktf.IResolvable;
    get kind(): string;
    get name(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get reserved(): string;
    get schemaName(): string;
    get text(): string;
}
export declare class ViewShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ViewShowOutputOutputReference;
}
export interface ViewAggregationPolicy {
    /**
    * Defines which columns uniquely identify an entity within the view.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#entity_key View#entity_key}
    */
    readonly entityKey?: string[];
    /**
    * Aggregation policy name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#policy_name View#policy_name}
    */
    readonly policyName: string;
}
export declare function viewAggregationPolicyToTerraform(struct?: ViewAggregationPolicyOutputReference | ViewAggregationPolicy): any;
export declare function viewAggregationPolicyToHclTerraform(struct?: ViewAggregationPolicyOutputReference | ViewAggregationPolicy): any;
export declare class ViewAggregationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ViewAggregationPolicy | undefined;
    set internalValue(value: ViewAggregationPolicy | undefined);
    private _entityKey?;
    get entityKey(): string[];
    set entityKey(value: string[]);
    resetEntityKey(): void;
    get entityKeyInput(): string[] | undefined;
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    get policyNameInput(): string | undefined;
}
export interface ViewColumnMaskingPolicy {
    /**
    * Specifies the masking policy to set on a column.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#policy_name View#policy_name}
    */
    readonly policyName: string;
    /**
    * Specifies the arguments to pass into the conditional masking policy SQL expression. The first column in the list specifies the column for the policy conditions to mask or tokenize the data and must match the column to which the masking policy is set. The additional columns specify the columns to evaluate to determine whether to mask or tokenize the data in each row of the query result when a query is made on the first column. If the USING clause is omitted, Snowflake treats the conditional masking policy as a normal masking policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#using View#using}
    */
    readonly using?: string[];
}
export declare function viewColumnMaskingPolicyToTerraform(struct?: ViewColumnMaskingPolicyOutputReference | ViewColumnMaskingPolicy): any;
export declare function viewColumnMaskingPolicyToHclTerraform(struct?: ViewColumnMaskingPolicyOutputReference | ViewColumnMaskingPolicy): any;
export declare class ViewColumnMaskingPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ViewColumnMaskingPolicy | undefined;
    set internalValue(value: ViewColumnMaskingPolicy | undefined);
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    get policyNameInput(): string | undefined;
    private _using?;
    get using(): string[];
    set using(value: string[]);
    resetUsing(): void;
    get usingInput(): string[] | undefined;
}
export interface ViewColumnProjectionPolicy {
    /**
    * Specifies the projection policy to set on a column.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#policy_name View#policy_name}
    */
    readonly policyName: string;
}
export declare function viewColumnProjectionPolicyToTerraform(struct?: ViewColumnProjectionPolicyOutputReference | ViewColumnProjectionPolicy): any;
export declare function viewColumnProjectionPolicyToHclTerraform(struct?: ViewColumnProjectionPolicyOutputReference | ViewColumnProjectionPolicy): any;
export declare class ViewColumnProjectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ViewColumnProjectionPolicy | undefined;
    set internalValue(value: ViewColumnProjectionPolicy | undefined);
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    get policyNameInput(): string | undefined;
}
export interface ViewColumn {
    /**
    * Specifies affected column name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#column_name View#column_name}
    */
    readonly columnName: string;
    /**
    * Specifies a comment for the column.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#comment View#comment}
    */
    readonly comment?: string;
    /**
    * masking_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#masking_policy View#masking_policy}
    */
    readonly maskingPolicy?: ViewColumnMaskingPolicy;
    /**
    * projection_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#projection_policy View#projection_policy}
    */
    readonly projectionPolicy?: ViewColumnProjectionPolicy;
}
export declare function viewColumnToTerraform(struct?: ViewColumn | cdktf.IResolvable): any;
export declare function viewColumnToHclTerraform(struct?: ViewColumn | cdktf.IResolvable): any;
export declare class ViewColumnOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ViewColumn | cdktf.IResolvable | undefined;
    set internalValue(value: ViewColumn | cdktf.IResolvable | undefined);
    private _columnName?;
    get columnName(): string;
    set columnName(value: string);
    get columnNameInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _maskingPolicy;
    get maskingPolicy(): ViewColumnMaskingPolicyOutputReference;
    putMaskingPolicy(value: ViewColumnMaskingPolicy): void;
    resetMaskingPolicy(): void;
    get maskingPolicyInput(): ViewColumnMaskingPolicy | undefined;
    private _projectionPolicy;
    get projectionPolicy(): ViewColumnProjectionPolicyOutputReference;
    putProjectionPolicy(value: ViewColumnProjectionPolicy): void;
    resetProjectionPolicy(): void;
    get projectionPolicyInput(): ViewColumnProjectionPolicy | undefined;
}
export declare class ViewColumnList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ViewColumn[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ViewColumnOutputReference;
}
export interface ViewDataMetricFunction {
    /**
    * Identifier of the data metric function to add to the table or view or drop from the table or view. This function identifier must be provided without arguments in parenthesis.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#function_name View#function_name}
    */
    readonly functionName: string;
    /**
    * The table or view columns on which to associate the data metric function. The data types of the columns must match the data types of the columns specified in the data metric function definition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#on View#on}
    */
    readonly on: string[];
    /**
    * The status of the metrics association. Valid values are: `STARTED` | `SUSPENDED`. When status of a data metric function is changed, it is being reassigned with `DROP DATA METRIC FUNCTION` and `ADD DATA METRIC FUNCTION`, and then its status is changed by `MODIFY DATA METRIC FUNCTION`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#schedule_status View#schedule_status}
    */
    readonly scheduleStatus: string;
}
export declare function viewDataMetricFunctionToTerraform(struct?: ViewDataMetricFunction | cdktf.IResolvable): any;
export declare function viewDataMetricFunctionToHclTerraform(struct?: ViewDataMetricFunction | cdktf.IResolvable): any;
export declare class ViewDataMetricFunctionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ViewDataMetricFunction | cdktf.IResolvable | undefined;
    set internalValue(value: ViewDataMetricFunction | cdktf.IResolvable | undefined);
    private _functionName?;
    get functionName(): string;
    set functionName(value: string);
    get functionNameInput(): string | undefined;
    private _on?;
    get on(): string[];
    set on(value: string[]);
    get onInput(): string[] | undefined;
    private _scheduleStatus?;
    get scheduleStatus(): string;
    set scheduleStatus(value: string);
    get scheduleStatusInput(): string | undefined;
}
export declare class ViewDataMetricFunctionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ViewDataMetricFunction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ViewDataMetricFunctionOutputReference;
}
export interface ViewDataMetricSchedule {
    /**
    * Specifies an interval (in minutes) of wait time inserted between runs of the data metric function. Conflicts with `using_cron`. Valid values are: `5` | `15` | `30` | `60` | `720` | `1440`. Due to Snowflake limitations, changes in this field are not managed by the provider. Please consider using [taint](https://developer.hashicorp.com/terraform/cli/commands/taint) command, `using_cron` field, or [replace_triggered_by](https://developer.hashicorp.com/terraform/language/meta-arguments/lifecycle#replace_triggered_by) metadata argument.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#minutes View#minutes}
    */
    readonly minutes?: number;
    /**
    * Specifies a cron expression and time zone for periodically running the data metric function. Supports a subset of standard cron utility syntax. Conflicts with `minutes`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#using_cron View#using_cron}
    */
    readonly usingCron?: string;
}
export declare function viewDataMetricScheduleToTerraform(struct?: ViewDataMetricScheduleOutputReference | ViewDataMetricSchedule): any;
export declare function viewDataMetricScheduleToHclTerraform(struct?: ViewDataMetricScheduleOutputReference | ViewDataMetricSchedule): any;
export declare class ViewDataMetricScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ViewDataMetricSchedule | undefined;
    set internalValue(value: ViewDataMetricSchedule | undefined);
    private _minutes?;
    get minutes(): number;
    set minutes(value: number);
    resetMinutes(): void;
    get minutesInput(): number | undefined;
    private _usingCron?;
    get usingCron(): string;
    set usingCron(value: string);
    resetUsingCron(): void;
    get usingCronInput(): string | undefined;
}
export interface ViewRowAccessPolicy {
    /**
    * Defines which columns are affected by the policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#on View#on}
    */
    readonly on: string[];
    /**
    * Row access policy name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#policy_name View#policy_name}
    */
    readonly policyName: string;
}
export declare function viewRowAccessPolicyToTerraform(struct?: ViewRowAccessPolicyOutputReference | ViewRowAccessPolicy): any;
export declare function viewRowAccessPolicyToHclTerraform(struct?: ViewRowAccessPolicyOutputReference | ViewRowAccessPolicy): any;
export declare class ViewRowAccessPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ViewRowAccessPolicy | undefined;
    set internalValue(value: ViewRowAccessPolicy | undefined);
    private _on?;
    get on(): string[];
    set on(value: string[]);
    get onInput(): string[] | undefined;
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    get policyNameInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view snowflake_view}
*/
export declare class View extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_view";
    /**
    * Generates CDKTF code for importing a View resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the View to import
    * @param importFromId The id of the existing View that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the View to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/view snowflake_view} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ViewConfig
    */
    constructor(scope: Construct, id: string, config: ViewConfig);
    private _changeTracking?;
    get changeTracking(): string;
    set changeTracking(value: string);
    resetChangeTracking(): void;
    get changeTrackingInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _copyGrants?;
    get copyGrants(): boolean | cdktf.IResolvable;
    set copyGrants(value: boolean | cdktf.IResolvable);
    resetCopyGrants(): void;
    get copyGrantsInput(): boolean | cdktf.IResolvable | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _describeOutput;
    get describeOutput(): ViewDescribeOutputList;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isRecursive?;
    get isRecursive(): string;
    set isRecursive(value: string);
    resetIsRecursive(): void;
    get isRecursiveInput(): string | undefined;
    private _isSecure?;
    get isSecure(): string;
    set isSecure(value: string);
    resetIsSecure(): void;
    get isSecureInput(): string | undefined;
    private _isTemporary?;
    get isTemporary(): string;
    set isTemporary(value: string);
    resetIsTemporary(): void;
    get isTemporaryInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _showOutput;
    get showOutput(): ViewShowOutputList;
    private _statement?;
    get statement(): string;
    set statement(value: string);
    get statementInput(): string | undefined;
    private _aggregationPolicy;
    get aggregationPolicy(): ViewAggregationPolicyOutputReference;
    putAggregationPolicy(value: ViewAggregationPolicy): void;
    resetAggregationPolicy(): void;
    get aggregationPolicyInput(): ViewAggregationPolicy | undefined;
    private _column;
    get column(): ViewColumnList;
    putColumn(value: ViewColumn[] | cdktf.IResolvable): void;
    resetColumn(): void;
    get columnInput(): cdktf.IResolvable | ViewColumn[] | undefined;
    private _dataMetricFunction;
    get dataMetricFunction(): ViewDataMetricFunctionList;
    putDataMetricFunction(value: ViewDataMetricFunction[] | cdktf.IResolvable): void;
    resetDataMetricFunction(): void;
    get dataMetricFunctionInput(): cdktf.IResolvable | ViewDataMetricFunction[] | undefined;
    private _dataMetricSchedule;
    get dataMetricSchedule(): ViewDataMetricScheduleOutputReference;
    putDataMetricSchedule(value: ViewDataMetricSchedule): void;
    resetDataMetricSchedule(): void;
    get dataMetricScheduleInput(): ViewDataMetricSchedule | undefined;
    private _rowAccessPolicy;
    get rowAccessPolicy(): ViewRowAccessPolicyOutputReference;
    putRowAccessPolicy(value: ViewRowAccessPolicy): void;
    resetRowAccessPolicy(): void;
    get rowAccessPolicyInput(): ViewRowAccessPolicy | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
