import numpy as np
from .. import core as jiminy
from ..dynamics import TrajectoryDataType
from .viewer import Tuple4FType, Viewer
from threading import Thread
from types import TracebackType
from typing import Any, Callable, Dict, Optional, Sequence, Tuple, Type, Union

__all__ = ['extract_replay_data_from_log', 'play_logs_data', 'play_logs_files', 'async_play_and_record_logs_files']

ColorType = Union[str, Tuple4FType]

class QRLock:
    def __init__(self) -> None: ...
    def acquire(self) -> None: ...
    def release(self) -> None: ...
    def __enter__(self) -> None: ...
    def __exit__(self, exc_type: Optional[Type[BaseException]], exc_value: Optional[BaseException], traceback: Optional[TracebackType]) -> None: ...

def extract_replay_data_from_log(log_data: Dict[str, np.ndarray], robot: jiminy.Robot) -> Tuple[TrajectoryDataType, Optional[Callable[[float, np.ndarray, np.ndarray], None]], Dict[str, Any]]: ...
def play_logs_data(robots: Union[Sequence[jiminy.Robot], jiminy.Robot], logs_data: Union[Sequence[Dict[str, np.ndarray]], Dict[str, np.ndarray]], **kwargs: Any) -> Sequence[Viewer]: ...
def play_logs_files(logs_files: Union[str, Sequence[str]], mesh_path_dir: Optional[str] = None, mesh_package_dirs: Sequence[str] = (), **kwargs: Any) -> Sequence[Viewer]: ...
def async_play_and_record_logs_files(logs_files: Union[str, Sequence[str]], enable_replay: Optional[bool] = None, mesh_path_dir: Optional[str] = None, mesh_package_dirs: Sequence[str] = (), **kwargs: Any) -> Optional[Thread]: ...
