/* Slightly adapted by W-Mark Kubacki from what can be found at:
 * http://ajaxorized.com/the-ultimate-password-strength-meter/
 */

var updateStrength = function(pw_field, strength_field) {
	var strength = getStrength(pw_field.value);
	var width = (100/32)*strength;
	new Effect.Morph($(strength_field), {style:'width:'+width+'px', duration:'0.4'});
}

var getStrength = function(passwd) {
	intScore = 0;
	if(passwd.match(/[a-z]/)){ // [verified] at least one lower case letter
		intScore = (intScore+1)
	}
	if(passwd.match(/[A-Z]/)){ // [verified] at least one upper case letter
		intScore = (intScore+5)
	} // NUMBERS
	if(passwd.match(/\d+/)){ // [verified] at least one number
		intScore = (intScore+5)
	}
	if(passwd.match(/(\d.*\d.*\d)/)){ // [verified] at least three numbers
		intScore = (intScore+5)
	} // SPECIAL CHAR
	if(passwd.match(/[!,@#$%^&*?_~]/)){ // [verified] at least one special character
		intScore = (intScore+5)
	}
	if(passwd.match(/([!,@#$%^&*?_~].*[!,@#$%^&*?_~])/)){ // [verified] at least two special characters
		intScore = (intScore+5)
	} // COMBOS
	if(passwd.match(/[a-z]/) && passwd.match(/[A-Z]/)){ // [verified] both upper and lower case
		intScore = (intScore+2)
	}
	if(passwd.match(/\d/) && passwd.match(/\D/)){ // [verified] both letters and numbers
		intScore = (intScore+2)
	} // [Verified] Upper Letters, Lower Letters, numbers and special characters
	if(passwd.match(/[a-z]/) && passwd.match(/[A-Z]/) && passwd.match(/\d/) && passwd.match(/[!,@#$%^&*?_~]/)){
		intScore = (intScore+2)
	}
	return intScore;
}
