# generated by datamodel-codegen:
#   filename:  api/data/createGlossary.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...entity.teams import user
from ...type import basic, entityReference, tagLabel


class CreateGlossaryRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: basic.EntityName = Field(
        ..., description='Name that identifies this glossary.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this glossary.'
    )
    description: basic.Markdown = Field(
        ..., description='Description of the glossary instance.'
    )
    reviewers: Optional[List[user.EntityName]] = Field(
        None, description='User references of the reviewers for this glossary.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this glossary'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this glossary'
    )
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    mutuallyExclusive: Optional[bool] = Field(
        'false',
        description='Glossary terms that are direct children in this glossary are mutually exclusive. When mutually exclusive is `true` only one term can be used to label an entity. When mutually exclusive is `false`, multiple terms from this group can be used to label an entity.',
    )
    domain: Optional[str] = Field(
        None, description='Fully qualified name of the domain the Glossary belongs to.'
    )
    extension: Optional[basic.EntityExtension] = Field(
        None,
        description='Entity extension data with custom attributes added to the entity.',
    )
