# generated by datamodel-codegen:
#   filename:  api/data/createMlModel.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field, constr

from ...entity.data import mlmodel
from ...type import basic, entityReference, lifeCycle, tagLabel


class CreateMlModelRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: basic.EntityName = Field(
        ..., description='Name that identifies this ML model.'
    )
    displayName: Optional[str] = Field(
        None,
        description='Display Name that identifies this ML model. It could be title or label from the source services',
    )
    description: Optional[basic.Markdown] = Field(
        None,
        description='Description of the ML model instance. How it was trained and for what it is used.',
    )
    algorithm: str = Field(..., description='Algorithm used to train the ML Model')
    mlFeatures: Optional[List[mlmodel.MlFeature]] = Field(
        None, description='Features used to train the ML Model.'
    )
    target: Optional[basic.EntityName] = Field(
        None, description='For supervised ML Models, the value to estimate.'
    )
    mlHyperParameters: Optional[List[mlmodel.MlHyperParameter]] = Field(
        None, description='Hyper Parameters used to train the ML Model.'
    )
    dashboard: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='Performance Dashboard fqn to track metric evolution'
    )
    mlStore: Optional[mlmodel.MlStore] = Field(
        None,
        description='Location containing the ML Model. It can be a storage layer and/or a container repository.',
    )
    server: Optional[basic.Href] = Field(
        None,
        description='Endpoint that makes the ML Model available, e.g,. a REST API serving the data or computing predictions.',
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this ML Model'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this database'
    )
    service: basic.FullyQualifiedEntityName = Field(
        ...,
        description='Link to the MLModel service fqn where this pipeline is hosted in',
    )
    extension: Optional[basic.EntityExtension] = Field(
        None,
        description='Entity extension data with custom attributes added to the entity.',
    )
    sourceUrl: Optional[basic.SourceUrl] = Field(
        None, description='Source URL of mlModel.'
    )
    domain: Optional[str] = Field(
        None, description='Fully qualified name of the domain the MLModel belongs to.'
    )
    dataProducts: Optional[List[basic.FullyQualifiedEntityName]] = Field(
        None,
        description='List of fully qualified names of data products this entity is part of.',
    )
    lifeCycle: Optional[lifeCycle.LifeCycle] = Field(
        None, description='Life Cycle of the entity'
    )
    sourceHash: Optional[constr(min_length=1, max_length=32)] = Field(
        None, description='Source hash of the entity'
    )
