# generated by datamodel-codegen:
#   filename:  api/data/createPipeline.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field, constr

from ...entity.data import pipeline
from ...type import basic, entityReference, lifeCycle, tagLabel


class CreatePipelineRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: pipeline.EntityName = Field(
        ..., description='Name that identifies this pipeline instance uniquely.'
    )
    displayName: Optional[str] = Field(
        None,
        description='Display Name that identifies this Pipeline. It could be title or label from the source services.',
    )
    description: Optional[basic.Markdown] = Field(
        None,
        description='Description of the pipeline instance. What it has and how to use it.',
    )
    dataProducts: Optional[List[basic.FullyQualifiedEntityName]] = Field(
        None,
        description='List of fully qualified names of data products this entity is part of.',
    )
    sourceUrl: Optional[basic.SourceUrl] = Field(
        None,
        description='Pipeline URL suffix to visit/manage. This URL points to respective pipeline service UI',
    )
    concurrency: Optional[int] = Field(None, description='Concurrency of the Pipeline')
    pipelineLocation: Optional[str] = Field(None, description='Pipeline Code Location')
    startDate: Optional[basic.DateTime] = Field(
        None, description='Start date of the workflow'
    )
    tasks: Optional[List[pipeline.Task]] = Field(
        None, description='All the tasks that are part of pipeline.'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this Pipeline.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this pipeline'
    )
    service: basic.FullyQualifiedEntityName = Field(
        ...,
        description='Link to the pipeline service fqn where this pipeline is hosted in',
    )
    extension: Optional[basic.EntityExtension] = Field(
        None,
        description='Entity extension data with custom attributes added to the entity.',
    )
    scheduleInterval: Optional[str] = Field(
        None, description='Scheduler Interval for the pipeline in cron format.'
    )
    domain: Optional[str] = Field(
        None, description='Fully qualified name of the domain the Pipeline belongs to.'
    )
    lifeCycle: Optional[lifeCycle.LifeCycle] = Field(
        None, description='Life Cycle of the entity'
    )
    sourceHash: Optional[constr(min_length=1, max_length=32)] = Field(
        None, description='Source hash of the entity'
    )
