# generated by datamodel-codegen:
#   filename:  api/data/createQuery.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...type import basic, entityReference, entityReferenceList, tagLabel


class CreateQueryRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: Optional[basic.EntityName] = Field(
        None, description='Name of a Query in case of User Creation.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this query.'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the query instance.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this entity'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this Query'
    )
    query: basic.SqlQuery = Field(..., description='SQL Query definition.')
    query_type: Optional[str] = Field(None, description='SQL query type')
    exclude_usage: Optional[bool] = Field(
        None,
        description='Flag to check if query is to be excluded while processing usage',
    )
    duration: Optional[float] = Field(
        None, description='How long did the query took to run in seconds.'
    )
    users: Optional[List[basic.FullyQualifiedEntityName]] = Field(
        None, description='UserName of the user running the query.'
    )
    usedBy: Optional[List[str]] = Field(
        None,
        description='List of users who ran the query but does not exist in OpenMetadata.',
        unique_items=True,
    )
    queryDate: Optional[basic.Timestamp] = Field(
        None, description='Date on which the query ran.'
    )
    queryUsedIn: Optional[entityReferenceList.EntityReferenceList] = Field(
        None, description='list of entities to which the query is joined.'
    )
    triggeredBy: Optional[entityReference.EntityReference] = Field(
        None,
        description='Entity that triggered the query. E.g., a Stored Procedure or a Pipeline Task.',
    )
    processedLineage: Optional[bool] = Field(
        False,
        description='Flag if this query has already been successfully processed for lineage',
    )
    service: basic.FullyQualifiedEntityName = Field(
        ...,
        description='Link to the database service fully qualified name where this query has been run',
    )
