# generated by datamodel-codegen:
#   filename:  api/data/createStoredProcedure.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field, constr

from ...entity.data import storedProcedure
from ...type import basic, entityReference, lifeCycle, tagLabel


class CreateStoredProcedureRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: storedProcedure.EntityName = Field(
        ..., description='Name of a Stored Procedure.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this Stored Procedure.'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the Stored Procedure.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this entity'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this StoredProcedure.'
    )
    storedProcedureCode: storedProcedure.StoredProcedureCode = Field(
        ..., description='SQL Query definition.'
    )
    databaseSchema: Optional[basic.FullyQualifiedEntityName] = Field(
        None,
        description='Link to the database schema fully qualified name where this stored procedure is hosted in',
    )
    extension: Optional[basic.EntityExtension] = Field(
        None,
        description='Entity extension data with custom attributes added to the entity.',
    )
    dataProducts: Optional[List[basic.FullyQualifiedEntityName]] = Field(
        None,
        description='List of fully qualified names of data products this entity is part of.',
    )
    sourceUrl: Optional[basic.SourceUrl] = Field(
        None, description='Source URL of database schema.'
    )
    domain: Optional[str] = Field(
        None,
        description='Fully qualified name of the domain the Stored Procedure belongs to.',
    )
    lifeCycle: Optional[lifeCycle.LifeCycle] = Field(
        None, description='Life Cycle of the entity'
    )
    sourceHash: Optional[constr(min_length=1, max_length=32)] = Field(
        None, description='Source hash of the entity'
    )
