# generated by datamodel-codegen:
#   filename:  api/services/createSearchService.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...entity.services import searchService
from ...type import basic, entityReference, tagLabel


class CreateSearchServiceRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: basic.EntityName = Field(
        ..., description='Name that identifies the this entity instance uniquely'
    )
    displayName: Optional[str] = Field(
        None,
        description='Display Name that identifies this search service. It could be title or label from the source services.',
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of search service entity.'
    )
    serviceType: searchService.SearchServiceType
    connection: Optional[searchService.SearchConnection] = None
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this Search Service.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this search service.'
    )
    dataProducts: Optional[List[basic.FullyQualifiedEntityName]] = Field(
        None,
        description='List of fully qualified names of data products this entity is part of.',
    )
    domain: Optional[str] = Field(
        None,
        description='Fully qualified name of the domain the Search Service belongs to.',
    )
