# generated by datamodel-codegen:
#   filename:  api/tests/createTestSuite.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Extra, Field, constr

from ...type import basic, entityReference


class TestSuiteEntityName(BaseModel):
    __root__: constr(min_length=1, max_length=256) = Field(
        ...,
        description='Name of a test suite entity. For executable testSuite, this should match the entity FQN in the platform.',
    )


class CreateTestSuiteRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: TestSuiteEntityName = Field(
        ..., description='Name that identifies this test suite.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this test suite.'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the test suite.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this test suite'
    )
    executableEntityReference: Optional[basic.FullyQualifiedEntityName] = Field(
        None,
        description='FQN of the entity the test suite is executed against. Only applicable for executable test suites.',
    )
