# generated by datamodel-codegen:
#   filename:  configuration/elasticSearchConfiguration.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field


class SearchType(Enum):
    elasticsearch = 'elasticsearch'
    opensearch = 'opensearch'


class SearchIndexMappingLanguage(Enum):
    EN = 'EN'
    JP = 'JP'
    ZH = 'ZH'


class ElasticSearchConfiguration(BaseModel):
    class Config:
        extra = Extra.forbid

    host: str = Field(..., description='Elastic Search Host')
    port: int = Field(..., description='Elastic Search port')
    scheme: str = Field(..., description='Http/Https connection scheme')
    username: Optional[str] = Field(
        None, description='Elastic Search Username for Login'
    )
    password: Optional[str] = Field(
        None, description='Elastic Search Password for Login'
    )
    truststorePath: Optional[str] = Field(None, description='Truststore Path')
    truststorePassword: Optional[str] = Field(None, description='Truststore Password')
    connectionTimeoutSecs: int = Field(..., description='Connection Timeout in Seconds')
    socketTimeoutSecs: int = Field(..., description='Socket Timeout in Seconds')
    keepAliveTimeoutSecs: Optional[int] = Field(
        None, description='Keep Alive Timeout in Seconds'
    )
    batchSize: int = Field(..., description='Batch Size for Requests')
    searchIndexMappingLanguage: SearchIndexMappingLanguage
    searchType: Optional[SearchType] = Field(
        SearchType.elasticsearch,
        description='This enum defines the search Type elastic/open search.',
    )
