# generated by datamodel-codegen:
#   filename:  entity/applications/marketplace/appMarketPlaceDefinition.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from typing import Any, List, Optional

from pydantic import AnyUrl, BaseModel, Extra, Field

from ....type import basic, entityHistory, entityReference, tagLabel
from .. import app


class AppMarketPlaceDefinition(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(..., description='Unique identifier of this application.')
    name: basic.EntityName = Field(..., description='Name of the Application.')
    displayName: Optional[str] = Field(
        None, description='Display Name for the application.'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the Application.'
    )
    features: Optional[basic.Markdown] = Field(
        None, description='Features of the Application.'
    )
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='FullyQualifiedName same as `name`.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this workflow.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags associated with the entity.'
    )
    developer: Optional[str] = Field(None, description='Developer For the Application.')
    developerUrl: Optional[str] = Field(None, description='Url for the developer')
    privacyPolicyUrl: Optional[str] = Field(
        None, description='Privacy Policy for the developer'
    )
    supportEmail: Optional[str] = Field(
        None, description='Support Email for the application'
    )
    className: str = Field(
        ..., description='Full Qualified ClassName for the the application'
    )
    appType: app.AppType = Field(
        ..., description='This schema defines the type of application.'
    )
    scheduleType: app.ScheduleType = Field(
        ..., description='This schema defines the Schedule Type of Application.'
    )
    permission: app.Permissions = Field(
        ..., description='Permission used by Native Applications.'
    )
    runtime: Optional[app.ExecutionContext] = Field(
        None,
        description='If app type is live, user can provide additional runtime context.',
    )
    appConfiguration: Optional[Any] = Field(
        None, description='Application Configuration object.'
    )
    appLogoUrl: Optional[AnyUrl] = Field(None, description='Application Logo Url.')
    appScreenshots: Optional[List[str]] = Field(
        None, description='Application Screenshots.', unique_items=True
    )
