# generated by datamodel-codegen:
#   filename:  entity/data/dashboardDataModel.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field, constr

from ...type import (
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    lifeCycle,
    tagLabel,
    votes,
)
from ..services import dashboardService
from . import table


class DataModelType(Enum):
    TableauDataModel = 'TableauDataModel'
    SupersetDataModel = 'SupersetDataModel'
    MetabaseDataModel = 'MetabaseDataModel'
    LookMlView = 'LookMlView'
    LookMlExplore = 'LookMlExplore'
    PowerBIDataModel = 'PowerBIDataModel'
    QlikSenseDataModel = 'QlikSenseDataModel'


class DashboardDataModel(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(
        ..., description='Unique identifier of this data model instance.'
    )
    name: basic.EntityName = Field(
        ...,
        description='Name of a data model. Expected to be unique within a Dashboard.',
    )
    displayName: Optional[str] = Field(
        None,
        description='Display Name that identifies this data model. It could be title or label from the source.',
    )
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None,
        description='Fully qualified name of a data model in the form `serviceName.dashboardName.datamodel.datamodelName`.',
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of a data model.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    href: Optional[basic.Href] = Field(
        None, description='Link to this data model entity.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this data model.'
    )
    dataProducts: Optional[entityReferenceList.EntityReferenceList] = Field(
        None, description='List of data products this entity is part of.'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this data model.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
    followers: Optional[entityReferenceList.EntityReferenceList] = Field(
        None, description='Followers of this dashboard.'
    )
    service: Optional[entityReference.EntityReference] = Field(
        None, description='Link to service where this data model is hosted in.'
    )
    serviceType: Optional[dashboardService.DashboardServiceType] = Field(
        None, description='Service type where this data model is hosted in.'
    )
    dataModelType: DataModelType
    sql: Optional[basic.SqlQuery] = Field(
        None, description='In case the Data Model is based on a SQL query.'
    )
    columns: List[table.Column] = Field(..., description='Columns from the data model.')
    project: Optional[str] = Field(
        None,
        description='Name of the project / workspace / collection in which the dataModel is contained',
    )
    domain: Optional[entityReference.EntityReference] = Field(
        None,
        description='Domain the Dashboard Data Model belongs to. When not set, the Dashboard model inherits the domain from the dashboard service it belongs to.',
    )
    votes: Optional[votes.Votes] = None
    lifeCycle: Optional[lifeCycle.LifeCycle] = Field(
        None, description='Life Cycle properties of the entity'
    )
    sourceHash: Optional[constr(min_length=1, max_length=32)] = Field(
        None, description='Source hash of the entity'
    )
