# generated by datamodel-codegen:
#   filename:  entity/data/databaseSchema.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field, constr

from ...type import (
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    lifeCycle,
    tagLabel,
    usageDetails,
    votes,
)
from ..services import databaseService
from ..services.connections import connectionBasicType
from . import table


class EntityName(BaseModel):
    __root__: constr(regex=r'^((?!::).)*$', min_length=1, max_length=128) = Field(
        ..., description='Name of a table. Expected to be unique within a database.'
    )


class DatabaseSchemaProfilerConfig(BaseModel):
    profileSample: Optional[float] = Field(
        None,
        description='Percentage of data or no. of rows we want to execute the profiler and tests on',
    )
    profileSampleType: Optional[
        table.ProfileSampleType
    ] = table.ProfileSampleType.PERCENTAGE
    sampleDataCount: Optional[int] = Field(
        50,
        description='Number of row of sample data to be generated',
        title='Sample Data Rows Count',
    )
    sampleDataStorageConfig: Optional[
        connectionBasicType.SampleDataStorageConfig
    ] = Field(None, title='Storage Config for Sample Data')


class DatabaseSchema(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[basic.Uuid] = Field(
        None, description='Unique identifier that identifies this schema instance.'
    )
    name: EntityName = Field(..., description='Name that identifies the schema.')
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None,
        description="Name that uniquely identifies a schema in the format 'ServiceName.DatabaseName.SchemaName'.",
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this schema.'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the schema instance.'
    )
    dataProducts: Optional[entityReferenceList.EntityReferenceList] = Field(
        None, description='List of data products this entity is part of.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this schema.'
    )
    service: entityReference.EntityReference = Field(
        ...,
        description='Link to the database cluster/service where this schema is hosted in.',
    )
    serviceType: Optional[databaseService.DatabaseServiceType] = Field(
        None, description='Service type where this schema is hosted in.'
    )
    database: entityReference.EntityReference = Field(
        ..., description='Reference to Database that contains this table.'
    )
    tables: Optional[entityReferenceList.EntityReferenceList] = Field(
        None, description='References to tables in the schema.'
    )
    usageSummary: Optional[usageDetails.UsageDetails] = Field(
        None, description='Latest usage information for this database.'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this Database Schema Service.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
    retentionPeriod: Optional[basic.Duration] = Field(
        None,
        description='Retention period of the data in the database schema. Period is expressed as duration in ISO 8601 format in UTC. Example - `P23DT23H`. When not set, the retention period is inherited from the parent database, if it exists.',
    )
    extension: Optional[basic.EntityExtension] = Field(
        None,
        description='Entity extension data with custom attributes added to the entity.',
    )
    sourceUrl: Optional[basic.SourceUrl] = Field(
        None, description='Source URL of database schema.'
    )
    domain: Optional[entityReference.EntityReference] = Field(
        None,
        description='Domain the Database Schema belongs to. When not set, the Schema inherits the domain from the database it belongs to.',
    )
    votes: Optional[votes.Votes] = None
    lifeCycle: Optional[lifeCycle.LifeCycle] = Field(
        None, description='Life Cycle properties of the entity'
    )
    sourceHash: Optional[constr(min_length=1, max_length=32)] = Field(
        None, description='Source hash of the entity'
    )
    databaseSchemaProfilerConfig: Optional[DatabaseSchemaProfilerConfig] = Field(
        None, description='This schema defines the type for Schema profile config.'
    )
