# generated by datamodel-codegen:
#   filename:  entity/data/query.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...type import (
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    tagLabel,
    votes,
)


class Query(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[basic.Uuid] = Field(
        None, description='Unique identifier of the query.'
    )
    name: basic.EntityName = Field(
        ..., description='Name of an entity to which the query belongs to'
    )
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='Fully qualified name of a query.'
    )
    displayName: Optional[str] = Field(
        None,
        description='Display Name that identifies this Query. It could be title or label.',
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of a query.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the query.')
    href: Optional[basic.Href] = Field(None, description='Link to this Query resource.')
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this Query.'
    )
    duration: Optional[float] = Field(
        None, description='How long did the query took to run in seconds.'
    )
    users: Optional[List[entityReference.EntityReference]] = Field(
        None, description='List of users who ran this query.'
    )
    followers: Optional[entityReferenceList.EntityReferenceList] = Field(
        None, description='Followers of this Query.'
    )
    votes: Optional[votes.Votes] = None
    query: basic.SqlQuery = Field(..., description='SQL Query definition.')
    query_type: Optional[str] = Field(None, description='SQL query type')
    exclude_usage: Optional[bool] = Field(
        None,
        description='Flag to check if query is to be excluded while processing usage',
    )
    checksum: Optional[str] = Field(
        None, description='Checksum to avoid registering duplicate queries.'
    )
    queryDate: Optional[basic.Timestamp] = Field(
        None, description='Date on which the query ran.'
    )
    usedBy: Optional[List[str]] = Field(
        None,
        description='List of users who ran the query but does not exist in OpenMetadata.',
        unique_items=True,
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this SQL query.'
    )
    queryUsedIn: Optional[entityReferenceList.EntityReferenceList] = Field(
        None, description='Entities that are using this query'
    )
    triggeredBy: Optional[entityReference.EntityReference] = Field(
        None,
        description='Entity that triggered the query. E.g., a Stored Procedure or a Pipeline Task.',
    )
    processedLineage: Optional[bool] = Field(
        False,
        description='Flag if this query has already been successfully processed for lineage',
    )
    service: entityReference.EntityReference = Field(
        ..., description='Link to the service this query belongs to.'
    )
