# generated by datamodel-codegen:
#   filename:  entity/domains/dataProduct.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Extra, Field

from ...type import basic, entityHistory, entityReference, entityReferenceList


class DataProduct(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(..., description='Unique ID of the Data Product')
    name: basic.EntityName = Field(..., description='A unique name of the Data Product')
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None,
        description='FullyQualifiedName is `domain.dataProductName` or `sub-domain.dataProductName`.',
    )
    displayName: Optional[str] = Field(
        None,
        description="Name used for display purposes. Example 'Marketing', 'Payments', etc.",
    )
    description: basic.Markdown = Field(
        ..., description='Description of the Data Product.'
    )
    style: Optional[basic.Style] = None
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this Data Product.'
    )
    experts: Optional[entityReferenceList.EntityReferenceList] = Field(
        None, description='List of users who are experts for this Data Product.'
    )
    domain: Optional[entityReference.EntityReference] = Field(
        None, description='Domain or sub-domain to which this Data Product belongs to.'
    )
    assets: Optional[entityReferenceList.EntityReferenceList] = Field(
        None, description='Data assets collection that is part of this data product.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
