# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/supersetConnection.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import AnyUrl, BaseModel, Extra, Field

from ....utils import supersetApiConnection
from .. import connectionBasicType
from ..database import mysqlConnection, postgresConnection


class SupersetType(Enum):
    Superset = 'Superset'


class SupersetConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[SupersetType] = Field(
        SupersetType.Superset, description='Service Type', title='Service Type'
    )
    hostPort: AnyUrl = Field(
        ..., description='URL for the superset instance.', title='Host and Port'
    )
    connection: Union[
        supersetApiConnection.SupersetApiConnection,
        postgresConnection.PostgresConnection,
        mysqlConnection.MysqlConnection,
    ] = Field(
        ...,
        description='Choose between API or database connection fetch metadata from superset.',
        title='Superset Connection',
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
