# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/datalakeConnection.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from .. import connectionBasicType
from .datalake import azureConfig, gcsConfig, s3Config


class DatalakeType(Enum):
    Datalake = 'Datalake'


class LocalConfig(BaseModel):
    pass

    class Config:
        extra = Extra.forbid


class DatalakeConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[DatalakeType] = Field(
        DatalakeType.Datalake, description='Service Type', title='Service Type'
    )
    configSource: Union[
        LocalConfig, azureConfig.AzureConfig, gcsConfig.GCSConfig, s3Config.S3Config
    ] = Field(
        ...,
        description='Available sources to fetch files.',
        title='DataLake Configuration Source',
    )
    bucketName: Optional[str] = Field(
        '', description='Bucket Name of the data source.', title='Bucket Name'
    )
    prefix: Optional[str] = Field(
        '', description='Prefix of the data source.', title='Prefix'
    )
    databaseName: Optional[str] = Field(
        None,
        description='Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.',
        title='Database Name',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
    sampleDataStorageConfig: Optional[
        connectionBasicType.SampleDataStorageConfig
    ] = Field(None, title='S3 Config for Sample Data')
