# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/druidConnection.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr

from .. import connectionBasicType


class DruidType(Enum):
    Druid = 'Druid'


class DruidScheme(Enum):
    druid = 'druid'


class DruidConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[DruidType] = Field(
        DruidType.Druid, description='Service Type', title='Service Type'
    )
    scheme: Optional[DruidScheme] = Field(
        DruidScheme.druid,
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    username: Optional[str] = Field(
        None,
        description='Username to connect to Druid. This user should have privileges to read all the metadata in Druid.',
        title='Username',
    )
    password: Optional[CustomSecretStr] = Field(
        None, description='Password to connect to Druid.', title='Password'
    )
    hostPort: str = Field(
        ..., description='Host and port of the Druid service.', title='Host and Port'
    )
    databaseName: Optional[str] = Field(
        None,
        description='Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.',
        title='Database Name',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
    supportsQueryComment: Optional[connectionBasicType.SupportsQueryComment] = Field(
        None, title='Supports Query Comment'
    )
    supportsDBTExtraction: Optional[connectionBasicType.SupportsDBTExtraction] = None
    sampleDataStorageConfig: Optional[
        connectionBasicType.SampleDataStorageConfig
    ] = Field(None, title='S3 Config for Sample Data')
