# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/hiveConnection.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional, Union

from pydantic import BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr

from .. import connectionBasicType
from . import mysqlConnection, postgresConnection


class Auth(Enum):
    NONE = 'NONE'
    LDAP = 'LDAP'
    KERBEROS = 'KERBEROS'
    CUSTOM = 'CUSTOM'
    NOSASL = 'NOSASL'
    BASIC = 'BASIC'
    GSSAPI = 'GSSAPI'
    JWT = 'JWT'
    PLAIN = 'PLAIN'


class HiveType(Enum):
    Hive = 'Hive'


class HiveScheme(Enum):
    hive = 'hive'
    hive_http = 'hive+http'
    hive_https = 'hive+https'


class HiveConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[HiveType] = Field(
        HiveType.Hive, description='Service Type', title='Service Type'
    )
    scheme: Optional[HiveScheme] = Field(
        HiveScheme.hive,
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    username: Optional[str] = Field(
        None,
        description='Username to connect to Hive. This user should have privileges to read all the metadata in Hive.',
        title='Username',
    )
    password: Optional[CustomSecretStr] = Field(
        None, description='Password to connect to Hive.', title='Password'
    )
    hostPort: str = Field(
        ..., description='Host and port of the Hive service.', title='Host and Port'
    )
    auth: Optional[Auth] = Field(
        Auth.NONE,
        description='Authentication mode to connect to hive.',
        title='Authentication Mode',
    )
    kerberosServiceName: Optional[str] = Field(
        None,
        description='If authenticating with Kerberos specify the Kerberos service name',
        title='Kerberos Service Name',
    )
    databaseSchema: Optional[str] = Field(
        None,
        description='Database Schema of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single schema. When left blank, OpenMetadata Ingestion attempts to scan all the schemas.',
        title='Database Schema',
    )
    databaseName: Optional[str] = Field(
        None,
        description='Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.',
        title='Database Name',
    )
    authOptions: Optional[str] = Field(
        None,
        description='Authentication options to pass to Hive connector. These options are based on SQLAlchemy.',
        title='URL Authentication Options',
    )
    metastoreConnection: Optional[
        Union[
            postgresConnection.PostgresConnection,
            mysqlConnection.MysqlConnection,
            Dict[str, Any],
        ]
    ] = Field(
        None,
        description='Hive Metastore Connection Details',
        title='Hive Metastore Connection Details',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsDBTExtraction: Optional[connectionBasicType.SupportsDBTExtraction] = None
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
    sampleDataStorageConfig: Optional[
        connectionBasicType.SampleDataStorageConfig
    ] = Field(None, title='S3 Config for Sample Data')
