# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/mongoDBConnection.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from .. import connectionBasicType
from .mongoDB import mongoDBValues


class MongoDBType(Enum):
    MongoDB = 'MongoDB'


class MongoConnectionString(BaseModel):
    connectionURI: Optional[str] = Field(
        None,
        description='Connection URI to connect to your MongoDB cluster',
        title='Connection URI',
    )


class MongoDBConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[MongoDBType] = Field(
        MongoDBType.MongoDB, description='Service Type', title='Service Type'
    )
    connectionDetails: Optional[
        Union[mongoDBValues.MongoConnectionValues, MongoConnectionString]
    ] = Field(
        None,
        description='MongoDB Connection Details.',
        title='MongoDB Connection Details',
    )
    databaseName: Optional[str] = Field(
        None,
        description='Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.',
        title='Database Name',
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
