# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/mysqlConnection.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from .. import connectionBasicType
from .common import basicAuth, iamAuthConfig


class MySQLType(Enum):
    Mysql = 'Mysql'


class MySQLScheme(Enum):
    mysql_pymysql = 'mysql+pymysql'


class MysqlConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[MySQLType] = Field(
        MySQLType.Mysql, description='Service Type', title='Service Type'
    )
    scheme: Optional[MySQLScheme] = Field(
        MySQLScheme.mysql_pymysql,
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    username: str = Field(
        ...,
        description='Username to connect to MySQL. This user should have privileges to read all the metadata in Mysql.',
        title='Username',
    )
    authType: Optional[
        Union[basicAuth.BasicAuth, iamAuthConfig.IamAuthConfigurationSource]
    ] = Field(
        None, description='Choose Auth Config Type.', title='Auth Configuration Type'
    )
    hostPort: str = Field(
        ..., description='Host and port of the MySQL service.', title='Host and Port'
    )
    databaseName: Optional[str] = Field(
        None,
        description='Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.',
        title='Database Name',
    )
    databaseSchema: Optional[str] = Field(
        None,
        description='Database Schema of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single schema. When left blank, OpenMetadata Ingestion attempts to scan all the schemas.',
        title='Database Schema',
    )
    sslCA: Optional[str] = Field(
        None, description='Provide the path to ssl ca file', title='SSL CA'
    )
    sslCert: Optional[str] = Field(
        None,
        description='Provide the path to ssl client certificate file (ssl_cert)',
        title='SSL Client Certificate File',
    )
    sslKey: Optional[str] = Field(
        None,
        description='Provide the path to ssl client certificate file (ssl_key)',
        title='SSL Client Key File',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsDBTExtraction: Optional[connectionBasicType.SupportsDBTExtraction] = None
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
    supportsQueryComment: Optional[connectionBasicType.SupportsQueryComment] = Field(
        None, title='Supports Query Comment'
    )
    sampleDataStorageConfig: Optional[
        connectionBasicType.SampleDataStorageConfig
    ] = Field(None, title='S3 Config for Sample Data')
