# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/sqliteConnection.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr

from .. import connectionBasicType


class SQLiteType(Enum):
    SQLite = 'SQLite'


class SQLiteScheme(Enum):
    sqlite_pysqlite = 'sqlite+pysqlite'


class SQLiteConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[SQLiteType] = Field(
        SQLiteType.SQLite, description='Service Type', title='Service Type'
    )
    scheme: Optional[SQLiteScheme] = Field(
        SQLiteScheme.sqlite_pysqlite,
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    username: Optional[str] = Field(
        None,
        description='Username to connect to SQLite. Blank for in-memory database.',
        title='Username',
    )
    password: Optional[CustomSecretStr] = Field(
        None,
        description='Password to connect to SQLite. Blank for in-memory database.',
        title='Password',
    )
    hostPort: Optional[str] = Field(
        None,
        description='Host and port of the SQLite service. Blank for in-memory database.',
        title='Host and Port',
    )
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank, OpenMetadata Ingestion attempts to scan all the databases.',
        title='Database',
    )
    databaseMode: Optional[str] = Field(
        ':memory:',
        description='How to run the SQLite database. :memory: by default.',
        title='Database Mode',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsDBTExtraction: Optional[connectionBasicType.SupportsDBTExtraction] = None
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
    supportsQueryComment: Optional[connectionBasicType.SupportsQueryComment] = Field(
        None, title='Supports Query Comment'
    )
    sampleDataStorageConfig: Optional[
        connectionBasicType.SampleDataStorageConfig
    ] = Field(None, title='S3 Config for Sample Data')
