# generated by datamodel-codegen:
#   filename:  entity/services/connections/metadata/alationConnection.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import AnyUrl, BaseModel, Extra, Field

from .....security.credentials import apiAccessTokenAuth, basicAuth
from .. import connectionBasicType


class AlationType(Enum):
    Alation = 'Alation'


class AlationConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[AlationType] = Field(AlationType.Alation, description='Service Type')
    hostPort: AnyUrl = Field(
        ..., description='Host and port of the Alation service.', title='Host and Port'
    )
    authType: Union[basicAuth.BasicAuth, apiAccessTokenAuth.ApiAccessTokenAuth] = Field(
        ...,
        description='Types of methods used to authenticate to the alation instance',
        title='Authentication type for Alation',
    )
    projectName: Optional[str] = Field(
        'AlationAPI',
        description='Project name to create the refreshToken. Can be anything',
        title='Project Name',
    )
    paginationLimit: Optional[int] = Field(
        10,
        description='Pagination limit used for Alation APIs pagination',
        title='Pagination Limit',
    )
    includeUndeployedDatasources: Optional[bool] = Field(
        False,
        description='Specifies if undeployed datasources should be included while ingesting.',
        title='Include Undeployed Datasources',
    )
    includeHiddenDatasources: Optional[bool] = Field(
        False,
        description='Specifies if hidden datasources should be included while ingesting.',
        title='Include Hidden Datasources',
    )
    alationTagClassificationName: Optional[str] = Field(
        'alationTags',
        description='Custom OpenMetadata Classification name for alation tags.',
        title='Alation Tags Classification Name',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
