# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/dagsterConnection.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr

from .. import connectionBasicType


class DagsterType(Enum):
    Dagster = 'Dagster'


class DagsterConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[DagsterType] = Field(
        DagsterType.Dagster, description='Service Type', title='Service Type'
    )
    host: AnyUrl = Field(..., description='URL to the Dagster instance', title='Host')
    token: Optional[CustomSecretStr] = Field(
        None, description='To Connect to Dagster Cloud', title='Token'
    )
    timeout: Optional[int] = Field(
        '1000',
        description='Connection Time Limit Between OM and Dagster Graphql API in second',
        title='Time Out',
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
