# generated by datamodel-codegen:
#   filename:  events/eventSubscription.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, Extra, Field

from ..entity.events import webhook
from ..type import basic, entityHistory, entityReference
from . import dataInsightAlertConfig, emailAlertConfig, eventFilterRule


class TriggerType(Enum):
    RealTime = 'RealTime'
    Scheduled = 'Scheduled'


class AlertType(Enum):
    ChangeEvent = 'ChangeEvent'
    DataInsightReport = 'DataInsightReport'
    Task_Conversation_Announcement = 'Task/Conversation/Announcement'


class SubscriptionType(Enum):
    GenericWebhook = 'GenericWebhook'
    SlackWebhook = 'SlackWebhook'
    MsTeamsWebhook = 'MsTeamsWebhook'
    GChatWebhook = 'GChatWebhook'
    Email = 'Email'
    ActivityFeed = 'ActivityFeed'
    DataInsight = 'DataInsight'


class Status(Enum):
    disabled = 'disabled'
    failed = 'failed'
    retryLimitReached = 'retryLimitReached'
    awaitingRetry = 'awaitingRetry'
    active = 'active'


class SubscriptionStatus(BaseModel):
    class Config:
        extra = Extra.forbid

    status: Optional[Status] = None
    lastSuccessfulAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last non-successful callback time in UNIX UTC epoch time in milliseconds.',
    )
    lastFailedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last non-successful callback time in UNIX UTC epoch time in milliseconds.',
    )
    lastFailedStatusCode: Optional[int] = Field(
        None,
        description='Last non-successful activity response code received during callback.',
    )
    lastFailedReason: Optional[str] = Field(
        None,
        description='Last non-successful activity response reason received during callback.',
    )
    nextAttempt: Optional[basic.Timestamp] = Field(
        None,
        description='Next retry will be done at this time in Unix epoch time milliseconds. Only valid is `status` is `awaitingRetry`.',
    )
    timestamp: Optional[basic.Timestamp] = None


class FilteringRules(BaseModel):
    class Config:
        extra = Extra.forbid

    resources: List[str] = Field(
        ...,
        description='Defines a list of resources that triggers the Event Subscription, Eg All, User, Teams etc.',
    )
    rules: Optional[List[eventFilterRule.EventFilterRule]] = Field(
        None, description='A set of filter rules associated with the Alert.'
    )


class ScheduleInfo(Enum):
    Daily = 'Daily'
    Weekly = 'Weekly'
    Monthly = 'Monthly'
    Custom = 'Custom'


class Trigger(BaseModel):
    class Config:
        extra = Extra.forbid

    triggerType: TriggerType
    scheduleInfo: Optional[ScheduleInfo] = Field(
        ScheduleInfo.Weekly, description='Schedule Info'
    )
    cronExpression: Optional[str] = Field(
        None, description='Cron Expression in case of Custom scheduled Trigger'
    )


class SubscriptionConfig(BaseModel):
    __root__: Union[
        webhook.Webhook,
        emailAlertConfig.EmailAlertConfig,
        dataInsightAlertConfig.DataInsightAlertConfig,
    ]


class EventSubscription(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(
        ..., description='Unique identifier that identifies this Event Subscription.'
    )
    name: basic.EntityName = Field(
        ..., description='Name that uniquely identifies this Event Subscription.'
    )
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None,
        description='FullyQualifiedName that uniquely identifies a Event Subscription.',
    )
    displayName: Optional[str] = Field(
        None, description='Display name for this Event Subscription.'
    )
    description: Optional[basic.Markdown] = Field(
        None,
        description='A short description of the Event Subscription, comprehensible to regular users.',
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this Event Subscription.'
    )
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the Event Subscription.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the Event Subscription in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that led to this version of the Event Subscription.'
    )
    alertType: AlertType = Field(..., description='Type of Alert')
    trigger: Optional[Trigger] = Field(
        None, description='Trigger information for Alert.'
    )
    filteringRules: Optional[FilteringRules] = Field(
        None,
        description='Set of rules that the Event Subscription Contains to allow conditional control for alerting.',
    )
    subscriptionType: SubscriptionType
    subscriptionConfig: Optional[SubscriptionConfig] = None
    enabled: Optional[bool] = Field(
        True, description='Is the event Subscription enabled.'
    )
    batchSize: Optional[int] = Field(
        10, description='Maximum number of events sent in a batch (Default 10).'
    )
    timeout: Optional[int] = Field(
        10, description='Connection timeout in seconds. (Default 10s).'
    )
    readTimeout: Optional[int] = Field(
        12, description='Read timeout in seconds. (Default 12s).'
    )
    statusDetails: Optional[SubscriptionStatus] = None
    provider: Optional[basic.ProviderType] = basic.ProviderType.user


class Subscription(BaseModel):
    class Config:
        extra = Extra.forbid

    subscriptionType: Optional[SubscriptionType] = None
    subscriptionName: Optional[str] = Field(
        None, description='Name for the subscription'
    )
    subscriptionConfig: Optional[SubscriptionConfig] = None
