# generated by datamodel-codegen:
#   filename:  metadataIngestion/dbtPipeline.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from ..type import filterPattern
from .dbtconfig import (
    dbtAzureConfig,
    dbtCloudConfig,
    dbtGCSConfig,
    dbtHttpConfig,
    dbtLocalConfig,
    dbtS3Config,
)


class DbtConfigType(Enum):
    DBT = 'DBT'


class DbtPipeline(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[DbtConfigType] = Field(
        DbtConfigType.DBT, description='Pipeline type'
    )
    dbtConfigSource: Optional[
        Union[
            dbtCloudConfig.DbtCloudConfig,
            dbtLocalConfig.DbtLocalConfig,
            dbtHttpConfig.DbtHttpConfig,
            dbtS3Config.DbtS3Config,
            dbtGCSConfig.DbtGcsConfig,
            dbtAzureConfig.DbtAzureConfig,
        ]
    ] = Field(
        None,
        description='Available sources to fetch DBT catalog and manifest files.',
        title='DBT Configuration Source',
    )
    dbtUpdateDescriptions: Optional[bool] = Field(
        False,
        description='Optional configuration to update the description from DBT or not',
    )
    includeTags: Optional[bool] = Field(
        True, description='Optional configuration to toggle the tags ingestion.'
    )
    dbtClassificationName: Optional[str] = Field(
        'dbtTags',
        description='Custom OpenMetadata Classification name for dbt tags.',
        title='dbt Classification Name',
    )
    schemaFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None,
        description='Regex to only fetch tables or databases that matches the pattern.',
        title='Schema Filter Pattern',
    )
    tableFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None,
        description='Regex exclude tables or databases that matches the pattern.',
        title='Table Filter Pattern',
    )
    parsingTimeoutLimit: Optional[int] = Field(
        300,
        description='Configuration to set the timeout for parsing the query in seconds.',
        title='Parsing Timeout Limit (in sec.)',
    )
    databaseFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None,
        description='Regex to only fetch databases that matches the pattern.',
        title='Database Filter Pattern',
    )
