# generated by datamodel-codegen:
#   filename:  metadataIngestion/metadataToElasticSearchPipeline.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from ..configuration import elasticSearchConfiguration


class MetadataToESConfigType(Enum):
    MetadataToElasticSearch = 'MetadataToElasticSearch'


class MetadataToElasticSearchPipeline(BaseModel):
    class Config:
        extra = Extra.forbid

    type: MetadataToESConfigType = Field(..., description='Pipeline type')
    regionName: Optional[str] = Field(
        None,
        description='Region name. Required when using AWS Credentials.',
        title='AWS Region Name',
    )
    caCerts: Optional[str] = Field(
        None,
        description='Certificate path to be added in configuration. The path should be local in the Ingestion Container.',
        title='CA Certificates',
    )
    timeout: Optional[int] = Field(30, description='Connection Timeout')
    useSSL: Optional[bool] = Field(
        False,
        description='Indicates whether to use SSL when connecting to ElasticSearch. By default, we will ignore SSL settings.',
        title='Use SSL',
    )
    verifyCerts: Optional[bool] = Field(
        False,
        description='Indicates whether to verify certificates when using SSL connection to ElasticSearch. Ignored by default. Is set to true, make sure to send the certificates in the property `CA Certificates`.',
        title='Validate Certificates',
    )
    useAwsCredentials: Optional[bool] = Field(
        False,
        description='Indicates whether to use aws credentials when connecting to OpenSearch in AWS.',
        title='Use AWS Credentials',
    )
    searchIndexMappingLanguage: Optional[
        elasticSearchConfiguration.SearchIndexMappingLanguage
    ] = Field(
        elasticSearchConfiguration.SearchIndexMappingLanguage.EN,
        description='Recreate Indexes with updated Language',
    )
    batchSize: Optional[int] = Field(
        1000,
        description='Maximum number of events entities in a batch (Default 1000).',
        title='Batch Size',
    )
    recreateIndex: Optional[bool] = Field(True, title='Recreate Indexes')
