# generated by datamodel-codegen:
#   filename:  metadataIngestion/searchServiceMetadataPipeline.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from ..type import filterPattern


class SearchMetadataConfigType(Enum):
    SearchMetadata = 'SearchMetadata'


class SearchServiceMetadataPipeline(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[SearchMetadataConfigType] = Field(
        SearchMetadataConfigType.SearchMetadata, description='Pipeline type'
    )
    searchIndexFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None,
        description='Regex to only fetch search indexes that matches the pattern.',
        title='Search Index Filter Pattern',
    )
    markDeletedSearchIndexes: Optional[bool] = Field(
        True,
        description='Optional configuration to soft delete search indexes in OpenMetadata if the source search indexes are deleted. Also, if the search index is deleted, all the associated entities like lineage, etc., with that search index will be deleted',
        title='Mark Deleted Search Index',
    )
    includeSampleData: Optional[bool] = Field(
        True,
        description='Optional configuration to turn off fetching sample data for search index.',
        title='Include Sample Data',
    )
    sampleSize: Optional[int] = Field(
        10,
        description='No. of records of sample data we want to ingest.',
        title='Sample Size',
    )
