# generated by datamodel-codegen:
#   filename:  settings/settings.json
#   timestamp: 2024-02-12T13:53:26+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Field

from ..configuration import (
    authenticationConfiguration,
    authorizerConfiguration,
    elasticSearchConfiguration,
    eventHandlerConfiguration,
    fernetConfiguration,
    jwtTokenConfiguration,
    pipelineServiceClientConfiguration,
    slackAppConfiguration,
    taskNotificationConfiguration,
)
from ..email import smtpSettings


class SettingType(Enum):
    authorizerConfiguration = 'authorizerConfiguration'
    authenticationConfiguration = 'authenticationConfiguration'
    jwtTokenConfiguration = 'jwtTokenConfiguration'
    elasticsearch = 'elasticsearch'
    eventHandlerConfiguration = 'eventHandlerConfiguration'
    airflowConfiguration = 'airflowConfiguration'
    fernetConfiguration = 'fernetConfiguration'
    slackEventPublishers = 'slackEventPublishers'
    secretsManagerConfiguration = 'secretsManagerConfiguration'
    sandboxModeEnabled = 'sandboxModeEnabled'
    slackChat = 'slackChat'
    emailConfiguration = 'emailConfiguration'
    customLogoConfiguration = 'customLogoConfiguration'
    loginConfiguration = 'loginConfiguration'
    slackAppConfiguration = 'slackAppConfiguration'
    slackBot = 'slackBot'
    slackInstaller = 'slackInstaller'


class Settings(BaseModel):
    config_type: SettingType = Field(
        ..., description='Unique identifier that identifies an entity instance.'
    )
    config_value: Optional[
        Union[
            pipelineServiceClientConfiguration.PipelineServiceClientConfiguration,
            authenticationConfiguration.AuthenticationConfiguration,
            authorizerConfiguration.AuthorizerConfiguration,
            elasticSearchConfiguration.ElasticSearchConfiguration,
            eventHandlerConfiguration.EventHandlerConfiguration,
            fernetConfiguration.FernetConfiguration,
            jwtTokenConfiguration.JWTTokenConfiguration,
            taskNotificationConfiguration.TaskNotificationConfiguration,
            smtpSettings.SmtpSettings,
            slackAppConfiguration.SlackAppConfiguration,
        ]
    ] = None
