/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.impl;

import com.datapps.linkoopdb.jdbc.ColumnBase;
import com.datapps.linkoopdb.jdbc.HsqlDateTime;
import com.datapps.linkoopdb.jdbc.LdbSqlException;
import com.datapps.linkoopdb.jdbc.SessionInterface;
import com.datapps.linkoopdb.jdbc.error.Error;
import com.datapps.linkoopdb.jdbc.impl.JDBCArray;
import com.datapps.linkoopdb.jdbc.impl.JDBCBlob;
import com.datapps.linkoopdb.jdbc.impl.JDBCBlobClient;
import com.datapps.linkoopdb.jdbc.impl.JDBCClob;
import com.datapps.linkoopdb.jdbc.impl.JDBCClobClient;
import com.datapps.linkoopdb.jdbc.impl.JDBCConnection;
import com.datapps.linkoopdb.jdbc.impl.JDBCNClob;
import com.datapps.linkoopdb.jdbc.impl.JDBCPreparedStatement;
import com.datapps.linkoopdb.jdbc.impl.JDBCResultSetMetaData;
import com.datapps.linkoopdb.jdbc.impl.JDBCSQLXML;
import com.datapps.linkoopdb.jdbc.impl.JDBCStatementBase;
import com.datapps.linkoopdb.jdbc.impl.JDBCUtil;
import com.datapps.linkoopdb.jdbc.lib.IntValueHashMap;
import com.datapps.linkoopdb.jdbc.lib.StringInputStream;
import com.datapps.linkoopdb.jdbc.map.BitMap;
import com.datapps.linkoopdb.jdbc.navigator.RowSetNavigator;
import com.datapps.linkoopdb.jdbc.result.Result;
import com.datapps.linkoopdb.jdbc.result.ResultMetaData;
import com.datapps.linkoopdb.jdbc.result.ResultProperties;
import com.datapps.linkoopdb.jdbc.types.BinaryData;
import com.datapps.linkoopdb.jdbc.types.BinaryUUIDType;
import com.datapps.linkoopdb.jdbc.types.BlobDataID;
import com.datapps.linkoopdb.jdbc.types.ClobDataID;
import com.datapps.linkoopdb.jdbc.types.DateTimeType;
import com.datapps.linkoopdb.jdbc.types.IntervalMonthData;
import com.datapps.linkoopdb.jdbc.types.IntervalSecondData;
import com.datapps.linkoopdb.jdbc.types.IntervalType;
import com.datapps.linkoopdb.jdbc.types.JavaObjectData;
import com.datapps.linkoopdb.jdbc.types.StructureType;
import com.datapps.linkoopdb.jdbc.types.TimeData;
import com.datapps.linkoopdb.jdbc.types.TimestampData;
import com.datapps.linkoopdb.jdbc.types.Type;
import com.datapps.linkoopdb.jdbc.types.Types;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Map;

public class JDBCResultSet
implements ResultSet {
    public Result result;
    protected ResultMetaData resultMetaData;
    JDBCStatementBase statement;
    SessionInterface session;
    JDBCConnection connection;
    boolean isScrollable;
    boolean isUpdatable;
    boolean isInsertable;
    int rsProperties;
    int fetchSize;
    boolean autoClose;
    JDBCPreparedStatement preparedStatement;
    boolean isRowUpdated;
    boolean isOnInsertRow;
    int currentUpdateRowNumber;
    private RowSetNavigator navigator;
    private boolean translateTTIType;
    private int columnCount;
    private boolean wasNullValue;
    private ResultSetMetaData resultSetMetaData;
    private IntValueHashMap columnMap;
    private SQLWarning rootWarning;

    public JDBCResultSet(JDBCConnection conn, JDBCStatementBase s, Result r, ResultMetaData metaData) {
        this(conn, r, metaData);
        this.statement = s;
        this.isScrollable = ResultProperties.isScrollable(this.rsProperties);
        if (ResultProperties.isUpdatable(this.rsProperties)) {
            this.isUpdatable = true;
            this.isInsertable = true;
            for (int i = 0; i < metaData.colIndexes.length; ++i) {
                if (metaData.colIndexes[i] >= 0) continue;
                this.isInsertable = false;
                break;
            }
            this.preparedStatement = new JDBCPreparedStatement(s.connection, this.result);
        }
    }

    public JDBCResultSet(JDBCConnection conn, Result r, ResultMetaData metaData) {
        this.session = conn == null ? null : conn.sessionProxy;
        this.result = r;
        this.connection = conn;
        this.rsProperties = r.rsProperties;
        this.navigator = r.getNavigator();
        this.resultMetaData = metaData;
        this.columnCount = this.resultMetaData.getColumnCount();
        if (ResultProperties.isBigResult(this.rsProperties)) {
            this.navigator.setBigResult(true);
            if (r.getFetchSize() > 0) {
                this.fetchSize = r.getFetchSize();
            }
        }
        if (conn != null) {
            this.translateTTIType = conn.isTranslateTTIType;
        }
    }

    public static JDBCResultSet newJDBCResultSet(Result r, ResultMetaData metaData) {
        return new JDBCResultSetBasic(r, metaData);
    }

    public static JDBCResultSet newEmptyResultSet() {
        ResultMetaData md = ResultMetaData.newResultMetaData(1);
        ColumnBase column = new ColumnBase(null, null, null, "C1");
        column.setType(Type.SQL_INTEGER);
        md.columnTypes[0] = Type.SQL_INTEGER;
        md.columns[0] = column;
        Result r = Result.newSingleColumnResult(md);
        return JDBCResultSet.newJDBCResultSet(r, md);
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
        return this.navigator.next();
    }

    @Override
    public void close() throws SQLException {
        if (this.navigator == null) {
            return;
        }
        if (ResultProperties.isHeld(this.rsProperties)) {
            this.session.closeNavigator(this.navigator.getId());
        } else {
            this.navigator.release();
        }
        this.navigator = null;
        if (this.autoClose && this.statement != null) {
            this.statement.close();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return this.wasNullValue;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkColumn(columnIndex);
        Type sourceType = this.resultMetaData.columnTypes[columnIndex - 1];
        if (sourceType.typeCode == 40) {
            ClobDataID x = (ClobDataID)this.getColumnInType(columnIndex, sourceType);
            if (x == null) {
                return null;
            }
            long length = x.length(this.session);
            if (length > Integer.MAX_VALUE) {
                JDBCUtil.throwError(Error.error(5561));
            }
            return x.getSubString(this.session, 0L, (int)length);
        }
        return (String)this.getColumnInType(columnIndex, Type.SQL_VARCHAR);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, Type.SQL_BOOLEAN);
        return o == null ? false : (Boolean)o;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, Type.TINYINT);
        return o == null ? (byte)0 : ((Number)o).byteValue();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, Type.SQL_SMALLINT);
        return o == null ? (short)0 : ((Number)o).shortValue();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, Type.SQL_INTEGER);
        return o == null ? 0 : ((Number)o).intValue();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, Type.SQL_BIGINT);
        return o == null ? 0L : ((Number)o).longValue();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, Type.SQL_DOUBLE);
        return o == null ? 0.0f : ((Number)o).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Object o = this.getColumnInType(columnIndex, Type.SQL_DOUBLE);
        return o == null ? 0.0 : ((Number)o).doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        if (scale < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        BigDecimal bd = this.getBigDecimal(columnIndex);
        if (bd != null) {
            bd = bd.setScale(scale, 1);
        }
        return bd;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkColumn(columnIndex);
        Type sourceType = this.resultMetaData.columnTypes[columnIndex - 1];
        if (sourceType.typeCode == 30) {
            BlobDataID x = (BlobDataID)this.getColumnInType(columnIndex, sourceType);
            if (x == null) {
                return null;
            }
            long length = x.length(this.session);
            if (length > Integer.MAX_VALUE) {
                JDBCUtil.throwError(Error.error(5561));
            }
            return x.getBytes(this.session, 0L, (int)length);
        }
        Object x = this.getColumnInType(columnIndex, Type.SQL_VARBINARY);
        if (x == null) {
            return null;
        }
        return ((BinaryData)x).getBytes();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        Object t = this.getColumnInType(columnIndex, Type.SQL_DATE);
        if (t == null) {
            return null;
        }
        return (Date)Type.SQL_DATE.convertSQLToJava(this.session, t);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        Object t = this.getColumnInType(columnIndex, Type.SQL_TIME);
        if (t == null) {
            return null;
        }
        return (Time)Type.SQL_TIME.convertSQLToJava(this.session, t);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Object t = this.getColumnInType(columnIndex, Type.SQL_TIMESTAMP);
        if (t == null) {
            return null;
        }
        return (Timestamp)Type.SQL_TIMESTAMP.convertSQLToJava(this.session, t);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(s.getBytes("US-ASCII"));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        return new StringInputStream(s);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkColumn(columnIndex);
        Type sourceType = this.resultMetaData.columnTypes[columnIndex - 1];
        Object o = this.getColumnInType(columnIndex, sourceType);
        if (o == null) {
            return null;
        }
        if (o instanceof BlobDataID) {
            return ((BlobDataID)o).getBinaryStream(this.session);
        }
        if (o instanceof Blob) {
            return ((Blob)o).getBinaryStream();
        }
        if (o instanceof BinaryData) {
            byte[] b = this.getBytes(columnIndex);
            return new ByteArrayInputStream(b);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.rootWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return "";
        }
        return this.result.getMainString();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.resultSetMetaData == null) {
            this.resultSetMetaData = new JDBCResultSetMetaData(this.resultMetaData, this.isUpdatable, this.isInsertable, this.connection);
        }
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkColumn(columnIndex);
        Type sourceType = this.resultMetaData.columnTypes[columnIndex - 1];
        switch (sourceType.typeCode) {
            case 50: {
                return this.getArray(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 94: {
                return this.getTimeWithZone(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
            case 95: {
                return this.getTimestampWithZone(columnIndex);
            }
            case 60: 
            case 61: {
                return this.getBytes(columnIndex);
            }
            case -11: {
                BinaryData bd = (BinaryData)this.getColumnValue(columnIndex);
                return BinaryUUIDType.getJavaUUID(bd);
            }
            case 14: {
                BinaryData bd = (BinaryData)this.getColumnValue(columnIndex);
                if (this.wasNull()) {
                    return null;
                }
                boolean b = BitMap.isSet(bd.getBytes(), 0);
                return b ? Boolean.TRUE : Boolean.FALSE;
            }
            case 40: {
                return this.getClob(columnIndex);
            }
            case 30: {
                return this.getBlob(columnIndex);
            }
            case 1111: 
            case 2000: {
                Object o = this.getColumnInType(columnIndex, sourceType);
                if (o == null) {
                    return null;
                }
                try {
                    return ((JavaObjectData)o).getObject();
                }
                catch (LdbSqlException e) {
                    throw JDBCUtil.sqlException(e);
                }
            }
        }
        return this.getColumnInType(columnIndex, sourceType);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        int columnIndex;
        this.checkClosed();
        if (columnLabel == null) {
            throw JDBCUtil.nullArgument();
        }
        if (this.columnMap != null && (columnIndex = this.columnMap.get((Object)columnLabel, -1)) != -1) {
            return columnIndex;
        }
        String[] colLabels = this.resultMetaData.columnLabels;
        columnIndex = -1;
        for (int i = 0; i < this.columnCount; ++i) {
            if (!columnLabel.equalsIgnoreCase(colLabels[i])) continue;
            columnIndex = i;
            break;
        }
        ColumnBase[] columns = this.resultMetaData.columns;
        if (columnIndex < 0) {
            for (int i = 0; i < this.columnCount; ++i) {
                if (!columnLabel.equalsIgnoreCase(columns[i].getNameString())) continue;
                columnIndex = i;
                break;
            }
        }
        if (columnIndex < 0) {
            int position = columnLabel.indexOf(46);
            if (position < 0) {
                throw JDBCUtil.sqlException(421, columnLabel);
            }
            for (int i = 0; i < this.columnCount; ++i) {
                String match;
                String tabName = columns[i].getTableNameString();
                if (tabName == null || tabName.length() == 0) continue;
                String colName = columns[i].getNameString();
                if (columnLabel.equalsIgnoreCase(tabName + '.' + colName)) {
                    columnIndex = i;
                    break;
                }
                String schemName = columns[i].getSchemaNameString();
                if (schemName == null || schemName.length() == 0 || !columnLabel.equalsIgnoreCase(match = new StringBuffer(schemName).append('.').append(tabName).append('.').append(colName).toString())) continue;
                columnIndex = i;
                break;
            }
        }
        if (columnIndex < 0) {
            throw JDBCUtil.sqlException(421, columnLabel);
        }
        ++columnIndex;
        if (this.columnMap == null) {
            this.columnMap = new IntValueHashMap();
        }
        this.columnMap.put(columnLabel, columnIndex);
        return columnIndex;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkColumn(columnIndex);
        Type sourceType = this.resultMetaData.columnTypes[columnIndex - 1];
        Object o = this.getColumnInType(columnIndex, sourceType);
        if (o == null) {
            return null;
        }
        if (o instanceof ClobDataID) {
            return ((ClobDataID)o).getCharacterStream(this.session);
        }
        if (o instanceof Clob) {
            return ((Clob)o).getCharacterStream();
        }
        if (o instanceof String) {
            return new StringReader((String)o);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkColumn(columnIndex);
        Type targetType = this.resultMetaData.columnTypes[columnIndex - 1];
        switch (targetType.typeCode) {
            case 2: 
            case 3: {
                break;
            }
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                targetType = Type.SQL_DECIMAL;
                break;
            }
            default: {
                targetType = Type.SQL_DECIMAL_DEFAULT;
            }
        }
        return (BigDecimal)this.getColumnInType(columnIndex, targetType);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        this.navigator.beforeFirst();
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        this.navigator.afterLast();
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        return this.navigator.first();
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        return this.navigator.last();
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed();
        if (this.navigator.isAfterLast()) {
            return 0;
        }
        return this.navigator.getRowNumber() + 1;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        if (row > 0) {
            --row;
        } else if (row == 0) {
            return this.navigator.beforeFirst();
        }
        return this.navigator.absolute(row);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        return this.navigator.relative(rows);
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        this.rootWarning = null;
        return this.navigator.previous();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        switch (direction) {
            case 1000: {
                break;
            }
            case 1001: {
                this.checkNotForwardOnly();
                break;
            }
            case 1002: {
                this.checkNotForwardOnly();
                break;
            }
            default: {
                throw JDBCUtil.notSupported();
            }
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return ResultProperties.getJDBCScrollability(this.rsProperties);
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return ResultProperties.getJDBCConcurrency(this.rsProperties);
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkClosed();
        return this.isRowUpdated;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, null);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        Boolean value = x ? Boolean.TRUE : Boolean.FALSE;
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, value);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setIntParameter(columnIndex, x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setIntParameter(columnIndex, x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setIntParameter(columnIndex, x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setLongParameter(columnIndex, x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        Double value = new Double(x);
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, value);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        Double value = new Double(x);
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, value);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setObject(columnIndex, x, 0, scaleOrLength);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, x);
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.updateNull(this.findColumn(columnLabel));
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.updateShort(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.updateInt(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.updateLong(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.updateString(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.updateObject(this.findColumn(columnLabel), x, scaleOrLength);
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnLabel), x);
    }

    @Override
    public void insertRow() throws SQLException {
        this.performInsert();
    }

    @Override
    public void updateRow() throws SQLException {
        this.performUpdate();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.performDelete();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.clearUpdates();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.clearUpdates();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.startInsert();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.endInsert();
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return (Statement)((Object)this.statement);
    }

    public Object getObject(int columnIndex, Map map) throws SQLException {
        return this.getObject(columnIndex);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkColumn(columnIndex);
        Type sourceType = this.resultMetaData.columnTypes[columnIndex - 1];
        Object o = this.getColumnInType(columnIndex, sourceType);
        if (o == null) {
            return null;
        }
        if (o instanceof BlobDataID) {
            JDBCBlobClient blob = new JDBCBlobClient(this.session, (BlobDataID)o);
            if (this.isUpdatable && this.resultMetaData.colIndexes[columnIndex - 1] > 0 && this.resultMetaData.columns[columnIndex - 1].isWriteable()) {
                blob.setWritable(this, columnIndex - 1);
            }
            return blob;
        }
        if (o instanceof Blob) {
            return (Blob)o;
        }
        if (o instanceof BinaryData) {
            byte[] b = this.getBytes(columnIndex);
            return new JDBCBlob(b);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.checkColumn(columnIndex);
        Type sourceType = this.resultMetaData.columnTypes[columnIndex - 1];
        Object o = this.getColumnInType(columnIndex, sourceType);
        if (o == null) {
            return null;
        }
        if (o instanceof ClobDataID) {
            JDBCClobClient clob = new JDBCClobClient(this.session, (ClobDataID)o);
            if (this.isUpdatable && this.resultMetaData.colIndexes[columnIndex - 1] > 0 && this.resultMetaData.columns[columnIndex - 1].isWriteable()) {
                clob.setWritable(this, columnIndex - 1);
            }
            return clob;
        }
        if (o instanceof Clob) {
            return (Clob)o;
        }
        if (o instanceof String) {
            return new JDBCClob((String)o);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        this.checkColumn(columnIndex);
        Type type = this.resultMetaData.columnTypes[columnIndex - 1];
        Object[] data = (Object[])this.getCurrent()[columnIndex - 1];
        if (!type.isArrayType()) {
            throw JDBCUtil.sqlException(5561);
        }
        if (this.trackNull(data)) {
            return null;
        }
        return new JDBCArray(data, type.collectionBaseType(), type, this.connection);
    }

    public Object getObject(String columnLabel, Map map) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), map);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return this.getRef(this.findColumn(columnLabel));
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        TimestampData t = (TimestampData)this.getColumnInType(columnIndex, Type.SQL_DATE);
        if (t == null) {
            return null;
        }
        long millis = t.getSeconds() * 1000L;
        if (cal != null) {
            millis = HsqlDateTime.convertMillisToCalendar(cal, millis);
        }
        return new Date(millis);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        TimeData t = (TimeData)this.getColumnInType(columnIndex, Type.SQL_TIME);
        if (t == null) {
            return null;
        }
        long millis = (long)DateTimeType.normaliseTime(t.getSeconds()) * 1000L;
        if (!this.resultMetaData.columnTypes[--columnIndex].isDateTimeTypeWithZone()) {
            Calendar calendar = cal == null ? this.session.getCalendar() : cal;
            millis = HsqlDateTime.convertMillisToCalendar(calendar, millis);
            millis = HsqlDateTime.getNormalisedTime(millis);
        }
        return new Time(millis);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        TimestampData t = (TimestampData)this.getColumnInType(columnIndex, Type.SQL_TIMESTAMP);
        if (t == null) {
            return null;
        }
        long millis = t.getSeconds() * 1000L;
        if (!this.resultMetaData.columnTypes[--columnIndex].isDateTimeTypeWithZone()) {
            Calendar calendar;
            Calendar calendar2 = calendar = cal == null ? this.session.getCalendar() : cal;
            if (cal != null) {
                millis = HsqlDateTime.convertMillisToCalendar(calendar, millis);
            }
        }
        Timestamp ts = new Timestamp(millis);
        ts.setNanos(t.getNanos());
        return ts;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setBlobParameter(columnIndex, x);
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.updateBlob(columnIndex, x);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setClobParameter(columnIndex, x);
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.updateClob(columnIndex, x);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setParameter(columnIndex, x);
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.updateArray(columnIndex, x);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return ResultProperties.getJDBCHoldability(this.rsProperties);
    }

    public boolean isStreamQuery() throws SQLException {
        this.checkClosed();
        return ResultProperties.isStreamQuery(this.rsProperties);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.navigator == null;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.updateString(columnIndex, nString);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.updateString(columnLabel, nString);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.updateClob(columnIndex, (Clob)nClob);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.updateClob(columnLabel, (Clob)nClob);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        return s == null ? null : new JDBCNClob(s);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        SQLXML sqlxml;
        this.checkColumn(columnIndex);
        int type = this.resultMetaData.columnTypes[columnIndex - 1].typeCode;
        switch (type) {
            case 137: {
                Object object = this.getObject(columnIndex);
                if (object == null) {
                    sqlxml = null;
                    break;
                }
                if (object instanceof SQLXML) {
                    sqlxml = (SQLXML)object;
                    break;
                }
                throw JDBCUtil.notSupported();
            }
            case 40: {
                Clob clob = this.getClob(columnIndex);
                if (clob == null) {
                    sqlxml = null;
                    break;
                }
                sqlxml = new JDBCSQLXML(clob.getCharacterStream());
                break;
            }
            case 1: 
            case 12: {
                Reader reader = this.getCharacterStream(columnIndex);
                if (reader == null) {
                    sqlxml = null;
                    break;
                }
                sqlxml = new JDBCSQLXML(reader);
                break;
            }
            case -9: 
            case -8: {
                Reader nreader = this.getNCharacterStream(columnIndex);
                if (nreader == null) {
                    sqlxml = null;
                    break;
                }
                sqlxml = new JDBCSQLXML(nreader);
                break;
            }
            case 30: {
                Blob blob = this.getBlob(columnIndex);
                if (blob == null) {
                    sqlxml = null;
                    break;
                }
                sqlxml = new JDBCSQLXML(blob.getBinaryStream());
                break;
            }
            case 60: 
            case 61: {
                InputStream inputStream = this.getBinaryStream(columnIndex);
                if (inputStream == null) {
                    sqlxml = null;
                    break;
                }
                sqlxml = new JDBCSQLXML(inputStream);
                break;
            }
            case 1111: 
            case 2000: {
                Object data = this.getObject(columnIndex);
                if (data == null) {
                    sqlxml = null;
                    break;
                }
                if (data instanceof SQLXML) {
                    sqlxml = (SQLXML)data;
                    break;
                }
                if (data instanceof String) {
                    sqlxml = new JDBCSQLXML((String)data);
                    break;
                }
                if (data instanceof byte[]) {
                    sqlxml = new JDBCSQLXML((byte[])data);
                    break;
                }
                if (data instanceof Blob) {
                    Blob blob = (Blob)data;
                    sqlxml = new JDBCSQLXML(blob.getBinaryStream());
                    break;
                }
                if (data instanceof Clob) {
                    Clob clob = (Clob)data;
                    sqlxml = new JDBCSQLXML(clob.getCharacterStream());
                    break;
                }
                throw JDBCUtil.notSupported();
            }
            default: {
                throw JDBCUtil.notSupported();
            }
        }
        return sqlxml;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.findColumn(columnLabel));
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setSQLXML(columnIndex, xmlObject);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.updateSQLXML(this.findColumn(columnLabel), xmlObject);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setCharacterStream(columnIndex, reader, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setBlob(columnIndex, inputStream, length);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setBlob(columnIndex, inputStream, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setClob(columnIndex, reader, length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setClob(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setClob(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setClob(columnIndex, reader, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setCharacterStream(columnIndex, reader);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setCharacterStream(columnIndex, reader);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setAsciiStream(columnIndex, x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setBinaryStream(columnIndex, x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setCharacterStream(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setAsciiStream(columnIndex, x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setBinaryStream(columnIndex, x);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setCharacterStream(columnIndex, reader);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setBlob(columnIndex, inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setBlob(columnIndex, inputStream);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setClob(columnIndex, reader);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        int columnIndex = this.findColumn(columnLabel);
        this.startUpdate(columnIndex);
        this.preparedStatement.setClob(columnIndex, reader);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        if (type == null) {
            throw JDBCUtil.nullArgument();
        }
        Type hsqlType = Types.getParameterSQLType(type);
        if (hsqlType == null) {
            throw JDBCUtil.sqlException(Error.error(5561));
        }
        Object source = this.getColumnValue(columnIndex);
        if (this.wasNullValue) {
            return null;
        }
        Object o = null;
        switch (type.getName()) {
            case "int": 
            case "java.lang.Integer": {
                o = this.getInt(columnIndex);
                break;
            }
            case "double": 
            case "java.lang.Double": {
                o = this.getDouble(columnIndex);
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                o = this.getBoolean(columnIndex);
                break;
            }
            case "byte": 
            case "java.lang.Byte": {
                o = this.getByte(columnIndex);
                break;
            }
            case "short": 
            case "java.lang.Short": {
                o = this.getShort(columnIndex);
                break;
            }
            case "long": 
            case "java.lang.Long": {
                o = this.getLong(columnIndex);
                break;
            }
            case "[B": {
                o = this.getBytes(columnIndex);
                break;
            }
            case "java.lang.Object": {
                o = this.getObject(columnIndex);
                break;
            }
            case "java.math.BigDecimal": {
                o = this.getBigDecimal(columnIndex);
                break;
            }
            case "java.sql.Blob": {
                o = this.getBlob(columnIndex);
                break;
            }
            case "java.sql.Clob": {
                o = this.getClob(columnIndex);
                break;
            }
            case "java.lang.String": 
            case "java.lang.CharSequence": {
                o = this.getString(columnIndex);
                break;
            }
            case "java.sql.Date": {
                o = this.getDate(columnIndex);
                break;
            }
            case "java.sql.Time": {
                o = this.getTime(columnIndex);
                break;
            }
            case "java.sql.Timestamp": {
                o = this.getTimestamp(columnIndex);
                break;
            }
            case "java.util.UUID": {
                source = this.getColumnInType(columnIndex, hsqlType);
                o = Type.SQL_GUID.convertSQLToJava(this.session, source);
                break;
            }
            case "java.time.LocalDate": {
                source = this.getColumnInType(columnIndex, hsqlType);
                TimestampData v = (TimestampData)source;
                long millis = v.getMillis();
                Calendar cal = this.session.getCalendarGMT();
                cal.setTimeInMillis(millis);
                o = LocalDate.of(cal.get(1), cal.get(2) + 1, cal.get(5));
                break;
            }
            case "java.time.LocalTime": {
                source = this.getColumnInType(columnIndex, hsqlType);
                TimeData v = (TimeData)source;
                o = LocalTime.ofNanoOfDay((long)v.getSeconds() * 1000000000L + (long)v.getNanos());
                break;
            }
            case "java.time.LocalDateTime": {
                source = this.getColumnInType(columnIndex, hsqlType);
                TimestampData v = (TimestampData)source;
                o = LocalDateTime.ofEpochSecond(v.getSeconds(), v.getNanos(), ZoneOffset.UTC);
                break;
            }
            case "java.time.OffsetTime": {
                o = this.getTimeWithZone(columnIndex);
                break;
            }
            case "java.time.OffsetDateTime": {
                o = this.getTimestampWithZone(columnIndex);
                break;
            }
            case "java.time.Duration": {
                Type sourceType = this.resultMetaData.columnTypes[columnIndex - 1];
                if (!sourceType.isIntervalDaySecondType()) break;
                source = this.getColumnValue(columnIndex);
                IntervalSecondData v = (IntervalSecondData)source;
                o = Duration.ofSeconds(v.getSeconds(), v.getNanos());
                break;
            }
            case "java.time.Period": {
                Type sourceType = this.resultMetaData.columnTypes[columnIndex - 1];
                if (!sourceType.isIntervalYearMonthType()) break;
                source = this.getColumnValue(columnIndex);
                IntervalMonthData v = (IntervalMonthData)source;
                int months = v.getMonths();
                if (sourceType.typeCode == 102) {
                    o = Period.ofMonths(months);
                    break;
                }
                o = Period.of(months / 12, months % 12, 0);
                break;
            }
            case "java.sql.Array": {
                o = this.getArray(columnIndex);
            }
        }
        if (o == null) {
            throw JDBCUtil.sqlException(Error.error(5561));
        }
        return (T)o;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.startUpdate(columnIndex);
        this.preparedStatement.setObject(columnIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.updateObject(this.findColumn(columnLabel), x, targetSqlType, scaleOrLength);
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.preparedStatement.setObject(columnIndex, x, targetSqlType);
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        this.updateObject(this.findColumn(columnLabel), x, targetSqlType);
    }

    private Object getTimestampWithZone(int columnIndex) throws SQLException {
        TimestampData v = (TimestampData)this.getColumnInType(columnIndex, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
        if (v == null) {
            return null;
        }
        ZoneOffset z = ZoneOffset.ofTotalSeconds(v.getZone());
        LocalDateTime ldt = LocalDateTime.ofEpochSecond(v.getSeconds(), v.getNanos(), z);
        return OffsetDateTime.of(ldt, z);
    }

    private Object getTimeWithZone(int columnIndex) throws SQLException {
        TimeData v = (TimeData)this.getColumnInType(columnIndex, Type.SQL_TIME_WITH_TIME_ZONE);
        if (v == null) {
            return null;
        }
        ZoneOffset z = ZoneOffset.ofTotalSeconds(v.getZone());
        LocalTime lt = LocalTime.ofNanoOfDay((long)(v.getSeconds() + v.getZone()) * 1000000000L + (long)v.getNanos());
        return OffsetTime.of(lt, z);
    }

    protected Object[] getCurrent() throws SQLException {
        RowSetNavigator lnavigator = this.navigator;
        if (lnavigator == null) {
            throw JDBCUtil.sqlException(3601);
        }
        if (lnavigator.isEmpty()) {
            throw JDBCUtil.sqlException(3603, 70);
        }
        if (lnavigator.isBeforeFirst()) {
            throw JDBCUtil.sqlException(3603, 71);
        }
        if (lnavigator.isAfterLast()) {
            throw JDBCUtil.sqlException(3603, 72);
        }
        Object[] data = lnavigator.getCurrent();
        if (data == null) {
            throw JDBCUtil.sqlException(3601);
        }
        return data;
    }

    private void checkClosed() throws SQLException {
        if (this.navigator == null) {
            throw JDBCUtil.sqlException(3601);
        }
    }

    protected void checkColumn(int columnIndex) throws SQLException {
        if (this.navigator == null) {
            throw JDBCUtil.sqlException(3601);
        }
        if (columnIndex < 1 || columnIndex > this.columnCount) {
            throw JDBCUtil.sqlException(421, String.valueOf(columnIndex));
        }
    }

    protected boolean trackNull(Object o) {
        this.wasNullValue = o == null;
        return this.wasNullValue;
    }

    protected Object getColumnValue(int columnIndex) throws SQLException {
        Object[] rowData = this.getCurrent();
        this.checkColumn(columnIndex);
        Object value = rowData[columnIndex - 1];
        this.trackNull(value);
        return value;
    }

    protected Object getColumnInType(int columnIndex, Type targetType) throws SQLException {
        Object value = this.getColumnValue(columnIndex);
        if (value == null) {
            return null;
        }
        Type sourceType = this.resultMetaData.columnTypes[columnIndex - 1];
        if (this.translateTTIType && targetType.isIntervalType()) {
            targetType = ((IntervalType)targetType).getCharacterType();
        }
        if (sourceType.typeCode != targetType.typeCode) {
            try {
                value = targetType.convertToTypeJDBC(this.session, value, sourceType);
            }
            catch (Exception e) {
                String stringValue = value instanceof Number || value instanceof String ? value.toString() : "instance of " + value.getClass().getName();
                String msg = "from SQL type " + sourceType.getNameString() + " to " + targetType.getJDBCClassName() + ", value: " + stringValue;
                JDBCUtil.throwError(Error.error(5561, msg));
            }
        }
        if (sourceType.typeCode == targetType.typeCode && targetType.typeCode == 17 && ((StructureType)targetType).colTypes.length == ((StructureType)sourceType).colTypes.length) {
            try {
                if (value instanceof Object[]) {
                    value = this.convertUDTType((Object[])value, sourceType, targetType);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    private Object convertUDTType(Object[] value, Type sourceType, Type targetType) throws SQLException {
        Object[] valTemp = (Object[])value.clone();
        for (int i = 0; i < valTemp.length; ++i) {
            Type targetTypeTemp = ((StructureType)targetType).colTypes[i];
            Type sourceTypeTemp = ((StructureType)sourceType).colTypes[i];
            if (targetTypeTemp.typeCode != sourceTypeTemp.typeCode) {
                try {
                    valTemp[i] = targetTypeTemp.convertToTypeJDBC(this.session, valTemp[i], sourceTypeTemp);
                }
                catch (Exception e) {
                    String stringValue = valTemp[i] instanceof Number || valTemp[i] instanceof String ? valTemp[i].toString() : "instance of " + valTemp[i].getClass().getName();
                    String msg = "from SQL type " + sourceType.getNameString() + " to " + targetType.getJDBCClassName() + ", value: " + stringValue;
                    JDBCUtil.throwError(Error.error(5561, msg));
                }
                continue;
            }
            if (targetTypeTemp.getJDBCTypeCode() == sourceTypeTemp.getJDBCTypeCode() && !(sourceTypeTemp instanceof StructureType)) {
                valTemp[i] = this.getUDTType(targetTypeTemp.getJDBCTypeCode(), targetTypeTemp, valTemp[i]);
                continue;
            }
            if (!(sourceTypeTemp instanceof StructureType) || !(valTemp[i] instanceof Object[])) continue;
            valTemp[i] = this.convertUDTType((Object[])valTemp[i], sourceTypeTemp, targetTypeTemp);
        }
        return valTemp;
    }

    public Object getUDTType(int typeCode, Type type, Object value) throws SQLException {
        switch (typeCode) {
            case 93: {
                if (value == null) {
                    return null;
                }
                return Type.SQL_TIMESTAMP.convertSQLToJava(this.session, value);
            }
            case 91: {
                if (value == null) {
                    return null;
                }
                return Type.SQL_DATE.convertSQLToJava(this.session, value);
            }
            case -6: {
                return value == null ? (byte)0 : ((Number)value).byteValue();
            }
            case 5: {
                return value == null ? (short)0 : ((Number)value).shortValue();
            }
            case 92: {
                if (value == null) {
                    return null;
                }
                return Type.SQL_TIME.convertSQLToJava(this.session, value);
            }
            case 50: 
            case 2003: {
                Object[] tempValue = (Object[])((Object[])value).clone();
                if (type.collectionBaseType().getJDBCTypeCode() == -6 || type.collectionBaseType().getJDBCTypeCode() == 5) {
                    for (int i = 0; i < tempValue.length; ++i) {
                        tempValue[i] = this.getUDTType(type.collectionBaseType().getJDBCTypeCode(), type.collectionBaseType(), tempValue[i]);
                    }
                }
                return new JDBCArray(tempValue, type.collectionBaseType(), type, this.connection);
            }
        }
        return value;
    }

    private void checkNotForwardOnly() throws SQLException {
        if (!this.isScrollable) {
            throw JDBCUtil.notSupported();
        }
    }

    private void checkUpdatable() throws SQLException {
        this.checkClosed();
        if (!this.isUpdatable) {
            throw JDBCUtil.notUpdatableColumn();
        }
    }

    private void checkUpdatable(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkColumn(columnIndex);
        if (!this.isUpdatable) {
            throw JDBCUtil.notUpdatableColumn();
        }
        if (this.resultMetaData.colIndexes[--columnIndex] == -1) {
            throw JDBCUtil.notUpdatableColumn();
        }
        if (!this.resultMetaData.columns[columnIndex].isWriteable()) {
            throw JDBCUtil.notUpdatableColumn();
        }
    }

    void startUpdate(int columnIndex) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (this.currentUpdateRowNumber != this.navigator.getRowNumber()) {
            this.preparedStatement.clearParameters();
        }
        this.currentUpdateRowNumber = this.navigator.getRowNumber();
        this.isRowUpdated = true;
    }

    private void clearUpdates() throws SQLException {
        this.checkUpdatable();
        this.preparedStatement.clearParameters();
        this.isRowUpdated = false;
    }

    private void startInsert() throws SQLException {
        this.checkUpdatable();
        this.isOnInsertRow = true;
    }

    private void endInsert() throws SQLException {
        this.checkUpdatable();
        this.preparedStatement.clearParameters();
        this.isOnInsertRow = false;
    }

    private void performUpdate() throws SQLException {
        this.preparedStatement.parameterValues[this.columnCount] = this.getCurrent()[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            boolean set = this.preparedStatement.parameterSet[i] != null;
            this.preparedStatement.resultOut.metaData.columnTypes[i] = set ? this.preparedStatement.parameterTypes[i] : Type.SQL_ALL_TYPES;
        }
        this.preparedStatement.resultOut.setActionType(91);
        this.preparedStatement.fetchResult();
        this.preparedStatement.clearParameters();
        this.rootWarning = this.preparedStatement.getWarnings();
        this.preparedStatement.clearWarnings();
        this.isRowUpdated = false;
    }

    private void performInsert() throws SQLException {
        this.checkUpdatable();
        for (int i = 0; i < this.columnCount; ++i) {
            boolean set;
            boolean bl = set = this.preparedStatement.parameterSet[i] != null;
            if (!set) {
                throw JDBCUtil.sqlException(3606);
            }
            this.preparedStatement.resultOut.metaData.columnTypes[i] = this.preparedStatement.parameterTypes[i];
        }
        this.preparedStatement.resultOut.setActionType(55);
        this.preparedStatement.fetchResult();
        this.preparedStatement.clearParameters();
        this.rootWarning = this.preparedStatement.getWarnings();
        this.preparedStatement.clearWarnings();
    }

    private void performDelete() throws SQLException {
        this.checkUpdatable();
        this.preparedStatement.parameterValues[this.columnCount] = this.getCurrent()[this.columnCount];
        this.preparedStatement.resultOut.metaData.columnTypes[this.columnCount] = this.resultMetaData.columnTypes[this.columnCount];
        this.preparedStatement.resultOut.setActionType(18);
        this.preparedStatement.fetchResult();
        this.preparedStatement.clearParameters();
        this.rootWarning = this.preparedStatement.getWarnings();
        this.preparedStatement.clearWarnings();
    }

    RowSetNavigator getNavigator() {
        return this.navigator;
    }

    void setNavigator(RowSetNavigator navigator) {
        this.navigator = navigator;
    }

    static class JDBCResultSetBasic
    extends JDBCResultSet {
        JDBCResultSetBasic(Result r, ResultMetaData metaData) {
            super(null, r, metaData);
        }

        @Override
        protected Object getColumnInType(int columnIndex, Type targetType) throws SQLException {
            Object[] rowData = this.getCurrent();
            this.checkColumn(columnIndex);
            Type sourceType = this.resultMetaData.columnTypes[--columnIndex];
            Object value = rowData[columnIndex];
            if (this.trackNull(value)) {
                return null;
            }
            if (sourceType.typeCode != targetType.typeCode) {
                JDBCUtil.throwError(Error.error(5561));
            }
            return value;
        }

        @Override
        public Date getDate(int columnIndex) throws SQLException {
            return (Date)this.getColumnInType(columnIndex, Type.SQL_DATE);
        }

        @Override
        public Time getTime(int columnIndex) throws SQLException {
            return (Time)this.getColumnInType(columnIndex, Type.SQL_DATE);
        }

        @Override
        public Timestamp getTimestamp(int columnIndex) throws SQLException {
            return (Timestamp)this.getColumnInType(columnIndex, Type.SQL_DATE);
        }

        @Override
        public InputStream getBinaryStream(int columnIndex) throws SQLException {
            throw JDBCUtil.notSupported();
        }

        @Override
        public Reader getCharacterStream(int columnIndex) throws SQLException {
            throw JDBCUtil.notSupported();
        }

        @Override
        public Blob getBlob(int columnIndex) throws SQLException {
            this.checkColumn(columnIndex);
            Type sourceType = this.resultMetaData.columnTypes[columnIndex - 1];
            Object o = this.getColumnInType(columnIndex, sourceType);
            if (o == null) {
                return null;
            }
            if (o instanceof Blob) {
                return (Blob)o;
            }
            if (o instanceof byte[]) {
                return new JDBCBlob((byte[])o);
            }
            throw JDBCUtil.sqlException(5561);
        }

        @Override
        public Clob getClob(int columnIndex) throws SQLException {
            this.checkColumn(columnIndex);
            Type sourceType = this.resultMetaData.columnTypes[columnIndex - 1];
            Object o = this.getColumnInType(columnIndex, sourceType);
            if (o == null) {
                return null;
            }
            if (o instanceof Clob) {
                return (Clob)o;
            }
            if (o instanceof String) {
                return new JDBCClob((String)o);
            }
            throw JDBCUtil.sqlException(5561);
        }

        @Override
        public Time getTime(int columnIndex, Calendar cal) throws SQLException {
            throw JDBCUtil.notSupported();
        }

        @Override
        public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
            throw JDBCUtil.notSupported();
        }
    }
}

