MODULE SUEFFT_MOD
CONTAINS
SUBROUTINE SUEFFT

USE PARKIND1  ,ONLY : JPIM     ,JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK, JPHOOK

USE TPM_DIM         ,ONLY : R
USE TPM_GEN         ,ONLY : NOUT, NPRINTLEV
USE TPM_DISTR       ,ONLY : D, MYSETW
USE TPM_GEOMETRY    ,ONLY : G
USE TPM_FFT         ,ONLY : T, TB
#ifdef WITH_FFTW
USE TPM_FFTW        ,ONLY : TW, INIT_PLANS_FFTW
#endif
USE BLUESTEIN_MOD   ,ONLY : BLUESTEIN_INIT, FFTB_TYPE
!

USE TPMALD_FFT      ,ONLY : TALD
!

IMPLICIT NONE

INTEGER(KIND=JPIM) :: JGL,IGLG, ILATS
LOGICAL :: LLP1,LLP2
REAL(KIND=JPHOOK) :: ZHOOK_HANDLE

!     ------------------------------------------------------------------

IF (LHOOK) CALL DR_HOOK('SUEFFT_MOD:SUEFFT',0,ZHOOK_HANDLE)

IF(.NOT.D%LGRIDONLY) THEN
        
  LLP1 = NPRINTLEV>0
  LLP2 = NPRINTLEV>1
  IF(LLP1) WRITE(NOUT,*) '=== ENTER ROUTINE SUEFFT ==='

#ifdef WITH_FFTW
  IF(TW%LFFTW)THEN

    CALL INIT_PLANS_FFTW(MAX(R%NDLON+R%NNOEXTZL,R%NDGL+R%NNOEXTZG))

  ELSE

    NULLIFY(TW%FFTW_PLANS)
#endif

    ALLOCATE(T%TRIGS(R%NDLON+R%NNOEXTZL,D%NDGL_FS))
    IF(LLP2)WRITE(NOUT,9) 'T%TRIGS    ',SIZE(T%TRIGS),SHAPE(T%TRIGS)
    ALLOCATE(T%NFAX(19,D%NDGL_FS))
    IF(LLP2)WRITE(NOUT,9) 'T%NFAX     ',SIZE(T%NFAX),SHAPE(T%NFAX)
    ALLOCATE(T%LUSEFFT992(D%NDGL_FS))
    IF(LLP2)WRITE(NOUT,9) 'T%LUSEFFT992',SIZE(T%LUSEFFT992),SHAPE(T%LUSEFFT992)

    !
    ! create TRIGS and NFAX for latitude lengths supported by FFT992,
    ! that is just with factors 2, 3 or 5
    !

    T%LBLUESTEIN=.FALSE.
    ILATS=0
    DO JGL=1,D%NDGL_FS
      IGLG = D%NPTRLS(MYSETW)+JGL-1
      IF (G%NLOEN(IGLG)>1) THEN
        CALL SET99B(T%TRIGS(1,JGL),T%NFAX(1,JGL),G%NLOEN(IGLG)+R%NNOEXTZL,T%LUSEFFT992(JGL))
        IF( .NOT.T%LUSEFFT992(JGL) )THEN
          ILATS=ILATS+1
          T%LBLUESTEIN=.TRUE.
        ENDIF
      ENDIF
    ENDDO
    
    !
    ! we only initialise for bluestein if there are latitude lengths 
    ! not supported by FFT992
    !

    IF( T%LBLUESTEIN )THEN
      TB%NDLON=R%NDLON
      TB%NLAT_COUNT=ILATS
      ILATS=0
      ALLOCATE(TB%NLATS(TB%NLAT_COUNT))
      DO JGL=1,D%NDGL_FS
        IF( .NOT.T%LUSEFFT992(JGL) )THEN
          ILATS=ILATS+1
          TB%NLATS(ILATS)=R%NDLON+R%NNOEXTZL
        ENDIF
      ENDDO
      CALL BLUESTEIN_INIT(TB)
    ENDIF
  
#ifdef WITH_FFTW

  ENDIF
#endif

  IF(TALD%LFFT992)THEN
    ALLOCATE(TALD%TRIGSE(R%NDGL+R%NNOEXTZG))
    IF(LLP2)WRITE(NOUT,9) 'TALD%TRIGSE    ',SIZE(TALD%TRIGSE),SHAPE(TALD%TRIGSE)
    ALLOCATE(TALD%NFAXE(19))
    IF(LLP2)WRITE(NOUT,9) 'TALD%NFAXE    ',SIZE(TALD%NFAXE),SHAPE(TALD%NFAXE)
    CALL SET99(TALD%TRIGSE,TALD%NFAXE,R%NDGL+R%NNOEXTZG)
  ENDIF

ENDIF

IF (LHOOK) CALL DR_HOOK('SUEFFT_MOD:SUEFFT',1,ZHOOK_HANDLE)

!     ------------------------------------------------------------------

9 FORMAT(1X,'ARRAY ',A10,' ALLOCATED ',8I8)

END SUBROUTINE SUEFFT
END MODULE SUEFFT_MOD
