# This file was automatically generated on 12/13/2019, 16:57:03.

import rdflib
from rdflib import URIRef, Literal
from dbrepo.core.omlib.dimension import Dimension
from dbrepo.core.omlib.scale import Scale
from dbrepo.core.omlib.unit import Prefix, Unit


class OM:

    NAMESPACE = 'http://www.ontology-of-units-of-measure.org/resource/om-2/'
    
    jansky = Unit.get_singular_unit([Literal('jansky', lang='nl'), Literal('jansky', lang='en')], Literal('Jy'), Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/jansky', system_of_units=None, is_base_unit=False)
    _05 = Unit.get_singular_unit([Literal('0-5', lang='nl'), Literal('0-5', lang='en')], None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/_0-5', system_of_units=None, is_base_unit=False)
    CanadianDollar = Unit.get_singular_unit([Literal('Canadian dollar', lang='en'), Literal('加元', lang='zh')], None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/CanadianDollar', system_of_units=None, is_base_unit=False)
    candela = Unit.get_singular_unit([Literal('坎德拉', lang='zh'), Literal('candela', lang='nl'), Literal('candela', lang='en')], Literal('cd'), Dimension(0, 0, 0, 0, 0, 0, 1), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/candela', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=True)
    one = Unit.get_singular_unit(Literal('one', lang='en'), Literal('1'), Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/one', system_of_units=None, is_base_unit=False)
    IndianRupee = Unit.get_singular_unit([Literal('Indian rupee', lang='en'), Literal('印度卢比', lang='zh')], None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/IndianRupee', system_of_units=None, is_base_unit=False)
    kelvin = Unit.get_singular_unit([Literal('开', lang='zh'), Literal('kelvin', lang='nl'), Literal('kelvin', lang='en')], Literal('K'), Dimension(0, 0, 0, 0, 1, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kelvin', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=True)
    bit = Unit.get_singular_unit([Literal('指二进制中的一位', lang='zh'), Literal('bit', lang='en'), Literal('bit', lang='nl')], Literal('bit'), Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/bit', system_of_units=None, is_base_unit=False)
    AFS = Unit.get_singular_unit(Literal('AFS', lang='en'), None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/AFS', system_of_units=None, is_base_unit=False)
    _10 = Unit.get_singular_unit([Literal('1/0', lang='nl'), Literal('1/0', lang='en')], None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/_1-0', system_of_units=None, is_base_unit=False)
    AustralianDollar = Unit.get_singular_unit([Literal('澳元', lang='zh'), Literal('Australian dollar', lang='en')], None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/AustralianDollar', system_of_units=None, is_base_unit=False)
    month = Unit.get_singular_unit([Literal('月', lang='zh'), Literal('month', lang='en'), Literal('maand', lang='nl')], None, Dimension(1, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/month', system_of_units=None, is_base_unit=False)
    MexicanPeso = Unit.get_singular_unit([Literal('墨西哥比索', lang='zh'), Literal('Mexican peso', lang='en')], None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/MexicanPeso', system_of_units=None, is_base_unit=False)
    secondTime = Unit.get_singular_unit([Literal('seconde', lang='nl'), Literal('second', lang='en'), Literal('秒', lang='zh')], Literal('s'), Dimension(1, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/second-Time', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectromagneticSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-Second-BiotSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/GaussianSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/metre-Kilogram-Second-AmpereSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectrostaticSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-Second-FranklinSystemOfUnits')], is_base_unit=True)
    _110 = Unit.get_singular_unit([Literal('1-10', lang='en'), Literal('1-10', lang='nl')], None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/_1-10', system_of_units=None, is_base_unit=False)
    ChineseYuan = Unit.get_singular_unit([Literal('Chinese yuan', lang='en'), Literal('中国元', lang='zh')], None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/ChineseYuan', system_of_units=None, is_base_unit=False)
    NewZealandDollar = Unit.get_singular_unit([Literal('New Zealand dollar', lang='en'), Literal('新西兰美元', lang='zh')], None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/NewZealandDollar', system_of_units=None, is_base_unit=False)
    poundSterling = Unit.get_singular_unit([Literal('英镑', lang='zh'), Literal('pound sterling', lang='en')], None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/poundSterling', system_of_units=None, is_base_unit=False)
    shake = Unit.get_singular_unit(Literal('shake', lang='en'), None, base_unit=secondTime, factor=1e-08, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/shake', system_of_units=None, is_base_unit=False)
    gram = Unit.get_singular_unit([Literal('克', lang='zh'), Literal('gram', lang='en'), Literal('gram', lang='nl')], Literal('g'), Dimension(0, 0, 1, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gram', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectrostaticSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-Second-BiotSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/GaussianSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectromagneticSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-Second-FranklinSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondSystemOfUnits')], is_base_unit=True)
    amylaseUnit = Unit.get_singular_unit(Literal('amylase unit', lang='en'), Literal('AU'), Dimension(-1, 0, 0, 0, 0, 1, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/amylaseUnit', system_of_units=None, is_base_unit=False)
    TurkishLira = Unit.get_singular_unit([Literal('Turkish lira', lang='en'), Literal('土耳其里拉', lang='zh')], None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/TurkishLira', system_of_units=None, is_base_unit=False)
    SingaporeDollar = Unit.get_singular_unit([Literal('Singapore dollar', lang='en'), Literal('新加坡元', lang='zh')], None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/SingaporeDollar', system_of_units=None, is_base_unit=False)
    euro = Unit.get_singular_unit([Literal('欧元', lang='zh'), Literal('euro', lang='en')], None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/euro', system_of_units=None, is_base_unit=False)
    deltaA450 = Unit.get_singular_unit(Literal('delta A450', lang='en'), None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/deltaA450', system_of_units=None, is_base_unit=False)
    unifiedAtomicMassUnit = Unit.get_singular_unit(Literal('unified atomic mass unit', lang='en'), Literal('u'), Dimension(0, 0, 1, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/unifiedAtomicMassUnit', system_of_units=None, is_base_unit=False)
    UnitedStatesDollar = Unit.get_singular_unit([Literal('United States dollar', lang='en'), Literal('美国美元', lang='zh')], None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/UnitedStatesDollar', system_of_units=None, is_base_unit=False)
    degreeFahrenheit = Unit.get_singular_unit([Literal('graad Fahrenheit', lang='nl'), Literal('degree Fahrenheit', lang='en')], Literal('°F'), base_unit=kelvin, factor=0.5555556, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/degreeFahrenheit', system_of_units=None, is_base_unit=False)
    SouthAfricanRand = Unit.get_singular_unit([Literal('南非兰特', lang='zh'), Literal('South African rand', lang='en')], None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/SouthAfricanRand', system_of_units=None, is_base_unit=False)
    hartley = Unit.get_singular_unit([Literal('hartley', lang='nl'), Literal('hartley', lang='en')], Literal('Hart'), base_unit=bit, factor=3.321928095, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hartley', system_of_units=None, is_base_unit=False)
    day = Unit.get_singular_unit([Literal('dag', lang='nl'), Literal('day', lang='en'), Literal('天', lang='zh')], Literal('d'), base_unit=secondTime, factor=86400.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/day', system_of_units=None, is_base_unit=False)
    milligramRAE = Unit.get_singular_unit(Literal('milligram RAE', lang='en'), None, Dimension(0, 0, 1, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/milligramRAE', system_of_units=None, is_base_unit=False)
    week = Unit.get_singular_unit([Literal('week', lang='nl'), Literal('week', lang='en')], None, base_unit=secondTime, factor=604800.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/week', system_of_units=None, is_base_unit=False)
    _15 = Unit.get_singular_unit([Literal('1-5', lang='en'), Literal('1-5', lang='nl')], None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/_1-5', system_of_units=None, is_base_unit=False)
    NorwegianKrone = Unit.get_singular_unit([Literal('Norwegian krone', lang='en'), Literal('挪威克朗', lang='zh')], None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/NorwegianKrone', system_of_units=None, is_base_unit=False)
    colonyFormingUnit = Unit.get_singular_unit(Literal('colony forming unit', lang='en'), Literal('CFU'), Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/colonyFormingUnit', system_of_units=None, is_base_unit=False)
    percent = Unit.get_singular_unit([Literal('百分', lang='zh'), Literal('percent', lang='en'), Literal('procent', lang='nl')], Literal('%'), base_unit=one, factor=0.01, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/percent', system_of_units=None, is_base_unit=False)
    yearTropical = Unit.get_singular_unit(Literal('year (tropical)', lang='en'), None, base_unit=secondTime, factor=31556930.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/year-Tropical', system_of_units=None, is_base_unit=False)
    SouthKoreanWon = Unit.get_singular_unit([Literal('韩元', lang='zh'), Literal('South Korean won', lang='en')], None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/SouthKoreanWon', system_of_units=None, is_base_unit=False)
    partsPerMillion = Unit.get_singular_unit(Literal('parts per million', lang='en'), Literal('ppm'), base_unit=one, factor=1e-06, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/partsPerMillion', system_of_units=None, is_base_unit=False)
    InternationalUnit = Unit.get_singular_unit([Literal('International Unit', lang='en'), Literal('国际单位', lang='zh')], Literal('IU'), Dimension(0, 0, 1, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalUnit', system_of_units=None, is_base_unit=False)
    byte = Unit.get_singular_unit([Literal('byte', lang='nl'), Literal('字节', lang='zh'), Literal('byte', lang='en')], Literal('B'), base_unit=bit, factor=8.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/byte', system_of_units=None, is_base_unit=False)
    shannon = Unit.get_singular_unit([Literal('shannon', lang='nl'), Literal('shannon', lang='en')], Literal('Sh'), base_unit=bit, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/shannon', system_of_units=None, is_base_unit=False)
    degreeCelsius = Unit.get_singular_unit([Literal('graad Celsius', lang='nl'), Literal('degree Celsius', lang='en'), Literal('摄氏度', lang='zh')], Literal('°C'), base_unit=kelvin, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/degreeCelsius', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    degreeRankine = Unit.get_singular_unit([Literal('degree Rankine', lang='en'), Literal('graad Rankine', lang='nl')], Literal('°R'), base_unit=kelvin, factor=0.5555556, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/degreeRankine', system_of_units=None, is_base_unit=False)
    ampere = Unit.get_singular_unit([Literal('ampère', lang='nl'), Literal('ampere', lang='en')], Literal('A'), Dimension(0, 0, 0, 1, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/ampere', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/metre-Kilogram-Second-AmpereSystemOfUnits')], is_base_unit=True)
    SwissFranc = Unit.get_singular_unit([Literal('瑞士法郎', lang='zh'), Literal('Swiss franc', lang='en')], None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/SwissFranc', system_of_units=None, is_base_unit=False)
    SwedishKrona = Unit.get_singular_unit([Literal('Swedish krona', lang='en'), Literal('瑞典克朗', lang='zh')], None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/SwedishKrona', system_of_units=None, is_base_unit=False)
    baud = Unit.get_singular_unit([Literal('baud', lang='en'), Literal('baud', lang='nl')], Literal('Bd'), Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/baud', system_of_units=None, is_base_unit=False)
    minuteTime = Unit.get_singular_unit([Literal('分钟', lang='zh'), Literal('minuut', lang='nl'), Literal('minute', lang='en')], Literal('min'), base_unit=secondTime, factor=60.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/minute-Time', system_of_units=None, is_base_unit=False)
    metre = Unit.get_singular_unit([Literal('metre', lang='en'), Literal('米', lang='zh'), Literal('meter', lang='nl')], Literal('m'), Dimension(0, 1, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metre', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/metre-Kilogram-Second-AmpereSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')], is_base_unit=True)
    metrePerDay = Unit.get_unit_division(metre, day, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerDay', system_of_units=None)
    degreeCelsiusPerSecondTime = Unit.get_unit_division(degreeCelsius, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/degreeCelsiusPerSecond-Time', system_of_units=None)
    colonyFormingUnitPerGram = Unit.get_unit_division(colonyFormingUnit, gram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/colonyFormingUnitPerGram', system_of_units=None)
    degreeCelsiusPerMinuteTime = Unit.get_unit_division(degreeCelsius, minuteTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/degreeCelsiusPerMinute-Time', system_of_units=None)
    deltaA450PerSecondTime = Unit.get_unit_division(deltaA450, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/deltaA450PerSecond-Time', system_of_units=None)
    gramPerMetre = Unit.get_unit_division(gram, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerMetre', system_of_units=None)
    secondTimePerDay = Unit.get_unit_division(secondTime, day, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/second-TimePerDay', system_of_units=None)
    metrePerMetre = Unit.get_unit_division(metre, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerMetre', system_of_units=None)
    bitPerSecondTime = Unit.get_unit_division(bit, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/bitPerSecond-Time', system_of_units=None)
    metrePerSecondTime = Unit.get_unit_division(metre, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerSecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    gramPerGram = Unit.get_unit_division(gram, gram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerGram', system_of_units=None)
    reciprocalMetre = Unit.get_unit_exponentiation(metre, -1, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/reciprocalMetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    secondTimeSquared = Unit.get_unit_exponentiation(secondTime, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/second-TimeSquared', system_of_units=None)
    reciprocalKelvin = Unit.get_unit_exponentiation(kelvin, -1, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/reciprocalKelvin', system_of_units=None)
    reciprocalPartsPerMillionPerYear = Unit.get_unit_exponentiation(partsPerMillion, -1, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/reciprocalPartsPerMillionPerYear', system_of_units=None)
    cubicMetre = Unit.get_unit_exponentiation(metre, 3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicMetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    reciprocalSecondTime = Unit.get_unit_exponentiation(secondTime, -1, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/reciprocalSecond-Time', system_of_units=None)
    reciprocalSquareMetre = Unit.get_unit_exponentiation(metre, -2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/reciprocalSquareMetre', system_of_units=None)
    reciprocalGram = Unit.get_unit_exponentiation(gram, -1, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/reciprocalGram', system_of_units=None)
    reciprocalCubicMetre = Unit.get_unit_exponentiation(metre, -3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/reciprocalCubicMetre', system_of_units=None)
    reciprocalMinuteTime = Unit.get_unit_exponentiation(minuteTime, -1, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/reciprocalMinute-Time', system_of_units=None)
    reciprocalSquareMetreReciprocalMetre = Unit.get_unit_multiplication(reciprocalSquareMetre, reciprocalMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/reciprocalSquareMetreReciprocalMetre', system_of_units=None)
    secondTimeAmpere = Unit.get_unit_multiplication(secondTime, ampere, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/second-TimeAmpere', system_of_units=None)
    cubicMetreKelvin = Unit.get_unit_multiplication(cubicMetre, kelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicMetreKelvin', system_of_units=None)
    metreKelvin = Unit.get_unit_multiplication(metre, kelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metreKelvin', system_of_units=None)
    reciprocalSquareMetreReciprocalGram = Unit.get_unit_multiplication(reciprocalSquareMetre, reciprocalGram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/reciprocalSquareMetreReciprocalGram', system_of_units=None)
    degreeCelsiusDay = Unit.get_unit_multiplication(degreeCelsius, day, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/degreeCelsiusDay', system_of_units=None)
    femtokelvin = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=kelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtokelvin', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decicandela = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=candela, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decicandela', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    exametre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exametre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctosecondTime = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctosecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    hectosecondTime = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectosecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    micrometre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/micrometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    mebibit = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mebi', base_unit=bit, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/mebibit', system_of_units=None, is_base_unit=False)
    picoampere = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=ampere, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picoampere', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    hectokelvin = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=kelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectokelvin', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottagram = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=gram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottagram', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petagram = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=gram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petagram', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zebibit = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zebi', base_unit=bit, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zebibit', system_of_units=None, is_base_unit=False)
    centikelvin = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=kelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centikelvin', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottametre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottametre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    picokelvin = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=kelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picokelvin', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctodegreeCelsius = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=degreeCelsius, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctodegreeCelsius', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctometre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    exabit = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=bit, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exabit', system_of_units=None, is_base_unit=False)
    exagram = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=gram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exagram', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottakelvin = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=kelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottakelvin', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decametre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decametre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kilobit = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=bit, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilobit', system_of_units=None, is_base_unit=False)
    teracandela = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=candela, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/teracandela', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    tebibit = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tebi', base_unit=bit, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/tebibit', system_of_units=None, is_base_unit=False)
    nanokelvin = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=kelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanokelvin', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottacandela = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=candela, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottacandela', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettabit = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=bit, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettabit', system_of_units=None, is_base_unit=False)
    petacandela = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=candela, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petacandela', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    pebibit = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pebi', base_unit=bit, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/pebibit', system_of_units=None, is_base_unit=False)
    zeptometre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centimetre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectrostaticSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-Second-FranklinSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-Second-BiotSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/GaussianSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectromagneticSystemOfUnits')], is_base_unit=True)
    megaeuro = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=euro, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megaeuro', system_of_units=None, is_base_unit=False)
    centidegreeCelsius = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=degreeCelsius, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centidegreeCelsius', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decakelvin = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=kelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decakelvin', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gigakelvin = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=kelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigakelvin', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtocandela = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=candela, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtocandela', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gigacandela = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=candela, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigacandela', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettaampere = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=ampere, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettaampere', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kilobyte = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=byte, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilobyte', system_of_units=None, is_base_unit=False)
    microsecondTime = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microsecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanosecondTime = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanosecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    hectoampere = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=ampere, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectoampere', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctogram = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=gram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctogram', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kiloampere = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=ampere, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kiloampere', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    millimetre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millimetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gigabyte = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=byte, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigabyte', system_of_units=None, is_base_unit=False)
    millikelvin = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=kelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millikelvin', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decagram = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=gram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decagram', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    pebibyte = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pebi', base_unit=byte, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/pebibyte', system_of_units=None, is_base_unit=False)
    exacandela = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=candela, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exacandela', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottaampere = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=ampere, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottaampere', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettakelvin = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=kelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettakelvin', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decacandela = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=candela, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decacandela', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptoampere = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=ampere, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptoampere', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yobibyte = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yobi', base_unit=byte, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yobibyte', system_of_units=None, is_base_unit=False)
    terabit = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=bit, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/terabit', system_of_units=None, is_base_unit=False)
    kilogram = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=gram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilogram', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/metre-Kilogram-Second-AmpereSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')], is_base_unit=True)
    yoctoampere = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=ampere, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctoampere', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petametre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petametre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettagram = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=gram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettagram', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanogram = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=gram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanogram', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    tebibyte = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tebi', base_unit=byte, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/tebibyte', system_of_units=None, is_base_unit=False)
    teraampere = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=ampere, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/teraampere', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    picosecondTime = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picosecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kilokelvin = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=kelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilokelvin', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctocandela = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=candela, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctocandela', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    picodegreeCelsius = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=degreeCelsius, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picodegreeCelsius', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptosecondTime = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptosecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanoampere = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=ampere, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanoampere', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    picocandela = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=candela, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picocandela', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtogram = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=gram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtogram', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decisecondTime = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decisecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attokelvin = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=kelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attokelvin', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kilocandela = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=candela, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilocandela', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    millicandela = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=candela, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millicandela', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    terabyte = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=byte, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/terabyte', system_of_units=None, is_base_unit=False)
    attometre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    hectometre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    picometre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptodegreeCelsius = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=degreeCelsius, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptodegreeCelsius', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centisecondTime = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centisecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    millisecondTime = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millisecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    terametre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/terametre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    exbibit = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exbi', base_unit=bit, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exbibit', system_of_units=None, is_base_unit=False)
    picogram = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=gram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picogram', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottabit = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=bit, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottabit', system_of_units=None, is_base_unit=False)
    exaampere = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=ampere, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exaampere', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    milligram = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=gram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/milligram', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centigram = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=gram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centigram', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottasecondTime = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottasecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    milliampere = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=ampere, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/milliampere', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gibibyte = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/gibi', base_unit=byte, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gibibyte', system_of_units=None, is_base_unit=False)
    hectogram = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=gram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectogram', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kilometre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petakelvin = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=kelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petakelvin', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attoampere = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=ampere, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attoampere', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petabit = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=bit, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petabit', system_of_units=None, is_base_unit=False)
    yobibit = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yobi', base_unit=bit, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yobibit', system_of_units=None, is_base_unit=False)
    exasecondTime = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exasecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptocandela = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=candela, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptocandela', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petasecondTime = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petasecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decikelvin = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=kelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decikelvin', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kilosecondTime = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilosecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megakelvin = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=kelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megakelvin', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megametre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megametre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megacandela = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=candela, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megacandela', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctokelvin = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=kelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctokelvin', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megaampere = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=ampere, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megaampere', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petabyte = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=byte, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petabyte', system_of_units=None, is_base_unit=False)
    zettametre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettametre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petaampere = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=ampere, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petaampere', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    microkelvin = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=kelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microkelvin', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettabyte = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=byte, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettabyte', system_of_units=None, is_base_unit=False)
    terasecondTime = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/terasecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gigabit = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=bit, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigabit', system_of_units=None, is_base_unit=False)
    decigram = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=gram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decigram', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megagram = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=gram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megagram', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettasecondTime = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettasecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centicandela = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=candela, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centicandela', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtoampere = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=ampere, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtoampere', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtometre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megabit = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=bit, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megabit', system_of_units=None, is_base_unit=False)
    gigagram = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=gram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigagram', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gigaampere = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=ampere, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigaampere', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gigametre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigametre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    microgram = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=gram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microgram', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attodegreeCelsius = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=degreeCelsius, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attodegreeCelsius', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    terakelvin = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=kelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/terakelvin', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    _100Kilometre = Unit.get_unit_multiple(kilometre, factor=100.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/_100Kilometre', label=[Literal('100 kilometre', lang='en'), Literal('100 kilometer', lang='nl')], symbol=Literal('100 km'), system_of_units=None)
    _1000ColonyFormingUnit = Unit.get_unit_multiple(colonyFormingUnit, factor=1000.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/_1000ColonyFormingUnit', label=Literal('1000 colony forming unit', lang='en'), symbol=Literal('1000 CFU'), system_of_units=None)
    yearSidereal = Unit.get_singular_unit(Literal('year (sidereal)', lang='en'), None, base_unit=secondTime, factor=31558150.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/year-Sidereal', system_of_units=None, is_base_unit=False)
    rodUS = Unit.get_singular_unit(Literal('rod (US)', lang='en'), Literal('rd'), base_unit=metre, factor=5.02921, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/rod-US', system_of_units=None, is_base_unit=False)
    tonne = Unit.get_singular_unit([Literal('公吨', lang='zh'), Literal('ton', lang='nl'), Literal('tonne', lang='en')], Literal('t'), base_unit=kilogram, factor=1000.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/tonne', system_of_units=None, is_base_unit=False)
    liquidQuartUS = Unit.get_singular_unit(Literal('liquid quart (US)', lang='en'), Literal('liq qt'), base_unit=cubicMetre, factor=0.0009463529, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/liquidQuart-US', system_of_units=None, is_base_unit=False)
    astronomicalUnit = Unit.get_singular_unit(Literal('astronomical unit', lang='en'), Literal('AU'), base_unit=metre, factor=149597870700.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/astronomicalUnit', system_of_units=None, is_base_unit=False)
    mileStatute = Unit.get_singular_unit(Literal('mile (statute)', lang='en'), Literal('mi'), base_unit=metre, factor=1609.344, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/mile-Statute', system_of_units=None, is_base_unit=False)
    poundAvoirdupois = Unit.get_singular_unit(Literal('pound (avoirdupois)', lang='en'), Literal('lb'), base_unit=kilogram, factor=0.45359237, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/poundAvoirdupois', system_of_units=None, is_base_unit=False)
    caratMass = Unit.get_singular_unit([Literal('karaat (massa)', lang='nl'), Literal('carat (mass)', lang='en')], None, base_unit=kilogram, factor=0.0002, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/carat-Mass', system_of_units=None, is_base_unit=False)
    mole = Unit.get_singular_unit([Literal('mol', lang='nl'), Literal('mole', lang='en')], Literal('mol'), Dimension(0, 0, 0, 0, 0, 1, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/mole', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=True)
    tonShort = Unit.get_singular_unit(Literal('ton (short)', lang='en'), None, base_unit=kilogram, factor=907.1847, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/ton-Short', system_of_units=None, is_base_unit=False)
    tablespoonUS = Unit.get_singular_unit(Literal('tablespoon (US)', lang='en'), None, base_unit=cubicMetre, factor=1.478676e-05, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/tablespoon-US', system_of_units=None, is_base_unit=False)
    radian = Unit.get_singular_unit([Literal('radian', lang='en'), Literal('弧度', lang='zh'), Literal('radiaal', lang='nl')], Literal('rad'), base_unit=metrePerMetre, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/radian', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    RussianRuble = Unit.get_singular_unit([Literal('RussianRuble', lang='en'), Literal('俄罗斯卢布', lang='zh')], None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/RussianRuble', system_of_units=None, is_base_unit=False)
    pointATA = Unit.get_singular_unit(Literal('point (ATA)', lang='en'), Literal('pt'), base_unit=metre, factor=0.0003514598, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/point-ATA', system_of_units=None, is_base_unit=False)
    milLength = Unit.get_singular_unit(Literal('mil (length)', lang='en'), None, base_unit=metre, factor=2.54e-05, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/mil-Length', system_of_units=None, is_base_unit=False)
    picaATA = Unit.get_singular_unit(Literal('pica (ATA)', lang='en'), None, base_unit=pointATA, factor=12.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/pica-ATA', system_of_units=None, is_base_unit=False)
    daySidereal = Unit.get_singular_unit(Literal('day (sidereal)', lang='en'), None, base_unit=secondTime, factor=86164.09, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/day-Sidereal', system_of_units=None, is_base_unit=False)
    dryQuartUS = Unit.get_singular_unit(Literal('dry quart (US)', lang='en'), Literal('dry qt'), base_unit=cubicMetre, factor=0.001101221, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/dryQuart-US', system_of_units=None, is_base_unit=False)
    JapaneseYen = Unit.get_singular_unit([Literal('日元', lang='zh'), Literal('Japanese yen', lang='en')], None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/JapaneseYen', system_of_units=None, is_base_unit=False)
    minuteSidereal = Unit.get_singular_unit(Literal('minute (sidereal)', lang='en'), None, base_unit=secondTime, factor=59.83617, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/minute-Sidereal', system_of_units=None, is_base_unit=False)
    secondAngle = Unit.get_singular_unit([Literal('seconde (hoek)', lang='nl'), Literal('second (angle)', lang='en'), Literal('秒（角度）', lang='zh')], Literal('\"'), base_unit=radian, factor=4.848137e-06, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/second-Angle', system_of_units=None, is_base_unit=False)
    secondSidereal = Unit.get_singular_unit(Literal('second (sidereal)', lang='en'), None, base_unit=secondTime, factor=0.9972696, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/second-Sidereal', system_of_units=None, is_base_unit=False)
    peckUS = Unit.get_singular_unit(Literal('peck (US)', lang='en'), Literal('pk'), base_unit=cubicMetre, factor=0.008809768, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/peck-US', system_of_units=None, is_base_unit=False)
    angstrom = Unit.get_singular_unit([Literal('ångström', lang='en'), Literal('ångström', lang='nl')], Literal('Å'), base_unit=metre, factor=1e-10, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/angstrom', system_of_units=None, is_base_unit=False)
    fathomUSSurvey = Unit.get_singular_unit(Literal('fathom (US survey)', lang='en'), None, base_unit=metre, factor=1.828804, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/fathom-USSurvey', system_of_units=None, is_base_unit=False)
    fluidOunceUS = Unit.get_singular_unit(Literal('fluid ounce (US)', lang='en'), Literal('fl oz'), base_unit=cubicMetre, factor=2.957353e-05, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/fluidOunce-US', system_of_units=None, is_base_unit=False)
    hundredweightUS = Unit.get_singular_unit(Literal('hundredweight (US)', lang='en'), None, base_unit=kilogram, factor=45.35924, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hundredweight-US', system_of_units=None, is_base_unit=False)
    gilbert = Unit.get_singular_unit([Literal('gilbert', lang='nl'), Literal('gilbert', lang='en')], Literal('Gb'), base_unit=ampere, factor=0.7957747, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gilbert', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/GaussianSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectromagneticSystemOfUnits')], is_base_unit=False)
    footUSSurvey = Unit.get_singular_unit(Literal('foot (US survey)', lang='en'), Literal('ft'), base_unit=metre, factor=0.3048006, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/foot-USSurvey', system_of_units=None, is_base_unit=False)
    acreFoot = Unit.get_singular_unit(Literal('acre foot', lang='en'), None, base_unit=cubicMetre, factor=1233.489, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/acreFoot', system_of_units=None, is_base_unit=False)
    pointDidot = Unit.get_singular_unit(Literal('point (Didot)', lang='en'), Literal('pt'), base_unit=metre, factor=0.0003759, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/point-Didot', system_of_units=None, is_base_unit=False)
    footInternational = Unit.get_singular_unit([Literal('英尺（国际）', lang='zh'), Literal('foot (international)', lang='en')], Literal('ft'), base_unit=metre, factor=0.3048, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/foot-International', system_of_units=None, is_base_unit=False)
    stere = Unit.get_singular_unit(Literal('stere', lang='en'), None, base_unit=cubicMetre, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/stere', system_of_units=None, is_base_unit=False)
    ounceApothecaries = Unit.get_singular_unit(Literal('ounce (apothecaries\')', lang='en'), Literal('oz (ap.)'), base_unit=kilogram, factor=0.03110348, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/ounceApothecaries', system_of_units=None, is_base_unit=False)
    tonShortAssay = Unit.get_singular_unit(Literal('ton (short assay)', lang='en'), None, base_unit=kilogram, factor=0.02916667, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/ton-ShortAssay', system_of_units=None, is_base_unit=False)
    ounceAvoirdupois = Unit.get_singular_unit(Literal('ounce (avoirdupois)', lang='en'), Literal('oz'), base_unit=kilogram, factor=0.02834952, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/ounceAvoirdupois', system_of_units=None, is_base_unit=False)
    yardInternational = Unit.get_singular_unit([Literal('yard (international)', lang='en'), Literal('码（国际）', lang='zh')], Literal('yd'), base_unit=metre, factor=0.9144, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yard-International', system_of_units=None, is_base_unit=False)
    fermi = Unit.get_singular_unit([Literal('fermi', lang='nl'), Literal('fermi', lang='en')], None, base_unit=metre, factor=1e-15, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/fermi', system_of_units=None, is_base_unit=False)
    becquerel = Unit.get_singular_unit([Literal('becquerel', lang='en'), Literal('becquerel', lang='nl')], Literal('Bq'), base_unit=reciprocalSecondTime, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/becquerel', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    revolution = Unit.get_singular_unit(Literal('revolution', lang='en'), Literal('r'), base_unit=radian, factor=6.283185, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/revolution', system_of_units=None, is_base_unit=False)
    grain = Unit.get_singular_unit(Literal('grain', lang='en'), Literal('gr'), base_unit=kilogram, factor=6.479891e-05, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/grain', system_of_units=None, is_base_unit=False)
    tonLong = Unit.get_singular_unit(Literal('ton (long)', lang='en'), None, base_unit=kilogram, factor=1016.047, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/ton-Long', system_of_units=None, is_base_unit=False)
    curie = Unit.get_singular_unit([Literal('curie', lang='en'), Literal('curie', lang='nl')], Literal('Ci'), base_unit=becquerel, factor=37000000000.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/curie', system_of_units=None, is_base_unit=False)
    dryPintUS = Unit.get_singular_unit(Literal('dry pint (US)', lang='en'), Literal('dry pt'), base_unit=cubicMetre, factor=0.0005506105, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/dryPint-US', system_of_units=None, is_base_unit=False)
    biot = Unit.get_singular_unit([Literal('biot', lang='en'), Literal('biot', lang='nl')], Literal('Bi'), base_unit=ampere, factor=10.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/biot', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-Second-BiotSystemOfUnits', is_base_unit=True)
    hour = Unit.get_singular_unit([Literal('小时', lang='zh'), Literal('uur', lang='nl'), Literal('hour', lang='en')], Literal('h'), base_unit=secondTime, factor=3600.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hour', system_of_units=None, is_base_unit=False)
    furlongInternational = Unit.get_singular_unit(Literal('furlong (international)', lang='en'), None, base_unit=metre, factor=201.168, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/furlong-International', system_of_units=None, is_base_unit=False)
    tonRegister = Unit.get_singular_unit(Literal('ton (register)', lang='en'), None, base_unit=cubicMetre, factor=2.831658, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/ton-Register', system_of_units=None, is_base_unit=False)
    hertz = Unit.get_singular_unit([Literal('赫兹', lang='zh'), Literal('hertz', lang='nl'), Literal('hertz', lang='en')], Literal('Hz'), base_unit=reciprocalSecondTime, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hertz', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/metre-Kilogram-Second-AmpereSystemOfUnits')], is_base_unit=False)
    kayser = Unit.get_singular_unit([Literal('kayser', lang='en'), Literal('kayser', lang='nl')], None, base_unit=reciprocalMetre, factor=100.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kayser', system_of_units=None, is_base_unit=False)
    cicero = Unit.get_singular_unit([Literal('cicero', lang='en'), Literal('cicero', lang='nl')], None, base_unit=pointDidot, factor=12.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cicero', system_of_units=None, is_base_unit=False)
    hourSidereal = Unit.get_singular_unit(Literal('hour (sidereal)', lang='en'), None, base_unit=secondTime, factor=3590.17, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hour-Sidereal', system_of_units=None, is_base_unit=False)
    BrazilianReal = Unit.get_singular_unit([Literal('巴西里拉', lang='zh'), Literal('Brazilian real', lang='en')], None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/BrazilianReal', system_of_units=None, is_base_unit=False)
    cord = Unit.get_singular_unit(Literal('cord', lang='en'), None, base_unit=cubicMetre, factor=3.624556, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cord', system_of_units=None, is_base_unit=False)
    nauticalMileInternational = Unit.get_singular_unit([Literal('海里（国际）', lang='zh'), Literal('zeemijl (internationaal)', lang='nl'), Literal('nautical mile (international)', lang='en')], Literal('nmi'), base_unit=metre, factor=1852.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nauticalMile-International', system_of_units=None, is_base_unit=False)
    pennyweightTroy = Unit.get_singular_unit(Literal('pennyweight (Troy)', lang='en'), Literal('dwt'), base_unit=kilogram, factor=0.001555174, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/pennyweight-Troy', system_of_units=None, is_base_unit=False)
    solarRadius = Unit.get_singular_unit(Literal('solar radius', lang='en'), Literal('R_☉'), base_unit=metre, factor=695500000.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/solarRadius', system_of_units=None, is_base_unit=False)
    lightYear = Unit.get_singular_unit([Literal('light year', lang='en'), Literal('lichtjaar', lang='nl')], Literal('ly'), base_unit=metre, factor=9460730000000000.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/lightYear', system_of_units=None, is_base_unit=False)
    cupUSCustomary = Unit.get_singular_unit(Literal('cup (US customary)', lang='en'), None, base_unit=cubicMetre, factor=0.0002365882, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cup-USCustomary', system_of_units=None, is_base_unit=False)
    coulomb = Unit.get_singular_unit([Literal('coulomb', lang='nl'), Literal('coulomb', lang='en')], Literal('C'), base_unit=secondTimeAmpere, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/coulomb', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/metre-Kilogram-Second-AmpereSystemOfUnits')], is_base_unit=False)
    kilometrePerHour = Unit.get_unit_division(kilometre, hour, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilometrePerHour', system_of_units=None)
    molePerSecondTime = Unit.get_unit_division(mole, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerSecond-Time', system_of_units=None)
    coulombPerCubicmetre = Unit.get_unit_division(coulomb, cubicMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/coulombPerCubicmetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    milligramPerKilometre = Unit.get_unit_division(milligram, kilometre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/milligramPerKilometre', system_of_units=None)
    radianPerSecondTimeSquared = Unit.get_unit_division(radian, secondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/radianPerSecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    molePerCubicmetre = Unit.get_unit_division(mole, cubicMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerCubicmetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    cubicMetrePerMole = Unit.get_unit_division(cubicMetre, mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicMetrePerMole', system_of_units=None)
    metrePerSecondTimeSquared = Unit.get_unit_division(metre, secondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerSecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    molePerMetre = Unit.get_unit_division(mole, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerMetre', system_of_units=None)
    cubicMetrePerKilogram = Unit.get_unit_division(cubicMetre, kilogram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicMetrePerKilogram', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    molePerMole = Unit.get_unit_division(mole, mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerMole', system_of_units=None)
    metrePerCubicMetre = Unit.get_unit_division(metre, cubicMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerCubicMetre', system_of_units=None)
    gramPerCubicmetre = Unit.get_unit_division(gram, cubicMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerCubicmetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    nauticalMileInternationalPerHour = Unit.get_unit_division(nauticalMileInternational, hour, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nauticalMile-InternationalPerHour', system_of_units=None)
    kilogramPerMole = Unit.get_unit_division(kilogram, mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilogramPerMole', system_of_units=None)
    mileStatutePerHour = Unit.get_unit_division(mileStatute, hour, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/mile-StatutePerHour', system_of_units=None)
    molePerKilogram = Unit.get_unit_division(mole, kilogram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerKilogram', system_of_units=None)
    deltaA450PerSecondTimePerMilligram = Unit.get_unit_division(deltaA450PerSecondTime, milligram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/deltaA450PerSecond-TimePerMilligram', system_of_units=None)
    metrePerSecondTimePerMetre = Unit.get_unit_division(metrePerSecondTime, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerSecond-TimePerMetre', system_of_units=None)
    cubicMetrePerSecondTime = Unit.get_unit_division(cubicMetre, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicMetrePerSecond-Time', system_of_units=None)
    cubicMetrePerCubicmetre = Unit.get_unit_division(cubicMetre, cubicMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicMetrePerCubicmetre', system_of_units=None)
    amperePerMetre = Unit.get_unit_division(ampere, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/amperePerMetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    kilogramPerSecondTime = Unit.get_unit_division(kilogram, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilogramPerSecond-Time', system_of_units=None)
    milligramPerHectogram = Unit.get_unit_division(milligram, hectogram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/milligramPerHectogram', system_of_units=None)
    milligramPerCubicmetre = Unit.get_unit_division(milligram, cubicMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/milligramPerCubicmetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    milligramPerKilogram = Unit.get_unit_division(milligram, kilogram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/milligramPerKilogram', system_of_units=None)
    millimetrePerDay = Unit.get_unit_division(millimetre, day, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millimetrePerDay', system_of_units=None)
    gramPerHectogram = Unit.get_unit_division(gram, hectogram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerHectogram', system_of_units=None)
    centimetrePerDay = Unit.get_unit_division(centimetre, day, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centimetrePerDay', system_of_units=None)
    coulombPerKilogram = Unit.get_unit_division(coulomb, kilogram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/coulombPerKilogram', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerTerasecondTime = Unit.get_unit_division(metre, terasecondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerTerasecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerPetasecondTime = Unit.get_unit_division(metre, petasecondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerPetasecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerZettasecondTime = Unit.get_unit_division(metre, zettasecondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerZettasecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerZeptosecondTime = Unit.get_unit_division(metre, zeptosecondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerZeptosecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerNanosecondTime = Unit.get_unit_division(metre, nanosecondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerNanosecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerYoctosecondTime = Unit.get_unit_division(metre, yoctosecondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerYoctosecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerKilosecondTime = Unit.get_unit_division(metre, kilosecondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerKilosecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerYottasecondTime = Unit.get_unit_division(metre, yottasecondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerYottasecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerCentisecondTime = Unit.get_unit_division(metre, centisecondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerCentisecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    decametrePerSecondTime = Unit.get_unit_division(decametre, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decametrePerSecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    kilometrePerSecondTime = Unit.get_unit_division(kilometre, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilometrePerSecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    zeptometrePerSecondTime = Unit.get_unit_division(zeptometre, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptometrePerSecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    gigametrePerSecondTime = Unit.get_unit_division(gigametre, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigametrePerSecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    exametrePerSecondTime = Unit.get_unit_division(exametre, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exametrePerSecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    centimetrePerSecondTime = Unit.get_unit_division(centimetre, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centimetrePerSecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    zettametrePerSecondTime = Unit.get_unit_division(zettametre, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettametrePerSecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    yoctometrePerSecondTime = Unit.get_unit_division(yoctometre, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctometrePerSecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    petametrePerSecondTime = Unit.get_unit_division(petametre, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petametrePerSecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    picometrePerSecondTimeSquared = Unit.get_unit_division(picometre, secondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picometrePerSecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    yottametrePerSecondTimeSquared = Unit.get_unit_division(yottametre, secondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottametrePerSecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    gigametrePerSecondTimeSquared = Unit.get_unit_division(gigametre, secondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigametrePerSecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    attometrePerSecondTimeSquared = Unit.get_unit_division(attometre, secondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attometrePerSecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    zettametrePerSecondTimeSquared = Unit.get_unit_division(zettametre, secondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettametrePerSecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    terametrePerSecondTimeSquared = Unit.get_unit_division(terametre, secondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/terametrePerSecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    yoctometrePerSecondTimeSquared = Unit.get_unit_division(yoctometre, secondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctometrePerSecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    hectometrePerSecondTimeSquared = Unit.get_unit_division(hectometre, secondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectometrePerSecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    millimetrePerSecondTimeSquared = Unit.get_unit_division(millimetre, secondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millimetrePerSecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    molePerZeptometre = Unit.get_unit_division(mole, zeptometre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerZeptometre', system_of_units=None)
    molePerTerametre = Unit.get_unit_division(mole, terametre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerTerametre', system_of_units=None)
    molePerCentimetre = Unit.get_unit_division(mole, centimetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerCentimetre', system_of_units=None)
    molePerAttometre = Unit.get_unit_division(mole, attometre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerAttometre', system_of_units=None)
    molePerYottametre = Unit.get_unit_division(mole, yottametre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerYottametre', system_of_units=None)
    molePermegametre = Unit.get_unit_division(mole, megametre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePermegametre', system_of_units=None)
    molePerMicrometre = Unit.get_unit_division(mole, micrometre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerMicrometre', system_of_units=None)
    molePerMillimetre = Unit.get_unit_division(mole, millimetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerMillimetre', system_of_units=None)
    molePerKilometre = Unit.get_unit_division(mole, kilometre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerKilometre', system_of_units=None)
    molePerFemtometre = Unit.get_unit_division(mole, femtometre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerFemtometre', system_of_units=None)
    secondTimeToThePower2 = Unit.get_unit_exponentiation(secondTime, -2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/second-TimeToThePower-2', system_of_units=None)
    reciprocalDegreeCelsius = Unit.get_unit_exponentiation(degreeCelsius, -1, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/reciprocalDegreeCelsius', system_of_units=None)
    reciprocalDay = Unit.get_unit_exponentiation(day, -1, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/reciprocalDay', system_of_units=None)
    secondAngleSquared = Unit.get_unit_exponentiation(secondAngle, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/second-AngleSquared', system_of_units=None)
    reciprocalDegreeCelsiusDay = Unit.get_unit_exponentiation(degreeCelsiusDay, -1, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/reciprocalDegreeCelsiusDay', system_of_units=None)
    reciprocalSquareCentimetre = Unit.get_unit_exponentiation(centimetre, -2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/reciprocalSquareCentimetre', system_of_units=None)
    cubicTerametre = Unit.get_unit_exponentiation(terametre, 3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicTerametre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    cubicMicrometre = Unit.get_unit_exponentiation(micrometre, 3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicMicrometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    cubicExametre = Unit.get_unit_exponentiation(exametre, 3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicExametre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    cubicCentimetre = Unit.get_unit_exponentiation(centimetre, 3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicCentimetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    cubicZettametre = Unit.get_unit_exponentiation(zettametre, 3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicZettametre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    cubicKilometre = Unit.get_unit_exponentiation(kilometre, 3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicKilometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    cubicYoctometre = Unit.get_unit_exponentiation(yoctometre, 3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicYoctometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    cubicMegametre = Unit.get_unit_exponentiation(megametre, 3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicMegametre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    cubicZeptometre = Unit.get_unit_exponentiation(zeptometre, 3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicZeptometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    cubicGigametre = Unit.get_unit_exponentiation(gigametre, 3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicGigametre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    squarePicometre = Unit.get_unit_exponentiation(picometre, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squarePicometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    squareMillimetre = Unit.get_unit_exponentiation(millimetre, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareMillimetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    squareGigametre = Unit.get_unit_exponentiation(gigametre, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareGigametre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    squareKilometre = Unit.get_unit_exponentiation(kilometre, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareKilometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    squareMicrometre = Unit.get_unit_exponentiation(micrometre, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareMicrometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    squareAttometre = Unit.get_unit_exponentiation(attometre, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareAttometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    squareFemtometre = Unit.get_unit_exponentiation(femtometre, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareFemtometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    squareCentimetre = Unit.get_unit_exponentiation(centimetre, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareCentimetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    squareExametre = Unit.get_unit_exponentiation(exametre, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareExametre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    squareMegametre = Unit.get_unit_exponentiation(megametre, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareMegametre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    millisecondTimeSquared = Unit.get_unit_exponentiation(millisecondTime, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millisecond-TimeSquared', system_of_units=None)
    zeptosecondTimeSquared = Unit.get_unit_exponentiation(zeptosecondTime, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptosecond-TimeSquared', system_of_units=None)
    kilosecondTimeSquared = Unit.get_unit_exponentiation(kilosecondTime, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilosecond-TimeSquared', system_of_units=None)
    exasecondTimeSquared = Unit.get_unit_exponentiation(exasecondTime, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exasecond-TimeSquared', system_of_units=None)
    yoctosecondTimeSquared = Unit.get_unit_exponentiation(yoctosecondTime, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctosecond-TimeSquared', system_of_units=None)
    decisecondTimeSquared = Unit.get_unit_exponentiation(decisecondTime, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decisecond-TimeSquared', system_of_units=None)
    picosecondTimeSquared = Unit.get_unit_exponentiation(picosecondTime, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picosecond-TimeSquared', system_of_units=None)
    hectosecondTimeSquared = Unit.get_unit_exponentiation(hectosecondTime, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectosecond-TimeSquared', system_of_units=None)
    kilogramSecondTimeToThePower2 = Unit.get_unit_multiplication(kilogram, secondTimeToThePower2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilogramSecond-TimeToThePower-2', system_of_units=None)
    coulombMetre = Unit.get_unit_multiplication(coulomb, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/coulombMetre', system_of_units=None)
    kelvinMole = Unit.get_unit_multiplication(kelvin, mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kelvinMole', system_of_units=None)
    metreKilogram = Unit.get_unit_multiplication(metre, kilogram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metreKilogram', system_of_units=None)
    kelvinKilogram = Unit.get_unit_multiplication(kelvin, kilogram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kelvinKilogram', system_of_units=None)
    gibibit = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/gibi', base_unit=bit, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gibibit', system_of_units=None, is_base_unit=False)
    microradian = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=radian, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microradian', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    millihertz = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=hertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millihertz', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    milliradian = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=radian, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/milliradian', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctobecquerel = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=becquerel, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctobecquerel', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    microampere = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=ampere, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microampere', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettacoulomb = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=coulomb, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettacoulomb', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctoradian = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=radian, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctoradian', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attocandela = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=candela, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attocandela', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtoradian = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=radian, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtoradian', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decacoulomb = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=coulomb, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decacoulomb', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decicoulomb = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=coulomb, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decicoulomb', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attocoulomb = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=coulomb, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attocoulomb', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    deciradian = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=radian, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/deciradian', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centiampere = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=ampere, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centiampere', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    teragram = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=gram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/teragram', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centiradian = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=radian, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centiradian', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptogram = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=gram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptogram', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decaampere = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=ampere, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decaampere', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petamole = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petamole', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decidegreeCelsius = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=degreeCelsius, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decidegreeCelsius', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centihertz = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=hertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centihertz', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptomole = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptomole', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    exbibyte = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exbi', base_unit=byte, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exbibyte', system_of_units=None, is_base_unit=False)
    zettahertz = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=hertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettahertz', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptohertz = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=hertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptohertz', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    deciampere = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=ampere, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/deciampere', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attobecquerel = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=becquerel, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attobecquerel', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    micromole = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/micromole', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    microbecquerel = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=becquerel, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microbecquerel', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    millidegreeCelsius = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=degreeCelsius, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millidegreeCelsius', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtocoulomb = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=coulomb, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtocoulomb', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    picobecquerel = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=becquerel, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picobecquerel', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    terabecquerel = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=becquerel, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/terabecquerel', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kibibyte = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kibi', base_unit=byte, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kibibyte', system_of_units=None, is_base_unit=False)
    millimole = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millimole', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decimetre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decimetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decamole = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decamole', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanohertz = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=hertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanohertz', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attohertz = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=hertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attohertz', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanobecquerel = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=becquerel, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanobecquerel', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptoradian = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=radian, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptoradian', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    exabyte = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=byte, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exabyte', system_of_units=None, is_base_unit=False)
    hectomole = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectomole', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decihertz = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=hertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decihertz', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    microdegreeCelsius = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=degreeCelsius, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microdegreeCelsius', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gigahertz = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=hertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigahertz', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanometre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attomole = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attomole', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtobecquerel = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=becquerel, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtobecquerel', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctocoulomb = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=coulomb, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctocoulomb', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decabecquerel = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=becquerel, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decabecquerel', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centimole = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centimole', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centicoulomb = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=coulomb, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centicoulomb', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    picomole = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picomole', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtodegreeCelsius = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=degreeCelsius, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtodegreeCelsius', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    millibecquerel = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=becquerel, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millibecquerel', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    exahertz = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=hertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exahertz', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    terahertz = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=hertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/terahertz', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptokelvin = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=kelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptokelvin', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptobecquerel = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=becquerel, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptobecquerel', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanounifiedAtomicMassUnit = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=unifiedAtomicMassUnit, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanounifiedAtomicMassUnit', system_of_units=None, is_base_unit=False)
    petacoulomb = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=coulomb, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petacoulomb', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettacandela = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=candela, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettacandela', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    exacoulomb = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=coulomb, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exacoulomb', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petabecquerel = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=becquerel, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petabecquerel', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    millicoulomb = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=coulomb, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millicoulomb', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megahertz = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=hertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megahertz', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    examole = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/examole', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottabecquerel = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=becquerel, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottabecquerel', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kilocoulomb = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=coulomb, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilocoulomb', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanomole = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanomole', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decibecquerel = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=becquerel, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decibecquerel', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptocoulomb = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=coulomb, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptocoulomb', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottabyte = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=byte, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottabyte', system_of_units=None, is_base_unit=False)
    picocoulomb = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=coulomb, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picocoulomb', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottacoulomb = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=coulomb, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottacoulomb', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanodegreeCelsius = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=degreeCelsius, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanodegreeCelsius', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zebibyte = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zebi', base_unit=byte, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zebibyte', system_of_units=None, is_base_unit=False)
    hectohertz = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=hertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectohertz', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    mebibyte = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mebi', base_unit=byte, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/mebibyte', system_of_units=None, is_base_unit=False)
    teramole = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/teramole', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtomole = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtomole', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attosecondTime = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attosecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megatonne = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=tonne, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megatonne', system_of_units=None, is_base_unit=False)
    megabyte = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=byte, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megabyte', system_of_units=None, is_base_unit=False)
    megacoulomb = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=coulomb, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megacoulomb', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    microcoulomb = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=coulomb, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microcoulomb', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petahertz = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=hertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petahertz', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gigacoulomb = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=coulomb, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigacoulomb', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kilohertz = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=hertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilohertz', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attogram = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=gram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attogram', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctomole = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctomole', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettamole = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettamole', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kibibit = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kibi', base_unit=bit, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kibibit', system_of_units=None, is_base_unit=False)
    nanocoulomb = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=coulomb, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanocoulomb', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottamole = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottamole', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attoradian = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=radian, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attoradian', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    exakelvin = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=kelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exakelvin', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gigasecondTime = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigasecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decahertz = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=hertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decahertz', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    chain = Unit.get_singular_unit(Literal('chain', lang='en'), Literal('ch'), base_unit=metre, factor=20.11684, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/chain', system_of_units=None, is_base_unit=False)
    katal = Unit.get_singular_unit([Literal('katal', lang='nl'), Literal('katal', lang='en')], Literal('kat'), base_unit=molePerSecondTime, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/katal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    röntgen = Unit.get_singular_unit([Literal('röntgen', lang='nl'), Literal('röntgen', lang='en')], Literal('R'), base_unit=coulombPerKilogram, factor=0.000258, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/röntgen', system_of_units=None, is_base_unit=False)
    milAngle = Unit.get_singular_unit(Literal('mil (angle)', lang='en'), None, base_unit=radian, factor=0.0009817477, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/mil-Angle', system_of_units=None, is_base_unit=False)
    faraday = Unit.get_singular_unit([Literal('faraday', lang='nl'), Literal('faraday', lang='en')], None, base_unit=coulomb, factor=96485.31, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/faraday', system_of_units=None, is_base_unit=False)
    year = Unit.get_singular_unit([Literal('year', lang='en'), Literal('jaar', lang='nl')], Literal('a'), base_unit=secondTime, factor=31536000.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/year', system_of_units=None, is_base_unit=False)
    gon = Unit.get_singular_unit(Literal('gon', lang='en'), Literal('gon'), base_unit=radian, factor=0.01570796, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gon', system_of_units=None, is_base_unit=False)
    degreeReaumur = Unit.get_singular_unit([Literal('graad Réaumur', lang='nl'), Literal('degree Réaumur', lang='en')], Literal('°Ré'), base_unit=kelvin, factor=1.25, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/degreeReaumur', system_of_units=None, is_base_unit=False)
    gallonImperial = Unit.get_singular_unit(Literal('gallon (imperial)', lang='en'), Literal('gal'), base_unit=cubicMetre, factor=0.00454609, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gallon-Imperial', system_of_units=None, is_base_unit=False)
    fluidOunceImperial = Unit.get_singular_unit(Literal('fluid ounce (imperial)', lang='en'), Literal('fl oz'), base_unit=cubicMetre, factor=2.841306e-05, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/fluidOunce-Imperial', system_of_units=None, is_base_unit=False)
    liquidPintUS = Unit.get_singular_unit(Literal('liquid pint (US)', lang='en'), Literal('liq pt'), base_unit=cubicMetre, factor=0.0004731765, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/liquidPint-US', system_of_units=None, is_base_unit=False)
    gallonUS = Unit.get_singular_unit(Literal('gallon (US)', lang='en'), Literal('gal'), base_unit=cubicMetre, factor=0.003785412, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gallon-US', system_of_units=None, is_base_unit=False)
    statcoulomb = Unit.get_singular_unit([Literal('statcoulomb', lang='nl'), Literal('statcoulomb', lang='en')], Literal('statC'), base_unit=coulomb, factor=3.335641e-10, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/statcoulomb', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/GaussianSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectrostaticSystemOfUnits')], is_base_unit=False)
    barrelUS = Unit.get_singular_unit(Literal('barrel (US)', lang='en'), Literal('bbl'), base_unit=cubicMetre, factor=0.1589873, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/barrel-US', system_of_units=None, is_base_unit=False)
    debye = Unit.get_singular_unit([Literal('debye', lang='en'), Literal('debye', lang='nl')], Literal('D'), base_unit=coulombMetre, factor=3.33564e-30, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/debye', system_of_units=None, is_base_unit=False)
    parsec = Unit.get_singular_unit(Literal('parsec', lang='en'), Literal('pc'), base_unit=metre, factor=3.08567758149137e+16, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/parsec', system_of_units=None, is_base_unit=False)
    hundredweightBritish = Unit.get_singular_unit(Literal('hundredweight (British)', lang='en'), None, base_unit=kilogram, factor=50.80235, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hundredweight-British', system_of_units=None, is_base_unit=False)
    inchInternational = Unit.get_singular_unit([Literal('inch (international)', lang='en'), Literal('英寸（国际）', lang='zh')], Literal('in'), base_unit=metre, factor=0.0254, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/inch-International', system_of_units=None, is_base_unit=False)
    micron = Unit.get_singular_unit([Literal('micron', lang='nl'), Literal('micron', lang='en')], Literal('μ'), base_unit=metre, factor=1e-06, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/micron', system_of_units=None, is_base_unit=False)
    mileUSSurvey = Unit.get_singular_unit(Literal('mile (US survey)', lang='en'), None, base_unit=metre, factor=1609.347, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/mile-USSurvey', system_of_units=None, is_base_unit=False)
    knotInternational = Unit.get_singular_unit([Literal('海里/小时（国际）', lang='zh'), Literal('knot (international)', lang='en'), Literal('knoop (internationaal)', lang='nl')], None, base_unit=nauticalMileInternationalPerHour, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/knot-International', system_of_units=None, is_base_unit=False)
    statampere = Unit.get_singular_unit([Literal('statampère', lang='nl'), Literal('statampere', lang='en')], Literal('statA'), base_unit=ampere, factor=3.335641e-10, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/statampere', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectrostaticSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/GaussianSystemOfUnits')], is_base_unit=False)
    dryGallonUS = Unit.get_singular_unit(Literal('dry gallon (US)', lang='en'), Literal('gal'), base_unit=cubicMetre, factor=0.00440488377086, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/dryGallon-US', system_of_units=None, is_base_unit=False)
    slug = Unit.get_singular_unit([Literal('金属块', lang='zh'), Literal('slug', lang='en')], Literal('slug'), base_unit=kilogram, factor=14.5939, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/slug', system_of_units=None, is_base_unit=False)
    pointPostscript = Unit.get_singular_unit(Literal('point (Postscript)', lang='en'), Literal('pt'), base_unit=inchInternational, factor=0.013888888888888888, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/point-Postscript', system_of_units=None, is_base_unit=False)
    magnitude = Unit.get_singular_unit([Literal('magnitude', lang='nl'), Literal('magnitude', lang='en')], Literal('mag'), base_unit=one, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/magnitude', system_of_units=None, is_base_unit=False)
    abampere = Unit.get_singular_unit([Literal('abampere', lang='en'), Literal('abampère', lang='nl')], Literal('abA'), base_unit=ampere, factor=10.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/abampere', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectromagneticSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/GaussianSystemOfUnits')], is_base_unit=False)
    bushelUS = Unit.get_singular_unit(Literal('bushel (US)', lang='en'), Literal('bu'), base_unit=cubicMetre, factor=0.03523907, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/bushel-US', system_of_units=None, is_base_unit=False)
    litre = Unit.get_singular_unit([Literal('升', lang='zh'), Literal('liter', lang='nl'), Literal('litre', lang='en')], Literal('l'), base_unit=cubicMetre, factor=0.001, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/litre', system_of_units=None, is_base_unit=False)
    magnitudePerSecondAngleSquared = Unit.get_unit_division(magnitude, secondAngleSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/magnitudePerSecond-AngleSquared', system_of_units=None)
    metreKilogramPerSecondTimeSquared = Unit.get_unit_division(metreKilogram, secondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metreKilogramPerSecond-TimeSquared', system_of_units=None)
    tonnePerCubicmetre = Unit.get_unit_division(tonne, cubicMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/tonnePerCubicmetre', system_of_units=None)
    cubicMetrePerYear = Unit.get_unit_division(cubicMetre, year, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicMetrePerYear', system_of_units=None)
    degreeCelsiusPerHour = Unit.get_unit_division(degreeCelsius, hour, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/degreeCelsiusPerHour', system_of_units=None)
    micromolePerSecondTime = Unit.get_unit_division(micromole, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/micromolePerSecond-Time', system_of_units=None)
    microgramPerCubicCentimetre = Unit.get_unit_division(microgram, cubicCentimetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microgramPerCubicCentimetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    megaeuroPerMegatonne = Unit.get_unit_division(megaeuro, megatonne, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megaeuroPerMegatonne', system_of_units=None)
    litrePerHour = Unit.get_unit_division(litre, hour, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/litrePerHour', system_of_units=None)
    metreKilogramPerSecondTime = Unit.get_unit_division(metreKilogram, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metreKilogramPerSecond-Time', system_of_units=None)
    molePerLitre = Unit.get_unit_division(mole, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerLitre', system_of_units=None)
    kilogramPerKilogram = Unit.get_unit_division(kilogram, kilogram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilogramPerKilogram', system_of_units=None)
    litrePerMole = Unit.get_unit_division(litre, mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/litrePerMole', system_of_units=None)
    micromolePerMole = Unit.get_unit_division(micromole, mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/micromolePerMole', system_of_units=None)
    euroPerTonne = Unit.get_unit_division(euro, tonne, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/euroPerTonne', system_of_units=None)
    micromolePerSecondTimeGram = Unit.get_unit_division(micromolePerSecondTime, gram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/micromolePerSecond-TimeGram', system_of_units=None)
    candelaPerSquareCentimetre = Unit.get_unit_division(candela, squareCentimetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/candelaPerSquareCentimetre', system_of_units=None)
    gramPerLitre = Unit.get_unit_division(gram, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerLitre', system_of_units=None)
    radianPerSecondTime = Unit.get_unit_division(radian, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/radianPerSecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    partsPerMillionPerYear = Unit.get_unit_division(partsPerMillion, year, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/partsPerMillionPerYear', system_of_units=None)
    centimetrePerCubicCentimetre = Unit.get_unit_division(centimetre, cubicCentimetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centimetrePerCubicCentimetre', system_of_units=None)
    cubicCentimetrePerCubicCentimetre = Unit.get_unit_division(cubicCentimetre, cubicCentimetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicCentimetrePerCubicCentimetre', system_of_units=None)
    metrePerMicrosecondTime = Unit.get_unit_division(metre, microsecondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerMicrosecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerGigasecondTime = Unit.get_unit_division(metre, gigasecondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerGigasecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerAttosecondTime = Unit.get_unit_division(metre, attosecondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerAttosecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerExasecondTime = Unit.get_unit_division(metre, exasecondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerExasecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerPicosecondTime = Unit.get_unit_division(metre, picosecondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerPicosecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    picometrePerSecondTime = Unit.get_unit_division(picometre, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picometrePerSecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    nanometrePerSecondTime = Unit.get_unit_division(nanometre, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanometrePerSecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    terametrePerSecondTime = Unit.get_unit_division(terametre, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/terametrePerSecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    megametrePerSecondTime = Unit.get_unit_division(megametre, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megametrePerSecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    femtometrePerSecondTime = Unit.get_unit_division(femtometre, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtometrePerSecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    yottametrePerSecondTime = Unit.get_unit_division(yottametre, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottametrePerSecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    teragramPerLitre = Unit.get_unit_division(teragram, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/teragramPerLitre', system_of_units=None)
    kilogramPerLitre = Unit.get_unit_division(kilogram, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilogramPerLitre', system_of_units=None)
    megagramPerLitre = Unit.get_unit_division(megagram, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megagramPerLitre', system_of_units=None)
    centigramPerLitre = Unit.get_unit_division(centigram, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centigramPerLitre', system_of_units=None)
    zeptogramPerLitre = Unit.get_unit_division(zeptogram, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptogramPerLitre', system_of_units=None)
    exagramPerLitre = Unit.get_unit_division(exagram, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exagramPerLitre', system_of_units=None)
    gigagramPerLitre = Unit.get_unit_division(gigagram, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigagramPerLitre', system_of_units=None)
    nanogramPerLitre = Unit.get_unit_division(nanogram, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanogramPerLitre', system_of_units=None)
    picogramPerLitre = Unit.get_unit_division(picogram, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picogramPerLitre', system_of_units=None)
    hectogramPerLitre = Unit.get_unit_division(hectogram, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectogramPerLitre', system_of_units=None)
    metrePerYoctosecondTimeSquared = Unit.get_unit_division(metre, yoctosecondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerYoctosecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerKilosecondTimeSquared = Unit.get_unit_division(metre, kilosecondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerKilosecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerHectosecondTimeSquared = Unit.get_unit_division(metre, hectosecondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerHectosecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerPicosecondTimeSquared = Unit.get_unit_division(metre, picosecondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerPicosecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerMillisecondTimeSquared = Unit.get_unit_division(metre, millisecondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerMillisecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    petamolePerMetre = Unit.get_unit_division(petamole, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petamolePerMetre', system_of_units=None)
    decamolePerMetre = Unit.get_unit_division(decamole, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decamolePerMetre', system_of_units=None)
    millimolePerMetre = Unit.get_unit_division(millimole, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millimolePerMetre', system_of_units=None)
    femtomolePerMetre = Unit.get_unit_division(femtomole, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtomolePerMetre', system_of_units=None)
    picomolePerMetre = Unit.get_unit_division(picomole, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picomolePerMetre', system_of_units=None)
    teramolePerMetre = Unit.get_unit_division(teramole, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/teramolePerMetre', system_of_units=None)
    nanomolePerMetre = Unit.get_unit_division(nanomole, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanomolePerMetre', system_of_units=None)
    examolePerMetre = Unit.get_unit_division(examole, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/examolePerMetre', system_of_units=None)
    attomolePerMetre = Unit.get_unit_division(attomole, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attomolePerMetre', system_of_units=None)
    micromolePerMetre = Unit.get_unit_division(micromole, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/micromolePerMetre', system_of_units=None)
    decametrePerSecondTimeSquared = Unit.get_unit_division(decametre, secondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decametrePerSecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    decimetrePerSecondTimeSquared = Unit.get_unit_division(decimetre, secondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decimetrePerSecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    petametrePerSecondTimeSquared = Unit.get_unit_division(petametre, secondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petametrePerSecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    megametrePerSecondTimeSquared = Unit.get_unit_division(megametre, secondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megametrePerSecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    exametrePerSecondTimeSquared = Unit.get_unit_division(exametre, secondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exametrePerSecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    nanometrePerSecondTimeSquared = Unit.get_unit_division(nanometre, secondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanometrePerSecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    molePerNanometre = Unit.get_unit_division(mole, nanometre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerNanometre', system_of_units=None)
    molePerGigametre = Unit.get_unit_division(mole, gigametre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerGigametre', system_of_units=None)
    molePerExametre = Unit.get_unit_division(mole, exametre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerExametre', system_of_units=None)
    molePerZettametre = Unit.get_unit_division(mole, zettametre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerZettametre', system_of_units=None)
    molePerHectometre = Unit.get_unit_division(mole, hectometre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerHectometre', system_of_units=None)
    nanomolePerLitre = Unit.get_unit_division(nanomole, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanomolePerLitre', system_of_units=None)
    yoctomolePerLitre = Unit.get_unit_division(yoctomole, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctomolePerLitre', system_of_units=None)
    zettamolePerLitre = Unit.get_unit_division(zettamole, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettamolePerLitre', system_of_units=None)
    picomolePerLitre = Unit.get_unit_division(picomole, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picomolePerLitre', system_of_units=None)
    hectomolePerLitre = Unit.get_unit_division(hectomole, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectomolePerLitre', system_of_units=None)
    centimolePerLitre = Unit.get_unit_division(centimole, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centimolePerLitre', system_of_units=None)
    examolePerLitre = Unit.get_unit_division(examole, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/examolePerLitre', system_of_units=None)
    zeptomolePerLitre = Unit.get_unit_division(zeptomole, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptomolePerLitre', system_of_units=None)
    micromolePerLitre = Unit.get_unit_division(micromole, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/micromolePerLitre', system_of_units=None)
    reciprocalCubicCentimetre = Unit.get_unit_exponentiation(centimetre, -3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/reciprocalCubicCentimetre', system_of_units=None)
    squareMetre = Unit.get_unit_exponentiation(metre, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareMetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    reciprocalYear = Unit.get_unit_exponentiation(year, -1, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/reciprocalYear', system_of_units=None)
    reciprocalHour = Unit.get_unit_exponentiation(hour, -1, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/reciprocalHour', system_of_units=None)
    cubicDecimetre = Unit.get_unit_exponentiation(decimetre, 3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicDecimetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    cubicNanometre = Unit.get_unit_exponentiation(nanometre, 3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicNanometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    cubicPetametre = Unit.get_unit_exponentiation(petametre, 3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicPetametre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    cubicHectometre = Unit.get_unit_exponentiation(hectometre, 3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicHectometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    cubicDecametre = Unit.get_unit_exponentiation(decametre, 3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicDecametre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    squareYoctometre = Unit.get_unit_exponentiation(yoctometre, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareYoctometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    squareDecimetre = Unit.get_unit_exponentiation(decimetre, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareDecimetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    squareTerametre = Unit.get_unit_exponentiation(terametre, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareTerametre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    squareNanometre = Unit.get_unit_exponentiation(nanometre, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareNanometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    squarePetametre = Unit.get_unit_exponentiation(petametre, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squarePetametre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    zettasecondTimeSquared = Unit.get_unit_exponentiation(zettasecondTime, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettasecond-TimeSquared', system_of_units=None)
    centisecondTimeSquared = Unit.get_unit_exponentiation(centisecondTime, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centisecond-TimeSquared', system_of_units=None)
    gigasecondTimeSquared = Unit.get_unit_exponentiation(gigasecondTime, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigasecond-TimeSquared', system_of_units=None)
    yottasecondTimeSquared = Unit.get_unit_exponentiation(yottasecondTime, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottasecond-TimeSquared', system_of_units=None)
    microsecondTimeSquared = Unit.get_unit_exponentiation(microsecondTime, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microsecond-TimeSquared', system_of_units=None)
    petasecondTimeSquared = Unit.get_unit_exponentiation(petasecondTime, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petasecond-TimeSquared', system_of_units=None)
    moleMicrometre = Unit.get_unit_multiplication(mole, micrometre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/moleMicrometre', system_of_units=None)
    kilogramSecondTimeToThePower2ReciprocalMetre = Unit.get_unit_multiplication(kilogramSecondTimeToThePower2, reciprocalMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilogramSecond-TimeToThePower-2ReciprocalMetre', system_of_units=None)
    squareMetreNanometre = Unit.get_unit_multiplication(squareMetre, nanometre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareMetreNanometre', system_of_units=None)
    squareMetreKelvin = Unit.get_unit_multiplication(squareMetre, kelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareMetreKelvin', system_of_units=None)
    moleMicrometreReciprocalSquareCentimetre = Unit.get_unit_multiplication(moleMicrometre, reciprocalSquareCentimetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/moleMicrometreReciprocalSquareCentimetre', system_of_units=None)
    squareMetreHertz = Unit.get_unit_multiplication(squareMetre, hertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareMetreHertz', system_of_units=None)
    kilogramSquareMetre = Unit.get_unit_multiplication(kilogram, squareMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilogramSquareMetre', system_of_units=None)
    moleMicrometreReciprocalSquareCentimetreReciprocalSecondTime = Unit.get_unit_multiplication(moleMicrometreReciprocalSquareCentimetre, reciprocalSecondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/moleMicrometreReciprocalSquareCentimetreReciprocalSecond-Time', system_of_units=None)
    squareMetreDay = Unit.get_unit_multiplication(squareMetre, day, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareMetreDay', system_of_units=None)
    hectocoulomb = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=coulomb, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectocoulomb', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decakatal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=katal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decakatal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtolitre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtolitre', system_of_units=None, is_base_unit=False)
    gigayear = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=year, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigayear', system_of_units=None, is_base_unit=False)
    megalitre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megalitre', system_of_units=None, is_base_unit=False)
    petakatal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=katal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petakatal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanocandela = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=candela, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanocandela', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centilitre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centilitre', system_of_units=None, is_base_unit=False)
    millikatal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=katal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millikatal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    micromagnitude = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=magnitude, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/micromagnitude', system_of_units=None, is_base_unit=False)
    megasecondTime = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megasecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decasecondTime = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decasecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gigabecquerel = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=becquerel, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigabecquerel', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    microsecondAngle = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=secondAngle, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microsecond-Angle', system_of_units=None, is_base_unit=False)
    terakatal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=katal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/terakatal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decimole = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decimole', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kilobecquerel = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=becquerel, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilobecquerel', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    hectolitre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectolitre', system_of_units=None, is_base_unit=False)
    gigalitre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigalitre', system_of_units=None, is_base_unit=False)
    picoradian = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=radian, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picoradian', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megamole = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megamole', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    microkatal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=katal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microkatal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kilolitre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilolitre', system_of_units=None, is_base_unit=False)
    microhertz = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=hertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microhertz', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottakatal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=katal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottakatal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centikatal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=katal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centikatal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtokatal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=katal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtokatal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctohertz = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=hertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctohertz', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettalitre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettalitre', system_of_units=None, is_base_unit=False)
    nanoradian = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=radian, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanoradian', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptokatal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=katal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptokatal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctokatal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=katal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctokatal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kilotonne = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=tonne, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilotonne', system_of_units=None, is_base_unit=False)
    zettakatal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=katal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettakatal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megabecquerel = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=becquerel, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megabecquerel', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kilomole = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilomole', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megakatal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=katal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megakatal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kilokatal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=katal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilokatal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottahertz = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=hertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottahertz', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtosecondTime = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtosecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attokatal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=katal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attokatal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    picokatal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=katal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picokatal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettabecquerel = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=becquerel, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettabecquerel', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtohertz = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=hertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtohertz', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megaparsec = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=parsec, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megaparsec', system_of_units=None, is_base_unit=False)
    zeptolitre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptolitre', system_of_units=None, is_base_unit=False)
    hectocandela = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=candela, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectocandela', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    picolitre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picolitre', system_of_units=None, is_base_unit=False)
    exakatal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=katal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exakatal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottalitre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottalitre', system_of_units=None, is_base_unit=False)
    millilitre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millilitre', system_of_units=None, is_base_unit=False)
    exabecquerel = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=becquerel, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exabecquerel', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    millisecondAngle = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=secondAngle, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millisecond-Angle', system_of_units=None, is_base_unit=False)
    microlitre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microlitre', system_of_units=None, is_base_unit=False)
    picohertz = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=hertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picohertz', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petalitre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petalitre', system_of_units=None, is_base_unit=False)
    yoctolitre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctolitre', system_of_units=None, is_base_unit=False)
    attolitre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attolitre', system_of_units=None, is_base_unit=False)
    hectokatal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=katal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectokatal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gigakatal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=katal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigakatal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    hectobecquerel = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=becquerel, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectobecquerel', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    teralitre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/teralitre', system_of_units=None, is_base_unit=False)
    microcandela = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=candela, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microcandela', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanolitre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanolitre', system_of_units=None, is_base_unit=False)
    decilitre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decilitre', system_of_units=None, is_base_unit=False)
    kiloparsec = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=parsec, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kiloparsec', system_of_units=None, is_base_unit=False)
    teracoulomb = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=coulomb, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/teracoulomb', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    _25Millilitre = Unit.get_unit_multiple(millilitre, factor=25.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/_25Millilitre', label=[Literal('25 milliliter', lang='nl'), Literal('25 millilitre', lang='en')], symbol=Literal('25 ml'), system_of_units=None)
    quartImperial = Unit.get_singular_unit(Literal('quart (imperial)', lang='en'), None, base_unit=litre, factor=1.1365, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/quart-Imperial', system_of_units=None, is_base_unit=False)
    newton = Unit.get_singular_unit([Literal('newton', lang='en'), Literal('牛顿', lang='zh'), Literal('newton', lang='nl')], Literal('N'), base_unit=metreKilogramPerSecondTimeSquared, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/newton', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/metre-Kilogram-Second-AmpereSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')], is_base_unit=False)
    pintImperial = Unit.get_singular_unit(Literal('pint (imperial)', lang='en'), None, base_unit=millilitre, factor=568.26125, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/pint-Imperial', system_of_units=None, is_base_unit=False)
    tonForceShort = Unit.get_singular_unit(Literal('ton-force (short)', lang='en'), None, base_unit=newton, factor=8896.443, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/ton-Force-Short', system_of_units=None, is_base_unit=False)
    poundForce = Unit.get_singular_unit(Literal('pound-force', lang='en'), Literal('lbf'), base_unit=newton, factor=4.448222, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/pound-Force', system_of_units=None, is_base_unit=False)
    poundApothecaries = Unit.get_singular_unit(Literal('pound (apthecaries\')', lang='en'), Literal('lb'), base_unit=kilogram, factor=0.3732417, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/poundApothecaries', system_of_units=None, is_base_unit=False)
    gillImperial = Unit.get_singular_unit(Literal('gill (imperial)', lang='en'), Literal('gi'), base_unit=cubicMetre, factor=0.0001420653, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gill-Imperial', system_of_units=None, is_base_unit=False)
    kip = Unit.get_singular_unit([Literal('kip', lang='en'), Literal('kip', lang='nl')], None, base_unit=newton, factor=4448.222, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kip', system_of_units=None, is_base_unit=False)
    acreInternational = Unit.get_singular_unit([Literal('英亩（国际）', lang='zh'), Literal('acre (international)', lang='en')], Literal('ac'), base_unit=squareMetre, factor=4046.8564224, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/acre-International', system_of_units=None, is_base_unit=False)
    solarMass = Unit.get_singular_unit([Literal('solar mass', lang='en'), Literal('zonsmassa', lang='nl')], Literal('M_☉'), base_unit=kilogram, factor=1.98892e+30, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/solarMass', system_of_units=None, is_base_unit=False)
    abcoulomb = Unit.get_singular_unit([Literal('abcoulomb', lang='en'), Literal('abcoulomb', lang='nl')], Literal('abC'), base_unit=coulomb, factor=10.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/abcoulomb', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/GaussianSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectromagneticSystemOfUnits')], is_base_unit=False)
    molair = Unit.get_singular_unit([Literal('molair', lang='en'), Literal('molair', lang='nl')], Literal('M'), base_unit=molePerLitre, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molair', system_of_units=None, is_base_unit=False)
    picaPostscript = Unit.get_singular_unit(Literal('pica (Postscript)', lang='en'), None, base_unit=pointPostscript, factor=12.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/pica-Postscript', system_of_units=None, is_base_unit=False)
    poundal = Unit.get_singular_unit(Literal('poundal', lang='en'), None, base_unit=newton, factor=0.138255, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/poundal', system_of_units=None, is_base_unit=False)
    minuteAngle = Unit.get_singular_unit([Literal('minuut (hoek)', lang='nl'), Literal('minute (angle)', lang='en'), Literal('分钟（角）', lang='zh')], Literal('\''), base_unit=radian, factor=0.0002908882, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/minute-Angle', system_of_units=None, is_base_unit=False)
    are = Unit.get_singular_unit([Literal('are', lang='en'), Literal('are', lang='nl')], Literal('a'), base_unit=squareMetre, factor=100.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/are', system_of_units=None, is_base_unit=False)
    acreUSSurvey = Unit.get_singular_unit([Literal('英亩（美国调查）', lang='zh'), Literal('acre (US survey)', lang='en')], Literal('ac'), base_unit=squareMetre, factor=4046.872609874252, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/acre-USSurvey', system_of_units=None, is_base_unit=False)
    franklin = Unit.get_singular_unit([Literal('franklin', lang='en'), Literal('franklin', lang='nl')], Literal('Fr'), base_unit=coulomb, factor=3.335641e-10, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/franklin', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-Second-FranklinSystemOfUnits', is_base_unit=True)
    gillUS = Unit.get_singular_unit(Literal('gill (US)', lang='en'), Literal('gi'), base_unit=cubicMetre, factor=0.0001182941, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gill-US', system_of_units=None, is_base_unit=False)
    dyne = Unit.get_singular_unit([Literal('dyne', lang='nl'), Literal('dyne', lang='en'), Literal('达因', lang='zh')], Literal('dyn'), base_unit=newton, factor=1e-05, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/dyne', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondSystemOfUnits', is_base_unit=False)
    HongKongDollar = Unit.get_singular_unit([Literal('港元', lang='zh'), Literal('Hong Kong dollar', lang='en')], None, Dimension(0, 0, 0, 0, 0, 0, 0), identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/HongKongDollar', system_of_units=None, is_base_unit=False)
    barn = Unit.get_singular_unit(Literal('barn', lang='en'), Literal('b'), base_unit=squareMetre, factor=1e-28, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/barn', system_of_units=None, is_base_unit=False)
    circularMil = Unit.get_singular_unit(Literal('circular mil', lang='en'), None, base_unit=squareMetre, factor=5.067075e-10, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/circularMil', system_of_units=None, is_base_unit=False)
    squareMetrePerSecondTime = Unit.get_unit_division(squareMetre, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareMetrePerSecond-Time', system_of_units=None)
    millimetrePerHour = Unit.get_unit_division(millimetre, hour, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millimetrePerHour', system_of_units=None)
    secondTimePerSquareMetre = Unit.get_unit_division(secondTime, squareMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/second-TimePerSquareMetre', system_of_units=None)
    gramPerCubicCentimetre = Unit.get_unit_division(gram, cubicCentimetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerCubicCentimetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    colonyFormingUnitPer25Millilitre = Unit.get_unit_division(colonyFormingUnit, _25Millilitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/colonyFormingUnitPer25Millilitre', system_of_units=None)
    gramPerKilogram = Unit.get_unit_division(gram, kilogram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerKilogram', system_of_units=None)
    newtonPerCoulomb = Unit.get_unit_division(newton, coulomb, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/newtonPerCoulomb', system_of_units=None)
    squareMetrePerSquareMetre = Unit.get_unit_division(squareMetre, squareMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareMetrePerSquareMetre', system_of_units=None)
    litrePer100Kilometre = Unit.get_unit_division(litre, _100Kilometre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/litrePer100Kilometre', system_of_units=None)
    gramPerSquareMetreDay = Unit.get_unit_division(gram, squareMetreDay, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerSquareMetreDay', system_of_units=None)
    coulombPerSquareMetre = Unit.get_unit_division(coulomb, squareMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/coulombPerSquareMetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    millisecondAnglePerYear = Unit.get_unit_division(millisecondAngle, year, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millisecond-AnglePerYear', system_of_units=None)
    gramPerSquareMetre = Unit.get_unit_division(gram, squareMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerSquareMetre', system_of_units=None)
    newtonPerMetre = Unit.get_unit_division(newton, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/newtonPerMetre', system_of_units=None)
    amperePerSquareMetre = Unit.get_unit_division(ampere, squareMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/amperePerSquareMetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    squareMetrePerGram = Unit.get_unit_division(squareMetre, gram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareMetrePerGram', system_of_units=None)
    _1000ColonyFormingUnitPerMillilitre = Unit.get_unit_division(_1000ColonyFormingUnit, millilitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/_1000ColonyFormingUnitPerMillilitre', system_of_units=None)
    kilogramPerCubicDecimetre = Unit.get_unit_division(kilogram, cubicDecimetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilogramPerCubicDecimetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    newtonPerSquareMetre = Unit.get_unit_division(newton, squareMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/newtonPerSquareMetre', system_of_units=None)
    kilometrePerSecondTimePerMegaparsec = Unit.get_unit_division(kilometrePerSecondTime, megaparsec, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilometrePerSecond-TimePerMegaparsec', system_of_units=None)
    colonyFormingUnitPerMillilitre = Unit.get_unit_division(colonyFormingUnit, millilitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/colonyFormingUnitPerMillilitre', system_of_units=None)
    metrePerMegasecondTime = Unit.get_unit_division(metre, megasecondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerMegasecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerHectosecondTime = Unit.get_unit_division(metre, hectosecondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerHectosecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerFemtosecondTime = Unit.get_unit_division(metre, femtosecondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerFemtosecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    attometrePerSecondTime = Unit.get_unit_division(attometre, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attometrePerSecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    millimetrePerSecondTime = Unit.get_unit_division(millimetre, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millimetrePerSecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    micrometrePerSecondTime = Unit.get_unit_division(micrometre, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/micrometrePerSecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    yoctogramPerLitre = Unit.get_unit_division(yoctogram, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctogramPerLitre', system_of_units=None)
    petagramPerLitre = Unit.get_unit_division(petagram, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petagramPerLitre', system_of_units=None)
    milligramPerLitre = Unit.get_unit_division(milligram, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/milligramPerLitre', system_of_units=None)
    attogramPerLitre = Unit.get_unit_division(attogram, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attogramPerLitre', system_of_units=None)
    zettagramPerLitre = Unit.get_unit_division(zettagram, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettagramPerLitre', system_of_units=None)
    metrePerCentisecondTimeSquared = Unit.get_unit_division(metre, centisecondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerCentisecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerMicrosecondTimeSquared = Unit.get_unit_division(metre, microsecondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerMicrosecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerDecisecondTimeSquared = Unit.get_unit_division(metre, decisecondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerDecisecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerPetasecondTimeSquared = Unit.get_unit_division(metre, petasecondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerPetasecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerExasecondTimeSquared = Unit.get_unit_division(metre, exasecondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerExasecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    kilomolePerMetre = Unit.get_unit_division(kilomole, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilomolePerMetre', system_of_units=None)
    decimolePerMetre = Unit.get_unit_division(decimole, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decimolePerMetre', system_of_units=None)
    megamolePerMetre = Unit.get_unit_division(megamole, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megamolePerMetre', system_of_units=None)
    hectomolePerMetre = Unit.get_unit_division(hectomole, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectomolePerMetre', system_of_units=None)
    zeptomolePerMetre = Unit.get_unit_division(zeptomole, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptomolePerMetre', system_of_units=None)
    femtometrePerSecondTimeSquared = Unit.get_unit_division(femtometre, secondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtometrePerSecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    zeptometrePerSecondTimeSquared = Unit.get_unit_division(zeptometre, secondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptometrePerSecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    kilometrePerSecondTimeSquared = Unit.get_unit_division(kilometre, secondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilometrePerSecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    molePerDecametre = Unit.get_unit_division(mole, decametre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerDecametre', system_of_units=None)
    molePerYoctometre = Unit.get_unit_division(mole, yoctometre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerYoctometre', system_of_units=None)
    millimolePerLitre = Unit.get_unit_division(millimole, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millimolePerLitre', system_of_units=None)
    yottamolePerLitre = Unit.get_unit_division(yottamole, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottamolePerLitre', system_of_units=None)
    teramolePerLitre = Unit.get_unit_division(teramole, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/teramolePerLitre', system_of_units=None)
    megamolePerLitre = Unit.get_unit_division(megamole, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megamolePerLitre', system_of_units=None)
    femtomolePerLitre = Unit.get_unit_division(femtomole, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtomolePerLitre', system_of_units=None)
    decamolePerLitre = Unit.get_unit_division(decamole, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decamolePerLitre', system_of_units=None)
    gramPerTeralitre = Unit.get_unit_division(gram, teralitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerTeralitre', system_of_units=None)
    gramPerAttolitre = Unit.get_unit_division(gram, attolitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerAttolitre', system_of_units=None)
    gramPerHectolitre = Unit.get_unit_division(gram, hectolitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerHectolitre', system_of_units=None)
    gramPerGigalitre = Unit.get_unit_division(gram, gigalitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerGigalitre', system_of_units=None)
    gramPerCentilitre = Unit.get_unit_division(gram, centilitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerCentilitre', system_of_units=None)
    gramPerZettalitre = Unit.get_unit_division(gram, zettalitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerZettalitre', system_of_units=None)
    gramPerKilolitre = Unit.get_unit_division(gram, kilolitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerKilolitre', system_of_units=None)
    gramPerPetalitre = Unit.get_unit_division(gram, petalitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerPetalitre', system_of_units=None)
    gramPerFemtolitre = Unit.get_unit_division(gram, femtolitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerFemtolitre', system_of_units=None)
    molePerZettalitre = Unit.get_unit_division(mole, zettalitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerZettalitre', system_of_units=None)
    molePerZeptolitre = Unit.get_unit_division(mole, zeptolitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerZeptolitre', system_of_units=None)
    molePerHectolitre = Unit.get_unit_division(mole, hectolitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerHectolitre', system_of_units=None)
    molePerMegalitre = Unit.get_unit_division(mole, megalitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerMegalitre', system_of_units=None)
    molePerYoctolitre = Unit.get_unit_division(mole, yoctolitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerYoctolitre', system_of_units=None)
    molePerKilolitre = Unit.get_unit_division(mole, kilolitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerKilolitre', system_of_units=None)
    molePerYottalitre = Unit.get_unit_division(mole, yottalitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerYottalitre', system_of_units=None)
    molePerMicrolitre = Unit.get_unit_division(mole, microlitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerMicrolitre', system_of_units=None)
    molePerGigalitre = Unit.get_unit_division(mole, gigalitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerGigalitre', system_of_units=None)
    molePerDecilitre = Unit.get_unit_division(mole, decilitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerDecilitre', system_of_units=None)
    cubicParsec = Unit.get_unit_exponentiation(parsec, 3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicParsec', system_of_units=None)
    reciprocalCubicParsec = Unit.get_unit_exponentiation(parsec, -3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/reciprocalCubicParsec', system_of_units=None)
    cubicMillimetre = Unit.get_unit_exponentiation(millimetre, 3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicMillimetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    cubicAttometre = Unit.get_unit_exponentiation(attometre, 3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicAttometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    cubicFemtometre = Unit.get_unit_exponentiation(femtometre, 3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicFemtometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    squareHectometre = Unit.get_unit_exponentiation(hectometre, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareHectometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    squareZettametre = Unit.get_unit_exponentiation(zettametre, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareZettametre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    megasecondTimeSquared = Unit.get_unit_exponentiation(megasecondTime, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megasecond-TimeSquared', system_of_units=None)
    decasecondTimeSquared = Unit.get_unit_exponentiation(decasecondTime, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decasecond-TimeSquared', system_of_units=None)
    nanosecondTimeSquared = Unit.get_unit_exponentiation(nanosecondTime, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanosecond-TimeSquared', system_of_units=None)
    gigayearCubicParsec = Unit.get_unit_multiplication(gigayear, cubicParsec, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigayearCubicParsec', system_of_units=None)
    newtonMetre = Unit.get_unit_multiplication(newton, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/newtonMetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    squareMetreSecondTime = Unit.get_unit_multiplication(squareMetre, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareMetreSecond-Time', system_of_units=None)
    yottanewton = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=newton, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottanewton', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanonewton = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=newton, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanonewton', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    teramolair = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=molair, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/teramolair', system_of_units=None, is_base_unit=False)
    decinewton = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=newton, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decinewton', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanomolair = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=molair, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanomolair', system_of_units=None, is_base_unit=False)
    micromolair = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=molair, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/micromolair', system_of_units=None, is_base_unit=False)
    exanewton = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=newton, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exanewton', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    hectomolair = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=molair, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectomolair', system_of_units=None, is_base_unit=False)
    gigaparsec = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=parsec, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigaparsec', system_of_units=None, is_base_unit=False)
    decikatal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=katal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decikatal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centinewton = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=newton, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centinewton', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decimolair = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=molair, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decimolair', system_of_units=None, is_base_unit=False)
    kilomolair = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=molair, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilomolair', system_of_units=None, is_base_unit=False)
    piconewton = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=newton, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/piconewton', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    millimolair = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=molair, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millimolair', system_of_units=None, is_base_unit=False)
    yottamolair = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=molair, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottamolair', system_of_units=None, is_base_unit=False)
    decamolair = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=molair, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decamolair', system_of_units=None, is_base_unit=False)
    petamolair = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=molair, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petamolair', system_of_units=None, is_base_unit=False)
    attomolair = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=molair, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attomolair', system_of_units=None, is_base_unit=False)
    petanewton = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=newton, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petanewton', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettamolair = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=molair, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettamolair', system_of_units=None, is_base_unit=False)
    femtomolair = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=molair, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtomolair', system_of_units=None, is_base_unit=False)
    decanewton = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=newton, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decanewton', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanokatal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=katal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanokatal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    hectonewton = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=newton, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectonewton', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettanewton = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=newton, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettanewton', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    teranewton = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=newton, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/teranewton', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centiare = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=are, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centiare', system_of_units=None, is_base_unit=False)
    millimagnitude = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=magnitude, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millimagnitude', system_of_units=None, is_base_unit=False)
    gigamole = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigamole', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    examolair = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=molair, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/examolair', system_of_units=None, is_base_unit=False)
    meganewton = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=newton, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/meganewton', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decalitre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decalitre', system_of_units=None, is_base_unit=False)
    gigamolair = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=molair, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigamolair', system_of_units=None, is_base_unit=False)
    yoctomolair = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=molair, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctomolair', system_of_units=None, is_base_unit=False)
    giganewton = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=newton, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/giganewton', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centimolair = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=molair, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centimolair', system_of_units=None, is_base_unit=False)
    hectare = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=are, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectare', system_of_units=None, is_base_unit=False)
    kilonewton = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=newton, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilonewton', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    exalitre = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exalitre', system_of_units=None, is_base_unit=False)
    picomolair = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=molair, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picomolair', system_of_units=None, is_base_unit=False)
    femtonewton = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=newton, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtonewton', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attonewton = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=newton, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attonewton', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    oersted = Unit.get_singular_unit(Literal('oersted', lang='en'), Literal('Oe'), base_unit=amperePerMetre, factor=79.57747, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/oersted', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/GaussianSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectromagneticSystemOfUnits')], is_base_unit=False)
    pointTeX = Unit.get_singular_unit(Literal('point (TeX)', lang='en'), Literal('pt'), base_unit=inchInternational, factor=0.013837000138370002, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/point-TeX', system_of_units=None, is_base_unit=False)
    degree = Unit.get_singular_unit([Literal('degree', lang='en'), Literal('graad', lang='nl'), Literal('度', lang='zh')], Literal('°'), base_unit=radian, factor=0.01745329, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/degree', system_of_units=None, is_base_unit=False)
    pascal = Unit.get_singular_unit([Literal('pascal', lang='en'), Literal('pascal', lang='nl')], Literal('Pa'), base_unit=newtonPerSquareMetre, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/pascal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    stokes = Unit.get_singular_unit([Literal('stokes', lang='en'), Literal('stokes', lang='nl')], Literal('St'), base_unit=squareMetrePerSecondTime, factor=0.0001, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/stokes', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondSystemOfUnits', is_base_unit=False)
    teaspoonUS = Unit.get_singular_unit(Literal('teaspoon (US)', lang='en'), None, base_unit=cubicMetre, factor=4.928922e-06, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/teaspoon-US', system_of_units=None, is_base_unit=False)
    minuteHourAngle = Unit.get_singular_unit([Literal('minuut (uurhoek)', lang='nl'), Literal('minute (hour angle)', lang='en')], Literal('m'), base_unit=degree, factor=0.25, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/minute-HourAngle', system_of_units=None, is_base_unit=False)
    steradian = Unit.get_singular_unit([Literal('steradiaal', lang='nl'), Literal('steradian', lang='en'), Literal('球面度', lang='zh')], Literal('sr'), base_unit=squareMetrePerSquareMetre, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/steradian', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    hourHourAngle = Unit.get_singular_unit([Literal('hour (hour angle)', lang='en'), Literal('uur (uurhoek)', lang='nl')], Literal('h'), base_unit=degree, factor=15.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hour-HourAngle', system_of_units=None, is_base_unit=False)
    darcy = Unit.get_singular_unit([Literal('darcy', lang='nl'), Literal('darcy', lang='en')], None, base_unit=squareMetre, factor=9.869233e-13, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/darcy', system_of_units=None, is_base_unit=False)
    picaTeX = Unit.get_singular_unit(Literal('pica (TeX)', lang='en'), None, base_unit=pointTeX, factor=12.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/pica-TeX', system_of_units=None, is_base_unit=False)
    metreOfMercury = Unit.get_singular_unit([Literal('metre of mercury', lang='en'), Literal('meter kwik', lang='nl')], Literal('m Hg'), base_unit=pascal, factor=133322.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metreOfMercury', system_of_units=None, is_base_unit=False)
    joule = Unit.get_singular_unit([Literal('joule', lang='nl'), Literal('joule', lang='en'), Literal('焦耳', lang='zh')], Literal('J'), base_unit=newtonMetre, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/joule', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/metre-Kilogram-Second-AmpereSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')], is_base_unit=False)
    erg = Unit.get_singular_unit([Literal('erg', lang='nl'), Literal('erg', lang='en'), Literal('尔格', lang='zh')], Literal('erg'), base_unit=joule, factor=1e-07, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/erg', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondSystemOfUnits', is_base_unit=False)
    bar = Unit.get_singular_unit([Literal('巴（压力计量单位）', lang='zh'), Literal('bar', lang='en'), Literal('bar', lang='nl')], Literal('bar'), base_unit=pascal, factor=100000.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/bar', system_of_units=None, is_base_unit=False)
    atmosphereTechnical = Unit.get_singular_unit(Literal('atmosphere (technical)', lang='en'), Literal('at'), base_unit=pascal, factor=98066.5, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/atmosphere-Technical', system_of_units=None, is_base_unit=False)
    tonOfTNT = Unit.get_singular_unit(Literal('ton of TNT', lang='en'), None, base_unit=joule, factor=4184000000.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/tonOfTNT', system_of_units=None, is_base_unit=False)
    solarMassPerGigayearCubicParsec = Unit.get_unit_division(solarMass, gigayearCubicParsec, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/solarMassPerGigayearCubicParsec', system_of_units=None)
    tonnePerHectare = Unit.get_unit_division(tonne, hectare, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/tonnePerHectare', system_of_units=None)
    gramPerSquareMetreCentimetre = Unit.get_unit_division(gramPerSquareMetre, centimetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerSquareMetreCentimetre', system_of_units=None)
    kilogramPerHectare = Unit.get_unit_division(kilogram, hectare, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilogramPerHectare', system_of_units=None)
    gramPerSquareMetreSecondTime = Unit.get_unit_division(gram, squareMetreSecondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerSquareMetreSecond-Time', system_of_units=None)
    joulePerSquareMetreSecondTime = Unit.get_unit_division(joule, squareMetreSecondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/joulePerSquareMetreSecond-Time', system_of_units=None)
    gramPerJoule = Unit.get_unit_division(gram, joule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerJoule', system_of_units=None)
    joulePerSquareMetre = Unit.get_unit_division(joule, squareMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/joulePerSquareMetre', system_of_units=None)
    joulePerCubicmetre = Unit.get_unit_division(joule, cubicMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/joulePerCubicmetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    kilogramPerSquareMetre = Unit.get_unit_division(kilogram, squareMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilogramPerSquareMetre', system_of_units=None)
    solarMassPerCubicParsec = Unit.get_unit_division(solarMass, cubicParsec, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/solarMassPerCubicParsec', system_of_units=None)
    microgramPerJoule = Unit.get_unit_division(microgram, joule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microgramPerJoule', system_of_units=None)
    joulePerSecondTime = Unit.get_unit_division(joule, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/joulePerSecond-Time', system_of_units=None)
    katalPerCubicmetre = Unit.get_unit_division(katal, cubicMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/katalPerCubicmetre', system_of_units=None)
    nanokatalPerMilligram = Unit.get_unit_division(nanokatal, milligram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanokatalPerMilligram', system_of_units=None)
    joulePerKilogram = Unit.get_unit_division(joule, kilogram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/joulePerKilogram', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    joulePerKelvin = Unit.get_unit_division(joule, kelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/joulePerKelvin', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerDecasecondTime = Unit.get_unit_division(metre, decasecondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerDecasecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerDecisecondTime = Unit.get_unit_division(metre, decisecondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerDecisecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    decimetrePerSecondTime = Unit.get_unit_division(decimetre, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decimetrePerSecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    decigramPerLitre = Unit.get_unit_division(decigram, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decigramPerLitre', system_of_units=None)
    decagramPerLitre = Unit.get_unit_division(decagram, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decagramPerLitre', system_of_units=None)
    metrePerDecasecondTimeSquared = Unit.get_unit_division(metre, decasecondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerDecasecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerNanosecondTimeSquared = Unit.get_unit_division(metre, nanosecondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerNanosecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerZettasecondTimeSquared = Unit.get_unit_division(metre, zettasecondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerZettasecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerGigasecondTimeSquared = Unit.get_unit_division(metre, gigasecondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerGigasecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    yoctomolePerMetre = Unit.get_unit_division(yoctomole, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctomolePerMetre', system_of_units=None)
    gigamolePerMetre = Unit.get_unit_division(gigamole, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigamolePerMetre', system_of_units=None)
    zettamolePerMetre = Unit.get_unit_division(zettamole, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettamolePerMetre', system_of_units=None)
    micrometrePerSecondTimeSquared = Unit.get_unit_division(micrometre, secondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/micrometrePerSecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    molePerPetametre = Unit.get_unit_division(mole, petametre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerPetametre', system_of_units=None)
    kilomolePerLitre = Unit.get_unit_division(kilomole, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilomolePerLitre', system_of_units=None)
    decimolePerLitre = Unit.get_unit_division(decimole, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decimolePerLitre', system_of_units=None)
    petamolePerLitre = Unit.get_unit_division(petamole, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petamolePerLitre', system_of_units=None)
    gramPerMillilitre = Unit.get_unit_division(gram, millilitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerMillilitre', system_of_units=None)
    gramPerNanolitre = Unit.get_unit_division(gram, nanolitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerNanolitre', system_of_units=None)
    gramPerDecilitre = Unit.get_unit_division(gram, decilitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerDecilitre', system_of_units=None)
    gramPerYoctolitre = Unit.get_unit_division(gram, yoctolitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerYoctolitre', system_of_units=None)
    gramPerExalitre = Unit.get_unit_division(gram, exalitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerExalitre', system_of_units=None)
    molePerDecalitre = Unit.get_unit_division(mole, decalitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerDecalitre', system_of_units=None)
    molePerCentilitre = Unit.get_unit_division(mole, centilitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerCentilitre', system_of_units=None)
    molePerPetalitre = Unit.get_unit_division(mole, petalitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerPetalitre', system_of_units=None)
    molePerFemtolitre = Unit.get_unit_division(mole, femtolitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerFemtolitre', system_of_units=None)
    molePerMillilitre = Unit.get_unit_division(mole, millilitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerMillilitre', system_of_units=None)
    cubicKiloparsec = Unit.get_unit_exponentiation(kiloparsec, 3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicKiloparsec', system_of_units=None)
    degreeSquared = Unit.get_unit_exponentiation(degree, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/degreeSquared', system_of_units=None)
    cubicPicometre = Unit.get_unit_exponentiation(picometre, 3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicPicometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    squareYottametre = Unit.get_unit_exponentiation(yottametre, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareYottametre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    attosecondTimeSquared = Unit.get_unit_exponentiation(attosecondTime, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attosecond-TimeSquared', system_of_units=None)
    terasecondTimeSquared = Unit.get_unit_exponentiation(terasecondTime, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/terasecond-TimeSquared', system_of_units=None)
    squareMetreSteradian = Unit.get_unit_multiplication(squareMetre, steradian, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareMetreSteradian', system_of_units=None)
    pascalSecondTime = Unit.get_unit_multiplication(pascal, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/pascalSecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    steradianSquareMetre = Unit.get_unit_multiplication(steradian, squareMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/steradianSquareMetre', system_of_units=None)
    steradianSquareMetreHertz = Unit.get_unit_multiplication(steradianSquareMetre, hertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/steradianSquareMetreHertz', system_of_units=None)
    jouleSecondTime = Unit.get_unit_multiplication(joule, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/jouleSecond-Time', system_of_units=None)
    gigayearCubicKiloparsec = Unit.get_unit_multiplication(gigayear, cubicKiloparsec, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigayearCubicKiloparsec', system_of_units=None)
    hectojoule = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=joule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectojoule', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptonewton = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=newton, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptonewton', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    hectopascal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=pascal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectopascal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    micropascal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=pascal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/micropascal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    microjoule = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=joule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microjoule', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottapascal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=pascal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottapascal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    millimetreOfMercury = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=metreOfMercury, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millimetreOfMercury', system_of_units=None, is_base_unit=False)
    centisteradian = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=steradian, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centisteradian', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    millisteradian = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=steradian, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millisteradian', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    picojoule = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=joule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picojoule', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petajoule = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=joule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petajoule', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decapascal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=pascal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decapascal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gigapascal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=pascal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigapascal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centipascal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=pascal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centipascal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    exajoule = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=joule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exajoule', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megamolair = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=molair, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megamolair', system_of_units=None, is_base_unit=False)
    microbar = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=bar, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microbar', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondSystemOfUnits', is_base_unit=False)
    decibar = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=bar, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decibar', system_of_units=None, is_base_unit=False)
    zeptopascal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=pascal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptopascal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decisteradian = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=steradian, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decisteradian', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanopascal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=pascal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanopascal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    picosteradian = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=steradian, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picosteradian', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    microsteradian = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=steradian, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microsteradian', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    terapascal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=pascal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/terapascal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centimetreOfMercury = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=metreOfMercury, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centimetreOfMercury', system_of_units=None, is_base_unit=False)
    decijoule = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=joule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decijoule', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettajoule = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=joule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettajoule', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctopascal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=pascal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctopascal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centibecquerel = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=becquerel, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centibecquerel', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megaerg = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=erg, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megaerg', system_of_units=None, is_base_unit=False)
    nanosteradian = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=steradian, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanosteradian', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kilopascal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=pascal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilopascal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtopascal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=pascal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtopascal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanojoule = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=joule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanojoule', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptosteradian = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=steradian, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptosteradian', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decipascal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=pascal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decipascal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petapascal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=pascal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petapascal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attojoule = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=joule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attojoule', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtojoule = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=joule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtojoule', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    millipascal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=pascal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millipascal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctojoule = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=joule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctojoule', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctosteradian = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=steradian, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctosteradian', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    millijoule = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=joule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millijoule', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centistokes = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=stokes, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centistokes', system_of_units=None, is_base_unit=False)
    kilojoule = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=joule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilojoule', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctonewton = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=newton, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctonewton', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    millibar = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=bar, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millibar', system_of_units=None, is_base_unit=False)
    centijoule = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=joule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centijoule', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettapascal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=pascal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettapascal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attosteradian = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=steradian, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attosteradian', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megapascal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=pascal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megapascal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    micronewton = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=newton, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/micronewton', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    secondHourAngle = Unit.get_singular_unit([Literal('second (hour angle)', lang='en'), Literal('seconde (uurhoek)', lang='nl')], Literal('s'), base_unit=degree, factor=0.0041666667, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/second-HourAngle', system_of_units=None, is_base_unit=False)
    atmosphereStandard = Unit.get_singular_unit([Literal('atmosfeer (standaard)', lang='nl'), Literal('atmosphere (standard)', lang='en')], Literal('atm'), base_unit=pascal, factor=101325.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/atmosphere-Standard', system_of_units=None, is_base_unit=False)
    calorieInternationalTable = Unit.get_singular_unit(Literal('calorie (International Table)', lang='en'), Literal('cal_IT'), base_unit=joule, factor=4.1868, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/calorie-InternationalTable', system_of_units=None, is_base_unit=False)
    BritishThermalUnit39F = Unit.get_singular_unit([Literal('British thermal unit (39 °F)', lang='en'), Literal('英国热力单位（39°F）', lang='zh')], Literal('Btu'), base_unit=joule, factor=1059.67, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/BritishThermalUnit-39F', system_of_units=None, is_base_unit=False)
    BritishThermalUnitMean = Unit.get_singular_unit([Literal('British thermal unit (mean)', lang='en'), Literal('英国热力单位（平均）', lang='zh')], Literal('Btu'), base_unit=joule, factor=1055.87, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/BritishThermalUnit-Mean', system_of_units=None, is_base_unit=False)
    BritishThermalUnit60F = Unit.get_singular_unit([Literal('英国热力单位（60°F）', lang='zh'), Literal('British thermal unit (60 °F)', lang='en')], Literal('Btu'), base_unit=joule, factor=1054.68, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/BritishThermalUnit-60F', system_of_units=None, is_base_unit=False)
    dessertspoon = Unit.get_singular_unit(Literal('dessertspoon', lang='en'), None, base_unit=teaspoonUS, factor=2.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/dessertspoon', system_of_units=None, is_base_unit=False)
    torr = Unit.get_singular_unit([Literal('torr', lang='en'), Literal('torr', lang='nl')], Literal('Torr'), base_unit=pascal, factor=133.322368421053, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/torr', system_of_units=None, is_base_unit=False)
    BritishThermalUnit59F = Unit.get_singular_unit([Literal('British thermal unit (59 °F)', lang='en'), Literal('英国热力单位（59°F）', lang='zh')], Literal('Btu'), base_unit=joule, factor=1054.8, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/BritishThermalUnit-59F', system_of_units=None, is_base_unit=False)
    poise = Unit.get_singular_unit([Literal('poise', lang='en'), Literal('poise', lang='nl')], Literal('P'), base_unit=pascalSecondTime, factor=0.1, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/poise', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondSystemOfUnits', is_base_unit=False)
    BritishThermalUnitThermochemical = Unit.get_singular_unit([Literal('British thermal unit (thermochemical)', lang='en'), Literal('英国热力单位（热力化学）', lang='zh')], Literal('Btu_th'), base_unit=joule, factor=1054.35, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/BritishThermalUnit-Thermochemical', system_of_units=None, is_base_unit=False)
    watt = Unit.get_singular_unit([Literal('watt', lang='en'), Literal('watt', lang='nl')], Literal('W'), base_unit=joulePerSecondTime, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/watt', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/metre-Kilogram-Second-AmpereSystemOfUnits')], is_base_unit=False)
    calorieMean = Unit.get_singular_unit(Literal('calorie (mean)', lang='en'), Literal('cal'), base_unit=joule, factor=4.19002, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/calorie-Mean', system_of_units=None, is_base_unit=False)
    calorie20C = Unit.get_singular_unit([Literal('calorie (20 °C)', lang='en'), Literal('calorie (20 °C)', lang='nl')], Literal('cal_20'), base_unit=joule, factor=4.1819, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/calorie-20C', system_of_units=None, is_base_unit=False)
    thermEC = Unit.get_singular_unit(Literal('therm (EC)', lang='en'), None, base_unit=joule, factor=105506000.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/therm-EC', system_of_units=None, is_base_unit=False)
    electronvolt = Unit.get_singular_unit([Literal('electronvolt', lang='en'), Literal('electronvolt', lang='nl'), Literal('电子伏特', lang='zh')], Literal('eV'), base_unit=joule, factor=1.602177e-19, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/electronvolt', system_of_units=None, is_base_unit=False)
    gray = Unit.get_singular_unit([Literal('gray', lang='nl'), Literal('gray', lang='en')], Literal('Gy'), base_unit=joulePerKilogram, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gray', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    barye = Unit.get_singular_unit([Literal('barye', lang='en'), Literal('barye', lang='nl')], Literal('ba'), base_unit=pascal, factor=0.1, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/barye', system_of_units=None, is_base_unit=False)
    sievert = Unit.get_singular_unit([Literal('sievert', lang='nl'), Literal('sievert', lang='en')], Literal('Sv'), base_unit=joulePerKilogram, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/sievert', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    candelaPerSquareMetre = Unit.get_unit_division(candela, squareMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/candelaPerSquareMetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    kilojoulePerSquareMetreDay = Unit.get_unit_division(kilojoule, squareMetreDay, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilojoulePerSquareMetreDay', system_of_units=None)
    joulePerMole = Unit.get_unit_division(joule, mole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/joulePerMole', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    megametrePerKilojoule = Unit.get_unit_division(megametre, kilojoule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megametrePerKilojoule', system_of_units=None)
    wattPerSteradianSquareMetre = Unit.get_unit_division(watt, steradianSquareMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/wattPerSteradianSquareMetre', system_of_units=None)
    wattPerSquareMetreSteradian = Unit.get_unit_division(watt, squareMetreSteradian, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/wattPerSquareMetreSteradian', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    wattPerSteradian = Unit.get_unit_division(watt, steradian, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/wattPerSteradian', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    squareMetreKelvinPerWatt = Unit.get_unit_division(squareMetreKelvin, watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareMetreKelvinPerWatt', system_of_units=None)
    squareMetrePerSquareMetreDay = Unit.get_unit_division(squareMetrePerSquareMetre, day, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareMetrePerSquareMetreDay', system_of_units=None)
    kilogramPerCubicmetre = Unit.get_unit_division(kilogram, cubicMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilogramPerCubicmetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    wattPerAmpere = Unit.get_unit_division(watt, ampere, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/wattPerAmpere', system_of_units=None)
    wattPerSquareMetreHertz = Unit.get_unit_division(watt, squareMetreHertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/wattPerSquareMetreHertz', system_of_units=None)
    kelvinPerWatt = Unit.get_unit_division(kelvin, watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kelvinPerWatt', system_of_units=None)
    joulePerKelvinKilogram = Unit.get_unit_division(joule, kelvinKilogram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/joulePerKelvinKilogram', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    solarMassPerGigayearCubicKiloparsec = Unit.get_unit_division(solarMass, gigayearCubicKiloparsec, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/solarMassPerGigayearCubicKiloparsec', system_of_units=None)
    wattPerSecondAngleSquared = Unit.get_unit_division(watt, secondAngleSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/wattPerSecond-AngleSquared', system_of_units=None)
    wattPerSteradianSquareMetreHertz = Unit.get_unit_division(watt, steradianSquareMetreHertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/wattPerSteradianSquareMetreHertz', system_of_units=None)
    wattPerNanometre = Unit.get_unit_division(watt, nanometre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/wattPerNanometre', system_of_units=None)
    cubicMillimetrePerCubicMillimetre = Unit.get_unit_division(cubicMillimetre, cubicMillimetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicMillimetrePerCubicMillimetre', system_of_units=None)
    joulePerSquareMetreDay = Unit.get_unit_division(joule, squareMetreDay, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/joulePerSquareMetreDay', system_of_units=None)
    metrePerMillisecondTime = Unit.get_unit_division(metre, millisecondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerMillisecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    femtogramPerLitre = Unit.get_unit_division(femtogram, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtogramPerLitre', system_of_units=None)
    microgramPerLitre = Unit.get_unit_division(microgram, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microgramPerLitre', system_of_units=None)
    metrePerAttosecondTimeSquared = Unit.get_unit_division(metre, attosecondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerAttosecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerMegasecondTimeSquared = Unit.get_unit_division(metre, megasecondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerMegasecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    centimolePerMetre = Unit.get_unit_division(centimole, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centimolePerMetre', system_of_units=None)
    centimetrePerSecondTimeSquared = Unit.get_unit_division(centimetre, secondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centimetrePerSecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    molePerDecimetre = Unit.get_unit_division(mole, decimetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerDecimetre', system_of_units=None)
    gigamolePerLitre = Unit.get_unit_division(gigamole, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigamolePerLitre', system_of_units=None)
    gramPerDecalitre = Unit.get_unit_division(gram, decalitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerDecalitre', system_of_units=None)
    gramPerMicrolitre = Unit.get_unit_division(gram, microlitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerMicrolitre', system_of_units=None)
    gramPerMegalitre = Unit.get_unit_division(gram, megalitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerMegalitre', system_of_units=None)
    molePerExalitre = Unit.get_unit_division(mole, exalitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerExalitre', system_of_units=None)
    molePerPicolitre = Unit.get_unit_division(mole, picolitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerPicolitre', system_of_units=None)
    reciprocalWatt = Unit.get_unit_exponentiation(watt, -1, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/reciprocalWatt', system_of_units=None)
    reciprocalAtmosphereStandard = Unit.get_unit_exponentiation(atmosphereStandard, -1, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/reciprocalAtmosphere-Standard', system_of_units=None)
    squareDecametre = Unit.get_unit_exponentiation(decametre, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareDecametre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    femtosecondTimeSquared = Unit.get_unit_exponentiation(femtosecondTime, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtosecond-TimeSquared', system_of_units=None)
    wattSquareMetre = Unit.get_unit_multiplication(watt, squareMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/wattSquareMetre', system_of_units=None)
    pascalSecondTimeSquareMetre = Unit.get_unit_multiplication(pascalSecondTime, squareMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/pascalSecond-TimeSquareMetre', system_of_units=None)
    wattHour = Unit.get_unit_multiplication(watt, hour, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/wattHour', system_of_units=None)
    hectareDay = Unit.get_unit_multiplication(hectare, day, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectareDay', system_of_units=None)
    ergSecondTime = Unit.get_unit_multiplication(erg, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/ergSecond-Time', system_of_units=None)
    deciwatt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/deciwatt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    exagray = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=gray, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exagray', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attopascal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=pascal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attopascal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    picowatt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picowatt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decigray = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=gray, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decigray', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanowatt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanowatt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megawatt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megawatt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gigagray = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=gray, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigagray', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptogray = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=gray, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptogray', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettawatt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettawatt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    picopascal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=pascal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picopascal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gigajoule = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=joule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigajoule', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petasievert = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=sievert, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petasievert', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centiwatt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centiwatt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptosievert = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=sievert, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptosievert', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptomolair = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=molair, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptomolair', system_of_units=None, is_base_unit=False)
    decajoule = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=joule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decajoule', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottagray = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=gray, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottagray', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kilosievert = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=sievert, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilosievert', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megaelectronvolt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=electronvolt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megaelectronvolt', system_of_units=None, is_base_unit=False)
    hectosievert = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=sievert, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectosievert', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottajoule = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=joule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottajoule', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    hectowatt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectowatt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attosievert = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=sievert, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attosievert', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megajoule = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=joule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megajoule', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petawatt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petawatt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gigasievert = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=sievert, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigasievert', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centisievert = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=sievert, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centisievert', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    terajoule = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=joule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/terajoule', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kilowatt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilowatt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decisievert = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=sievert, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decisievert', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    microwatt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microwatt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    picosievert = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=sievert, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picosievert', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    millinewton = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=newton, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millinewton', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanosievert = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=sievert, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanosievert', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    teragray = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=gray, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/teragray', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottasievert = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=sievert, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottasievert', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    picogray = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=gray, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picogray', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decasievert = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=sievert, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decasievert', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    microgray = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=gray, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microgray', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attogray = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=gray, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attogray', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctogray = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=gray, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctogray', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    terasievert = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=sievert, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/terasievert', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtosievert = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=sievert, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtosievert', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centipoise = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=poise, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centipoise', system_of_units=None, is_base_unit=False)
    yoctowatt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctowatt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    microsievert = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=sievert, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microsievert', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centigray = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=gray, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centigray', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    millisievert = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=sievert, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millisievert', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gigaelectronvolt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=electronvolt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigaelectronvolt', system_of_units=None, is_base_unit=False)
    kilocalorieMean = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=calorieMean, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilocalorie-Mean', system_of_units=None, is_base_unit=False)
    gigawatt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigawatt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decawatt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decawatt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    exapascal = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=pascal, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exapascal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptowatt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptowatt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettasievert = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=sievert, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettasievert', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    milligray = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=gray, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/milligray', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctosievert = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=sievert, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctosievert', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    exasievert = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=sievert, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exasievert', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanogray = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=gray, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanogray', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    hectogray = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=gray, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectogray', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petagray = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=gray, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petagray', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    BritishThermalUnitInternationalTable = Unit.get_singular_unit([Literal('British thermal unit (International Table)', lang='en'), Literal('英国热力单位（国际表）', lang='zh')], Literal('Btu_IT'), base_unit=joule, factor=1055.056, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/BritishThermalUnit-InternationalTable', system_of_units=None, is_base_unit=False)
    horsepowerElectric = Unit.get_singular_unit(Literal('horsepower (electric)', lang='en'), None, base_unit=watt, factor=746.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/horsepower-Electric', system_of_units=None, is_base_unit=False)
    horsepowerBritish = Unit.get_singular_unit(Literal('horsepower (British)', lang='en'), None, base_unit=watt, factor=745.7, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/horsepower-British', system_of_units=None, is_base_unit=False)
    solarLuminosity = Unit.get_singular_unit(Literal('solar luminosity', lang='en'), Literal('L_☉'), base_unit=watt, factor=3.839e+26, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/solarLuminosity', system_of_units=None, is_base_unit=False)
    tonOfRefrigeration = Unit.get_singular_unit(Literal('ton of refrigeration', lang='en'), None, base_unit=watt, factor=3516.853, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/tonOfRefrigeration', system_of_units=None, is_base_unit=False)
    lambert = Unit.get_singular_unit([Literal('lambert', lang='en'), Literal('lambert', lang='nl')], None, base_unit=candelaPerSquareMetre, factor=3183.099, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/lambert', system_of_units=None, is_base_unit=False)
    rem = Unit.get_singular_unit([Literal('rem', lang='en'), Literal('rem', lang='nl')], Literal('rem'), base_unit=sievert, factor=0.01, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/rem', system_of_units=None, is_base_unit=False)
    horsepowerBoiler = Unit.get_singular_unit(Literal('horsepower (boiler)', lang='en'), None, base_unit=watt, factor=9809.5, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/horsepower-Boiler', system_of_units=None, is_base_unit=False)
    gal = Unit.get_singular_unit([Literal('gal', lang='en'), Literal('gal', lang='nl')], Literal('Gal'), base_unit=centimetrePerSecondTimeSquared, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gal', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondSystemOfUnits', is_base_unit=False)
    horsepowerWater = Unit.get_singular_unit(Literal('horsepower (water)', lang='en'), None, base_unit=watt, factor=746.043, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/horsepower-Water', system_of_units=None, is_base_unit=False)
    footlambert = Unit.get_singular_unit(Literal('footlambert', lang='en'), None, base_unit=candelaPerSquareMetre, factor=3.426259, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/footlambert', system_of_units=None, is_base_unit=False)
    volt = Unit.get_singular_unit([Literal('volt', lang='nl'), Literal('volt', lang='en')], Literal('V'), base_unit=wattPerAmpere, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/volt', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/metre-Kilogram-Second-AmpereSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')], is_base_unit=False)
    calorieThermochemical = Unit.get_singular_unit(Literal('calorie (thermochemical)', lang='en'), Literal('cal_th'), base_unit=joule, factor=4.184, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/calorie-Thermochemical', system_of_units=None, is_base_unit=False)
    thermUS = Unit.get_singular_unit(Literal('therm (US)', lang='en'), None, base_unit=joule, factor=105480400.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/therm-US', system_of_units=None, is_base_unit=False)
    statvolt = Unit.get_singular_unit([Literal('statvolt', lang='nl'), Literal('statvolt', lang='en')], Literal('statV'), base_unit=volt, factor=299.7925, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/statvolt', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectrostaticSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/GaussianSystemOfUnits')], is_base_unit=False)
    gramPerSquareMetreMetre = Unit.get_unit_division(gramPerSquareMetre, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerSquareMetreMetre', system_of_units=None)
    wattPerCubicmetre = Unit.get_unit_division(watt, cubicMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/wattPerCubicmetre', system_of_units=None)
    megaeuroPerMegawatt = Unit.get_unit_division(megaeuro, megawatt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megaeuroPerMegawatt', system_of_units=None)
    wattPerSquareMetreKelvin = Unit.get_unit_division(watt, squareMetreKelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/wattPerSquareMetreKelvin', system_of_units=None)
    microgramPerSquareMetreSecondTime = Unit.get_unit_division(microgram, squareMetreSecondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microgramPerSquareMetreSecond-Time', system_of_units=None)
    megajoulePerSquareMetreDay = Unit.get_unit_division(megajoule, squareMetreDay, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megajoulePerSquareMetreDay', system_of_units=None)
    wattPerSquareMetre = Unit.get_unit_division(watt, squareMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/wattPerSquareMetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    kilojoulePerHectogram = Unit.get_unit_division(kilojoule, hectogram, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilojoulePerHectogram', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    wattPerSquareMetreNanometre = Unit.get_unit_division(watt, squareMetreNanometre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/wattPerSquareMetreNanometre', system_of_units=None)
    coulombPerVolt = Unit.get_unit_division(coulomb, volt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/coulombPerVolt', system_of_units=None)
    gramPerMegajoule = Unit.get_unit_division(gram, megajoule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerMegajoule', system_of_units=None)
    joulePerCubicMetreKelvin = Unit.get_unit_division(joule, cubicMetreKelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/joulePerCubicMetreKelvin', system_of_units=None)
    grayPerSecondTime = Unit.get_unit_division(gray, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/grayPerSecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    kilogramPerHectareDay = Unit.get_unit_division(kilogram, hectareDay, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilogramPerHectareDay', system_of_units=None)
    kilogramPerPascalSecondTimeSquareMetre = Unit.get_unit_division(kilogram, pascalSecondTimeSquareMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilogramPerPascalSecond-TimeSquareMetre', system_of_units=None)
    hectometrePerSecondTime = Unit.get_unit_division(hectometre, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectometrePerSecond-Time', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerZeptosecondTimeSquared = Unit.get_unit_division(metre, zeptosecondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerZeptosecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    metrePerTerasecondTimeSquared = Unit.get_unit_division(metre, terasecondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerTerasecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    yottamolePerMetre = Unit.get_unit_division(yottamole, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottamolePerMetre', system_of_units=None)
    attomolePerLitre = Unit.get_unit_division(attomole, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attomolePerLitre', system_of_units=None)
    gramPerPicolitre = Unit.get_unit_division(gram, picolitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerPicolitre', system_of_units=None)
    molePerNanolitre = Unit.get_unit_division(mole, nanolitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerNanolitre', system_of_units=None)
    molePerAttolitre = Unit.get_unit_division(mole, attolitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerAttolitre', system_of_units=None)
    cubicYottametre = Unit.get_unit_exponentiation(yottametre, 3, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/cubicYottametre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    micronewtonMetre = Unit.get_unit_multiplication(micronewton, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/micronewtonMetre', system_of_units=None)
    millinewtonMetre = Unit.get_unit_multiplication(millinewton, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millinewtonMetre', system_of_units=None)
    candelaSteradian = Unit.get_unit_multiplication(candela, steradian, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/candelaSteradian', system_of_units=None)
    yoctovolt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=volt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctovolt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtosteradian = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=steradian, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtosteradian', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    exawatt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exawatt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kilovolt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=volt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilovolt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    milliwatt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/milliwatt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attowatt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attowatt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    microvolt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=volt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microvolt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attovolt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=volt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attovolt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decagray = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=gray, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decagray', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptovolt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=volt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptovolt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kiloelectronvolt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=electronvolt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kiloelectronvolt', system_of_units=None, is_base_unit=False)
    yottawatt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottawatt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    exavolt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=volt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exavolt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    terawatt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/terawatt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtovolt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=volt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtovolt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottavolt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=volt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottavolt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    picovolt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=volt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picovolt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    hectovolt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=volt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectovolt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanovolt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=volt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanovolt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decavolt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=volt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decavolt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centivolt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=volt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centivolt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petavolt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=volt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petavolt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtowatt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtowatt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megagray = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=gray, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megagray', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megavolt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=volt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megavolt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettagray = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=gray, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettagray', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    millivolt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=volt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millivolt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kilogray = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=gray, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilogray', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettavolt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=volt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettavolt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptojoule = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=joule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptojoule', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megasievert = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=sievert, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megasievert', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    lumen = Unit.get_singular_unit([Literal('lumen', lang='nl'), Literal('lumen', lang='en')], Literal('lm'), base_unit=candelaSteradian, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/lumen', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    perm23C = Unit.get_singular_unit([Literal('perm (23 °C)', lang='en'), Literal('perm (23 °C)', lang='nl')], None, base_unit=kilogramPerPascalSecondTimeSquareMetre, factor=5.74525e-11, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/perm-23C', system_of_units=None, is_base_unit=False)
    perm0C = Unit.get_singular_unit([Literal('perm (0 °C)', lang='nl'), Literal('perm (0 °C)', lang='en')], None, base_unit=kilogramPerPascalSecondTimeSquareMetre, factor=5.72135e-11, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/perm-0C', system_of_units=None, is_base_unit=False)
    farad = Unit.get_singular_unit([Literal('farad', lang='nl'), Literal('farad', lang='en')], Literal('F'), base_unit=coulombPerVolt, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/farad', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/metre-Kilogram-Second-AmpereSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')], is_base_unit=False)
    rad = Unit.get_singular_unit([Literal('rad', lang='en'), Literal('rad', lang='nl')], Literal('rad'), base_unit=gray, factor=0.01, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/rad', system_of_units=None, is_base_unit=False)
    footPoundal = Unit.get_singular_unit(Literal('foot poundal', lang='en'), None, base_unit=joule, factor=0.04214011, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/footPoundal', system_of_units=None, is_base_unit=False)
    horsepowerMetric = Unit.get_singular_unit(Literal('horsepower (metric)', lang='en'), Literal('PS'), base_unit=watt, factor=735.4988, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/horsepower-Metric', system_of_units=None, is_base_unit=False)
    calorie15C = Unit.get_singular_unit([Literal('calorie (15 °C)', lang='en'), Literal('calorie (15 °C)', lang='nl')], Literal('cal_15'), base_unit=joule, factor=4.1858, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/calorie-15C', system_of_units=None, is_base_unit=False)
    stilb = Unit.get_singular_unit([Literal('stilb', lang='nl'), Literal('stilb', lang='en')], Literal('sb'), base_unit=candelaPerSquareMetre, factor=10000.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/stilb', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondSystemOfUnits', is_base_unit=False)
    lumenPerSquareMetre = Unit.get_unit_division(lumen, squareMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/lumenPerSquareMetre', system_of_units=None)
    voltPerMetre = Unit.get_unit_division(volt, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/voltPerMetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    joulePerKelvinMole = Unit.get_unit_division(joule, kelvinMole, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/joulePerKelvinMole', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    faradPerMetre = Unit.get_unit_division(farad, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/faradPerMetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    kilogramPerGigajoule = Unit.get_unit_division(kilogram, gigajoule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilogramPerGigajoule', system_of_units=None)
    lumenPerWatt = Unit.get_unit_division(lumen, watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/lumenPerWatt', system_of_units=None)
    megajoulePerSquareMetre = Unit.get_unit_division(megajoule, squareMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megajoulePerSquareMetre', system_of_units=None)
    wattPerMetreKelvin = Unit.get_unit_division(watt, metreKelvin, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/wattPerMetreKelvin', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    amperePerVolt = Unit.get_unit_division(ampere, volt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/amperePerVolt', system_of_units=None)
    metrePerFemtosecondTimeSquared = Unit.get_unit_division(metre, femtosecondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerFemtosecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    molePerPicometre = Unit.get_unit_division(mole, picometre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerPicometre', system_of_units=None)
    gramPerYottalitre = Unit.get_unit_division(gram, yottalitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerYottalitre', system_of_units=None)
    reciprocalPascalSecondTime = Unit.get_unit_exponentiation(pascalSecondTime, -1, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/reciprocalPascalSecond-Time', system_of_units=None)
    squareZeptometre = Unit.get_unit_exponentiation(zeptometre, 2, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/squareZeptometre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    terawattHour = Unit.get_unit_multiplication(terawatt, hour, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/terawattHour', system_of_units=None)
    kilowattHour = Unit.get_unit_multiplication(kilowatt, hour, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilowattHour', system_of_units=None)
    lumenSecondTime = Unit.get_unit_multiplication(lumen, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/lumenSecond-Time', system_of_units=None)
    decilumen = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=lumen, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decilumen', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decifarad = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=farad, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decifarad', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    picolumen = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=lumen, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picolumen', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottafarad = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=farad, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottafarad', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centilumen = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=lumen, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centilumen', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attolumen = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=lumen, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attolumen', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptofarad = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=farad, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptofarad', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtogray = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=gray, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtogray', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettafarad = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=farad, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettafarad', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtolumen = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=lumen, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtolumen', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctolumen = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=lumen, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctolumen', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottalumen = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=lumen, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottalumen', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    hectofarad = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=farad, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectofarad', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanolumen = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=lumen, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanolumen', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    exalumen = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=lumen, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exalumen', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decivolt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=volt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decivolt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    picofarad = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=farad, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picofarad', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanofarad = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=farad, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanofarad', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    teralumen = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=lumen, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/teralumen', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctofarad = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=farad, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctofarad', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    exafarad = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=farad, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exafarad', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petafarad = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=farad, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petafarad', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptolumen = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=lumen, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptolumen', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    millilumen = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=lumen, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millilumen', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    terafarad = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=farad, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/terafarad', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kilolumen = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=lumen, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilolumen', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gigalumen = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=lumen, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigalumen', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    millifarad = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=farad, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millifarad', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megalumen = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=lumen, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megalumen', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettalumen = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=lumen, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettalumen', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    teravolt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=volt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/teravolt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    microfarad = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=farad, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microfarad', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megafarad = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=farad, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megafarad', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gigavolt = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=volt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigavolt', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kilofarad = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=farad, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilofarad', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    microlumen = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=lumen, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microlumen', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    abfarad = Unit.get_singular_unit([Literal('abfarad', lang='en'), Literal('abfarad', lang='nl')], Literal('abF'), base_unit=farad, factor=1000000000.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/abfarad', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectromagneticSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/GaussianSystemOfUnits')], is_base_unit=False)
    quad = Unit.get_singular_unit(Literal('quad', lang='en'), None, base_unit=BritishThermalUnitInternationalTable, factor=1000000000000000.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/quad', system_of_units=None, is_base_unit=False)
    rhe = Unit.get_singular_unit([Literal('rhe', lang='nl'), Literal('rhe', lang='en')], None, base_unit=reciprocalPascalSecondTime, factor=10.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/rhe', system_of_units=None, is_base_unit=False)
    statfarad = Unit.get_singular_unit([Literal('statfarad', lang='nl'), Literal('statfarad', lang='en')], Literal('statF'), base_unit=farad, factor=1.11265e-12, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/statfarad', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectrostaticSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/GaussianSystemOfUnits')], is_base_unit=False)
    siemens = Unit.get_singular_unit([Literal('siemens', lang='nl'), Literal('siemens', lang='en')], Literal('S'), base_unit=amperePerVolt, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/siemens', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    lux = Unit.get_singular_unit([Literal('lux', lang='nl'), Literal('lux', lang='en')], Literal('lx'), base_unit=lumenPerSquareMetre, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/lux', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    abmho = Unit.get_singular_unit([Literal('abmho', lang='en'), Literal('abmho', lang='nl')], None, base_unit=siemens, factor=1000000000.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/abmho', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectromagneticSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/GaussianSystemOfUnits')], is_base_unit=False)
    voltPerAmpere = Unit.get_unit_division(volt, ampere, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/voltPerAmpere', system_of_units=None)
    wattPerHertz = Unit.get_unit_division(watt, hertz, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/wattPerHertz', system_of_units=None)
    voltPerWatt = Unit.get_unit_division(volt, watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/voltPerWatt', system_of_units=None)
    siemensPerMetre = Unit.get_unit_division(siemens, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/siemensPerMetre', system_of_units=None)
    yottagramPerLitre = Unit.get_unit_division(yottagram, litre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottagramPerLitre', system_of_units=None)
    gramPerZeptolitre = Unit.get_unit_division(gram, zeptolitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gramPerZeptolitre', system_of_units=None)
    voltSecondTime = Unit.get_unit_multiplication(volt, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/voltSecond-Time', system_of_units=None)
    hectosiemens = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=siemens, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectosiemens', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctosiemens = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=siemens, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctosiemens', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petasiemens = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=siemens, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petasiemens', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettalux = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=lux, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettalux', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanosiemens = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=siemens, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanosiemens', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kilolux = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=lux, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilolux', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attofarad = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=farad, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attofarad', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptolux = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=lux, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptolux', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettasiemens = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=siemens, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettasiemens', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centilux = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=lux, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centilux', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gigalux = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=lux, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigalux', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    millisiemens = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=siemens, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millisiemens', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    picosiemens = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=siemens, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picosiemens', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gigasiemens = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=siemens, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigasiemens', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    teralux = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=lux, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/teralux', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megasiemens = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=siemens, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megasiemens', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtofarad = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=farad, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtofarad', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtolux = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=lux, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtolux', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptosiemens = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=siemens, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptosiemens', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decalux = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=lux, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decalux', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottasiemens = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=siemens, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottasiemens', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petalumen = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=lumen, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petalumen', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    hectolumen = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=lumen, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectolumen', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    hectolux = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=lux, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectolux', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gigafarad = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=farad, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigafarad', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megalux = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=lux, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megalux', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attolux = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=lux, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attolux', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    millilux = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=lux, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millilux', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    exalux = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=lux, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exalux', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    microsiemens = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=siemens, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microsiemens', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottalux = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=lux, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottalux', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    picolux = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=lux, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picolux', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decafarad = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=farad, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decafarad', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    microlux = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=lux, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microlux', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    footcandle = Unit.get_singular_unit(Literal('footcandle', lang='en'), None, base_unit=lux, factor=10.76391, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/footcandle', system_of_units=None, is_base_unit=False)
    weber = Unit.get_singular_unit([Literal('weber', lang='en'), Literal('weber', lang='nl')], Literal('Wb'), base_unit=voltSecondTime, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/weber', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/metre-Kilogram-Second-AmpereSystemOfUnits')], is_base_unit=False)
    statmho = Unit.get_singular_unit([Literal('statmho', lang='nl'), Literal('statmho', lang='en')], None, base_unit=siemens, factor=1.11265e-12, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/statmho', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectrostaticSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/GaussianSystemOfUnits')], is_base_unit=False)
    ohm = Unit.get_singular_unit([Literal('ohm', lang='en'), Literal('ohm', lang='nl')], Literal('Ω'), base_unit=voltPerAmpere, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/ohm', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/metre-Kilogram-Second-AmpereSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')], is_base_unit=False)
    abvolt = Unit.get_singular_unit([Literal('abvolt', lang='en'), Literal('abvolt', lang='nl')], Literal('abV'), base_unit=volt, factor=1e-08, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/abvolt', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/GaussianSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectromagneticSystemOfUnits')], is_base_unit=False)
    statohm = Unit.get_singular_unit([Literal('statohm', lang='en'), Literal('statohm', lang='nl')], Literal('statΩ'), base_unit=ohm, factor=898755200000.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/statohm', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/GaussianSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectrostaticSystemOfUnits')], is_base_unit=False)
    abohm = Unit.get_singular_unit([Literal('abohm', lang='nl'), Literal('abohm', lang='en')], Literal('abΩ'), base_unit=ohm, factor=1e-09, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/abohm', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectromagneticSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/GaussianSystemOfUnits')], is_base_unit=False)
    amperePerWatt = Unit.get_unit_division(ampere, watt, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/amperePerWatt', system_of_units=None)
    weberPerAmpere = Unit.get_unit_division(weber, ampere, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/weberPerAmpere', system_of_units=None)
    weberPerSquareMetre = Unit.get_unit_division(weber, squareMetre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/weberPerSquareMetre', system_of_units=None)
    molePerTeralitre = Unit.get_unit_division(mole, teralitre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/molePerTeralitre', system_of_units=None)
    ohmMetre = Unit.get_unit_multiplication(ohm, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/ohmMetre', system_of_units=None)
    kilosiemens = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=siemens, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilosiemens', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    exasiemens = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=siemens, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exasiemens', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    picoohm = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=ohm, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picoohm', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptoohm = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=ohm, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptoohm', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanolux = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=lux, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanolux', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    deciweber = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=weber, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/deciweber', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centifarad = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=farad, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centifarad', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attoohm = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=ohm, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attoohm', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    microohm = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=ohm, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microohm', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    picoweber = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=weber, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picoweber', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kilohm = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=ohm, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilohm', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    exaweber = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=weber, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exaweber', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottaweber = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=weber, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottaweber', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petaohm = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=ohm, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petaohm', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decasiemens = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=siemens, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decasiemens', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    deciohm = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=ohm, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/deciohm', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megohm = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=ohm, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megohm', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtoweber = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=weber, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtoweber', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctolux = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=lux, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctolux', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decalumen = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=lumen, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decalumen', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gigaohm = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=ohm, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigaohm', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centisiemens = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=siemens, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centisiemens', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanoohm = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=ohm, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanoohm', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petalux = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=lux, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petalux', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attosiemens = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=siemens, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attosiemens', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kiloweber = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=weber, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kiloweber', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megaweber = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=weber, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megaweber', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    milliohm = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=ohm, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/milliohm', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottaohm = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=ohm, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottaohm', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decaohm = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=ohm, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decaohm', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctoweber = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=weber, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctoweber', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtoohm = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=ohm, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtoohm', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decaweber = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=weber, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decaweber', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctoohm = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=ohm, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctoohm', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    statweber = Unit.get_singular_unit([Literal('statweber', lang='nl'), Literal('statweber', lang='en')], Literal('statWb'), base_unit=weber, factor=299.79, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/statweber', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectrostaticSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/GaussianSystemOfUnits')], is_base_unit=False)
    henry = Unit.get_singular_unit([Literal('henry', lang='nl'), Literal('henry', lang='en')], Literal('H'), base_unit=weberPerAmpere, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/henry', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/metre-Kilogram-Second-AmpereSystemOfUnits')], is_base_unit=False)
    mho = Unit.get_singular_unit([Literal('mho', lang='nl'), Literal('mho', lang='en')], None, base_unit=siemens, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/mho', system_of_units=None, is_base_unit=False)
    maxwell = Unit.get_singular_unit([Literal('maxwell', lang='nl'), Literal('maxwell', lang='en')], Literal('Mx'), base_unit=weber, factor=1e-08, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/maxwell', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/GaussianSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectromagneticSystemOfUnits')], is_base_unit=False)
    tesla = Unit.get_singular_unit([Literal('tesla', lang='en'), Literal('tesla', lang='nl')], Literal('T'), base_unit=weberPerSquareMetre, factor=1.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/tesla', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/metre-Kilogram-Second-AmpereSystemOfUnits')], is_base_unit=False)
    henryPerMetre = Unit.get_unit_division(henry, metre, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/henryPerMetre', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    reciprocalHenry = Unit.get_unit_exponentiation(henry, -1, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/reciprocalHenry', system_of_units=None)
    zeptohenry = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=henry, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptohenry', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtotesla = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=tesla, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtotesla', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centitesla = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=tesla, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centitesla', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtohenry = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=henry, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtohenry', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    femtosiemens = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/femto', base_unit=siemens, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/femtosiemens', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    teraohm = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=ohm, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/teraohm', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megahenry = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=henry, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megahenry', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petahenry = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=henry, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petahenry', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettaweber = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=weber, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettaweber', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    microweber = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=weber, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microweber', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    hectohenry = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=henry, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectohenry', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    exatesla = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=tesla, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exatesla', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attoweber = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=weber, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attoweber', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decisiemens = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=siemens, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decisiemens', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettaohm = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=ohm, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettaohm', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decihenry = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=henry, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decihenry', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptoweber = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=weber, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptoweber', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gigatesla = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=tesla, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigatesla', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    millihenry = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=henry, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millihenry', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctotesla = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=tesla, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctotesla', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    hectotesla = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=tesla, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectotesla', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decatesla = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=tesla, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decatesla', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zettatesla = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=tesla, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettatesla', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    millitesla = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=tesla, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/millitesla', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yoctohenry = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yocto', base_unit=henry, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yoctohenry', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanohenry = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=henry, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanohenry', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    terahenry = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=henry, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/terahenry', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    kilotesla = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=tesla, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilotesla', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    picohenry = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=henry, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picohenry', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centiohm = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=ohm, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centiohm', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    microtesla = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=tesla, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microtesla', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    abhenry = Unit.get_singular_unit([Literal('abhenry', lang='nl'), Literal('abhenry', lang='en')], Literal('abH'), base_unit=henry, factor=1e-09, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/abhenry', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/GaussianSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectromagneticSystemOfUnits')], is_base_unit=False)
    stathenry = Unit.get_singular_unit([Literal('stathenry', lang='en'), Literal('stathenry', lang='nl')], Literal('statH'), base_unit=henry, factor=898755200000.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/stathenry', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/GaussianSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectrostaticSystemOfUnits')], is_base_unit=False)
    unitPole = Unit.get_singular_unit(Literal('unit pole', lang='en'), None, base_unit=weber, factor=1.256637e-07, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/unitPole', system_of_units=None, is_base_unit=False)
    stattesla = Unit.get_singular_unit([Literal('stattesla', lang='en'), Literal('stattesla', lang='nl')], Literal('statT'), base_unit=tesla, factor=2997900.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/stattesla', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/GaussianSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectrostaticSystemOfUnits')], is_base_unit=False)
    metrePerYottasecondTimeSquared = Unit.get_unit_division(metre, yottasecondTimeSquared, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/metrePerYottasecond-TimeSquared', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits')
    kilohenry = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/kilo', base_unit=henry, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/kilohenry', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    milliweber = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=weber, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/milliweber', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottatesla = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=tesla, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottatesla', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    yottahenry = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/yotta', base_unit=henry, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/yottahenry', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decahenry = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deca', base_unit=henry, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decahenry', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    teraweber = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=weber, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/teraweber', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decilux = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=lux, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decilux', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    decitesla = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/deci', base_unit=tesla, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/decitesla', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    exahenry = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=henry, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exahenry', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanoweber = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=weber, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanoweber', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    nanotesla = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/nano', base_unit=tesla, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/nanotesla', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gigaweber = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=weber, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigaweber', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    hectoohm = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=ohm, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectoohm', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    picotesla = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/pico', base_unit=tesla, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/picotesla', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    zeptotesla = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zepto', base_unit=tesla, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zeptotesla', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gauss = Unit.get_singular_unit([Literal('gauss', lang='en'), Literal('gauss', lang='nl')], Literal('G'), base_unit=tesla, factor=0.0001, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gauss', system_of_units=[rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/GaussianSystemOfUnits'), rdflib.term.URIRef('http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondElectromagneticSystemOfUnits')], is_base_unit=False)
    phot = Unit.get_singular_unit([Literal('phot', lang='nl'), Literal('phot', lang='en')], Literal('ph'), base_unit=lux, factor=10000.0, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/phot', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/centimetre-Gram-SecondSystemOfUnits', is_base_unit=False)
    luxSecondTime = Unit.get_unit_multiplication(lux, secondTime, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/luxSecond-Time', system_of_units=None)
    terasiemens = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=siemens, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/terasiemens', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petaweber = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=weber, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petaweber', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    microhenry = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/micro', base_unit=henry, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/microhenry', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centiweber = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=weber, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centiweber', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    teratesla = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/tera', base_unit=tesla, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/teratesla', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    hectoweber = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/hecto', base_unit=weber, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/hectoweber', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    centihenry = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/centi', base_unit=henry, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/centihenry', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    gamma = Unit.get_singular_unit([Literal('gamma', lang='nl'), Literal('gamma', lang='en')], Literal('γ'), base_unit=tesla, factor=1e-09, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gamma', system_of_units=None, is_base_unit=False)
    zettahenry = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/zetta', base_unit=henry, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/zettahenry', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    petatesla = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/peta', base_unit=tesla, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/petatesla', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    milligauss = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/milli', base_unit=gauss, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/milligauss', system_of_units=None, is_base_unit=False)
    exaohm = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/exa', base_unit=ohm, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/exaohm', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megaeuroPerPetajoule = Unit.get_unit_division(megaeuro, petajoule, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megaeuroPerPetajoule', system_of_units=None)
    gigahenry = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/giga', base_unit=henry, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/gigahenry', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attohenry = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=henry, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attohenry', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    attotesla = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/atto', base_unit=tesla, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/attotesla', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
    megatesla = Unit.get_prefixed_unit('http://www.ontology-of-units-of-measure.org/resource/om-2/mega', base_unit=tesla, identifier='http://www.ontology-of-units-of-measure.org/resource/om-2/megatesla', system_of_units='http://www.ontology-of-units-of-measure.org/resource/om-2/InternationalSystemOfUnits', is_base_unit=False)
