"""
    Exchange DataFeed Snapshot

    FactSet’s Exchange DataFeed Snapshot API provides cost-effective access to real-time and delayed global exchange data. Proprietary technology normalizes over 200 global exchanges and 150+ data fields. Asset types integrated include equities, futures, options, warrants, fixed income, mutual funds, ETFs, indices, commodities, and FX rates. <p>Cutting-edge technology ensures reliability and provides scalability that allow applications to request multiple items at a time. To simplify client-side development an entire response can be placed in a matrix or table for effortless integration into internal and external applications. Using specified output formats (CSV, XML, JSON) receive all standard fields by default or customize the list based on specific needs.</p></p>Below are the current hosts:</p><p>Production: api.factset.com<p>Sandbox: api-sandbox.factset.com</p>  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from fds.sdk.ExchangeDataFeedSnapshotAPISymbolList.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from fds.sdk.ExchangeDataFeedSnapshotAPISymbolList.exceptions import ApiAttributeError



class Fields(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'exchange': (str,),  # noqa: E501
            'product': (str,),  # noqa: E501
            'bid': (float,),  # noqa: E501
            'bid_date': (str,),  # noqa: E501
            'bid_time': (int,),  # noqa: E501
            'bid_vol': (int,),  # noqa: E501
            'bid_tick': (str,),  # noqa: E501
            'bid_close': (float,),  # noqa: E501
            'bid_close_date': (str,),  # noqa: E501
            'bid_close_vol': (int,),  # noqa: E501
            'bid_exch': (str,),  # noqa: E501
            'ask': (float,),  # noqa: E501
            'ask_date': (str,),  # noqa: E501
            'ask_time': (int,),  # noqa: E501
            'ask_vol': (int,),  # noqa: E501
            'ask_close': (float,),  # noqa: E501
            'ask_close_date': (str,),  # noqa: E501
            'ask_close_vol': (int,),  # noqa: E501
            'ask_exch': (str,),  # noqa: E501
            'short_sale_indicator': (int,),  # noqa: E501
            'quote_condition': (str,),  # noqa: E501
            'last_price': (float,),  # noqa: E501
            'last_date': (str,),  # noqa: E501
            'last_time': (int,),  # noqa: E501
            'last_vol': (int,),  # noqa: E501
            'last_tick': (str,),  # noqa: E501
            'official_close': (float,),  # noqa: E501
            'official_close_time': (int,),  # noqa: E501
            'last_exch': (str,),  # noqa: E501
            'settlement': (float,),  # noqa: E501
            'traded_price': (float,),  # noqa: E501
            'traded_date': (str,),  # noqa: E501
            'traded_time': (int,),  # noqa: E501
            'traded_vol': (int,),  # noqa: E501
            'traded_condition': (str,),  # noqa: E501
            'net_change': (float,),  # noqa: E501
            'percent_change': (float,),  # noqa: E501
            'premkt_price': (float,),  # noqa: E501
            'premkt_time': (int,),  # noqa: E501
            'premkt_vol': (int,),  # noqa: E501
            'premkt_c_vol': (int,),  # noqa: E501
            'postmkt_price': (float,),  # noqa: E501
            'postmkt_time': (int,),  # noqa: E501
            'postmkt_vol': (int,),  # noqa: E501
            'postmkt_cvol': (int,),  # noqa: E501
            'offbook_cum_vol': (int,),  # noqa: E501
            'official_bid_close': (float,),  # noqa: E501
            'official_ask_close': (float,),  # noqa: E501
            'mid_date': (str,),  # noqa: E501
            'mid_time': (int,),  # noqa: E501
            'cvol': (int,),  # noqa: E501
            'turnover': (float,),  # noqa: E501
            'vwap': (float,),  # noqa: E501
            'trade_count': (int,),  # noqa: E501
            'block_trade_count': (int,),  # noqa: E501
            'block_cvol': (int,),  # noqa: E501
            'prev_close': (float,),  # noqa: E501
            'close_date': (str,),  # noqa: E501
            'prev_close_unadj': (float,),  # noqa: E501
            'prev_close_2': (float,),  # noqa: E501
            'prev_close_unadj_2': (float,),  # noqa: E501
            'lower_trading_band': (float,),  # noqa: E501
            'upper_trading_band': (float,),  # noqa: E501
            'buy_imbalance': (int,),  # noqa: E501
            'sell_imbalance': (int,),  # noqa: E501
            'nas_buy_imbalance': (int,),  # noqa: E501
            'nas_sell_imbalance': (int,),  # noqa: E501
            'open': (float,),  # noqa: E501
            'high': (float,),  # noqa: E501
            'low': (float,),  # noqa: E501
            'venue': (str,),  # noqa: E501
            'buy_id': (str,),  # noqa: E501
            'sell_id': (str,),  # noqa: E501
            'auto_trade_vwap': (float,),  # noqa: E501
            'auto_trade_cvol': (int,),  # noqa: E501
            'auto_trade_count': (int,),  # noqa: E501
            'ex_date_status': (str,),  # noqa: E501
            'premkt_net_change': (float,),  # noqa: E501
            'premkt_percent_change': (float,),  # noqa: E501
            'closing_vol': (int,),  # noqa: E501
            'primary_market': (str,),  # noqa: E501
            'iso_country_exchange': (str,),  # noqa: E501
            'premkt_exch': (str,),  # noqa: E501
            'postmkt_exch': (str,),  # noqa: E501
            'fref_security_type': (str,),  # noqa: E501
            'security_sub_type': (str,),  # noqa: E501
            'postmkt_net_change': (float,),  # noqa: E501
            'postmkt_percent_change': (float,),  # noqa: E501
            'isin': (str,),  # noqa: E501
            'cusip': (str,),  # noqa: E501
            'sedol': (str,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'shares_outstanding': (float,),  # noqa: E501
            'price_currency': (str,),  # noqa: E501
            'security_status': (str,),  # noqa: E501
            'gmt_offset': (int,),  # noqa: E501
            'market_segment': (str,),  # noqa: E501
            'market_sector': (str,),  # noqa: E501
            'period': (str,),  # noqa: E501
            'country_code': (str,),  # noqa: E501
            'financial_status': (int,),  # noqa: E501
            'factset_industry': (str,),  # noqa: E501
            'factset_sector': (str,),  # noqa: E501
            'halt_info': (int,),  # noqa: E501
            'homepage': (str,),  # noqa: E501
            'halt_description': (str,),  # noqa: E501
            'feed_currency': (str,),  # noqa: E501
            'country_name': (str,),  # noqa: E501
            'order_lot_size': (int,),  # noqa: E501
            'trade_lot_size': (int,),  # noqa: E501
            'tick_size': (float,),  # noqa: E501
            'tick_group': (str,),  # noqa: E501
            'tick_pilot_eff_date': (str,),  # noqa: E501
            'avg_30_day_vol': (float,),  # noqa: E501
            'avg_5_day_vol': (float,),  # noqa: E501
            'high_52_week': (float,),  # noqa: E501
            'low_52_week': (float,),  # noqa: E501
            'high_52_week_date': (str,),  # noqa: E501
            'low_52_week_date': (str,),  # noqa: E501
            'trade_condition': (str,),  # noqa: E501
            'total_return_3_m': (float,),  # noqa: E501
            'total_return_52_w': (float,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'exchange': 'Exchange',  # noqa: E501
        'product': 'product',  # noqa: E501
        'bid': 'Bid',  # noqa: E501
        'bid_date': 'Bid_Date',  # noqa: E501
        'bid_time': 'Bid_Time',  # noqa: E501
        'bid_vol': 'Bid_Vol',  # noqa: E501
        'bid_tick': 'Bid_Tick',  # noqa: E501
        'bid_close': 'Bid_Close',  # noqa: E501
        'bid_close_date': 'Bid_Close_Date',  # noqa: E501
        'bid_close_vol': 'Bid_Close_Vol',  # noqa: E501
        'bid_exch': 'Bid_Exch',  # noqa: E501
        'ask': 'Ask',  # noqa: E501
        'ask_date': 'Ask_Date',  # noqa: E501
        'ask_time': 'Ask_Time',  # noqa: E501
        'ask_vol': 'Ask_Vol',  # noqa: E501
        'ask_close': 'Ask_Close',  # noqa: E501
        'ask_close_date': 'Ask_Close_Date',  # noqa: E501
        'ask_close_vol': 'Ask_Close_Vol',  # noqa: E501
        'ask_exch': 'Ask_Exch',  # noqa: E501
        'short_sale_indicator': 'Short_Sale_Indicator',  # noqa: E501
        'quote_condition': 'Quote_Condition',  # noqa: E501
        'last_price': 'Last_Price',  # noqa: E501
        'last_date': 'Last_Date',  # noqa: E501
        'last_time': 'Last_Time',  # noqa: E501
        'last_vol': 'Last_Vol',  # noqa: E501
        'last_tick': 'Last_Tick',  # noqa: E501
        'official_close': 'Official_Close',  # noqa: E501
        'official_close_time': 'Official_Close_Time',  # noqa: E501
        'last_exch': 'Last_Exch',  # noqa: E501
        'settlement': 'Settlement',  # noqa: E501
        'traded_price': 'Traded_Price',  # noqa: E501
        'traded_date': 'Traded_Date',  # noqa: E501
        'traded_time': 'Traded_Time',  # noqa: E501
        'traded_vol': 'Traded_Vol',  # noqa: E501
        'traded_condition': 'Traded_Condition',  # noqa: E501
        'net_change': 'Net_Change',  # noqa: E501
        'percent_change': 'Percent_Change',  # noqa: E501
        'premkt_price': 'Premkt_Price',  # noqa: E501
        'premkt_time': 'Premkt_Time',  # noqa: E501
        'premkt_vol': 'Premkt_Vol',  # noqa: E501
        'premkt_c_vol': 'Premkt_CVol',  # noqa: E501
        'postmkt_price': 'Postmkt_Price',  # noqa: E501
        'postmkt_time': 'Postmkt_Time',  # noqa: E501
        'postmkt_vol': 'Postmkt_Vol',  # noqa: E501
        'postmkt_cvol': 'Postmkt_Cvol',  # noqa: E501
        'offbook_cum_vol': 'Offbook_Cum_Vol',  # noqa: E501
        'official_bid_close': 'Official_Bid_Close',  # noqa: E501
        'official_ask_close': 'Official_Ask_Close',  # noqa: E501
        'mid_date': 'Mid_Date',  # noqa: E501
        'mid_time': 'Mid_Time',  # noqa: E501
        'cvol': 'Cvol',  # noqa: E501
        'turnover': 'Turnover',  # noqa: E501
        'vwap': 'Vwap',  # noqa: E501
        'trade_count': 'Trade_Count',  # noqa: E501
        'block_trade_count': 'Block_Trade_Count',  # noqa: E501
        'block_cvol': 'Block_Cvol',  # noqa: E501
        'prev_close': 'Prev_Close',  # noqa: E501
        'close_date': 'Close_Date',  # noqa: E501
        'prev_close_unadj': 'Prev_Close_Unadj',  # noqa: E501
        'prev_close_2': 'Prev_Close_2',  # noqa: E501
        'prev_close_unadj_2': 'Prev_Close_Unadj_2',  # noqa: E501
        'lower_trading_band': 'Lower_Trading_Band',  # noqa: E501
        'upper_trading_band': 'Upper_Trading_Band',  # noqa: E501
        'buy_imbalance': 'Buy_Imbalance',  # noqa: E501
        'sell_imbalance': 'Sell_Imbalance',  # noqa: E501
        'nas_buy_imbalance': 'Nas_Buy_Imbalance',  # noqa: E501
        'nas_sell_imbalance': 'Nas_Sell_Imbalance',  # noqa: E501
        'open': 'Open',  # noqa: E501
        'high': 'High',  # noqa: E501
        'low': 'Low',  # noqa: E501
        'venue': 'Venue',  # noqa: E501
        'buy_id': 'Buy_Id',  # noqa: E501
        'sell_id': 'Sell_Id',  # noqa: E501
        'auto_trade_vwap': 'Auto_Trade_Vwap',  # noqa: E501
        'auto_trade_cvol': 'Auto_Trade_Cvol',  # noqa: E501
        'auto_trade_count': 'Auto_Trade_Count',  # noqa: E501
        'ex_date_status': 'Ex_Date_Status',  # noqa: E501
        'premkt_net_change': 'Premkt_Net_Change',  # noqa: E501
        'premkt_percent_change': 'Premkt_Percent_Change',  # noqa: E501
        'closing_vol': 'Closing_Vol',  # noqa: E501
        'primary_market': 'Primary_Market',  # noqa: E501
        'iso_country_exchange': 'Iso_Country_Exchange',  # noqa: E501
        'premkt_exch': 'Premkt_Exch',  # noqa: E501
        'postmkt_exch': 'Postmkt_Exch',  # noqa: E501
        'fref_security_type': 'Fref_Security_type',  # noqa: E501
        'security_sub_type': 'Security_Sub_type',  # noqa: E501
        'postmkt_net_change': 'Postmkt_Net_Change',  # noqa: E501
        'postmkt_percent_change': 'Postmkt_Percent_Change',  # noqa: E501
        'isin': 'Isin',  # noqa: E501
        'cusip': 'Cusip',  # noqa: E501
        'sedol': 'Sedol',  # noqa: E501
        'description': 'description',  # noqa: E501
        'shares_outstanding': 'Shares_Outstanding',  # noqa: E501
        'price_currency': 'Price_Currency',  # noqa: E501
        'security_status': 'Security_Status',  # noqa: E501
        'gmt_offset': 'Gmt_Offset',  # noqa: E501
        'market_segment': 'Market_Segment',  # noqa: E501
        'market_sector': 'Market_Sector',  # noqa: E501
        'period': 'Period',  # noqa: E501
        'country_code': 'Country_Code',  # noqa: E501
        'financial_status': 'Financial_Status',  # noqa: E501
        'factset_industry': 'Factset_Industry',  # noqa: E501
        'factset_sector': 'Factset_Sector',  # noqa: E501
        'halt_info': 'Halt_Info',  # noqa: E501
        'homepage': 'Homepage',  # noqa: E501
        'halt_description': 'Halt_description',  # noqa: E501
        'feed_currency': 'Feed_Currency',  # noqa: E501
        'country_name': 'Country_Name',  # noqa: E501
        'order_lot_size': 'Order_Lot_Size',  # noqa: E501
        'trade_lot_size': 'Trade_Lot_Size',  # noqa: E501
        'tick_size': 'Tick_Size',  # noqa: E501
        'tick_group': 'Tick_Group',  # noqa: E501
        'tick_pilot_eff_date': 'Tick_Pilot_Eff_Date',  # noqa: E501
        'avg_30_day_vol': 'Avg_30Day_Vol',  # noqa: E501
        'avg_5_day_vol': 'Avg_5Day_Vol',  # noqa: E501
        'high_52_week': 'High_52Week',  # noqa: E501
        'low_52_week': 'Low_52Week',  # noqa: E501
        'high_52_week_date': 'High_52Week_Date',  # noqa: E501
        'low_52_week_date': 'Low_52Week_Date',  # noqa: E501
        'trade_condition': 'Trade_Condition',  # noqa: E501
        'total_return_3_m': 'Total_Return_3M',  # noqa: E501
        'total_return_52_w': 'Total_Return_52W',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """Fields - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            exchange (str): Field ID # 20. Exchange ISO-Code. Enumeration in Data Service Manual.. [optional]  # noqa: E501
            product (str): Field ID # 4. Product identifier. Enumeration in Data Service Manual.. [optional]  # noqa: E501
            bid (float): Field ID # 509. Current bid price. [optional]  # noqa: E501
            bid_date (str): Field ID # 386. Current bid date. [optional]  # noqa: E501
            bid_time (int): Field ID # 385. Current bid time. [optional]  # noqa: E501
            bid_vol (int): Field ID # 505. Current bid size. [optional]  # noqa: E501
            bid_tick (str): Field ID # 518. Current bid tick direction. Enumeration in Data Service Manual.. [optional]  # noqa: E501
            bid_close (float): Field ID # 648. Official Closing Bid. [optional]  # noqa: E501
            bid_close_date (str): Field ID # 1062. Official Closing Bid Date. [optional]  # noqa: E501
            bid_close_vol (int): Field ID # 296. Official Closing Bid Volume. [optional]  # noqa: E501
            bid_exch (str): Field ID # 506. Exchange of the current bid price. Enumeration in Data Service Manual.. [optional]  # noqa: E501
            ask (float): Field ID # 609. Current ask price. [optional]  # noqa: E501
            ask_date (str): Field ID # 388. Current ask date. [optional]  # noqa: E501
            ask_time (int): Field ID # 387. Current ask time. [optional]  # noqa: E501
            ask_vol (int): Field ID # 605. Current ask size. [optional]  # noqa: E501
            ask_close (float): Field ID # 649. Official Closing ask. [optional]  # noqa: E501
            ask_close_date (str): Field ID # 1064. Official Closing ask Date. [optional]  # noqa: E501
            ask_close_vol (int): Field ID # 297. Official Closing ask Volume. [optional]  # noqa: E501
            ask_exch (str): Field ID # 606. Exchange of the current ask price.  Enumeration in Data Service Manual.. [optional]  # noqa: E501
            short_sale_indicator (int): Field ID # 277. Flag to indicate if a security is restricted from being sold short. [optional]  # noqa: E501
            quote_condition (str): Field ID # 38. Current Quote Condition.  Enumeration in Data Service Manual.. [optional]  # noqa: E501
            last_price (float): Field ID # 50. Official last trade price. [optional]  # noqa: E501
            last_date (str): Field ID # 384. Last Date. [optional]  # noqa: E501
            last_time (int): Field ID # 383. Official last traded time. [optional]  # noqa: E501
            last_vol (int): Field ID # 31. Official last traded volume. [optional]  # noqa: E501
            last_tick (str): Field ID # 25. Official last tick. Enumeration in Data Service Manual.. [optional]  # noqa: E501
            official_close (float): Field ID # 526. Official Close/Close Range 1 Price. [optional]  # noqa: E501
            official_close_time (int): Field ID # 1065. Official Close/Close Range 1 Time. [optional]  # noqa: E501
            last_exch (str): Field ID # 33. Official last traded exchange. Enumeration in Data Service Manual.. [optional]  # noqa: E501
            settlement (float): Field ID # 815. Settle Price. [optional]  # noqa: E501
            traded_price (float): Field ID # 912. Last traded Price. [optional]  # noqa: E501
            traded_date (str): Field ID # 868. Last traded Date. [optional]  # noqa: E501
            traded_time (int): Field ID # 916. Last traded Time. [optional]  # noqa: E501
            traded_vol (int): Field ID # 918. Last traded Volume. [optional]  # noqa: E501
            traded_condition (str): Field ID # 1098. Last traded trade condition. [optional]  # noqa: E501
            net_change (float): Field ID # 662. Official last change. [optional]  # noqa: E501
            percent_change (float): Field ID # 816. Official last percentage change. [optional]  # noqa: E501
            premkt_price (float): Field ID # 1019. Unofficial last premarket trade price. [optional]  # noqa: E501
            premkt_time (int): Field ID # 1075. Unofficial last premarket traded time. [optional]  # noqa: E501
            premkt_vol (int): Field ID # 1832. Unofficial last premarket traded volume. [optional]  # noqa: E501
            premkt_c_vol (int): Field ID # 1836. Unofficial last premarket cumulative volume. [optional]  # noqa: E501
            postmkt_price (float): Field ID # 2029. Unofficial last post market trade price. [optional]  # noqa: E501
            postmkt_time (int): Field ID # 1076. Unofficial last post market traded time. [optional]  # noqa: E501
            postmkt_vol (int): Field ID # 1860. Unofficial last post market traded volume. [optional]  # noqa: E501
            postmkt_cvol (int): Field ID # 1864. Unofficial last post market cumulative volume. [optional]  # noqa: E501
            offbook_cum_vol (int): Field ID # 528. Off Book Cumulative Volume. [optional]  # noqa: E501
            official_bid_close (float): Field ID # 448. The bid close price of today. [optional]  # noqa: E501
            official_ask_close (float): Field ID # 476. The ask close price of today. [optional]  # noqa: E501
            mid_date (str): Field ID # 136. Current mid date. [optional]  # noqa: E501
            mid_time (int): Field ID # 135. Current mid price time. [optional]  # noqa: E501
            cvol (int): Field ID # 132. Cumulative volume. [optional]  # noqa: E501
            turnover (float): Field ID # 341. Turnover. [optional]  # noqa: E501
            vwap (float): Field ID # 780. Volume Weighted Average Price. [optional]  # noqa: E501
            trade_count (int): Field ID # 267. Cumulative trade count. [optional]  # noqa: E501
            block_trade_count (int): Field ID # 269. Cumulative block count. [optional]  # noqa: E501
            block_cvol (int): Field ID # 271. Cumulative block volume. [optional]  # noqa: E501
            prev_close (float): Field ID # 208. Previous trading days Close. [optional]  # noqa: E501
            close_date (str): Field ID # 1051. Previous trading days Closing Date. [optional]  # noqa: E501
            prev_close_unadj (float): Field ID # 892. Unadjusted Previous trading days Close. [optional]  # noqa: E501
            prev_close_2 (float): Field ID # 1172. Previous trading days Close  late rollover[1]. [optional]  # noqa: E501
            prev_close_unadj_2 (float): Field ID # 1176. Unadjusted Previous trading days Close  late rollover. [optional]  # noqa: E501
            lower_trading_band (float): Field ID # 1093. Lower trading band. [optional]  # noqa: E501
            upper_trading_band (float): Field ID # 1087. Upper trading band. [optional]  # noqa: E501
            buy_imbalance (int): Field ID # 495. NYSE buy imbalance. [optional]  # noqa: E501
            sell_imbalance (int): Field ID # 496. NYSE sell imbalance. [optional]  # noqa: E501
            nas_buy_imbalance (int): Field ID # 948. NAS buy imbalance. [optional]  # noqa: E501
            nas_sell_imbalance (int): Field ID # 949. NAS sell imbalance. [optional]  # noqa: E501
            open (float): Field ID # 158. The Open Range 1 or Open Price. [optional]  # noqa: E501
            high (float): Field ID # 107. Current high for the day. [optional]  # noqa: E501
            low (float): Field ID # 307. Current low for the day. [optional]  # noqa: E501
            venue (str): Field ID # 530. Venue. [optional]  # noqa: E501
            buy_id (str): Field ID # 1820. Buy Id. [optional]  # noqa: E501
            sell_id (str): Field ID # 1824. Sell Id. [optional]  # noqa: E501
            auto_trade_vwap (float): Field ID # 637. VWAP including only order book (automatic) trades. [optional]  # noqa: E501
            auto_trade_cvol (int): Field ID # 635. Cumulative Volume calculated on all automated trading volumes for order-based segments. [optional]  # noqa: E501
            auto_trade_count (int): Field ID # 636. Trade Quantity including only order book (automatic) trades. [optional]  # noqa: E501
            ex_date_status (str): Field ID # 531. Ex-Date Status. [optional]  # noqa: E501
            premkt_net_change (float): Field ID # 896. Net change in pre-market session(US stocks only). [optional]  # noqa: E501
            premkt_percent_change (float): Field ID # 897. Percent change in pre-market session(US stocks only). [optional]  # noqa: E501
            closing_vol (int): Field ID # 1345. Volume of the closing trade. [optional]  # noqa: E501
            primary_market (str): Field ID # 1517. FactSet Exchange Code of primary market for instrument. Determined by highest trading volume over a 3-day calendar period. [optional]  # noqa: E501
            iso_country_exchange (str): Field ID # 1621. Three Letter Country Code from ISO-3166. [optional]  # noqa: E501
            premkt_exch (str): Field ID # 1743. Premarket Exchange. Enumeration in Data Service Manual. . [optional]  # noqa: E501
            postmkt_exch (str): Field ID # 1744. Post Market Exchange. Enumeration in Data Service Manual.. [optional]  # noqa: E501
            fref_security_type (str): Field ID # 1751. The Security type returned by FREF_SECURITY_type. [optional]  # noqa: E501
            security_sub_type (str): Field ID # 1762. Sub type of the security populated for funds right now. [optional]  # noqa: E501
            postmkt_net_change (float): Field ID # 1881. Post Market Net Change. [optional]  # noqa: E501
            postmkt_percent_change (float): Field ID # 1882. Post Market Percent Change. . [optional]  # noqa: E501
            isin (str): Field ID # 12. ISIN. [optional]  # noqa: E501
            cusip (str): Field ID # 14. CUSIP. [optional]  # noqa: E501
            sedol (str): Field ID # 15. SEDOL. [optional]  # noqa: E501
            description (str): Field ID # 8. Security Description. [optional]  # noqa: E501
            shares_outstanding (float): Field ID # 29. Total number of shares outstanding. [optional]  # noqa: E501
            price_currency (str): Field ID # 62. Price currency code. [optional]  # noqa: E501
            security_status (str): Field ID # 2800. Security Status or Halt Indicator. Enumeration in Data manual. [optional]  # noqa: E501
            gmt_offset (int): Field ID # 389. GMT Offset in Minutes. [optional]  # noqa: E501
            market_segment (str): Field ID # 650. Market segment. [optional]  # noqa: E501
            market_sector (str): Field ID # 651. Market sector. [optional]  # noqa: E501
            period (str): Field ID # 633. Period. [optional]  # noqa: E501
            country_code (str): Field ID # 652. ISO Country code. [optional]  # noqa: E501
            financial_status (int): Field ID # 1896. Financial Status Enumeration Table. [optional]  # noqa: E501
            factset_industry (str): Field ID # 722. FactSet Industry Classification. [optional]  # noqa: E501
            factset_sector (str): Field ID # 723. FactSet Sector Classification. [optional]  # noqa: E501
            halt_info (int): Field ID # 1414. Halt Status. [optional]  # noqa: E501
            homepage (str): Field ID # 724. Company Homepage. [optional]  # noqa: E501
            halt_description (str): Field ID # 1184. Halt description. [optional]  # noqa: E501
            feed_currency (str): Field ID # 1182. Currency the Exchange sends the prices to FactSet in. [optional]  # noqa: E501
            country_name (str): Field ID # 1190. Name of Country. [optional]  # noqa: E501
            order_lot_size (int): Field ID # 427. Number of securities in a lot. [optional]  # noqa: E501
            trade_lot_size (int): Field ID # 1335. The minimum number of lots required to trade. [optional]  # noqa: E501
            tick_size (float): Field ID # 1499. Tick Size. [optional]  # noqa: E501
            tick_group (str): Field ID # 1507. Tick Group. [optional]  # noqa: E501
            tick_pilot_eff_date (str): Field ID # 1508. Tick Pilot effective day. [optional]  # noqa: E501
            avg_30_day_vol (float): Field ID # 709. Average cumulative volume for last 30 days. [optional]  # noqa: E501
            avg_5_day_vol (float): Field ID # 719. Average cumulative volume over last 5 trading days. [optional]  # noqa: E501
            high_52_week (float): Field ID # 767. 52 Week High Price. [optional]  # noqa: E501
            low_52_week (float): Field ID # 768. 52 Week Low Price. [optional]  # noqa: E501
            high_52_week_date (str): Field ID # 1220. 52 Week High Price Date. [optional]  # noqa: E501
            low_52_week_date (str): Field ID # 1295. 52 Week Low Price Date. [optional]  # noqa: E501
            trade_condition (str): Field ID # 174. Trade Condition. [optional]  # noqa: E501
            total_return_3_m (float): Field ID # 746. 3 Month return for US mutual funds. [optional]  # noqa: E501
            total_return_52_w (float): Field ID # 747. 52-Week Total Return for US mutual funds. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """Fields - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            exchange (str): Field ID # 20. Exchange ISO-Code. Enumeration in Data Service Manual.. [optional]  # noqa: E501
            product (str): Field ID # 4. Product identifier. Enumeration in Data Service Manual.. [optional]  # noqa: E501
            bid (float): Field ID # 509. Current bid price. [optional]  # noqa: E501
            bid_date (str): Field ID # 386. Current bid date. [optional]  # noqa: E501
            bid_time (int): Field ID # 385. Current bid time. [optional]  # noqa: E501
            bid_vol (int): Field ID # 505. Current bid size. [optional]  # noqa: E501
            bid_tick (str): Field ID # 518. Current bid tick direction. Enumeration in Data Service Manual.. [optional]  # noqa: E501
            bid_close (float): Field ID # 648. Official Closing Bid. [optional]  # noqa: E501
            bid_close_date (str): Field ID # 1062. Official Closing Bid Date. [optional]  # noqa: E501
            bid_close_vol (int): Field ID # 296. Official Closing Bid Volume. [optional]  # noqa: E501
            bid_exch (str): Field ID # 506. Exchange of the current bid price. Enumeration in Data Service Manual.. [optional]  # noqa: E501
            ask (float): Field ID # 609. Current ask price. [optional]  # noqa: E501
            ask_date (str): Field ID # 388. Current ask date. [optional]  # noqa: E501
            ask_time (int): Field ID # 387. Current ask time. [optional]  # noqa: E501
            ask_vol (int): Field ID # 605. Current ask size. [optional]  # noqa: E501
            ask_close (float): Field ID # 649. Official Closing ask. [optional]  # noqa: E501
            ask_close_date (str): Field ID # 1064. Official Closing ask Date. [optional]  # noqa: E501
            ask_close_vol (int): Field ID # 297. Official Closing ask Volume. [optional]  # noqa: E501
            ask_exch (str): Field ID # 606. Exchange of the current ask price.  Enumeration in Data Service Manual.. [optional]  # noqa: E501
            short_sale_indicator (int): Field ID # 277. Flag to indicate if a security is restricted from being sold short. [optional]  # noqa: E501
            quote_condition (str): Field ID # 38. Current Quote Condition.  Enumeration in Data Service Manual.. [optional]  # noqa: E501
            last_price (float): Field ID # 50. Official last trade price. [optional]  # noqa: E501
            last_date (str): Field ID # 384. Last Date. [optional]  # noqa: E501
            last_time (int): Field ID # 383. Official last traded time. [optional]  # noqa: E501
            last_vol (int): Field ID # 31. Official last traded volume. [optional]  # noqa: E501
            last_tick (str): Field ID # 25. Official last tick. Enumeration in Data Service Manual.. [optional]  # noqa: E501
            official_close (float): Field ID # 526. Official Close/Close Range 1 Price. [optional]  # noqa: E501
            official_close_time (int): Field ID # 1065. Official Close/Close Range 1 Time. [optional]  # noqa: E501
            last_exch (str): Field ID # 33. Official last traded exchange. Enumeration in Data Service Manual.. [optional]  # noqa: E501
            settlement (float): Field ID # 815. Settle Price. [optional]  # noqa: E501
            traded_price (float): Field ID # 912. Last traded Price. [optional]  # noqa: E501
            traded_date (str): Field ID # 868. Last traded Date. [optional]  # noqa: E501
            traded_time (int): Field ID # 916. Last traded Time. [optional]  # noqa: E501
            traded_vol (int): Field ID # 918. Last traded Volume. [optional]  # noqa: E501
            traded_condition (str): Field ID # 1098. Last traded trade condition. [optional]  # noqa: E501
            net_change (float): Field ID # 662. Official last change. [optional]  # noqa: E501
            percent_change (float): Field ID # 816. Official last percentage change. [optional]  # noqa: E501
            premkt_price (float): Field ID # 1019. Unofficial last premarket trade price. [optional]  # noqa: E501
            premkt_time (int): Field ID # 1075. Unofficial last premarket traded time. [optional]  # noqa: E501
            premkt_vol (int): Field ID # 1832. Unofficial last premarket traded volume. [optional]  # noqa: E501
            premkt_c_vol (int): Field ID # 1836. Unofficial last premarket cumulative volume. [optional]  # noqa: E501
            postmkt_price (float): Field ID # 2029. Unofficial last post market trade price. [optional]  # noqa: E501
            postmkt_time (int): Field ID # 1076. Unofficial last post market traded time. [optional]  # noqa: E501
            postmkt_vol (int): Field ID # 1860. Unofficial last post market traded volume. [optional]  # noqa: E501
            postmkt_cvol (int): Field ID # 1864. Unofficial last post market cumulative volume. [optional]  # noqa: E501
            offbook_cum_vol (int): Field ID # 528. Off Book Cumulative Volume. [optional]  # noqa: E501
            official_bid_close (float): Field ID # 448. The bid close price of today. [optional]  # noqa: E501
            official_ask_close (float): Field ID # 476. The ask close price of today. [optional]  # noqa: E501
            mid_date (str): Field ID # 136. Current mid date. [optional]  # noqa: E501
            mid_time (int): Field ID # 135. Current mid price time. [optional]  # noqa: E501
            cvol (int): Field ID # 132. Cumulative volume. [optional]  # noqa: E501
            turnover (float): Field ID # 341. Turnover. [optional]  # noqa: E501
            vwap (float): Field ID # 780. Volume Weighted Average Price. [optional]  # noqa: E501
            trade_count (int): Field ID # 267. Cumulative trade count. [optional]  # noqa: E501
            block_trade_count (int): Field ID # 269. Cumulative block count. [optional]  # noqa: E501
            block_cvol (int): Field ID # 271. Cumulative block volume. [optional]  # noqa: E501
            prev_close (float): Field ID # 208. Previous trading days Close. [optional]  # noqa: E501
            close_date (str): Field ID # 1051. Previous trading days Closing Date. [optional]  # noqa: E501
            prev_close_unadj (float): Field ID # 892. Unadjusted Previous trading days Close. [optional]  # noqa: E501
            prev_close_2 (float): Field ID # 1172. Previous trading days Close  late rollover[1]. [optional]  # noqa: E501
            prev_close_unadj_2 (float): Field ID # 1176. Unadjusted Previous trading days Close  late rollover. [optional]  # noqa: E501
            lower_trading_band (float): Field ID # 1093. Lower trading band. [optional]  # noqa: E501
            upper_trading_band (float): Field ID # 1087. Upper trading band. [optional]  # noqa: E501
            buy_imbalance (int): Field ID # 495. NYSE buy imbalance. [optional]  # noqa: E501
            sell_imbalance (int): Field ID # 496. NYSE sell imbalance. [optional]  # noqa: E501
            nas_buy_imbalance (int): Field ID # 948. NAS buy imbalance. [optional]  # noqa: E501
            nas_sell_imbalance (int): Field ID # 949. NAS sell imbalance. [optional]  # noqa: E501
            open (float): Field ID # 158. The Open Range 1 or Open Price. [optional]  # noqa: E501
            high (float): Field ID # 107. Current high for the day. [optional]  # noqa: E501
            low (float): Field ID # 307. Current low for the day. [optional]  # noqa: E501
            venue (str): Field ID # 530. Venue. [optional]  # noqa: E501
            buy_id (str): Field ID # 1820. Buy Id. [optional]  # noqa: E501
            sell_id (str): Field ID # 1824. Sell Id. [optional]  # noqa: E501
            auto_trade_vwap (float): Field ID # 637. VWAP including only order book (automatic) trades. [optional]  # noqa: E501
            auto_trade_cvol (int): Field ID # 635. Cumulative Volume calculated on all automated trading volumes for order-based segments. [optional]  # noqa: E501
            auto_trade_count (int): Field ID # 636. Trade Quantity including only order book (automatic) trades. [optional]  # noqa: E501
            ex_date_status (str): Field ID # 531. Ex-Date Status. [optional]  # noqa: E501
            premkt_net_change (float): Field ID # 896. Net change in pre-market session(US stocks only). [optional]  # noqa: E501
            premkt_percent_change (float): Field ID # 897. Percent change in pre-market session(US stocks only). [optional]  # noqa: E501
            closing_vol (int): Field ID # 1345. Volume of the closing trade. [optional]  # noqa: E501
            primary_market (str): Field ID # 1517. FactSet Exchange Code of primary market for instrument. Determined by highest trading volume over a 3-day calendar period. [optional]  # noqa: E501
            iso_country_exchange (str): Field ID # 1621. Three Letter Country Code from ISO-3166. [optional]  # noqa: E501
            premkt_exch (str): Field ID # 1743. Premarket Exchange. Enumeration in Data Service Manual. . [optional]  # noqa: E501
            postmkt_exch (str): Field ID # 1744. Post Market Exchange. Enumeration in Data Service Manual.. [optional]  # noqa: E501
            fref_security_type (str): Field ID # 1751. The Security type returned by FREF_SECURITY_type. [optional]  # noqa: E501
            security_sub_type (str): Field ID # 1762. Sub type of the security populated for funds right now. [optional]  # noqa: E501
            postmkt_net_change (float): Field ID # 1881. Post Market Net Change. [optional]  # noqa: E501
            postmkt_percent_change (float): Field ID # 1882. Post Market Percent Change. . [optional]  # noqa: E501
            isin (str): Field ID # 12. ISIN. [optional]  # noqa: E501
            cusip (str): Field ID # 14. CUSIP. [optional]  # noqa: E501
            sedol (str): Field ID # 15. SEDOL. [optional]  # noqa: E501
            description (str): Field ID # 8. Security Description. [optional]  # noqa: E501
            shares_outstanding (float): Field ID # 29. Total number of shares outstanding. [optional]  # noqa: E501
            price_currency (str): Field ID # 62. Price currency code. [optional]  # noqa: E501
            security_status (str): Field ID # 2800. Security Status or Halt Indicator. Enumeration in Data manual. [optional]  # noqa: E501
            gmt_offset (int): Field ID # 389. GMT Offset in Minutes. [optional]  # noqa: E501
            market_segment (str): Field ID # 650. Market segment. [optional]  # noqa: E501
            market_sector (str): Field ID # 651. Market sector. [optional]  # noqa: E501
            period (str): Field ID # 633. Period. [optional]  # noqa: E501
            country_code (str): Field ID # 652. ISO Country code. [optional]  # noqa: E501
            financial_status (int): Field ID # 1896. Financial Status Enumeration Table. [optional]  # noqa: E501
            factset_industry (str): Field ID # 722. FactSet Industry Classification. [optional]  # noqa: E501
            factset_sector (str): Field ID # 723. FactSet Sector Classification. [optional]  # noqa: E501
            halt_info (int): Field ID # 1414. Halt Status. [optional]  # noqa: E501
            homepage (str): Field ID # 724. Company Homepage. [optional]  # noqa: E501
            halt_description (str): Field ID # 1184. Halt description. [optional]  # noqa: E501
            feed_currency (str): Field ID # 1182. Currency the Exchange sends the prices to FactSet in. [optional]  # noqa: E501
            country_name (str): Field ID # 1190. Name of Country. [optional]  # noqa: E501
            order_lot_size (int): Field ID # 427. Number of securities in a lot. [optional]  # noqa: E501
            trade_lot_size (int): Field ID # 1335. The minimum number of lots required to trade. [optional]  # noqa: E501
            tick_size (float): Field ID # 1499. Tick Size. [optional]  # noqa: E501
            tick_group (str): Field ID # 1507. Tick Group. [optional]  # noqa: E501
            tick_pilot_eff_date (str): Field ID # 1508. Tick Pilot effective day. [optional]  # noqa: E501
            avg_30_day_vol (float): Field ID # 709. Average cumulative volume for last 30 days. [optional]  # noqa: E501
            avg_5_day_vol (float): Field ID # 719. Average cumulative volume over last 5 trading days. [optional]  # noqa: E501
            high_52_week (float): Field ID # 767. 52 Week High Price. [optional]  # noqa: E501
            low_52_week (float): Field ID # 768. 52 Week Low Price. [optional]  # noqa: E501
            high_52_week_date (str): Field ID # 1220. 52 Week High Price Date. [optional]  # noqa: E501
            low_52_week_date (str): Field ID # 1295. 52 Week Low Price Date. [optional]  # noqa: E501
            trade_condition (str): Field ID # 174. Trade Condition. [optional]  # noqa: E501
            total_return_3_m (float): Field ID # 746. 3 Month return for US mutual funds. [optional]  # noqa: E501
            total_return_52_w (float): Field ID # 747. 52-Week Total Return for US mutual funds. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
