import { PolicyDocument } from '@aws-cdk/aws-iam';
import { RemovalPolicy, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IBucket } from './bucket';
/**
 *
 */
export interface BucketPolicyProps {
    /**
     * The Amazon S3 bucket that the policy applies to.
     */
    readonly bucket: IBucket;
    /**
     * Policy to apply when the policy is removed from this stack.
     *
     * @default - RemovalPolicy.DESTROY.
     */
    readonly removalPolicy?: RemovalPolicy;
}
/**
 * Applies an Amazon S3 bucket policy to an Amazon S3 bucket.
 */
export declare class BucketPolicy extends Resource {
    /**
     * A policy document containing permissions to add to the specified bucket.
     *
     * For more information, see Access Policy Language Overview in the Amazon
     * Simple Storage Service Developer Guide.
     */
    readonly document: PolicyDocument;
    private resource;
    /**
     *
     */
    constructor(scope: Construct, id: string, props: BucketPolicyProps);
    /**
     * Sets the removal policy for the BucketPolicy.
     *
     * @param removalPolicy the RemovalPolicy to set.
     */
    applyRemovalPolicy(removalPolicy: RemovalPolicy): void;
}
