#!/usr/bin/env python3
# -*- coding: utf-8 -*-


from django.contrib.auth.models import User


class EmailModelBackend(object):
    def authenticate(self, username=None, password=None):
        try:
            user = User.objects.get(email=username)
        except User.DoesNotExist:
            return None

        if user.check_password(password):
            return user

    def get_user(self, user_id):
        try:
            return User.objects.get(pk=user_id)
        except User.DoesNotExist:
            return None
