"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseDatabase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const constructs_1 = require("constructs");
/**
 * A database.
 */
class BaseDatabase extends constructs_1.Construct {
    /**
     * Creates a new BaseDatabase.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param props - The configuration properties for this construct.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.endpoint = props.endpoint;
        this.databaseName = props.databaseName;
        this.securityGroup =
            props.securityGroup ||
                new aws_ec2_1.SecurityGroup(this, "SecurityGroup", {
                    vpc: props.vpc,
                    description: `Created for ${this.node.path}/Function`,
                });
        props.target.connections.allowDefaultPortFrom(this.securityGroup);
        this.subnetSelection = {
            subnets: props.vpc.selectSubnets(props.vpcSubnets).subnets,
        };
    }
}
exports.BaseDatabase = BaseDatabase;
_a = JSII_RTTI_SYMBOL_1;
BaseDatabase[_a] = { fqn: "shady-island.BaseDatabase", version: "0.1.37" };
//# sourceMappingURL=data:application/json;base64,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