import datetime as dt


def get_queries(today: str | None = None):
    """Return query templates for ETF endpoints.

    Parameters
    ----------
    today : str, optional
        Date string in ``YYYY-MM-DD`` format used for historical queries.
        Defaults to ``datetime.date.today()``.
    """
    today = today or dt.date.today().strftime("%Y-%m-%d")
    return [{'name': 'disclosure_flag',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/disclosureFlag/<ETF_ID>/data?clientId=MDC&benchmarkId=undefined&component=sal-disclosure&version=4.65.0'},
 {'name': 'distribution_annual',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/distribution/annual/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-distribution&version=4.65.0'},
 {'name': 'distribution_latest',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/distribution/latest/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-distribution&version=4.65.0'},
 {'name': 'esg_risk',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/esgRisk/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-esg-risk&version=4.65.0'},
 {'name': 'esg_product_involvement',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/esg/productInvolvement/v1/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-esg-values&version=4.65.0'},
 {'name': 'factor_exposure_profile',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/factorProfile/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-factor-profile&version=4.65.0'},
 {'name': 'investment_strategy',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/morningstarTake/investmentStrategy/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-strategy&version=4.65.0'},
 {'name': 'fixed_income_exposure',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/multiLevelFixedIncomeData/<ETF_ID>/data?primary=superEffectiveDuration&secondary=creditQuality.weight&clientId=MDC&benchmarkId=prospectus_primary&component=sal-fixed-income-exposure-analysis&version=4.65.0'},
 {'name': 'parent_fund_flow',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/parent/graphData/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-fund-flows&version=4.65.0'},
 {'name': 'parent_medalist_rating_summary',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/parent/medalistRating/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-analyst-rating-breakdown&version=4.65.0'},
 {'name': 'parent_medalist_rating_top_funds',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/parent/medalistRating/topfunds/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-analyst-rating-breakdown&version=4.65.0'},
 {'name': 'parent_medalist_rating_top_funds_up_down',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/parent/medalistRating/topfundsUpDown/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-analyst-rating-breakdown&version=4.65.0'},
 {'name': 'parent_fund_star_ratings_asc',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/parent/mstarRating/StarRatingFundAsc/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-star-rating-breakdown&version=4.65.0'},
 {'name': 'parent_fund_star_ratings_desc',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/parent/mstarRating/StarRatingFundDesc/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-star-rating-breakdown&version=4.65.0'},
 {'name': 'parent_fund_overall_star_rating',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/parent/parentMstarRating/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-star-rating-breakdown&version=4.65.0'},
 {'name': 'parent_fund_summary',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/parent/parentSummary/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-parent-summary&version=4.65.0'},
 {'name': 'market_volatility_measure_10y',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/performance/marketVolatilityMeasure/<ETF_ID>/data?year=10&longestTenure=false&clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-market-volatility-measures&version=4.65.0'},
 {'name': 'market_volatility_measure_3y',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/performance/marketVolatilityMeasure/<ETF_ID>/data?year=3&longestTenure=false&clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-market-volatility-measures&version=4.65.0'},
 {'name': 'market_volatility_measure_5y',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/performance/marketVolatilityMeasure/<ETF_ID>/data?year=5&longestTenure=false&clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-market-volatility-measures&version=4.65.0'},
 {'name': 'risk_return_scatterplot',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/performance/riskReturnScatterplot/<ETF_ID>/data?longestTenure=false&clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-risk-return-analysis&version=4.65.0'},
 {'name': 'risk_return_summary',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/performance/riskReturnSummary/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-risk-return&version=4.65.0'},
 {'name': 'risk_score',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/performance/riskScore/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-risk-score&version=4.65.0'},
 {'name': 'risk_volatility',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/performance/riskVolatility/<ETF_ID>/data?longestTenure=false&clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-risk-volatility-measures&version=4.65.0'},
 {'name': 'performance_table',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/performance/table/<ETF_ID>?secExchangeList=&limitAge=&hideYTD=false&clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-annual-return&version=4.65.0'},
 {'name': 'performance_10k_growth',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/performance/v4/<ETF_ID>?secExchangeList=&limitAge=&hideYTD=false&clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-growth-10k&version=4.65.0'},
 {'name': 'portfolio_holdings',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/portfolio/holding/v2/<ETF_ID>/data?premiumNum=10000&freeNum=10000&hideesg=false&clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-holdings&version=4.65.0'},
 {'name': 'portfolio_regional_sector_exposure',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/portfolio/regionalSector/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-region-exposure&version=4.65.0'},
 {'name': 'portfolio_regional_sector_include_countries',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/portfolio/regionalSectorIncludeCountries/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-country-exposure&version=4.65.0'},
 {'name': 'portfolio_sector_exposure',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/portfolio/v2/sector/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-sector-exposure&version=4.65.0'},
 {'name': 'price_cost_projection',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/price/costProjection/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-cost-projection&version=4.65.0'},
 {'name': 'price_fee_level',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/price/feeLevel/v1/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-fee-level&version=4.65.0'},
 {'name': 'price',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/price/v4/<ETF_ID>/data?fundServCode=&clientId=MDC&benchmarkId=prospectus_primary&component=sal-pillar-cards-price&version=4.65.0'},
 {'name': 'process_asset_allocation',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/process/asset/v3/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-asset-allocation&version=4.65.0'},
 {'name': 'process_equity_style_box_history',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/process/equityStyleBoxHistory/<ETF_ID>/data?source=truesight&clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-style-historical&version=4.65.0'},
 {'name': 'process_financial_metrics',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/process/financialMetrics/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-financial-metrics&version=4.65.0'},
 {'name': 'process_market_capitalization',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/process/marketCap/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-market-cap&version=4.65.0'},
 {'name': 'process_ownership_zone',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/process/ownershipZone/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-stock-style&version=4.65.0'},
 {'name': 'process_stock_style',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/process/stockStyle/v2/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-measures&version=4.65.0'},
 {'name': 'process_weighting',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/process/weighting/<ETF_ID>/data?clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-style-weight&version=4.65.0'},
 {'name': 'quote_mini_chart_realtime_data',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/quote/miniChartRealTimeData/v2/<ETF_ID>/data?ts=0&secExchangeList=&random=0.1333888197593387&clientId=MDC&benchmarkId=prospectus_primary&component=sal-mini-quote-chart&version=4.65.0'},
 {'name': 'quote_investment_overview',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/quote/v5/<ETF_ID>/data?fundServCode=&showAnalystRatingChinaFund=false&showAnalystRating=false&hideesg=false&clientId=MDC&benchmarkId=prospectus_primary&component=sal-mip-investment-overview&version=4.65.0'},
 {'name': 'quote',
  'type': 'etf',
  'url': 'https://api-global.morningstar.com/sal-service/v1/etf/quote/v5/<ETF_ID>/data?fundServCode=&showAnalystRatingChinaFund=false&showAnalystRating=undefined&clientId=MDC&benchmarkId=prospectus_primary&component=sal-etf-quote&version=4.65.0'},
 {'name': 'history_dividend_monthly',
  'type': 'etf',
  'url': f'https://www.us-api.morningstar.com/QS-markets/chartservice/v2/timeseries?query=<ETF_ID>:dividend&frequency=m&startDate=1900-01-01&endDate={today}&trackMarketData=3.6.3&instid=DOTCOM'},
 {'name': 'history_market_total_return_daily',
  'type': 'etf',
  'url': f'https://www.us-api.morningstar.com/QS-markets/chartservice/v2/timeseries?query=<ETF_ID>:marketTotalReturn&frequency=d&startDate=2024-05-20&endDate={today}&trackMarketData=3.6.3&instid=DOTCOM'},
 {'name': 'history_price_monthly',
  'type': 'etf',
  'url': f'https://www.us-api.morningstar.com/QS-markets/chartservice/v2/timeseries?query=<ETF_ID>:open,high,low,close,volume,previousClose,marketTotalReturn,nav,totalReturn&frequency=m&startDate=1900-01-01&endDate={today}&trackMarketData=3.6.3&instid=DOTCOM'},
 {'name': 'history_premium_discount_monthly',
  'type': 'etf',
  'url': f'https://www.us-api.morningstar.com/QS-markets/chartservice/v2/timeseries?query=<ETF_ID>:premiumDiscount&frequency=m&startDate=1900-01-01&endDate={today}&trackMarketData=3.6.3&instid=DOTCOM'},
 {'name': 'history_price_daily',
  'type': 'etf',
  'url': f'https://www.us-api.morningstar.com/QS-markets/chartservice/v2/timeseries?query=<ETF_ID>:totalReturn,nav,open,high,low,close,volume,previousClose&frequency=d&startDate=2024-05-20&endDate={today}&trackMarketData=3.6.3&instid=DOTCOM'},
 {'name': 'market_id_information',
  'type': 'etf',
  'url': 'https://www.us-api.morningstar.com/QS-markets/ra/idService?symbol=<ETF_ID>&trackMarketData=3.6.3&instid=DOTCOM'}]
