import datetime as dt


def get_queries(today: str | None = None):
    """Return query templates for Fund endpoints.

    Parameters
    ----------
    today : str, optional
        Date string in ``YYYY-MM-DD`` format used for historical queries.
        Defaults to ``datetime.date.today()``.
    """
    today = today or dt.date.today().strftime("%Y-%m-%d")
    return [{'name': 'disclosure_flag',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/disclosureFlag/<FUND_ID>/data?clientId=MDC&benchmarkId=undefined&component=sal-disclosure&version=4.65.0'},
 {'name': 'distribution_annual',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/distribution/annual/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-distribution&version=4.65.0'},
 {'name': 'distribution_latest',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/distribution/latest/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-distribution&version=4.65.0'},
 {'name': 'esg_risk',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/esgRisk/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-esg-risk&version=4.65.0'},
 {'name': 'esg_product_involvement',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/esg/productInvolvement/v1/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-esg-values&version=4.65.0'},
 {'name': 'factor_exposure_profile',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/factorProfile/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-factor-profile&version=4.65.0'},
 {'name': 'investment_strategy',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/morningstarTake/investmentStrategy/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-strategy&version=4.65.0'},
 {'name': 'fixed_income_credit_quality_by_region',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/multiLevelFixedIncomeData/<FUND_ID>/data?primary=creditQuality&secondary=region.weight&clientId=MDC&benchmarkId=mstarorcat&component=sal-fixed-income-exposure-analysis&version=4.65.0'},
 {'name': 'fixed_income_credit_quality_by_sector',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/multiLevelFixedIncomeData/<FUND_ID>/data?primary=creditQuality&secondary=superSector.weight&clientId=MDC&benchmarkId=mstarorcat&component=sal-fixed-income-exposure-analysis&version=4.65.0'},
 {'name': 'fixed_income_duration_by_credit_quality',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/multiLevelFixedIncomeData/<FUND_ID>/data?primary=superEffectiveDuration&secondary=creditQuality.weight&clientId=MDC&benchmarkId=mstarorcat&component=sal-fixed-income-exposure-analysis&version=4.65.0'},
 {'name': 'fixed_income_duration_by_region',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/multiLevelFixedIncomeData/<FUND_ID>/data?primary=superEffectiveDuration&secondary=region.weight&clientId=MDC&benchmarkId=mstarorcat&component=sal-fixed-income-exposure-analysis&version=4.65.0'},
 {'name': 'fixed_income_duration_by_sector',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/multiLevelFixedIncomeData/<FUND_ID>/data?primary=superEffectiveDuration&secondary=superSector.weight&clientId=MDC&benchmarkId=mstarorcat&component=sal-fixed-income-exposure-analysis&version=4.65.0'},
 {'name': 'fixed_income_yield_to_worst_by_credit_quality',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/multiLevelFixedIncomeData/<FUND_ID>/data?primary=superYieldToWorst&secondary=creditQuality.weight&clientId=MDC&benchmarkId=mstarorcat&component=sal-fixed-income-exposure-analysis&version=4.65.0'},
 {'name': 'fixed_income_yield_to_worst_by_region',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/multiLevelFixedIncomeData/<FUND_ID>/data?primary=superYieldToWorst&secondary=region.weight&clientId=MDC&benchmarkId=mstarorcat&component=sal-fixed-income-exposure-analysis&version=4.65.0'},
 {'name': 'fixed_income_yield_to_worst_by_sector',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/multiLevelFixedIncomeData/<FUND_ID>/data?primary=superYieldToWorst&secondary=superSector.weight&clientId=MDC&benchmarkId=mstarorcat&component=sal-fixed-income-exposure-analysis&version=4.65.0'},
 {'name': 'parent_fund_flow',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/parent/graphData/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-fund-flows&version=4.65.0'},
 {'name': 'parent_medalist_rating_summary',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/parent/medalistRating/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-analyst-rating-breakdown&version=4.65.0'},
 {'name': 'parent_medalist_rating_top_funds',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/parent/medalistRating/topfunds/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-analyst-rating-breakdown&version=4.65.0'},
 {'name': 'parent_medalist_rating_top_funds_up_down',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/parent/medalistRating/topfundsUpDown/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-analyst-rating-breakdown&version=4.65.0'},
 {'name': 'parent_star_rating_fund_asc',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/parent/mstarRating/StarRatingFundAsc/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-star-rating-breakdown&version=4.65.0'},
 {'name': 'parent_star_rating_fund_desc',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/parent/mstarRating/StarRatingFundDesc/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-star-rating-breakdown&version=4.65.0'},
 {'name': 'parent_star_rating_summary',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/parent/parentMstarRating/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-star-rating-breakdown&version=4.65.0'},
 {'name': 'parent_summary',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/parent/parentSummary/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-parent-summary&version=4.65.0'},
 {'name': 'people',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/people/<FUND_ID>/data?locale=fr&clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-people-summary&version=4.65.0'},
 {'name': 'market_volatility_measure_10y',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/performance/marketVolatilityMeasure/<FUND_ID>/data?year=10&longestTenure=false&clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-market-volatility-measures&version=4.65.0'},
 {'name': 'market_volatility_measure_3y',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/performance/marketVolatilityMeasure/<FUND_ID>/data?year=3&longestTenure=false&clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-market-volatility-measures&version=4.65.0'},
 {'name': 'market_volatility_measure_5y',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/performance/marketVolatilityMeasure/<FUND_ID>/data?year=5&longestTenure=false&clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-market-volatility-measures&version=4.65.0'},
 {'name': 'risk_return_scatterplot',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/performance/riskReturnScatterplot/<FUND_ID>/data?longestTenure=false&clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-risk-return-analysis&version=4.65.0'},
 {'name': 'risk_return_summary',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/performance/riskReturnSummary/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-risk-return&version=4.65.0'},
 {'name': 'risk_score',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/performance/riskScore/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-risk-score&version=4.65.0'},
 {'name': 'risk_volatility',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/performance/riskVolatility/<FUND_ID>/data?longestTenure=false&clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-risk-volatility-measures&version=4.65.0'},
 {'name': 'performance_annual_return_table',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/performance/table/<FUND_ID>?secExchangeList=&limitAge=&hideYTD=false&clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-annual-return&version=4.65.0'},
 {'name': 'performance_10k_growth',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/performance/v5/<FUND_ID>?secExchangeList=&limitAge=&hideYTD=false&clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-growth-10k&version=4.65.0'},
 {'name': 'portfolio_credit_quality',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/portfolio/creditQuality/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-credit-quality&version=4.65.0'},
 {'name': 'portfolio_holdings',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/portfolio/holding/v2/<FUND_ID>/data?premiumNum=10000&freeNum=10000&hideesg=false&clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-holdings&version=4.65.0'},
 {'name': 'portfolio_regional_sector_exposure',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/portfolio/regionalSector/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-region-exposure&version=4.65.0'},
 {'name': 'portfolio_regional_and_country_exposure',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/portfolio/regionalSectorIncludeCountries/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-country-exposure&version=4.65.0'},
 {'name': 'portfolio_sector_exposure',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/portfolio/v2/sector/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-sector-exposure&version=4.65.0'},
 {'name': 'price_cost_projection',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/price/costProjection/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-cost-projection&version=4.65.0'},
 {'name': 'price_fee_level',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/price/feeLevel/v1/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-fee-level&version=4.65.0'},
 {'name': 'price_investment_fee',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/price/investmentFee/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-investment-fees&version=4.65.0'},
 {'name': 'price_other_fee',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/price/otherFee/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-other-fees&version=4.65.0'},
 {'name': 'price_overview',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/price/v4/<FUND_ID>/data?fundServCode=&clientId=MDC&benchmarkId=mstarorcat&component=sal-pillar-cards-price&version=4.65.0'},
 {'name': 'process_asset_allocation',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/process/asset/v3/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-asset-allocation&version=4.65.0'},
 {'name': 'process_coupon_range',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/process/couponRange/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-coupon-range&version=4.65.0'},
 {'name': 'process_equity_style_box_history',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/process/equityStyleBoxHistory/<FUND_ID>/data?source=truesight&clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-style-historical&version=4.65.0'},
 {'name': 'process_financial_metrics',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/process/financialMetrics/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-financial-metrics&version=4.65.0'},
 {'name': 'process_fixed_income_style',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/process/fixedIncomeStyle/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-fixed-income-style&version=4.65.0'},
 {'name': 'process_fixed_income_style_box_history',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/process/fixedincomeStyleBoxHistory/<FUND_ID>/data?source=truesight&clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-style-historical&version=4.65.0'},
 {'name': 'process_market_capitalization',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/process/marketCap/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-market-cap&version=4.65.0'},
 {'name': 'process_maturity_schedule',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/process/maturitySchedule/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-maturity-schedule&version=4.65.0'},
 {'name': 'process_ownership_zone',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/process/ownershipZone/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-stock-style&version=4.65.0'},
 {'name': 'process_stock_style',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/process/stockStyle/v2/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-measures&version=4.65.0'},
 {'name': 'process_weighting',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/process/weighting/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-style-weight&version=4.65.0'},
 {'name': 'quote_overview',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/quote/v7/<FUND_ID>/data?fundServCode=&showAnalystRatingChinaFund=false&showAnalystRating=false&hideesg=false&region=EEA&clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-investment-overview&version=4.65.0'},
 {'name': 'security_metadata',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/securityMetaData/<FUND_ID>'},
 {'name': 'strategy_preview',
  'type': 'fund',
  'url': 'https://api-global.morningstar.com/sal-service/v1/fund/strategyPreview/<FUND_ID>/data?clientId=MDC&benchmarkId=mstarorcat&component=sal-mip-strategy&version=4.65.0'},
 {'name': 'history_dividend_monthly',
  'type': 'fund',
  'url': f'https://www.us-api.morningstar.com/QS-markets/chartservice/v2/timeseries?query=<FUND_ID>:dividend&frequency=m&startDate=1900-01-01&endDate={today}&trackMarketData=3.6.3&instid=DOTCOM'},
 {'name': 'history_nav_total_return_post_tax_monthly',
  'type': 'fund',
  'url': f'https://www.us-api.morningstar.com/QS-markets/chartservice/v2/timeseries?query=<FUND_ID>:nav,totalReturn,postTax&frequency=m&startDate=1900-01-01&endDate={today}&trackMarketData=3.6.3&instid=DOTCOM'},
 {'name': 'history_ohlcv_monthly',
  'type': 'fund',
  'url': f'https://www.us-api.morningstar.com/QS-markets/chartservice/v2/timeseries?query=<FUND_ID>:open,high,low,close,volume,previousClose&frequency=m&startDate=1900-01-01&endDate={today}&trackMarketData=3.6.3&instid=DOTCOM'},
 {'name': 'history_post_tax_daily',
  'type': 'fund',
  'url': f'https://www.us-api.morningstar.com/QS-markets/chartservice/v2/timeseries?query=<FUND_ID>:postTax&frequency=d&startDate=1900-01-01&endDate={today}&trackMarketData=3.6.3&instid=DOTCOM'},
 {'name': 'history_nav_total_return_daily',
  'type': 'fund',
  'url': f'https://www.us-api.morningstar.com/QS-markets/chartservice/v2/timeseries?query=<FUND_ID>:totalReturn,nav&frequency=d&startDate=1900-01-01&endDate={today}&trackMarketData=3.6.3&instid=DOTCOM'},
 {'name': 'history_nav_total_return_daily_recent',
  'type': 'fund',
  'url': f'https://www.us-api.morningstar.com/QS-markets/chartservice/v2/timeseries?query=<FUND_ID>:totalReturn,nav&frequency=d&startDate=2024-05-20&endDate={today}&trackMarketData=3.6.3&instid=DOTCOM'},
 {'name': 'history_nav_total_return_monthly',
  'type': 'fund',
  'url': f'https://www.us-api.morningstar.com/QS-markets/chartservice/v2/timeseries?query=<FUND_ID>:totalReturn,nav&frequency=m&startDate=1900-01-01&endDate={today}&trackMarketData=3.6.3&instid=DOTCOM'},
 {'name': 'market_id_information',
  'type': 'fund',
  'url': 'https://www.us-api.morningstar.com/QS-markets/ra/idService?symbol=<FUND_ID>&trackMarketData=3.6.3&instid=DOTCOM'}]
