# coding: utf-8

"""
    Fiddle Options Platform

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import
from datetime import datetime, date

import unittest

from swagger_client.mercury.client.api.fiddle_api import FiddleApi
from swagger_client.mercury.client.model.fiddle import Fiddle
from .utils import TestUtils


class TestFiddleApi(unittest.TestCase):
    """FiddleApi unit test stubs"""

    def setUp(self):
        self.api = FiddleApi()
        self.test_utils = TestUtils()

    def tearDown(self):
        pass

    def test_delete_fiddle(self):
        """Test case for delete_fiddle

        Deletes Fiddle with specified id  # noqa: E501
        """
        pass

    def test_get_fiddle(self):
        """Test case for get_fiddle

        Returns the Fiddle with specified id  # noqa: E501
        """
        time_start = datetime.now()
        print('Loading Fiddle...')
        fiddle = self.api.get_fiddle('wwPeB')
        # position = fiddle.position
        print('Loaded fiddle %s' % fiddle)
        print('Loaded in %s' % (datetime.now() - time_start))
        # TODO: add assertion to response

    def test_get_fiddle_list(self):
        """Test case for get_fiddle_list

        Returns the list of Fiddles for the specified user  # noqa: E501
        """
        pass

    def test_get_position_legs(self):
        """Test case for get_position_legs

        Returns all options contracts that the specified options position is consisted of  # noqa: E501
        """
        pass

    def test_get_trade_from_tos_string(self):
        """Test case for get_trade_from_tos_string

        Creates a list of positions from a list of trades specified in ThinkOrSwim format  # noqa: E501
        """
        pass

    def test_save_fiddle(self):
        """Test case for save_fiddle

        Saves a new Fiddle or updates an existing one  # noqa: E501
        """
        opening_date = date(2018, 4, 9)
        long_put_butterfly = self.test_utils.\
            create_long_put_butterfly_position(opening_date)
        print(long_put_butterfly)
        fiddle = Fiddle(user_id='vladimir',
                        title='Long Butterfly April 9th test Python',
                        position=long_put_butterfly)
        user_id = 'vladimir'
        data = {'body': fiddle}
        fiddle = self.api.save_fiddle(user_id, **data)
        print('Saved fiddle %s' % fiddle)

        # TODO: add assertion to response

        # delete fiddle
        self.api.delete_fiddle(id=fiddle.id)
        print('Deleted fiddle with id %s' % fiddle.id)


if __name__ == '__main__':
    unittest.main()
