# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetTlsSubscriptionIdsResult',
    'AwaitableGetTlsSubscriptionIdsResult',
    'get_tls_subscription_ids',
    'get_tls_subscription_ids_output',
]

@pulumi.output_type
class GetTlsSubscriptionIdsResult:
    """
    A collection of values returned by getTlsSubscriptionIds.
    """
    def __init__(__self__, id=None, ids=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[builtins.str]:
        """
        IDs of available TLS subscriptions.
        """
        return pulumi.get(self, "ids")


class AwaitableGetTlsSubscriptionIdsResult(GetTlsSubscriptionIdsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTlsSubscriptionIdsResult(
            id=self.id,
            ids=self.ids)


def get_tls_subscription_ids(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTlsSubscriptionIdsResult:
    """
    Use this data source to get the list of IDs of TLS Subscriptions in Fastly.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_fastly as fastly

    example = fastly.get_tls_subscription_ids()
    example_get_tls_subscription = {__key: fastly.get_tls_subscription(id=__value) for __key, __value in example.ids}
    pulumi.export("subscriptionDomains", [a.certificate_authority for a in example_get_tls_subscription])
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('fastly:index/getTlsSubscriptionIds:getTlsSubscriptionIds', __args__, opts=opts, typ=GetTlsSubscriptionIdsResult).value

    return AwaitableGetTlsSubscriptionIdsResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'))
def get_tls_subscription_ids_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTlsSubscriptionIdsResult]:
    """
    Use this data source to get the list of IDs of TLS Subscriptions in Fastly.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_fastly as fastly

    example = fastly.get_tls_subscription_ids()
    example_get_tls_subscription = {__key: fastly.get_tls_subscription(id=__value) for __key, __value in example.ids}
    pulumi.export("subscriptionDomains", [a.certificate_authority for a in example_get_tls_subscription])
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('fastly:index/getTlsSubscriptionIds:getTlsSubscriptionIds', __args__, opts=opts, typ=GetTlsSubscriptionIdsResult)
    return __ret__.apply(lambda __response__: GetTlsSubscriptionIdsResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids')))
