# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ObjectStorageAccessKeysArgs', 'ObjectStorageAccessKeys']

@pulumi.input_type
class ObjectStorageAccessKeysArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[builtins.str],
                 permission: pulumi.Input[builtins.str],
                 buckets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ObjectStorageAccessKeys resource.
        :param pulumi.Input[builtins.str] description: The description of the access key
        :param pulumi.Input[builtins.str] permission: The permissions of the access key
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] buckets: Optional list of buckets the access key will be associated with.  Example: `["bucket1", "bucket2"]`
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "permission", permission)
        if buckets is not None:
            pulumi.set(__self__, "buckets", buckets)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        The description of the access key
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def permission(self) -> pulumi.Input[builtins.str]:
        """
        The permissions of the access key
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "permission", value)

    @property
    @pulumi.getter
    def buckets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Optional list of buckets the access key will be associated with.  Example: `["bucket1", "bucket2"]`
        """
        return pulumi.get(self, "buckets")

    @buckets.setter
    def buckets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "buckets", value)


@pulumi.input_type
class _ObjectStorageAccessKeysState:
    def __init__(__self__, *,
                 access_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 buckets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 permission: Optional[pulumi.Input[builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ObjectStorageAccessKeys resources.
        :param pulumi.Input[builtins.str] access_key_id: ID for the object storage access token
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] buckets: Optional list of buckets the access key will be associated with.  Example: `["bucket1", "bucket2"]`
        :param pulumi.Input[builtins.str] description: The description of the access key
        :param pulumi.Input[builtins.str] permission: The permissions of the access key
        :param pulumi.Input[builtins.str] secret_key: Secret key for the object storage access token
        """
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if buckets is not None:
            pulumi.set(__self__, "buckets", buckets)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID for the object storage access token
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_key_id", value)

    @property
    @pulumi.getter
    def buckets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Optional list of buckets the access key will be associated with.  Example: `["bucket1", "bucket2"]`
        """
        return pulumi.get(self, "buckets")

    @buckets.setter
    def buckets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "buckets", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the access key
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def permission(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The permissions of the access key
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "permission", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Secret key for the object storage access token
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_key", value)


@pulumi.type_token("fastly:index/objectStorageAccessKeys:ObjectStorageAccessKeys")
class ObjectStorageAccessKeys(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 buckets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 permission: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides an Object Storage Access Key, which can be used to manage resources in various clouds.

        Implements the [Object Storage Access Key API functions](https://www.fastly.com/documentation/reference/api/services/resources/object-storage-access-keys/)

        > **Note:** Access Keys cannot be updated, so when you change a value in any of the editable fields the key is destroyed and remade

        Basic usage

        ```python
        import pulumi
        import pulumi_fastly as fastly

        demo = fastly.ObjectStorageAccessKeys("demo",
            buckets=[
                "bucket1",
                "bucket2",
            ],
            description="this is a bucket",
            permission="")
        ```
        > **Note:** Permissions can only be one of these values listed [here](https://quic.fastly.com/documentation/reference/api/services/resources/object-storage-access-keys/#permissions), any other values will return an error

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] buckets: Optional list of buckets the access key will be associated with.  Example: `["bucket1", "bucket2"]`
        :param pulumi.Input[builtins.str] description: The description of the access key
        :param pulumi.Input[builtins.str] permission: The permissions of the access key
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ObjectStorageAccessKeysArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Object Storage Access Key, which can be used to manage resources in various clouds.

        Implements the [Object Storage Access Key API functions](https://www.fastly.com/documentation/reference/api/services/resources/object-storage-access-keys/)

        > **Note:** Access Keys cannot be updated, so when you change a value in any of the editable fields the key is destroyed and remade

        Basic usage

        ```python
        import pulumi
        import pulumi_fastly as fastly

        demo = fastly.ObjectStorageAccessKeys("demo",
            buckets=[
                "bucket1",
                "bucket2",
            ],
            description="this is a bucket",
            permission="")
        ```
        > **Note:** Permissions can only be one of these values listed [here](https://quic.fastly.com/documentation/reference/api/services/resources/object-storage-access-keys/#permissions), any other values will return an error

        :param str resource_name: The name of the resource.
        :param ObjectStorageAccessKeysArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ObjectStorageAccessKeysArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 buckets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 permission: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ObjectStorageAccessKeysArgs.__new__(ObjectStorageAccessKeysArgs)

            __props__.__dict__["buckets"] = buckets
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if permission is None and not opts.urn:
                raise TypeError("Missing required property 'permission'")
            __props__.__dict__["permission"] = permission
            __props__.__dict__["access_key_id"] = None
            __props__.__dict__["secret_key"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secretKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ObjectStorageAccessKeys, __self__).__init__(
            'fastly:index/objectStorageAccessKeys:ObjectStorageAccessKeys',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key_id: Optional[pulumi.Input[builtins.str]] = None,
            buckets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            permission: Optional[pulumi.Input[builtins.str]] = None,
            secret_key: Optional[pulumi.Input[builtins.str]] = None) -> 'ObjectStorageAccessKeys':
        """
        Get an existing ObjectStorageAccessKeys resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_key_id: ID for the object storage access token
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] buckets: Optional list of buckets the access key will be associated with.  Example: `["bucket1", "bucket2"]`
        :param pulumi.Input[builtins.str] description: The description of the access key
        :param pulumi.Input[builtins.str] permission: The permissions of the access key
        :param pulumi.Input[builtins.str] secret_key: Secret key for the object storage access token
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ObjectStorageAccessKeysState.__new__(_ObjectStorageAccessKeysState)

        __props__.__dict__["access_key_id"] = access_key_id
        __props__.__dict__["buckets"] = buckets
        __props__.__dict__["description"] = description
        __props__.__dict__["permission"] = permission
        __props__.__dict__["secret_key"] = secret_key
        return ObjectStorageAccessKeys(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> pulumi.Output[builtins.str]:
        """
        ID for the object storage access token
        """
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter
    def buckets(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Optional list of buckets the access key will be associated with.  Example: `["bucket1", "bucket2"]`
        """
        return pulumi.get(self, "buckets")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the access key
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def permission(self) -> pulumi.Output[builtins.str]:
        """
        The permissions of the access key
        """
        return pulumi.get(self, "permission")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[builtins.str]:
        """
        Secret key for the object storage access token
        """
        return pulumi.get(self, "secret_key")

