# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DbSystemArgs', 'DbSystem']

@pulumi.input_type
class DbSystemArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 db_version: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 network_details: pulumi.Input['DbSystemNetworkDetailsArgs'],
                 shape: pulumi.Input[str],
                 storage_details: pulumi.Input['DbSystemStorageDetailsArgs'],
                 config_id: Optional[pulumi.Input[str]] = None,
                 credentials: Optional[pulumi.Input['DbSystemCredentialsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 instance_memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 instance_ocpu_count: Optional[pulumi.Input[int]] = None,
                 instances_details: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemInstancesDetailArgs']]]] = None,
                 management_policy: Optional[pulumi.Input['DbSystemManagementPolicyArgs']] = None,
                 source: Optional[pulumi.Input['DbSystemSourceArgs']] = None,
                 system_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DbSystem resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment identifier
        :param pulumi.Input[str] db_version: Version of DbSystem software.
        :param pulumi.Input[str] display_name: Display name of the DbInstance.
        :param pulumi.Input['DbSystemNetworkDetailsArgs'] network_details: DbSystem network details.
        :param pulumi.Input[str] shape: Shape of DbInstance. This name should match from with one of the available shapes from /shapes API.
        :param pulumi.Input['DbSystemStorageDetailsArgs'] storage_details: (Updatable) Storage details of the DbSystem.
        :param pulumi.Input[str] config_id: Configuration identifier
        :param pulumi.Input['DbSystemCredentialsArgs'] credentials: Initial DbSystem credentials that the DbSystem will be provisioned with. The password details are not visible on any subsequent operation, such as GET /dbSystems/{dbSystemId}.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: Description of the DbInstance. This field should be input by the user.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[int] instance_count: Count of DbInstances to be created in the DbSystem.
        :param pulumi.Input[int] instance_memory_size_in_gbs: The total amount of memory available to each DbInstance, in gigabytes.
        :param pulumi.Input[int] instance_ocpu_count: The total number of OCPUs available to each DbInstance.
        :param pulumi.Input[Sequence[pulumi.Input['DbSystemInstancesDetailArgs']]] instances_details: Details of DbInstances to be created. Optional parameter. If specified, its size must match instanceCount.
        :param pulumi.Input['DbSystemManagementPolicyArgs'] management_policy: (Updatable) Posgresql DB system management policy update details
        :param pulumi.Input['DbSystemSourceArgs'] source: New source is used to restore the DB system.
        :param pulumi.Input[str] system_type: Type of the DbSystem.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "db_version", db_version)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "network_details", network_details)
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "storage_details", storage_details)
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_memory_size_in_gbs is not None:
            pulumi.set(__self__, "instance_memory_size_in_gbs", instance_memory_size_in_gbs)
        if instance_ocpu_count is not None:
            pulumi.set(__self__, "instance_ocpu_count", instance_ocpu_count)
        if instances_details is not None:
            pulumi.set(__self__, "instances_details", instances_details)
        if management_policy is not None:
            pulumi.set(__self__, "management_policy", management_policy)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if system_type is not None:
            pulumi.set(__self__, "system_type", system_type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Compartment identifier
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> pulumi.Input[str]:
        """
        Version of DbSystem software.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_version", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        Display name of the DbInstance.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="networkDetails")
    def network_details(self) -> pulumi.Input['DbSystemNetworkDetailsArgs']:
        """
        DbSystem network details.
        """
        return pulumi.get(self, "network_details")

    @network_details.setter
    def network_details(self, value: pulumi.Input['DbSystemNetworkDetailsArgs']):
        pulumi.set(self, "network_details", value)

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Input[str]:
        """
        Shape of DbInstance. This name should match from with one of the available shapes from /shapes API.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: pulumi.Input[str]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter(name="storageDetails")
    def storage_details(self) -> pulumi.Input['DbSystemStorageDetailsArgs']:
        """
        (Updatable) Storage details of the DbSystem.
        """
        return pulumi.get(self, "storage_details")

    @storage_details.setter
    def storage_details(self, value: pulumi.Input['DbSystemStorageDetailsArgs']):
        pulumi.set(self, "storage_details", value)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration identifier
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_id", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['DbSystemCredentialsArgs']]:
        """
        Initial DbSystem credentials that the DbSystem will be provisioned with. The password details are not visible on any subsequent operation, such as GET /dbSystems/{dbSystemId}.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['DbSystemCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the DbInstance. This field should be input by the user.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        Count of DbInstances to be created in the DbSystem.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="instanceMemorySizeInGbs")
    def instance_memory_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The total amount of memory available to each DbInstance, in gigabytes.
        """
        return pulumi.get(self, "instance_memory_size_in_gbs")

    @instance_memory_size_in_gbs.setter
    def instance_memory_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_memory_size_in_gbs", value)

    @property
    @pulumi.getter(name="instanceOcpuCount")
    def instance_ocpu_count(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of OCPUs available to each DbInstance.
        """
        return pulumi.get(self, "instance_ocpu_count")

    @instance_ocpu_count.setter
    def instance_ocpu_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_ocpu_count", value)

    @property
    @pulumi.getter(name="instancesDetails")
    def instances_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemInstancesDetailArgs']]]]:
        """
        Details of DbInstances to be created. Optional parameter. If specified, its size must match instanceCount.
        """
        return pulumi.get(self, "instances_details")

    @instances_details.setter
    def instances_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemInstancesDetailArgs']]]]):
        pulumi.set(self, "instances_details", value)

    @property
    @pulumi.getter(name="managementPolicy")
    def management_policy(self) -> Optional[pulumi.Input['DbSystemManagementPolicyArgs']]:
        """
        (Updatable) Posgresql DB system management policy update details
        """
        return pulumi.get(self, "management_policy")

    @management_policy.setter
    def management_policy(self, value: Optional[pulumi.Input['DbSystemManagementPolicyArgs']]):
        pulumi.set(self, "management_policy", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['DbSystemSourceArgs']]:
        """
        New source is used to restore the DB system.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['DbSystemSourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="systemType")
    def system_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the DbSystem.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_type")

    @system_type.setter
    def system_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_type", value)


@pulumi.input_type
class _DbSystemState:
    def __init__(__self__, *,
                 admin_username: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 config_id: Optional[pulumi.Input[str]] = None,
                 credentials: Optional[pulumi.Input['DbSystemCredentialsArgs']] = None,
                 db_version: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 instance_memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 instance_ocpu_count: Optional[pulumi.Input[int]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemInstanceArgs']]]] = None,
                 instances_details: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemInstancesDetailArgs']]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 management_policy: Optional[pulumi.Input['DbSystemManagementPolicyArgs']] = None,
                 network_details: Optional[pulumi.Input['DbSystemNetworkDetailsArgs']] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input['DbSystemSourceArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 storage_details: Optional[pulumi.Input['DbSystemStorageDetailsArgs']] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 system_type: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DbSystem resources.
        :param pulumi.Input[str] admin_username: The DB system username.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment identifier
        :param pulumi.Input[str] config_id: Configuration identifier
        :param pulumi.Input['DbSystemCredentialsArgs'] credentials: Initial DbSystem credentials that the DbSystem will be provisioned with. The password details are not visible on any subsequent operation, such as GET /dbSystems/{dbSystemId}.
        :param pulumi.Input[str] db_version: Version of DbSystem software.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: Description of the DbInstance. This field should be input by the user.
        :param pulumi.Input[str] display_name: Display name of the DbInstance.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[int] instance_count: Count of DbInstances to be created in the DbSystem.
        :param pulumi.Input[int] instance_memory_size_in_gbs: The total amount of memory available to each DbInstance, in gigabytes.
        :param pulumi.Input[int] instance_ocpu_count: The total number of OCPUs available to each DbInstance.
        :param pulumi.Input[Sequence[pulumi.Input['DbSystemInstanceArgs']]] instances: The list of DbInstances in the DbSystem.
        :param pulumi.Input[Sequence[pulumi.Input['DbSystemInstancesDetailArgs']]] instances_details: Details of DbInstances to be created. Optional parameter. If specified, its size must match instanceCount.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input['DbSystemManagementPolicyArgs'] management_policy: (Updatable) Posgresql DB system management policy update details
        :param pulumi.Input['DbSystemNetworkDetailsArgs'] network_details: DbSystem network details.
        :param pulumi.Input[str] shape: Shape of DbInstance. This name should match from with one of the available shapes from /shapes API.
        :param pulumi.Input['DbSystemSourceArgs'] source: New source is used to restore the DB system.
        :param pulumi.Input[str] state: The current state of the DbSystem.
        :param pulumi.Input['DbSystemStorageDetailsArgs'] storage_details: (Updatable) Storage details of the DbSystem.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] system_type: Type of the DbSystem.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The time the the DbSystem was created. An RFC3339 formatted datetime string
        :param pulumi.Input[str] time_updated: The time the DbSystem was updated. An RFC3339 formatted datetime string
        """
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if db_version is not None:
            pulumi.set(__self__, "db_version", db_version)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_memory_size_in_gbs is not None:
            pulumi.set(__self__, "instance_memory_size_in_gbs", instance_memory_size_in_gbs)
        if instance_ocpu_count is not None:
            pulumi.set(__self__, "instance_ocpu_count", instance_ocpu_count)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if instances_details is not None:
            pulumi.set(__self__, "instances_details", instances_details)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if management_policy is not None:
            pulumi.set(__self__, "management_policy", management_policy)
        if network_details is not None:
            pulumi.set(__self__, "network_details", network_details)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_details is not None:
            pulumi.set(__self__, "storage_details", storage_details)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if system_type is not None:
            pulumi.set(__self__, "system_type", system_type)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[pulumi.Input[str]]:
        """
        The DB system username.
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_username", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Compartment identifier
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration identifier
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_id", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['DbSystemCredentialsArgs']]:
        """
        Initial DbSystem credentials that the DbSystem will be provisioned with. The password details are not visible on any subsequent operation, such as GET /dbSystems/{dbSystemId}.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['DbSystemCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of DbSystem software.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_version", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the DbInstance. This field should be input by the user.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of the DbInstance.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        Count of DbInstances to be created in the DbSystem.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="instanceMemorySizeInGbs")
    def instance_memory_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The total amount of memory available to each DbInstance, in gigabytes.
        """
        return pulumi.get(self, "instance_memory_size_in_gbs")

    @instance_memory_size_in_gbs.setter
    def instance_memory_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_memory_size_in_gbs", value)

    @property
    @pulumi.getter(name="instanceOcpuCount")
    def instance_ocpu_count(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of OCPUs available to each DbInstance.
        """
        return pulumi.get(self, "instance_ocpu_count")

    @instance_ocpu_count.setter
    def instance_ocpu_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_ocpu_count", value)

    @property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemInstanceArgs']]]]:
        """
        The list of DbInstances in the DbSystem.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemInstanceArgs']]]]):
        pulumi.set(self, "instances", value)

    @property
    @pulumi.getter(name="instancesDetails")
    def instances_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemInstancesDetailArgs']]]]:
        """
        Details of DbInstances to be created. Optional parameter. If specified, its size must match instanceCount.
        """
        return pulumi.get(self, "instances_details")

    @instances_details.setter
    def instances_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemInstancesDetailArgs']]]]):
        pulumi.set(self, "instances_details", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="managementPolicy")
    def management_policy(self) -> Optional[pulumi.Input['DbSystemManagementPolicyArgs']]:
        """
        (Updatable) Posgresql DB system management policy update details
        """
        return pulumi.get(self, "management_policy")

    @management_policy.setter
    def management_policy(self, value: Optional[pulumi.Input['DbSystemManagementPolicyArgs']]):
        pulumi.set(self, "management_policy", value)

    @property
    @pulumi.getter(name="networkDetails")
    def network_details(self) -> Optional[pulumi.Input['DbSystemNetworkDetailsArgs']]:
        """
        DbSystem network details.
        """
        return pulumi.get(self, "network_details")

    @network_details.setter
    def network_details(self, value: Optional[pulumi.Input['DbSystemNetworkDetailsArgs']]):
        pulumi.set(self, "network_details", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[str]]:
        """
        Shape of DbInstance. This name should match from with one of the available shapes from /shapes API.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['DbSystemSourceArgs']]:
        """
        New source is used to restore the DB system.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['DbSystemSourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the DbSystem.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="storageDetails")
    def storage_details(self) -> Optional[pulumi.Input['DbSystemStorageDetailsArgs']]:
        """
        (Updatable) Storage details of the DbSystem.
        """
        return pulumi.get(self, "storage_details")

    @storage_details.setter
    def storage_details(self, value: Optional[pulumi.Input['DbSystemStorageDetailsArgs']]):
        pulumi.set(self, "storage_details", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="systemType")
    def system_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the DbSystem.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_type")

    @system_type.setter
    def system_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_type", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the the DbSystem was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the DbSystem was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class DbSystem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 config_id: Optional[pulumi.Input[str]] = None,
                 credentials: Optional[pulumi.Input[pulumi.InputType['DbSystemCredentialsArgs']]] = None,
                 db_version: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 instance_memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 instance_ocpu_count: Optional[pulumi.Input[int]] = None,
                 instances_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DbSystemInstancesDetailArgs']]]]] = None,
                 management_policy: Optional[pulumi.Input[pulumi.InputType['DbSystemManagementPolicyArgs']]] = None,
                 network_details: Optional[pulumi.Input[pulumi.InputType['DbSystemNetworkDetailsArgs']]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[pulumi.InputType['DbSystemSourceArgs']]] = None,
                 storage_details: Optional[pulumi.Input[pulumi.InputType['DbSystemStorageDetailsArgs']]] = None,
                 system_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Db System resource in Oracle Cloud Infrastructure Psql service.

        Creates a new DbSystem.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_db_system = oci.psql.DbSystem("testDbSystem",
            compartment_id=var["compartment_id"],
            db_version=var["db_system_db_version"],
            display_name=var["db_system_display_name"],
            network_details=oci.psql.DbSystemNetworkDetailsArgs(
                subnet_id=oci_core_subnet["test_subnet"]["id"],
                nsg_ids=var["db_system_network_details_nsg_ids"],
                primary_db_endpoint_private_ip=var["db_system_network_details_primary_db_endpoint_private_ip"],
            ),
            shape=var["db_system_shape"],
            storage_details=oci.psql.DbSystemStorageDetailsArgs(
                is_regionally_durable=var["db_system_storage_details_is_regionally_durable"],
                system_type=var["db_system_storage_details_system_type"],
                availability_domain=var["db_system_storage_details_availability_domain"],
                iops=var["db_system_storage_details_iops"],
            ),
            config_id=oci_apm_config_config["test_config"]["id"],
            credentials=oci.psql.DbSystemCredentialsArgs(
                password_details=oci.psql.DbSystemCredentialsPasswordDetailsArgs(
                    password_type=var["db_system_credentials_password_details_password_type"],
                    password=var["db_system_credentials_password_details_password"],
                    secret_id=oci_vault_secret["test_secret"]["id"],
                    secret_version=var["db_system_credentials_password_details_secret_version"],
                ),
                username=var["db_system_credentials_username"],
            ),
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=var["db_system_description"],
            freeform_tags={
                "bar-key": "value",
            },
            instance_count=var["db_system_instance_count"],
            instance_memory_size_in_gbs=var["db_system_instance_memory_size_in_gbs"],
            instance_ocpu_count=var["db_system_instance_ocpu_count"],
            instances_details=[oci.psql.DbSystemInstancesDetailArgs(
                description=var["db_system_instances_details_description"],
                display_name=var["db_system_instances_details_display_name"],
                private_ip=var["db_system_instances_details_private_ip"],
            )],
            management_policy=oci.psql.DbSystemManagementPolicyArgs(
                backup_policy=oci.psql.DbSystemManagementPolicyBackupPolicyArgs(
                    backup_start=var["db_system_management_policy_backup_policy_backup_start"],
                    days_of_the_months=var["db_system_management_policy_backup_policy_days_of_the_month"],
                    days_of_the_weeks=var["db_system_management_policy_backup_policy_days_of_the_week"],
                    kind=var["db_system_management_policy_backup_policy_kind"],
                    retention_days=var["db_system_management_policy_backup_policy_retention_days"],
                ),
                maintenance_window_start=var["db_system_management_policy_maintenance_window_start"],
            ),
            source=oci.psql.DbSystemSourceArgs(
                source_type=var["db_system_source_source_type"],
                backup_id=oci_psql_backup["test_backup"]["id"],
                is_having_restore_config_overrides=var["db_system_source_is_having_restore_config_overrides"],
            ),
            system_type=var["db_system_system_type"])
        ```

        ## Import

        DbSystems can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Psql/dbSystem:DbSystem test_db_system "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment identifier
        :param pulumi.Input[str] config_id: Configuration identifier
        :param pulumi.Input[pulumi.InputType['DbSystemCredentialsArgs']] credentials: Initial DbSystem credentials that the DbSystem will be provisioned with. The password details are not visible on any subsequent operation, such as GET /dbSystems/{dbSystemId}.
        :param pulumi.Input[str] db_version: Version of DbSystem software.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: Description of the DbInstance. This field should be input by the user.
        :param pulumi.Input[str] display_name: Display name of the DbInstance.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[int] instance_count: Count of DbInstances to be created in the DbSystem.
        :param pulumi.Input[int] instance_memory_size_in_gbs: The total amount of memory available to each DbInstance, in gigabytes.
        :param pulumi.Input[int] instance_ocpu_count: The total number of OCPUs available to each DbInstance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DbSystemInstancesDetailArgs']]]] instances_details: Details of DbInstances to be created. Optional parameter. If specified, its size must match instanceCount.
        :param pulumi.Input[pulumi.InputType['DbSystemManagementPolicyArgs']] management_policy: (Updatable) Posgresql DB system management policy update details
        :param pulumi.Input[pulumi.InputType['DbSystemNetworkDetailsArgs']] network_details: DbSystem network details.
        :param pulumi.Input[str] shape: Shape of DbInstance. This name should match from with one of the available shapes from /shapes API.
        :param pulumi.Input[pulumi.InputType['DbSystemSourceArgs']] source: New source is used to restore the DB system.
        :param pulumi.Input[pulumi.InputType['DbSystemStorageDetailsArgs']] storage_details: (Updatable) Storage details of the DbSystem.
        :param pulumi.Input[str] system_type: Type of the DbSystem.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbSystemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Db System resource in Oracle Cloud Infrastructure Psql service.

        Creates a new DbSystem.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_db_system = oci.psql.DbSystem("testDbSystem",
            compartment_id=var["compartment_id"],
            db_version=var["db_system_db_version"],
            display_name=var["db_system_display_name"],
            network_details=oci.psql.DbSystemNetworkDetailsArgs(
                subnet_id=oci_core_subnet["test_subnet"]["id"],
                nsg_ids=var["db_system_network_details_nsg_ids"],
                primary_db_endpoint_private_ip=var["db_system_network_details_primary_db_endpoint_private_ip"],
            ),
            shape=var["db_system_shape"],
            storage_details=oci.psql.DbSystemStorageDetailsArgs(
                is_regionally_durable=var["db_system_storage_details_is_regionally_durable"],
                system_type=var["db_system_storage_details_system_type"],
                availability_domain=var["db_system_storage_details_availability_domain"],
                iops=var["db_system_storage_details_iops"],
            ),
            config_id=oci_apm_config_config["test_config"]["id"],
            credentials=oci.psql.DbSystemCredentialsArgs(
                password_details=oci.psql.DbSystemCredentialsPasswordDetailsArgs(
                    password_type=var["db_system_credentials_password_details_password_type"],
                    password=var["db_system_credentials_password_details_password"],
                    secret_id=oci_vault_secret["test_secret"]["id"],
                    secret_version=var["db_system_credentials_password_details_secret_version"],
                ),
                username=var["db_system_credentials_username"],
            ),
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=var["db_system_description"],
            freeform_tags={
                "bar-key": "value",
            },
            instance_count=var["db_system_instance_count"],
            instance_memory_size_in_gbs=var["db_system_instance_memory_size_in_gbs"],
            instance_ocpu_count=var["db_system_instance_ocpu_count"],
            instances_details=[oci.psql.DbSystemInstancesDetailArgs(
                description=var["db_system_instances_details_description"],
                display_name=var["db_system_instances_details_display_name"],
                private_ip=var["db_system_instances_details_private_ip"],
            )],
            management_policy=oci.psql.DbSystemManagementPolicyArgs(
                backup_policy=oci.psql.DbSystemManagementPolicyBackupPolicyArgs(
                    backup_start=var["db_system_management_policy_backup_policy_backup_start"],
                    days_of_the_months=var["db_system_management_policy_backup_policy_days_of_the_month"],
                    days_of_the_weeks=var["db_system_management_policy_backup_policy_days_of_the_week"],
                    kind=var["db_system_management_policy_backup_policy_kind"],
                    retention_days=var["db_system_management_policy_backup_policy_retention_days"],
                ),
                maintenance_window_start=var["db_system_management_policy_maintenance_window_start"],
            ),
            source=oci.psql.DbSystemSourceArgs(
                source_type=var["db_system_source_source_type"],
                backup_id=oci_psql_backup["test_backup"]["id"],
                is_having_restore_config_overrides=var["db_system_source_is_having_restore_config_overrides"],
            ),
            system_type=var["db_system_system_type"])
        ```

        ## Import

        DbSystems can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Psql/dbSystem:DbSystem test_db_system "id"
        ```

        :param str resource_name: The name of the resource.
        :param DbSystemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbSystemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 config_id: Optional[pulumi.Input[str]] = None,
                 credentials: Optional[pulumi.Input[pulumi.InputType['DbSystemCredentialsArgs']]] = None,
                 db_version: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 instance_memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 instance_ocpu_count: Optional[pulumi.Input[int]] = None,
                 instances_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DbSystemInstancesDetailArgs']]]]] = None,
                 management_policy: Optional[pulumi.Input[pulumi.InputType['DbSystemManagementPolicyArgs']]] = None,
                 network_details: Optional[pulumi.Input[pulumi.InputType['DbSystemNetworkDetailsArgs']]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[pulumi.InputType['DbSystemSourceArgs']]] = None,
                 storage_details: Optional[pulumi.Input[pulumi.InputType['DbSystemStorageDetailsArgs']]] = None,
                 system_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbSystemArgs.__new__(DbSystemArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["config_id"] = config_id
            __props__.__dict__["credentials"] = credentials
            if db_version is None and not opts.urn:
                raise TypeError("Missing required property 'db_version'")
            __props__.__dict__["db_version"] = db_version
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["instance_count"] = instance_count
            __props__.__dict__["instance_memory_size_in_gbs"] = instance_memory_size_in_gbs
            __props__.__dict__["instance_ocpu_count"] = instance_ocpu_count
            __props__.__dict__["instances_details"] = instances_details
            __props__.__dict__["management_policy"] = management_policy
            if network_details is None and not opts.urn:
                raise TypeError("Missing required property 'network_details'")
            __props__.__dict__["network_details"] = network_details
            if shape is None and not opts.urn:
                raise TypeError("Missing required property 'shape'")
            __props__.__dict__["shape"] = shape
            __props__.__dict__["source"] = source
            if storage_details is None and not opts.urn:
                raise TypeError("Missing required property 'storage_details'")
            __props__.__dict__["storage_details"] = storage_details
            __props__.__dict__["system_type"] = system_type
            __props__.__dict__["admin_username"] = None
            __props__.__dict__["instances"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(DbSystem, __self__).__init__(
            'oci:Psql/dbSystem:DbSystem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_username: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            config_id: Optional[pulumi.Input[str]] = None,
            credentials: Optional[pulumi.Input[pulumi.InputType['DbSystemCredentialsArgs']]] = None,
            db_version: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            instance_count: Optional[pulumi.Input[int]] = None,
            instance_memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
            instance_ocpu_count: Optional[pulumi.Input[int]] = None,
            instances: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DbSystemInstanceArgs']]]]] = None,
            instances_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DbSystemInstancesDetailArgs']]]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            management_policy: Optional[pulumi.Input[pulumi.InputType['DbSystemManagementPolicyArgs']]] = None,
            network_details: Optional[pulumi.Input[pulumi.InputType['DbSystemNetworkDetailsArgs']]] = None,
            shape: Optional[pulumi.Input[str]] = None,
            source: Optional[pulumi.Input[pulumi.InputType['DbSystemSourceArgs']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            storage_details: Optional[pulumi.Input[pulumi.InputType['DbSystemStorageDetailsArgs']]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            system_type: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'DbSystem':
        """
        Get an existing DbSystem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_username: The DB system username.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment identifier
        :param pulumi.Input[str] config_id: Configuration identifier
        :param pulumi.Input[pulumi.InputType['DbSystemCredentialsArgs']] credentials: Initial DbSystem credentials that the DbSystem will be provisioned with. The password details are not visible on any subsequent operation, such as GET /dbSystems/{dbSystemId}.
        :param pulumi.Input[str] db_version: Version of DbSystem software.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: Description of the DbInstance. This field should be input by the user.
        :param pulumi.Input[str] display_name: Display name of the DbInstance.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[int] instance_count: Count of DbInstances to be created in the DbSystem.
        :param pulumi.Input[int] instance_memory_size_in_gbs: The total amount of memory available to each DbInstance, in gigabytes.
        :param pulumi.Input[int] instance_ocpu_count: The total number of OCPUs available to each DbInstance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DbSystemInstanceArgs']]]] instances: The list of DbInstances in the DbSystem.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DbSystemInstancesDetailArgs']]]] instances_details: Details of DbInstances to be created. Optional parameter. If specified, its size must match instanceCount.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[pulumi.InputType['DbSystemManagementPolicyArgs']] management_policy: (Updatable) Posgresql DB system management policy update details
        :param pulumi.Input[pulumi.InputType['DbSystemNetworkDetailsArgs']] network_details: DbSystem network details.
        :param pulumi.Input[str] shape: Shape of DbInstance. This name should match from with one of the available shapes from /shapes API.
        :param pulumi.Input[pulumi.InputType['DbSystemSourceArgs']] source: New source is used to restore the DB system.
        :param pulumi.Input[str] state: The current state of the DbSystem.
        :param pulumi.Input[pulumi.InputType['DbSystemStorageDetailsArgs']] storage_details: (Updatable) Storage details of the DbSystem.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] system_type: Type of the DbSystem.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The time the the DbSystem was created. An RFC3339 formatted datetime string
        :param pulumi.Input[str] time_updated: The time the DbSystem was updated. An RFC3339 formatted datetime string
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DbSystemState.__new__(_DbSystemState)

        __props__.__dict__["admin_username"] = admin_username
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["db_version"] = db_version
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["instance_count"] = instance_count
        __props__.__dict__["instance_memory_size_in_gbs"] = instance_memory_size_in_gbs
        __props__.__dict__["instance_ocpu_count"] = instance_ocpu_count
        __props__.__dict__["instances"] = instances
        __props__.__dict__["instances_details"] = instances_details
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["management_policy"] = management_policy
        __props__.__dict__["network_details"] = network_details
        __props__.__dict__["shape"] = shape
        __props__.__dict__["source"] = source
        __props__.__dict__["state"] = state
        __props__.__dict__["storage_details"] = storage_details
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["system_type"] = system_type
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return DbSystem(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> pulumi.Output[str]:
        """
        The DB system username.
        """
        return pulumi.get(self, "admin_username")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Compartment identifier
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[str]:
        """
        Configuration identifier
        """
        return pulumi.get(self, "config_id")

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Output[Optional['outputs.DbSystemCredentials']]:
        """
        Initial DbSystem credentials that the DbSystem will be provisioned with. The password details are not visible on any subsequent operation, such as GET /dbSystems/{dbSystemId}.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> pulumi.Output[str]:
        """
        Version of DbSystem software.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description of the DbInstance. This field should be input by the user.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Display name of the DbInstance.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> pulumi.Output[int]:
        """
        Count of DbInstances to be created in the DbSystem.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceMemorySizeInGbs")
    def instance_memory_size_in_gbs(self) -> pulumi.Output[int]:
        """
        The total amount of memory available to each DbInstance, in gigabytes.
        """
        return pulumi.get(self, "instance_memory_size_in_gbs")

    @property
    @pulumi.getter(name="instanceOcpuCount")
    def instance_ocpu_count(self) -> pulumi.Output[int]:
        """
        The total number of OCPUs available to each DbInstance.
        """
        return pulumi.get(self, "instance_ocpu_count")

    @property
    @pulumi.getter
    def instances(self) -> pulumi.Output[Sequence['outputs.DbSystemInstance']]:
        """
        The list of DbInstances in the DbSystem.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter(name="instancesDetails")
    def instances_details(self) -> pulumi.Output[Sequence['outputs.DbSystemInstancesDetail']]:
        """
        Details of DbInstances to be created. Optional parameter. If specified, its size must match instanceCount.
        """
        return pulumi.get(self, "instances_details")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="managementPolicy")
    def management_policy(self) -> pulumi.Output['outputs.DbSystemManagementPolicy']:
        """
        (Updatable) Posgresql DB system management policy update details
        """
        return pulumi.get(self, "management_policy")

    @property
    @pulumi.getter(name="networkDetails")
    def network_details(self) -> pulumi.Output['outputs.DbSystemNetworkDetails']:
        """
        DbSystem network details.
        """
        return pulumi.get(self, "network_details")

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Output[str]:
        """
        Shape of DbInstance. This name should match from with one of the available shapes from /shapes API.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output['outputs.DbSystemSource']:
        """
        New source is used to restore the DB system.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the DbSystem.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageDetails")
    def storage_details(self) -> pulumi.Output['outputs.DbSystemStorageDetails']:
        """
        (Updatable) Storage details of the DbSystem.
        """
        return pulumi.get(self, "storage_details")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="systemType")
    def system_type(self) -> pulumi.Output[str]:
        """
        Type of the DbSystem.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_type")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the the DbSystem was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the DbSystem was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

