import numpy as np
import pinocchio as pin
import subprocess
from .. import core as jiminy
from ..core import discretize_heightmap as discretize_heightmap
from ..dynamics import State as State
from .meshcat.utilities import interactive_mode as interactive_mode
from .panda3d.panda3d_visualizer import Panda3dApp as Panda3dApp, Panda3dViewer as Panda3dViewer, Panda3dVisualizer as Panda3dVisualizer, ShapeType as ShapeType, Tuple3FType as Tuple3FType, Tuple4FType as Tuple4FType, convert_bvh_collision_geometry_to_primitive as convert_bvh_collision_geometry_to_primitive
from _typeshed import Incomplete
from multiprocessing import Process as ProcessMP
from psutil import Process
from threading import RLock
from typing import Any, Callable, Optional, Sequence, Tuple, TypedDict, Union, overload

REPLAY_FRAMERATE: int
CAMERA_INV_TRANSFORM_PANDA3D: Incomplete
CAMERA_INV_TRANSFORM_MESHCAT: Incomplete
DEFAULT_CAMERA_XYZRPY_ABS: Incomplete
DEFAULT_CAMERA_XYZRPY_REL: Incomplete
DEFAULT_WATERMARK_MAXSIZE: Incomplete
CONTACT_FORCE_SCALE: float
EXTERNAL_FORCE_SCALE: float
COLORS: Incomplete
LOGGER: Incomplete

@overload
def interp1d(t_in: np.ndarray, y_in: np.ndarray, t_out: float) -> float: ...
@overload
def interp1d(t_in: np.ndarray, y_in: np.ndarray, t_out: np.ndarray) -> np.ndarray: ...
def is_display_available() -> bool: ...
def get_default_backend() -> str: ...
def get_backend_type(backend_name: str) -> type: ...

TIMER_JITTER: Incomplete

def sleep(dt: float) -> None: ...
def get_color_code(color: Optional[Union[str, Tuple4FType]]) -> Optional[Tuple4FType]: ...

class _ProcessWrapper:
    def __init__(self, proc: Union[ProcessMP, subprocess.Popen, Process, Panda3dApp]) -> None: ...
    def __del__(self) -> None: ...
    def is_parent(self) -> bool: ...
    def is_alive(self) -> bool: ...
    def wait(self, timeout: Optional[float] = None) -> None: ...
    def kill(self) -> None: ...
CameraPoseType = Tuple[Optional[Tuple3FType], Optional[Tuple3FType], Optional[Union[int, str]]]

class CameraMotionBreakpointType(TypedDict, total=True):
    t: float
    pose: Tuple[Tuple3FType, Tuple3FType]
CameraMotionType = Sequence[CameraMotionBreakpointType]
Matrix3FType = np.ndarray
RotationType = Union[Tuple4FType, Matrix3FType]
FramePoseType = Tuple[Tuple3FType, RotationType]

class MarkerDataType(TypedDict, total=True):
    pose: Union[np.ndarray, Callable[[], np.ndarray]]
    scale: Union[Tuple3FType, Callable[[], Tuple3FType]]
    color: Optional[Union[Tuple4FType, Callable[[], Tuple4FType]]]

class Viewer:
    backend: Optional[str]
    window_name: str
    robot_name: Incomplete
    robot_color: Incomplete
    scene_name: Incomplete
    use_theoretical_model: Incomplete
    delete_robot_on_close: Incomplete
    markers: Incomplete
    f_external: Incomplete
    is_backend_parent: Incomplete
    def __init__(self, robot: jiminy.Model, use_theoretical_model: bool = False, robot_color: Optional[Union[str, Tuple4FType]] = None, lock: Optional[RLock] = None, backend: Optional[str] = None, open_gui_if_parent: Optional[bool] = None, delete_robot_on_close: bool = False, robot_name: Optional[str] = None, scene_name: str = 'world', display_com: bool = False, display_dcm: bool = False, display_contact_frames: bool = False, display_contact_forces: bool = False, display_f_external: Optional[Union[Sequence[bool], bool]] = None, **kwargs: Any) -> None: ...
    def __del__(self) -> None: ...
    @staticmethod
    def open_gui() -> None: ...
    @staticmethod
    def has_gui() -> bool: ...
    @staticmethod
    def wait(require_client: bool = False) -> None: ...
    @staticmethod
    def is_alive() -> bool: ...
    def is_open(self: Incomplete | None = None) -> bool: ...
    def close(self: Incomplete | None = None) -> None: ...
    @staticmethod
    def connect_backend(backend: Optional[str] = None) -> None: ...
    @staticmethod
    def set_watermark(img_fullpath: Optional[str] = None, width: Optional[int] = None, height: Optional[int] = None) -> None: ...
    @staticmethod
    def set_legend(labels: Optional[Sequence[str]] = None) -> None: ...
    @staticmethod
    def set_clock(t: Optional[float] = None) -> None: ...
    @staticmethod
    def get_camera_transform() -> Tuple[Tuple3FType, Tuple3FType]: ...
    def set_camera_transform(self: Incomplete | None = None, position: Optional[Tuple3FType] = None, rotation: Optional[Tuple3FType] = None, relative: Optional[Union[str, int]] = None, wait: bool = False) -> None: ...
    def set_camera_lookat(self, position: Tuple3FType, relative: Optional[Union[str, int]] = None, wait: bool = False) -> None: ...
    @staticmethod
    def register_camera_motion(camera_motion: CameraMotionType) -> None: ...
    @staticmethod
    def remove_camera_motion() -> None: ...
    def attach_camera(self, relative: Union[str, int], position: Optional[Tuple3FType] = None, rotation: Optional[Tuple3FType] = None, lock_relative_pose: Optional[bool] = None) -> None: ...
    @staticmethod
    def detach_camera() -> None: ...
    def set_color(self, color: Optional[Union[str, Tuple4FType]] = None) -> None: ...
    @staticmethod
    def update_floor(ground_profile: Optional[jiminy.HeightmapFunction] = None, x_range: Tuple[float, float] = (-10.0, 10.0), y_range: Tuple[float, float] = (-10.0, 10.0), grid_unit: Tuple[float, float] = (0.04, 0.04), simplify_meshes: bool = False, show_meshes: bool = False) -> None: ...
    @staticmethod
    def capture_frame(width: Optional[int] = None, height: Optional[int] = None, raw_data: bool = False) -> Union[np.ndarray, bytes]: ...
    @staticmethod
    def save_frame(image_path: str, width: Optional[int] = None, height: Optional[int] = None) -> None: ...
    def display_visuals(self, visibility: bool) -> None: ...
    def display_collisions(self, visibility: bool) -> None: ...
    def add_marker(self, name: str, shape: ShapeType, pose: Union[pin.SE3, Tuple[Optional[Tuple3FType], Optional[RotationType]], Callable[[], FramePoseType]] = (None, None), scale: Union[float, Tuple3FType, Callable[[], Tuple3FType]] = 1.0, color: Union[Optional[Union[str, Tuple4FType]], Callable[[], Tuple4FType]] = None, always_foreground: bool = True, remove_if_exists: bool = False, auto_refresh: bool = True, **shape_kwargs: Any) -> MarkerDataType: ...
    def display_center_of_mass(self, visibility: bool) -> None: ...
    def display_capture_point(self, visibility: bool) -> None: ...
    def display_contact_frames(self, visibility: bool) -> None: ...
    def display_contact_forces(self, visibility: bool) -> None: ...
    def display_external_forces(self, visibility: Union[Sequence[bool], bool]) -> None: ...
    def remove_marker(self, name: str) -> None: ...
    def refresh(self, force_update_visual: bool = False, force_update_collision: bool = False, wait: bool = False) -> None: ...
    def display(self, q: np.ndarray, v: Optional[np.ndarray] = None, xyz_offset: Optional[np.ndarray] = None, update_hook: Optional[Callable[[], None]] = None, wait: bool = False) -> None: ...
    def replay(self, evolution_robot: Sequence[State], time_interval: Union[np.ndarray, Tuple[float, float]] = ..., speed_ratio: float = 1.0, xyz_offset: Optional[np.ndarray] = None, update_hook: Optional[Callable[[float, np.ndarray, np.ndarray], None]] = None, enable_clock: bool = False, wait: bool = False) -> None: ...
