# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from ...types.article_translated_content import ArticleTranslatedContent
from .article_list_item_state import ArticleListItemState


class ArticleListItem(UncheckedBaseModel):
    """
    The data returned about your articles when you list them.
    """

    type: typing.Optional[typing.Literal["article"]] = pydantic.Field(default=None)
    """
    The type of object - `article`.
    """

    id: str = pydantic.Field()
    """
    The unique identifier for the article which is given by Intercom.
    """

    workspace_id: str = pydantic.Field()
    """
    The id of the workspace which the article belongs to.
    """

    title: str = pydantic.Field()
    """
    The title of the article. For multilingual articles, this will be the title of the default language's content.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the article. For multilingual articles, this will be the description of the default language's content.
    """

    body: typing.Optional[str] = pydantic.Field(default=None)
    """
    The body of the article in HTML. For multilingual articles, this will be the body of the default language's content.
    """

    author_id: int = pydantic.Field()
    """
    The id of the author of the article. For multilingual articles, this will be the id of the author of the default language's content. Must be a teammate on the help center's workspace.
    """

    state: ArticleListItemState = pydantic.Field()
    """
    Whether the article is `published` or is a `draft`. For multilingual articles, this will be the state of the default language's content.
    """

    created_at: int = pydantic.Field()
    """
    The time when the article was created. For multilingual articles, this will be the timestamp of creation of the default language's content in seconds.
    """

    updated_at: int = pydantic.Field()
    """
    The time when the article was last updated. For multilingual articles, this will be the timestamp of last update of the default language's content in seconds.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The URL of the article. For multilingual articles, this will be the URL of the default language's content.
    """

    parent_id: typing.Optional[int] = pydantic.Field(default=None)
    """
    The id of the article's parent collection or section. An article without this field stands alone.
    """

    parent_ids: typing.Optional[typing.List[int]] = pydantic.Field(default=None)
    """
    The ids of the article's parent collections or sections. An article without this field stands alone.
    """

    parent_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of parent, which can either be a `collection` or `section`.
    """

    default_locale: typing.Optional[str] = pydantic.Field(default=None)
    """
    The default locale of the help center. This field is only returned for multilingual help centers.
    """

    translated_content: typing.Optional[ArticleTranslatedContent] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
