# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..messages.types.message import Message
from ..tickets.types.ticket import Ticket
from ..types.custom_attributes import CustomAttributes
from ..types.redact_conversation_request import RedactConversationRequest
from ..types.reply_conversation_request import ReplyConversationRequest
from ..types.search_request_query import SearchRequestQuery
from ..types.starting_after_paging import StartingAfterPaging
from ..types.ticket_request_custom_attributes import TicketRequestCustomAttributes
from .raw_client import AsyncRawConversationsClient, RawConversationsClient
from .types.attach_contact_to_conversation_request_customer import AttachContactToConversationRequestCustomer
from .types.conversation import Conversation
from .types.conversations_manage_request_body import ConversationsManageRequestBody
from .types.create_conversation_request_from import CreateConversationRequestFrom

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ConversationsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawConversationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawConversationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawConversationsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        per_page: typing.Optional[int] = None,
        starting_after: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Conversation]:
        """
        You can fetch a list of all conversations.

        You can optionally request the result page size and the cursor to start after to fetch the result.
        {% admonition type="warning" name="Pagination" %}
          You can use pagination to limit the number of results returned. The default is `20` results per page.
          See the [pagination section](https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#pagination-for-list-apis) for more details on how to use the `starting_after` param.
        {% /admonition %}

        Parameters
        ----------
        per_page : typing.Optional[int]
            How many results per page

        starting_after : typing.Optional[str]
            String used to get the next page of conversations.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Conversation]
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        response = client.conversations.list()
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(per_page=per_page, starting_after=starting_after, request_options=request_options)

    def create(
        self,
        *,
        from_: CreateConversationRequestFrom,
        body: str,
        created_at: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Message:
        """
        You can create a conversation that has been initiated by a contact (ie. user or lead).
        The conversation can be an in-app message only.

        {% admonition type="info" name="Sending for visitors" %}
        You can also send a message from a visitor by specifying their `user_id` or `id` value in the `from` field, along with a `type` field value of `contact`.
        This visitor will be automatically converted to a contact with a lead role once the conversation is created.
        {% /admonition %}

        This will return the Message model that has been created.

        Parameters
        ----------
        from_ : CreateConversationRequestFrom

        body : str
            The content of the message. HTML is not supported.

        created_at : typing.Optional[int]
            The time the conversation was created as a UTC Unix timestamp. If not provided, the current time will be used. This field is only recommneded for migrating past conversations from another source into Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Message
            conversation created

        Examples
        --------
        from intercom import Intercom
        from intercom.conversations import CreateConversationRequestFrom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.conversations.create(
            from_=CreateConversationRequestFrom(
                type="user",
                id="667d60d18a68186f43bafddd",
            ),
            body="Hello there",
        )
        """
        _response = self._raw_client.create(
            from_=from_, body=body, created_at=created_at, request_options=request_options
        )
        return _response.data

    def find(
        self,
        conversation_id: str,
        *,
        display_as: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Conversation:
        """

        You can fetch the details of a single conversation.

        This will return a single Conversation model with all its conversation parts.

        {% admonition type="warning" name="Hard limit of 500 parts" %}
        The maximum number of conversation parts that can be returned via the API is 500. If you have more than that we will return the 500 most recent conversation parts.
        {% /admonition %}

        For AI agent conversation metadata, please note that you need to have the agent enabled in your workspace, which is a [paid feature](https://www.intercom.com/help/en/articles/8205718-fin-resolutions#h_97f8c2e671).

        Parameters
        ----------
        conversation_id : str
            The id of the conversation to target

        display_as : typing.Optional[str]
            Set to plaintext to retrieve conversation messages in plain text.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Conversation
            conversation found

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.conversations.find(
            conversation_id="123",
            display_as="plaintext",
        )
        """
        _response = self._raw_client.find(conversation_id, display_as=display_as, request_options=request_options)
        return _response.data

    def update(
        self,
        conversation_id: str,
        *,
        display_as: typing.Optional[str] = None,
        read: typing.Optional[bool] = OMIT,
        custom_attributes: typing.Optional[CustomAttributes] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Conversation:
        """

        You can update an existing conversation.

        {% admonition type="info" name="Replying and other actions" %}
        If you want to reply to a coveration or take an action such as assign, unassign, open, close or snooze, take a look at the reply and manage endpoints.
        {% /admonition %}

        Parameters
        ----------
        conversation_id : str
            The id of the conversation to target

        display_as : typing.Optional[str]
            Set to plaintext to retrieve conversation messages in plain text.

        read : typing.Optional[bool]
            Mark a conversation as read within Intercom.

        custom_attributes : typing.Optional[CustomAttributes]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Conversation
            conversation found

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.conversations.update(
            conversation_id="123",
            display_as="plaintext",
            read=True,
            custom_attributes={"issue_type": "Billing", "priority": "High"},
        )
        """
        _response = self._raw_client.update(
            conversation_id,
            display_as=display_as,
            read=read,
            custom_attributes=custom_attributes,
            request_options=request_options,
        )
        return _response.data

    def search(
        self,
        *,
        query: SearchRequestQuery,
        pagination: typing.Optional[StartingAfterPaging] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Conversation]:
        """
        You can search for multiple conversations by the value of their attributes in order to fetch exactly which ones you want.

        To search for conversations, you need to send a `POST` request to `https://api.intercom.io/conversations/search`.

        This will accept a query object in the body which will define your filters in order to search for conversations.
        {% admonition type="warning" name="Optimizing search queries" %}
          Search queries can be complex, so optimizing them can help the performance of your search.
          Use the `AND` and `OR` operators to combine multiple filters to get the exact results you need and utilize
          pagination to limit the number of results returned. The default is `20` results per page and maximum is `150`.
          See the [pagination section](https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#example-search-conversations-request) for more details on how to use the `starting_after` param.
        {% /admonition %}

        ### Nesting & Limitations

        You can nest these filters in order to get even more granular insights that pinpoint exactly what you need. Example: (1 OR 2) AND (3 OR 4).
        There are some limitations to the amount of multiple's there can be:
        - There's a limit of max 2 nested filters
        - There's a limit of max 15 filters for each AND or OR group

        ### Accepted Fields

        Most keys listed as part of the The conversation model is searchable, whether writeable or not. The value you search for has to match the accepted type, otherwise the query will fail (ie. as `created_at` accepts a date, the `value` cannot be a string such as `"foorbar"`).
        The `source.body` field is unique as the search will not be performed against the entire value, but instead against every element of the value separately. For example, when searching for a conversation with a `"I need support"` body - the query should contain a `=` operator with the value `"support"` for such conversation to be returned. A query with a `=` operator and a `"need support"` value will not yield a result.

        | Field                                     | Type                                                                                                                                                   |
        | :---------------------------------------- | :----------------------------------------------------------------------------------------------------------------------------------------------------- |
        | id                                        | String                                                                                                                                                 |
        | created_at                                | Date (UNIX timestamp)                                                                                                                                  |
        | updated_at                                | Date (UNIX timestamp)                                                                                                                                  |
        | source.type                               | String<br>Accepted fields are `conversation`, `email`, `facebook`, `instagram`, `phone_call`, `phone_switch`, `push`, `sms`, `twitter` and `whatsapp`. |
        | source.id                                 | String                                                                                                                                                 |
        | source.delivered_as                       | String                                                                                                                                                 |
        | source.subject                            | String                                                                                                                                                 |
        | source.body                               | String                                                                                                                                                 |
        | source.author.id                          | String                                                                                                                                                 |
        | source.author.type                        | String                                                                                                                                                 |
        | source.author.name                        | String                                                                                                                                                 |
        | source.author.email                       | String                                                                                                                                                 |
        | source.url                                | String                                                                                                                                                 |
        | contact_ids                               | String                                                                                                                                                 |
        | teammate_ids                              | String                                                                                                                                                 |
        | admin_assignee_id                         | String                                                                                                                                                 |
        | team_assignee_id                          | String                                                                                                                                                 |
        | channel_initiated                         | String                                                                                                                                                 |
        | open                                      | Boolean                                                                                                                                                |
        | read                                      | Boolean                                                                                                                                                |
        | state                                     | String                                                                                                                                                 |
        | waiting_since                             | Date (UNIX timestamp)                                                                                                                                  |
        | snoozed_until                             | Date (UNIX timestamp)                                                                                                                                  |
        | tag_ids                                   | String                                                                                                                                                 |
        | priority                                  | String                                                                                                                                                 |
        | statistics.time_to_assignment             | Integer                                                                                                                                                |
        | statistics.time_to_admin_reply            | Integer                                                                                                                                                |
        | statistics.time_to_first_close            | Integer                                                                                                                                                |
        | statistics.time_to_last_close             | Integer                                                                                                                                                |
        | statistics.median_time_to_reply           | Integer                                                                                                                                                |
        | statistics.first_contact_reply_at         | Date (UNIX timestamp)                                                                                                                                  |
        | statistics.first_assignment_at            | Date (UNIX timestamp)                                                                                                                                  |
        | statistics.first_admin_reply_at           | Date (UNIX timestamp)                                                                                                                                  |
        | statistics.first_close_at                 | Date (UNIX timestamp)                                                                                                                                  |
        | statistics.last_assignment_at             | Date (UNIX timestamp)                                                                                                                                  |
        | statistics.last_assignment_admin_reply_at | Date (UNIX timestamp)                                                                                                                                  |
        | statistics.last_contact_reply_at          | Date (UNIX timestamp)                                                                                                                                  |
        | statistics.last_admin_reply_at            | Date (UNIX timestamp)                                                                                                                                  |
        | statistics.last_close_at                  | Date (UNIX timestamp)                                                                                                                                  |
        | statistics.last_closed_by_id              | String                                                                                                                                                 |
        | statistics.count_reopens                  | Integer                                                                                                                                                |
        | statistics.count_assignments              | Integer                                                                                                                                                |
        | statistics.count_conversation_parts       | Integer                                                                                                                                                |
        | conversation_rating.requested_at          | Date (UNIX timestamp)                                                                                                                                  |
        | conversation_rating.replied_at            | Date (UNIX timestamp)                                                                                                                                  |
        | conversation_rating.score                 | Integer                                                                                                                                                |
        | conversation_rating.remark                | String                                                                                                                                                 |
        | conversation_rating.contact_id            | String                                                                                                                                                 |
        | conversation_rating.admin_d               | String                                                                                                                                                 |
        | ai_agent_participated                     | Boolean                                                                                                                                                |
        | ai_agent.resolution_state                 | String                                                                                                                                                 |
        | ai_agent.last_answer_type                 | String                                                                                                                                                 |
        | ai_agent.rating                           | Integer                                                                                                                                                |
        | ai_agent.rating_remark                    | String                                                                                                                                                 |
        | ai_agent.source_type                      | String                                                                                                                                                 |
        | ai_agent.source_title                     | String                                                                                                                                                 |

        ### Accepted Operators

        The table below shows the operators you can use to define how you want to search for the value.  The operator should be put in as a string (`"="`). The operator has to be compatible with the field's type  (eg. you cannot search with `>` for a given string value as it's only compatible for integer's and dates).

        | Operator | Valid Types                    | Description                                                  |
        | :------- | :----------------------------- | :----------------------------------------------------------- |
        | =        | All                            | Equals                                                       |
        | !=       | All                            | Doesn't Equal                                                |
        | IN       | All                            | In  Shortcut for `OR` queries  Values most be in Array       |
        | NIN      | All                            | Not In  Shortcut for `OR !` queries  Values must be in Array |
        | >        | Integer  Date (UNIX Timestamp) | Greater (or equal) than                                      |
        | <       | Integer  Date (UNIX Timestamp) | Lower (or equal) than                                        |
        | ~        | String                         | Contains                                                     |
        | !~       | String                         | Doesn't Contain                                              |
        | ^        | String                         | Starts With                                                  |
        | $        | String                         | Ends With                                                    |

        Parameters
        ----------
        query : SearchRequestQuery

        pagination : typing.Optional[StartingAfterPaging]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Conversation]
            successful

        Examples
        --------
        from intercom import (
            Intercom,
            MultipleFilterSearchRequest,
            SingleFilterSearchRequest,
            StartingAfterPaging,
        )

        client = Intercom(
            token="YOUR_TOKEN",
        )
        response = client.conversations.search(
            query=MultipleFilterSearchRequest(
                operator="AND",
                value=[
                    SingleFilterSearchRequest(
                        field="created_at",
                        operator=">",
                        value="1306054154",
                    )
                ],
            ),
            pagination=StartingAfterPaging(
                per_page=5,
            ),
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.search(query=query, pagination=pagination, request_options=request_options)

    def reply(
        self,
        conversation_id: str,
        *,
        request: ReplyConversationRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Conversation:
        """
        You can reply to a conversation with a message from an admin or on behalf of a contact, or with a note for admins.

        Parameters
        ----------
        conversation_id : str
            The Intercom provisioned identifier for the conversation or the string "last" to reply to the last part of the conversation

        request : ReplyConversationRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Conversation
            User last conversation reply

        Examples
        --------
        from intercom import ContactReplyIntercomUserIdRequest, Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.conversations.reply(
            conversation_id='123 or "last"',
            request=ContactReplyIntercomUserIdRequest(
                body="Thanks again :)",
                intercom_user_id="667d60f18a68186f43bafdf4",
            ),
        )
        """
        _response = self._raw_client.reply(conversation_id, request=request, request_options=request_options)
        return _response.data

    def manage(
        self,
        conversation_id: str,
        *,
        request: ConversationsManageRequestBody,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Conversation:
        """
        For managing conversations you can:
        - Close a conversation
        - Snooze a conversation to reopen on a future date
        - Open a conversation which is `snoozed` or `closed`
        - Assign a conversation to an admin and/or team.

        Parameters
        ----------
        conversation_id : str
            The identifier for the conversation as given by Intercom.

        request : ConversationsManageRequestBody

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Conversation
            Assign a conversation

        Examples
        --------
        from intercom import Intercom
        from intercom.conversations import ConversationsManageRequestBody_Close

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.conversations.manage(
            conversation_id="123",
            request=ConversationsManageRequestBody_Close(
                admin_id="12345",
            ),
        )
        """
        _response = self._raw_client.manage(conversation_id, request=request, request_options=request_options)
        return _response.data

    def run_assignment_rules(
        self, conversation_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Conversation:
        """
        {% admonition type="danger" name="Deprecation of Run Assignment Rules" %}
        Run assignment rules is now deprecated in version 2.12 and future versions and will be permanently removed on December 31, 2026. After this date, any requests made to this endpoint will fail.
        {% /admonition %}
        You can let a conversation be automatically assigned following assignment rules.
        {% admonition type="warning" name="When using workflows" %}
        It is not possible to use this endpoint with Workflows.
        {% /admonition %}

        Parameters
        ----------
        conversation_id : str
            The identifier for the conversation as given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Conversation
            Assign a conversation using assignment rules

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.conversations.run_assignment_rules(
            conversation_id="123",
        )
        """
        _response = self._raw_client.run_assignment_rules(conversation_id, request_options=request_options)
        return _response.data

    def attach_contact_as_admin(
        self,
        conversation_id: str,
        *,
        admin_id: typing.Optional[str] = OMIT,
        customer: typing.Optional[AttachContactToConversationRequestCustomer] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Conversation:
        """
        You can add participants who are contacts to a conversation, on behalf of either another contact or an admin.

        {% admonition type="warning" name="Contacts without an email" %}
        If you add a contact via the email parameter and there is no user/lead found on that workspace with he given email, then we will create a new contact with `role` set to `lead`.
        {% /admonition %}

        Parameters
        ----------
        conversation_id : str
            The identifier for the conversation as given by Intercom.

        admin_id : typing.Optional[str]
            The `id` of the admin who is adding the new participant.

        customer : typing.Optional[AttachContactToConversationRequestCustomer]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Conversation
            Attach a contact to a conversation

        Examples
        --------
        from intercom import Intercom
        from intercom.conversations import (
            AttachContactToConversationRequestCustomerIntercomUserId,
        )

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.conversations.attach_contact_as_admin(
            conversation_id="123",
            admin_id="12345",
            customer=AttachContactToConversationRequestCustomerIntercomUserId(
                intercom_user_id="667d61168a68186f43bafe0d",
            ),
        )
        """
        _response = self._raw_client.attach_contact_as_admin(
            conversation_id, admin_id=admin_id, customer=customer, request_options=request_options
        )
        return _response.data

    def detach_contact_as_admin(
        self,
        conversation_id: str,
        contact_id: str,
        *,
        admin_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Conversation:
        """
        You can add participants who are contacts to a conversation, on behalf of either another contact or an admin.

        {% admonition type="warning" name="Contacts without an email" %}
        If you add a contact via the email parameter and there is no user/lead found on that workspace with he given email, then we will create a new contact with `role` set to `lead`.
        {% /admonition %}

        Parameters
        ----------
        conversation_id : str
            The identifier for the conversation as given by Intercom.

        contact_id : str
            The identifier for the contact as given by Intercom.

        admin_id : str
            The `id` of the admin who is performing the action.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Conversation
            Detach a contact from a group conversation

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.conversations.detach_contact_as_admin(
            conversation_id="123",
            contact_id="123",
            admin_id="5017690",
        )
        """
        _response = self._raw_client.detach_contact_as_admin(
            conversation_id, contact_id, admin_id=admin_id, request_options=request_options
        )
        return _response.data

    def redact_conversation_part(
        self, *, request: RedactConversationRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> Conversation:
        """
        You can redact a conversation part or the source message of a conversation (as seen in the source object).

        {% admonition type="info" name="Redacting parts and messages" %}
        If you are redacting a conversation part, it must have a `body`. If you are redacting a source message, it must have been created by a contact. We will return a `conversation_part_not_redactable` error if these criteria are not met.
        {% /admonition %}

        Parameters
        ----------
        request : RedactConversationRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Conversation
            Redact a conversation part

        Examples
        --------
        from intercom import Intercom, RedactConversationRequest_ConversationPart

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.conversations.redact_conversation_part(
            request=RedactConversationRequest_ConversationPart(
                conversation_id="19894788788",
                conversation_part_id="19381789428",
            ),
        )
        """
        _response = self._raw_client.redact_conversation_part(request=request, request_options=request_options)
        return _response.data

    def convert_to_ticket(
        self,
        conversation_id: str,
        *,
        ticket_type_id: str,
        attributes: typing.Optional[TicketRequestCustomAttributes] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Ticket:
        """
        You can convert a conversation to a ticket.

        Parameters
        ----------
        conversation_id : str
            The id of the conversation to target

        ticket_type_id : str
            The ID of the type of ticket you want to convert the conversation to

        attributes : typing.Optional[TicketRequestCustomAttributes]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Ticket
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.conversations.convert_to_ticket(
            conversation_id="123",
            ticket_type_id="79",
        )
        """
        _response = self._raw_client.convert_to_ticket(
            conversation_id, ticket_type_id=ticket_type_id, attributes=attributes, request_options=request_options
        )
        return _response.data


class AsyncConversationsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawConversationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawConversationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawConversationsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        per_page: typing.Optional[int] = None,
        starting_after: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Conversation]:
        """
        You can fetch a list of all conversations.

        You can optionally request the result page size and the cursor to start after to fetch the result.
        {% admonition type="warning" name="Pagination" %}
          You can use pagination to limit the number of results returned. The default is `20` results per page.
          See the [pagination section](https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#pagination-for-list-apis) for more details on how to use the `starting_after` param.
        {% /admonition %}

        Parameters
        ----------
        per_page : typing.Optional[int]
            How many results per page

        starting_after : typing.Optional[str]
            String used to get the next page of conversations.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Conversation]
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.conversations.list()
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            per_page=per_page, starting_after=starting_after, request_options=request_options
        )

    async def create(
        self,
        *,
        from_: CreateConversationRequestFrom,
        body: str,
        created_at: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Message:
        """
        You can create a conversation that has been initiated by a contact (ie. user or lead).
        The conversation can be an in-app message only.

        {% admonition type="info" name="Sending for visitors" %}
        You can also send a message from a visitor by specifying their `user_id` or `id` value in the `from` field, along with a `type` field value of `contact`.
        This visitor will be automatically converted to a contact with a lead role once the conversation is created.
        {% /admonition %}

        This will return the Message model that has been created.

        Parameters
        ----------
        from_ : CreateConversationRequestFrom

        body : str
            The content of the message. HTML is not supported.

        created_at : typing.Optional[int]
            The time the conversation was created as a UTC Unix timestamp. If not provided, the current time will be used. This field is only recommneded for migrating past conversations from another source into Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Message
            conversation created

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom
        from intercom.conversations import CreateConversationRequestFrom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.conversations.create(
                from_=CreateConversationRequestFrom(
                    type="user",
                    id="667d60d18a68186f43bafddd",
                ),
                body="Hello there",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            from_=from_, body=body, created_at=created_at, request_options=request_options
        )
        return _response.data

    async def find(
        self,
        conversation_id: str,
        *,
        display_as: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Conversation:
        """

        You can fetch the details of a single conversation.

        This will return a single Conversation model with all its conversation parts.

        {% admonition type="warning" name="Hard limit of 500 parts" %}
        The maximum number of conversation parts that can be returned via the API is 500. If you have more than that we will return the 500 most recent conversation parts.
        {% /admonition %}

        For AI agent conversation metadata, please note that you need to have the agent enabled in your workspace, which is a [paid feature](https://www.intercom.com/help/en/articles/8205718-fin-resolutions#h_97f8c2e671).

        Parameters
        ----------
        conversation_id : str
            The id of the conversation to target

        display_as : typing.Optional[str]
            Set to plaintext to retrieve conversation messages in plain text.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Conversation
            conversation found

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.conversations.find(
                conversation_id="123",
                display_as="plaintext",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.find(conversation_id, display_as=display_as, request_options=request_options)
        return _response.data

    async def update(
        self,
        conversation_id: str,
        *,
        display_as: typing.Optional[str] = None,
        read: typing.Optional[bool] = OMIT,
        custom_attributes: typing.Optional[CustomAttributes] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Conversation:
        """

        You can update an existing conversation.

        {% admonition type="info" name="Replying and other actions" %}
        If you want to reply to a coveration or take an action such as assign, unassign, open, close or snooze, take a look at the reply and manage endpoints.
        {% /admonition %}

        Parameters
        ----------
        conversation_id : str
            The id of the conversation to target

        display_as : typing.Optional[str]
            Set to plaintext to retrieve conversation messages in plain text.

        read : typing.Optional[bool]
            Mark a conversation as read within Intercom.

        custom_attributes : typing.Optional[CustomAttributes]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Conversation
            conversation found

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.conversations.update(
                conversation_id="123",
                display_as="plaintext",
                read=True,
                custom_attributes={"issue_type": "Billing", "priority": "High"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            conversation_id,
            display_as=display_as,
            read=read,
            custom_attributes=custom_attributes,
            request_options=request_options,
        )
        return _response.data

    async def search(
        self,
        *,
        query: SearchRequestQuery,
        pagination: typing.Optional[StartingAfterPaging] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Conversation]:
        """
        You can search for multiple conversations by the value of their attributes in order to fetch exactly which ones you want.

        To search for conversations, you need to send a `POST` request to `https://api.intercom.io/conversations/search`.

        This will accept a query object in the body which will define your filters in order to search for conversations.
        {% admonition type="warning" name="Optimizing search queries" %}
          Search queries can be complex, so optimizing them can help the performance of your search.
          Use the `AND` and `OR` operators to combine multiple filters to get the exact results you need and utilize
          pagination to limit the number of results returned. The default is `20` results per page and maximum is `150`.
          See the [pagination section](https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#example-search-conversations-request) for more details on how to use the `starting_after` param.
        {% /admonition %}

        ### Nesting & Limitations

        You can nest these filters in order to get even more granular insights that pinpoint exactly what you need. Example: (1 OR 2) AND (3 OR 4).
        There are some limitations to the amount of multiple's there can be:
        - There's a limit of max 2 nested filters
        - There's a limit of max 15 filters for each AND or OR group

        ### Accepted Fields

        Most keys listed as part of the The conversation model is searchable, whether writeable or not. The value you search for has to match the accepted type, otherwise the query will fail (ie. as `created_at` accepts a date, the `value` cannot be a string such as `"foorbar"`).
        The `source.body` field is unique as the search will not be performed against the entire value, but instead against every element of the value separately. For example, when searching for a conversation with a `"I need support"` body - the query should contain a `=` operator with the value `"support"` for such conversation to be returned. A query with a `=` operator and a `"need support"` value will not yield a result.

        | Field                                     | Type                                                                                                                                                   |
        | :---------------------------------------- | :----------------------------------------------------------------------------------------------------------------------------------------------------- |
        | id                                        | String                                                                                                                                                 |
        | created_at                                | Date (UNIX timestamp)                                                                                                                                  |
        | updated_at                                | Date (UNIX timestamp)                                                                                                                                  |
        | source.type                               | String<br>Accepted fields are `conversation`, `email`, `facebook`, `instagram`, `phone_call`, `phone_switch`, `push`, `sms`, `twitter` and `whatsapp`. |
        | source.id                                 | String                                                                                                                                                 |
        | source.delivered_as                       | String                                                                                                                                                 |
        | source.subject                            | String                                                                                                                                                 |
        | source.body                               | String                                                                                                                                                 |
        | source.author.id                          | String                                                                                                                                                 |
        | source.author.type                        | String                                                                                                                                                 |
        | source.author.name                        | String                                                                                                                                                 |
        | source.author.email                       | String                                                                                                                                                 |
        | source.url                                | String                                                                                                                                                 |
        | contact_ids                               | String                                                                                                                                                 |
        | teammate_ids                              | String                                                                                                                                                 |
        | admin_assignee_id                         | String                                                                                                                                                 |
        | team_assignee_id                          | String                                                                                                                                                 |
        | channel_initiated                         | String                                                                                                                                                 |
        | open                                      | Boolean                                                                                                                                                |
        | read                                      | Boolean                                                                                                                                                |
        | state                                     | String                                                                                                                                                 |
        | waiting_since                             | Date (UNIX timestamp)                                                                                                                                  |
        | snoozed_until                             | Date (UNIX timestamp)                                                                                                                                  |
        | tag_ids                                   | String                                                                                                                                                 |
        | priority                                  | String                                                                                                                                                 |
        | statistics.time_to_assignment             | Integer                                                                                                                                                |
        | statistics.time_to_admin_reply            | Integer                                                                                                                                                |
        | statistics.time_to_first_close            | Integer                                                                                                                                                |
        | statistics.time_to_last_close             | Integer                                                                                                                                                |
        | statistics.median_time_to_reply           | Integer                                                                                                                                                |
        | statistics.first_contact_reply_at         | Date (UNIX timestamp)                                                                                                                                  |
        | statistics.first_assignment_at            | Date (UNIX timestamp)                                                                                                                                  |
        | statistics.first_admin_reply_at           | Date (UNIX timestamp)                                                                                                                                  |
        | statistics.first_close_at                 | Date (UNIX timestamp)                                                                                                                                  |
        | statistics.last_assignment_at             | Date (UNIX timestamp)                                                                                                                                  |
        | statistics.last_assignment_admin_reply_at | Date (UNIX timestamp)                                                                                                                                  |
        | statistics.last_contact_reply_at          | Date (UNIX timestamp)                                                                                                                                  |
        | statistics.last_admin_reply_at            | Date (UNIX timestamp)                                                                                                                                  |
        | statistics.last_close_at                  | Date (UNIX timestamp)                                                                                                                                  |
        | statistics.last_closed_by_id              | String                                                                                                                                                 |
        | statistics.count_reopens                  | Integer                                                                                                                                                |
        | statistics.count_assignments              | Integer                                                                                                                                                |
        | statistics.count_conversation_parts       | Integer                                                                                                                                                |
        | conversation_rating.requested_at          | Date (UNIX timestamp)                                                                                                                                  |
        | conversation_rating.replied_at            | Date (UNIX timestamp)                                                                                                                                  |
        | conversation_rating.score                 | Integer                                                                                                                                                |
        | conversation_rating.remark                | String                                                                                                                                                 |
        | conversation_rating.contact_id            | String                                                                                                                                                 |
        | conversation_rating.admin_d               | String                                                                                                                                                 |
        | ai_agent_participated                     | Boolean                                                                                                                                                |
        | ai_agent.resolution_state                 | String                                                                                                                                                 |
        | ai_agent.last_answer_type                 | String                                                                                                                                                 |
        | ai_agent.rating                           | Integer                                                                                                                                                |
        | ai_agent.rating_remark                    | String                                                                                                                                                 |
        | ai_agent.source_type                      | String                                                                                                                                                 |
        | ai_agent.source_title                     | String                                                                                                                                                 |

        ### Accepted Operators

        The table below shows the operators you can use to define how you want to search for the value.  The operator should be put in as a string (`"="`). The operator has to be compatible with the field's type  (eg. you cannot search with `>` for a given string value as it's only compatible for integer's and dates).

        | Operator | Valid Types                    | Description                                                  |
        | :------- | :----------------------------- | :----------------------------------------------------------- |
        | =        | All                            | Equals                                                       |
        | !=       | All                            | Doesn't Equal                                                |
        | IN       | All                            | In  Shortcut for `OR` queries  Values most be in Array       |
        | NIN      | All                            | Not In  Shortcut for `OR !` queries  Values must be in Array |
        | >        | Integer  Date (UNIX Timestamp) | Greater (or equal) than                                      |
        | <       | Integer  Date (UNIX Timestamp) | Lower (or equal) than                                        |
        | ~        | String                         | Contains                                                     |
        | !~       | String                         | Doesn't Contain                                              |
        | ^        | String                         | Starts With                                                  |
        | $        | String                         | Ends With                                                    |

        Parameters
        ----------
        query : SearchRequestQuery

        pagination : typing.Optional[StartingAfterPaging]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Conversation]
            successful

        Examples
        --------
        import asyncio

        from intercom import (
            AsyncIntercom,
            MultipleFilterSearchRequest,
            SingleFilterSearchRequest,
            StartingAfterPaging,
        )

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.conversations.search(
                query=MultipleFilterSearchRequest(
                    operator="AND",
                    value=[
                        SingleFilterSearchRequest(
                            field="created_at",
                            operator=">",
                            value="1306054154",
                        )
                    ],
                ),
                pagination=StartingAfterPaging(
                    per_page=5,
                ),
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.search(query=query, pagination=pagination, request_options=request_options)

    async def reply(
        self,
        conversation_id: str,
        *,
        request: ReplyConversationRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Conversation:
        """
        You can reply to a conversation with a message from an admin or on behalf of a contact, or with a note for admins.

        Parameters
        ----------
        conversation_id : str
            The Intercom provisioned identifier for the conversation or the string "last" to reply to the last part of the conversation

        request : ReplyConversationRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Conversation
            User last conversation reply

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom, ContactReplyIntercomUserIdRequest

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.conversations.reply(
                conversation_id='123 or "last"',
                request=ContactReplyIntercomUserIdRequest(
                    body="Thanks again :)",
                    intercom_user_id="667d60f18a68186f43bafdf4",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.reply(conversation_id, request=request, request_options=request_options)
        return _response.data

    async def manage(
        self,
        conversation_id: str,
        *,
        request: ConversationsManageRequestBody,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Conversation:
        """
        For managing conversations you can:
        - Close a conversation
        - Snooze a conversation to reopen on a future date
        - Open a conversation which is `snoozed` or `closed`
        - Assign a conversation to an admin and/or team.

        Parameters
        ----------
        conversation_id : str
            The identifier for the conversation as given by Intercom.

        request : ConversationsManageRequestBody

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Conversation
            Assign a conversation

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom
        from intercom.conversations import ConversationsManageRequestBody_Close

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.conversations.manage(
                conversation_id="123",
                request=ConversationsManageRequestBody_Close(
                    admin_id="12345",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.manage(conversation_id, request=request, request_options=request_options)
        return _response.data

    async def run_assignment_rules(
        self, conversation_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Conversation:
        """
        {% admonition type="danger" name="Deprecation of Run Assignment Rules" %}
        Run assignment rules is now deprecated in version 2.12 and future versions and will be permanently removed on December 31, 2026. After this date, any requests made to this endpoint will fail.
        {% /admonition %}
        You can let a conversation be automatically assigned following assignment rules.
        {% admonition type="warning" name="When using workflows" %}
        It is not possible to use this endpoint with Workflows.
        {% /admonition %}

        Parameters
        ----------
        conversation_id : str
            The identifier for the conversation as given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Conversation
            Assign a conversation using assignment rules

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.conversations.run_assignment_rules(
                conversation_id="123",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.run_assignment_rules(conversation_id, request_options=request_options)
        return _response.data

    async def attach_contact_as_admin(
        self,
        conversation_id: str,
        *,
        admin_id: typing.Optional[str] = OMIT,
        customer: typing.Optional[AttachContactToConversationRequestCustomer] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Conversation:
        """
        You can add participants who are contacts to a conversation, on behalf of either another contact or an admin.

        {% admonition type="warning" name="Contacts without an email" %}
        If you add a contact via the email parameter and there is no user/lead found on that workspace with he given email, then we will create a new contact with `role` set to `lead`.
        {% /admonition %}

        Parameters
        ----------
        conversation_id : str
            The identifier for the conversation as given by Intercom.

        admin_id : typing.Optional[str]
            The `id` of the admin who is adding the new participant.

        customer : typing.Optional[AttachContactToConversationRequestCustomer]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Conversation
            Attach a contact to a conversation

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom
        from intercom.conversations import (
            AttachContactToConversationRequestCustomerIntercomUserId,
        )

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.conversations.attach_contact_as_admin(
                conversation_id="123",
                admin_id="12345",
                customer=AttachContactToConversationRequestCustomerIntercomUserId(
                    intercom_user_id="667d61168a68186f43bafe0d",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.attach_contact_as_admin(
            conversation_id, admin_id=admin_id, customer=customer, request_options=request_options
        )
        return _response.data

    async def detach_contact_as_admin(
        self,
        conversation_id: str,
        contact_id: str,
        *,
        admin_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Conversation:
        """
        You can add participants who are contacts to a conversation, on behalf of either another contact or an admin.

        {% admonition type="warning" name="Contacts without an email" %}
        If you add a contact via the email parameter and there is no user/lead found on that workspace with he given email, then we will create a new contact with `role` set to `lead`.
        {% /admonition %}

        Parameters
        ----------
        conversation_id : str
            The identifier for the conversation as given by Intercom.

        contact_id : str
            The identifier for the contact as given by Intercom.

        admin_id : str
            The `id` of the admin who is performing the action.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Conversation
            Detach a contact from a group conversation

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.conversations.detach_contact_as_admin(
                conversation_id="123",
                contact_id="123",
                admin_id="5017690",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.detach_contact_as_admin(
            conversation_id, contact_id, admin_id=admin_id, request_options=request_options
        )
        return _response.data

    async def redact_conversation_part(
        self, *, request: RedactConversationRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> Conversation:
        """
        You can redact a conversation part or the source message of a conversation (as seen in the source object).

        {% admonition type="info" name="Redacting parts and messages" %}
        If you are redacting a conversation part, it must have a `body`. If you are redacting a source message, it must have been created by a contact. We will return a `conversation_part_not_redactable` error if these criteria are not met.
        {% /admonition %}

        Parameters
        ----------
        request : RedactConversationRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Conversation
            Redact a conversation part

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom, RedactConversationRequest_ConversationPart

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.conversations.redact_conversation_part(
                request=RedactConversationRequest_ConversationPart(
                    conversation_id="19894788788",
                    conversation_part_id="19381789428",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.redact_conversation_part(request=request, request_options=request_options)
        return _response.data

    async def convert_to_ticket(
        self,
        conversation_id: str,
        *,
        ticket_type_id: str,
        attributes: typing.Optional[TicketRequestCustomAttributes] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Ticket:
        """
        You can convert a conversation to a ticket.

        Parameters
        ----------
        conversation_id : str
            The id of the conversation to target

        ticket_type_id : str
            The ID of the type of ticket you want to convert the conversation to

        attributes : typing.Optional[TicketRequestCustomAttributes]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Ticket
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.conversations.convert_to_ticket(
                conversation_id="123",
                ticket_type_id="79",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.convert_to_ticket(
            conversation_id, ticket_type_id=ticket_type_id, attributes=attributes, request_options=request_options
        )
        return _response.data
